/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.type.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface GlueColumnStatisticsProvider {
    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type var1);

    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String var1, String var2, Set<String> var3);

    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String var1, String var2, Set<String> var3, Set<String> var4);

    public void updateTableColumnStatistics(Table var1, Map<String, HiveColumnStatistics> var2);

    default public void updatePartitionStatistics(Partition partition, Map<String, HiveColumnStatistics> columnStatistics) {
        this.updatePartitionStatistics((Set<PartitionStatisticsUpdate>)ImmutableSet.of((Object)new PartitionStatisticsUpdate(partition, columnStatistics)));
    }

    public void updatePartitionStatistics(Set<PartitionStatisticsUpdate> var1);

    public static class PartitionStatisticsUpdate {
        private final Partition partition;
        private final Map<String, HiveColumnStatistics> columnStatistics;

        public PartitionStatisticsUpdate(Partition partition, Map<String, HiveColumnStatistics> columnStatistics) {
            this.partition = Objects.requireNonNull(partition, "partition is null");
            this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
        }

        public Partition getPartition() {
            return this.partition;
        }

        public Map<String, HiveColumnStatistics> getColumnStatistics() {
            return this.columnStatistics;
        }
    }
}

