/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.AccessDeniedException;
import com.amazonaws.services.glue.model.AlreadyExistsException;
import com.amazonaws.services.glue.model.BatchCreatePartitionRequest;
import com.amazonaws.services.glue.model.BatchCreatePartitionResult;
import com.amazonaws.services.glue.model.BatchGetPartitionRequest;
import com.amazonaws.services.glue.model.BatchGetPartitionResult;
import com.amazonaws.services.glue.model.BatchUpdatePartitionRequest;
import com.amazonaws.services.glue.model.BatchUpdatePartitionRequestEntry;
import com.amazonaws.services.glue.model.ConcurrentModificationException;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.CreateUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeletePartitionRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.DeleteUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.ErrorDetail;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabaseResult;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetPartitionRequest;
import com.amazonaws.services.glue.model.GetPartitionResult;
import com.amazonaws.services.glue.model.GetPartitionsRequest;
import com.amazonaws.services.glue.model.GetPartitionsResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTableResult;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionsRequest;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionsResult;
import com.amazonaws.services.glue.model.PartitionError;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.PartitionValueList;
import com.amazonaws.services.glue.model.Segment;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateDatabaseRequest;
import com.amazonaws.services.glue.model.UpdatePartitionRequest;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.amazonaws.services.glue.model.UpdateUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.UserDefinedFunctionInput;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionNotFoundException;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StatisticsUpdateMode;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.glue.AwsApiCallStats;
import io.trino.plugin.hive.metastore.glue.AwsSdkUtil;
import io.trino.plugin.hive.metastore.glue.ForGlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.GlueExpressionUtil;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.converter.GlueInputConverter;
import io.trino.plugin.hive.metastore.glue.converter.GlueToTrinoConverter;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class GlueHiveMetastore
implements HiveMetastore {
    private static final Logger log = Logger.get(GlueHiveMetastore.class);
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String DEFAULT_METASTORE_USER = "presto";
    private static final int BATCH_GET_PARTITION_MAX_PAGE_SIZE = 1000;
    private static final int BATCH_CREATE_PARTITION_MAX_PAGE_SIZE = 100;
    private static final int BATCH_UPDATE_PARTITION_MAX_PAGE_SIZE = 100;
    private static final int AWS_GLUE_GET_PARTITIONS_MAX_RESULTS = 1000;
    private static final int AWS_GLUE_GET_DATABASES_MAX_RESULTS = 100;
    private static final int AWS_GLUE_GET_FUNCTIONS_MAX_RESULTS = 100;
    private static final int AWS_GLUE_GET_TABLES_MAX_RESULTS = 100;
    private static final Comparator<Iterable<String>> PARTITION_VALUE_COMPARATOR = Comparators.lexicographical((Comparator)String.CASE_INSENSITIVE_ORDER);
    private static final Predicate<com.amazonaws.services.glue.model.Table> SOME_KIND_OF_VIEW_FILTER = table -> TableType.VIRTUAL_VIEW.name().equals(GlueToTrinoConverter.getTableTypeNullable(table));
    private static final RetryPolicy<?> CONCURRENT_MODIFICATION_EXCEPTION_RETRY_POLICY = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(throwable -> Throwables.getRootCause((Throwable)throwable) instanceof ConcurrentModificationException)).withDelay(Duration.ofMillis(100L)).withMaxRetries(3).build();
    private final TrinoFileSystem fileSystem;
    private final AWSGlueAsync glueClient;
    private final Optional<String> defaultDir;
    private final int partitionSegments;
    private final Executor partitionsReadExecutor;
    private final GlueMetastoreStats stats;
    private final GlueColumnStatisticsProvider columnStatisticsProvider;
    private final boolean assumeCanonicalPartitionKeys;
    private final Predicate<com.amazonaws.services.glue.model.Table> tableFilter;

    @Inject
    public GlueHiveMetastore(TrinoFileSystemFactory fileSystemFactory, GlueHiveMetastoreConfig glueConfig, @ForGlueHiveMetastore Executor partitionsReadExecutor, GlueColumnStatisticsProviderFactory columnStatisticsProviderFactory, AWSGlueAsync glueClient, @ForGlueHiveMetastore GlueMetastoreStats stats, @ForGlueHiveMetastore Predicate<com.amazonaws.services.glue.model.Table> tableFilter) {
        this.fileSystem = fileSystemFactory.create(ConnectorIdentity.ofUser((String)DEFAULT_METASTORE_USER));
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.defaultDir = glueConfig.getDefaultWarehouseDir();
        this.partitionSegments = glueConfig.getPartitionSegments();
        this.partitionsReadExecutor = Objects.requireNonNull(partitionsReadExecutor, "partitionsReadExecutor is null");
        this.assumeCanonicalPartitionKeys = glueConfig.isAssumeCanonicalPartitionKeys();
        this.tableFilter = Objects.requireNonNull(tableFilter, "tableFilter is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.columnStatisticsProvider = columnStatisticsProviderFactory.createGlueColumnStatisticsProvider(glueClient, stats);
    }

    @Managed
    @Flatten
    public GlueMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            GetDatabaseResult result = this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(new GetDatabaseRequest().withName(databaseName)));
            return Optional.of(GlueToTrinoConverter.convertDatabase(result.getDatabase()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            List databaseNames = (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getDatabases(arg_0), new GetDatabasesRequest().withMaxResults(Integer.valueOf(100)), GetDatabasesRequest::setNextToken, GetDatabasesResult::getNextToken, this.stats.getGetDatabases()).map(GetDatabasesResult::getDatabaseList).flatMap(Collection::stream).map(com.amazonaws.services.glue.model.Database::getName).collect(ImmutableList.toImmutableList());
            return databaseNames;
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        try {
            GetTableResult result = this.stats.getGetTable().call(() -> this.glueClient.getTable(new GetTableRequest().withDatabaseName(databaseName).withName(tableName)));
            return Optional.of(GlueToTrinoConverter.convertTable(result.getTable(), databaseName));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.columnStatisticsProvider.getSupportedColumnStatistics(type);
    }

    private Table getExistingTable(String databaseName, String tableName) {
        return this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    @Override
    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        Preconditions.checkArgument((!columnNames.isEmpty() ? 1 : 0) != 0, (Object)"columnNames is empty");
        return this.columnStatisticsProvider.getTableColumnStatistics(databaseName, tableName, columnNames);
    }

    @Override
    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
        Preconditions.checkArgument((!columnNames.isEmpty() ? 1 : 0) != 0, (Object)"columnNames is empty");
        return this.columnStatisticsProvider.getPartitionColumnStatistics(databaseName, tableName, partitionNames, columnNames);
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
        Failsafe.with(CONCURRENT_MODIFICATION_EXCEPTION_RETRY_POLICY, (Policy[])new RetryPolicy[0]).run(() -> this.updateTableStatisticsInternal(databaseName, tableName, transaction, mode, statisticsUpdate));
    }

    private void updateTableStatisticsInternal(String databaseName, String tableName, AcidTransaction transaction, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
        Table table = this.getExistingTable(databaseName, tableName);
        if (transaction.isAcidTransactionRunning()) {
            table = Table.builder(table).setWriteId(OptionalLong.of(transaction.getWriteId())).build();
        }
        HiveBasicStatistics currentBasicStatistics = ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters());
        Map<String, HiveColumnStatistics> currentColumnStatistics = this.getTableColumnStatistics(databaseName, tableName, (Set)Stream.concat(table.getDataColumns().stream(), table.getPartitionColumns().stream()).map(Column::getName).collect(ImmutableSet.toImmutableSet()));
        PartitionStatistics currentStatistics = new PartitionStatistics(currentBasicStatistics, currentColumnStatistics);
        PartitionStatistics updatedStatistics = mode.updatePartitionStatistics(currentStatistics, statisticsUpdate);
        try {
            TableInput tableInput = GlueInputConverter.convertTable(table);
            Map<String, String> statisticsParameters = ThriftMetastoreUtil.updateStatisticsParameters(table.getParameters(), updatedStatistics.getBasicStatistics());
            tableInput.setParameters(statisticsParameters);
            table = Table.builder(table).setParameters(statisticsParameters).build();
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(databaseName).withTableInput(tableInput)));
            this.columnStatisticsProvider.updateTableColumnStatistics(table, updatedStatistics.getColumnStatistics());
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void updatePartitionStatistics(Table table, StatisticsUpdateMode mode, Map<String, PartitionStatistics> partitionUpdates) {
        Iterables.partition(partitionUpdates.entrySet(), (int)100).forEach(batch -> this.updatePartitionStatisticsBatch(table, mode, (Map)batch.stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    private void updatePartitionStatisticsBatch(Table table, StatisticsUpdateMode mode, Map<String, PartitionStatistics> partitionUpdates) {
        Map partitions = (Map)this.getPartitionsByNamesInternal(table, partitionUpdates.keySet()).entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Partition)((Optional)entry.getValue()).orElseThrow()));
        Map<String, Map<String, HiveColumnStatistics>> currentColumnStats = this.columnStatisticsProvider.getPartitionColumnStatistics(table.getDatabaseName(), table.getTableName(), partitionUpdates.keySet(), (Set)table.getDataColumns().stream().map(Column::getName).collect(ImmutableSet.toImmutableSet()));
        ImmutableList.Builder partitionUpdateRequests = ImmutableList.builder();
        ImmutableSet.Builder columnStatisticsUpdates = ImmutableSet.builder();
        partitions.forEach((partitionName, partition) -> {
            PartitionStatistics update = (PartitionStatistics)partitionUpdates.get(partitionName);
            PartitionStatistics currentStatistics = new PartitionStatistics(ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters()), (Map)currentColumnStats.get(partitionName));
            PartitionStatistics updatedStatistics = mode.updatePartitionStatistics(currentStatistics, update);
            Map<String, String> updatedStatisticsParameters = ThriftMetastoreUtil.updateStatisticsParameters(partition.getParameters(), updatedStatistics.getBasicStatistics());
            partition = Partition.builder(partition).setParameters(updatedStatisticsParameters).build();
            Map<String, HiveColumnStatistics> updatedColumnStatistics = updatedStatistics.getColumnStatistics();
            PartitionInput partitionInput = GlueInputConverter.convertPartition(partition);
            partitionInput.setParameters(partition.getParameters());
            partitionUpdateRequests.add((Object)new BatchUpdatePartitionRequestEntry().withPartitionValueList(partition.getValues()).withPartitionInput(partitionInput));
            columnStatisticsUpdates.add((Object)new GlueColumnStatisticsProvider.PartitionStatisticsUpdate((Partition)partition, updatedColumnStatistics));
        });
        List partitionUpdateRequestsPartitioned = Lists.partition((List)partitionUpdateRequests.build(), (int)100);
        ArrayList partitionUpdateRequestsFutures = new ArrayList();
        partitionUpdateRequestsPartitioned.forEach(partitionUpdateRequestsPartition -> partitionUpdateRequestsFutures.add(this.glueClient.batchUpdatePartitionAsync(new BatchUpdatePartitionRequest().withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withEntries((Collection)partitionUpdateRequestsPartition), new StatsRecordingAsyncHandler(this.stats.getBatchUpdatePartition()))));
        try {
            this.columnStatisticsProvider.updatePartitionStatistics((Set<GlueColumnStatisticsProvider.PartitionStatisticsUpdate>)columnStatisticsUpdates.build());
            partitionUpdateRequestsFutures.forEach(MoreFutures::getFutureValue);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getTables(String databaseName) {
        return this.getTableNames(databaseName, this.tableFilter);
    }

    @Override
    public Optional<List<SchemaTableName>> getAllTables() {
        return Optional.empty();
    }

    @Override
    public Map<String, RelationType> getRelationTypes(String databaseName) {
        try {
            return (Map)this.getGlueTables(databaseName).filter(this.tableFilter.or(SOME_KIND_OF_VIEW_FILTER)).collect(ImmutableMap.toImmutableMap(com.amazonaws.services.glue.model.Table::getName, table -> {
                if (SOME_KIND_OF_VIEW_FILTER.test((com.amazonaws.services.glue.model.Table)table)) {
                    return RelationType.VIEW;
                }
                return RelationType.TABLE;
            }));
        }
        catch (AccessDeniedException | EntityNotFoundException e) {
            return ImmutableMap.of();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Map<SchemaTableName, RelationType>> getAllRelationTypes() {
        return Optional.empty();
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        return this.getTableNames(databaseName, table -> parameterValue.equals(GlueToTrinoConverter.getTableParameters(table).get(parameterKey)));
    }

    @Override
    public List<String> getViews(String databaseName) {
        return this.getTableNames(databaseName, SOME_KIND_OF_VIEW_FILTER);
    }

    @Override
    public Optional<List<SchemaTableName>> getAllViews() {
        return Optional.empty();
    }

    private List<String> getTableNames(String databaseName, Predicate<com.amazonaws.services.glue.model.Table> filter) {
        try {
            List tableNames = (List)this.getGlueTables(databaseName).filter(filter).map(com.amazonaws.services.glue.model.Table::getName).collect(ImmutableList.toImmutableList());
            return tableNames;
        }
        catch (AccessDeniedException | EntityNotFoundException e) {
            return ImmutableList.of();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createDatabase(Database database) {
        Location location;
        if (database.getLocation().isEmpty() && this.defaultDir.isPresent()) {
            location = Location.of((String)this.defaultDir.get()).appendPath(HiveUtil.escapeSchemaName(database.getDatabaseName()));
            database = Database.builder(database).setLocation(Optional.of(location.toString())).build();
        }
        try {
            DatabaseInput databaseInput = GlueInputConverter.convertDatabase(database);
            this.stats.getCreateDatabase().call(() -> this.glueClient.createDatabase(new CreateDatabaseRequest().withDatabaseInput(databaseInput)));
        }
        catch (AlreadyExistsException e) {
            String existingQueryId;
            String expectedQueryId = database.getParameters().get("trino_query_id");
            if (expectedQueryId != null && expectedQueryId.equals(existingQueryId = (String)this.getDatabase(database.getDatabaseName()).map(Database::getParameters).map(parameters -> (String)parameters.get("trino_query_id")).orElse(null))) {
                return;
            }
            throw new SchemaAlreadyExistsException(database.getDatabaseName(), e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        if (database.getLocation().isPresent()) {
            location = Location.of((String)database.getLocation().get());
            try {
                this.fileSystem.createDirectory(location);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to create directory: " + String.valueOf(location), (Throwable)e);
            }
        }
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        Optional<Object> location = Optional.empty();
        if (deleteData) {
            location = this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName)).getLocation();
        }
        try {
            this.stats.getDeleteDatabase().call(() -> this.glueClient.deleteDatabase(new DeleteDatabaseRequest().withName(databaseName)));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(databaseName, (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        if (deleteData) {
            location.map(Location::of).ifPresent(this::deleteDir);
        }
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            Database database = this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
            DatabaseInput renamedDatabase = GlueInputConverter.convertDatabase(database).withName(newDatabaseName);
            this.stats.getUpdateDatabase().call(() -> this.glueClient.updateDatabase(new UpdateDatabaseRequest().withName(databaseName).withDatabaseInput(renamedDatabase)));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setting the database owner is not supported by Glue");
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        try {
            TableInput input = GlueInputConverter.convertTable(table);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(new CreateTableRequest().withDatabaseName(table.getDatabaseName()).withTableInput(input)));
        }
        catch (AlreadyExistsException e) {
            String existingQueryId;
            String expectedQueryId = table.getParameters().get("trino_query_id");
            if (expectedQueryId != null && expectedQueryId.equals(existingQueryId = (String)this.getTable(table.getDatabaseName(), table.getTableName()).map(Table::getParameters).map(parameters -> (String)parameters.get("trino_query_id")).orElse(null))) {
                return;
            }
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDatabaseName(), table.getTableName()), e);
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(table.getDatabaseName(), (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        Table table = this.getExistingTable(databaseName, tableName);
        DeleteTableRequest deleteTableRequest = new DeleteTableRequest().withDatabaseName(databaseName).withName(tableName);
        try {
            Failsafe.with(CONCURRENT_MODIFICATION_EXCEPTION_RETRY_POLICY, (Policy[])new RetryPolicy[0]).run(() -> this.stats.getDeleteTable().call(() -> this.glueClient.deleteTable(deleteTableRequest)));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        Optional<String> location = table.getStorage().getOptionalLocation().filter(Predicate.not(String::isEmpty));
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && location.isPresent()) {
            this.deleteDir(Location.of((String)location.get()));
        }
    }

    private static boolean isManagedTable(Table table) {
        return table.getTableType().equals(TableType.MANAGED_TABLE.name());
    }

    private void deleteDir(Location path) {
        try {
            this.fileSystem.deleteDirectory(path);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to delete path: %s", new Object[]{path});
        }
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        if (!tableName.equals(newTable.getTableName()) || !databaseName.equals(newTable.getDatabaseName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename is not yet supported by Glue service");
        }
        try {
            TableInput newTableInput = GlueInputConverter.convertTable(newTable);
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(databaseName).withTableInput(newTableInput)));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        boolean newTableCreated = false;
        try {
            GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(databaseName).withName(tableName);
            GetTableResult glueTable = this.glueClient.getTable(getTableRequest);
            TableInput tableInput = this.convertGlueTableToTableInput(glueTable.getTable(), newTableName);
            CreateTableRequest createTableRequest = new CreateTableRequest().withDatabaseName(newDatabaseName).withTableInput(tableInput);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
            newTableCreated = true;
            this.dropTable(databaseName, tableName, false);
        }
        catch (RuntimeException e) {
            block5: {
                if (newTableCreated) {
                    try {
                        this.dropTable(databaseName, tableName, false);
                    }
                    catch (RuntimeException cleanupException) {
                        if (cleanupException.equals(e)) break block5;
                        e.addSuppressed(cleanupException);
                    }
                }
            }
            throw e;
        }
    }

    private TableInput convertGlueTableToTableInput(com.amazonaws.services.glue.model.Table glueTable, String newTableName) {
        return new TableInput().withName(newTableName).withDescription(glueTable.getDescription()).withOwner(glueTable.getOwner()).withLastAccessTime(glueTable.getLastAccessTime()).withLastAnalyzedTime(glueTable.getLastAnalyzedTime()).withRetention(glueTable.getRetention()).withStorageDescriptor(glueTable.getStorageDescriptor()).withPartitionKeys((Collection)glueTable.getPartitionKeys()).withViewOriginalText(glueTable.getViewOriginalText()).withViewExpandedText(glueTable.getViewExpandedText()).withTableType(GlueToTrinoConverter.getTableTypeNullable(glueTable)).withTargetTable(glueTable.getTargetTable()).withParameters(GlueToTrinoConverter.getTableParameters(glueTable));
    }

    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        Table oldTable = this.getExistingTable(databaseName, tableName);
        Table newTable = Table.builder(oldTable).setParameter("comment", comment).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        if (principal.getType() != PrincipalType.USER) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Setting table owner type as a role is not supported");
        }
        try {
            Table table = this.getExistingTable(databaseName, tableName);
            TableInput newTableInput = GlueInputConverter.convertTable(table);
            newTableInput.setOwner(principal.getName());
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(new UpdateTableRequest().withDatabaseName(databaseName).withTableInput(newTableInput)));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        Table table = this.getExistingTable(databaseName, tableName);
        List<Column> dataColumns = table.getDataColumns();
        List<Column> partitionColumns = table.getPartitionColumns();
        Optional<Integer> matchingDataColumn = GlueHiveMetastore.indexOfColumnWithName(dataColumns, columnName);
        Optional<Integer> matchingPartitionColumn = GlueHiveMetastore.indexOfColumnWithName(partitionColumns, columnName);
        if (matchingDataColumn.isPresent() && matchingPartitionColumn.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Found two columns with names matching " + columnName);
        }
        if (matchingDataColumn.isEmpty() && matchingPartitionColumn.isEmpty()) {
            throw new ColumnNotFoundException(table.getSchemaTableName(), columnName);
        }
        Table updatedTable = Table.builder(table).setDataColumns(matchingDataColumn.map(index -> GlueHiveMetastore.setColumnCommentForIndex(dataColumns, index, comment)).orElse(dataColumns)).setPartitionColumns(matchingPartitionColumn.map(index -> GlueHiveMetastore.setColumnCommentForIndex(partitionColumns, index, comment)).orElse(partitionColumns)).build();
        this.replaceTable(databaseName, tableName, updatedTable, null);
    }

    private static Optional<Integer> indexOfColumnWithName(List<Column> columns, String columnName) {
        Optional<Integer> index = Optional.empty();
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).getName().equals(columnName)) continue;
            index.ifPresent(ignored -> {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Found two columns with names matching " + columnName);
            });
            index = Optional.of(i);
        }
        return index;
    }

    private static List<Column> setColumnCommentForIndex(List<Column> columns, int indexToUpdate, Optional<String> comment) {
        ImmutableList.Builder newColumns = ImmutableList.builder();
        for (int i = 0; i < columns.size(); ++i) {
            Column originalColumn = columns.get(i);
            if (i == indexToUpdate) {
                newColumns.add((Object)new Column(originalColumn.getName(), originalColumn.getType(), comment, originalColumn.getProperties()));
                continue;
            }
            newColumns.add((Object)originalColumn);
        }
        return newColumns.build();
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Table oldTable = this.getExistingTable(databaseName, tableName);
        Table newTable = Table.builder(oldTable).addDataColumn(new Column(columnName, columnType, Optional.ofNullable(columnComment), (Map<String, String>)ImmutableMap.of())).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Table oldTable = this.getExistingTable(databaseName, tableName);
        if (oldTable.getPartitionColumns().stream().anyMatch(c -> c.getName().equals(oldColumnName))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        for (Column column : oldTable.getDataColumns()) {
            if (column.getName().equals(oldColumnName)) {
                newDataColumns.add((Object)new Column(newColumnName, column.getType(), column.getComment(), column.getProperties()));
                continue;
            }
            newDataColumns.add((Object)column);
        }
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, databaseName, tableName, columnName);
        Table oldTable = this.getExistingTable(databaseName, tableName);
        if (oldTable.getColumn(columnName).isEmpty()) {
            SchemaTableName name = new SchemaTableName(databaseName, tableName);
            throw new ColumnNotFoundException(name, columnName);
        }
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        oldTable.getDataColumns().stream().filter(fieldSchema -> !fieldSchema.getName().equals(columnName)).forEach(arg_0 -> ((ImmutableList.Builder)newDataColumns).add(arg_0));
        Table newTable = Table.builder(oldTable).setDataColumns((List<Column>)newDataColumns.build()).build();
        this.replaceTable(databaseName, tableName, newTable, null);
    }

    @Override
    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        try {
            GetPartitionResult result = this.stats.getGetPartition().call(() -> this.glueClient.getPartition(new GetPartitionRequest().withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withPartitionValues((Collection)partitionValues)));
            return Optional.of(new GlueToTrinoConverter.GluePartitionConverter(table.getDatabaseName(), table.getTableName()).apply(result.getPartition()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        if (partitionKeysFilter.isNone()) {
            return Optional.of(ImmutableList.of());
        }
        String expression = GlueExpressionUtil.buildGlueExpression(columnNames, partitionKeysFilter, this.assumeCanonicalPartitionKeys);
        List<List<String>> partitionValues = this.getPartitionValues(databaseName, tableName, expression);
        return Optional.of(GlueHiveMetastore.buildPartitionNames(columnNames, partitionValues));
    }

    private List<List<String>> getPartitionValues(String databaseName, String tableName, String expression) {
        if (this.partitionSegments == 1) {
            return this.getPartitionValues(databaseName, tableName, expression, null);
        }
        ExecutorCompletionService<List> completionService = new ExecutorCompletionService<List>(this.partitionsReadExecutor);
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>(this.partitionSegments);
        ArrayList<List<String>> partitions = new ArrayList<List<String>>();
        try {
            int i;
            for (i = 0; i < this.partitionSegments; ++i) {
                Segment segment = new Segment().withSegmentNumber(Integer.valueOf(i)).withTotalSegments(Integer.valueOf(this.partitionSegments));
                futures.add(completionService.submit(() -> this.getPartitionValues(databaseName, tableName, expression, segment)));
            }
            for (i = 0; i < this.partitionSegments; ++i) {
                Future futurePartitions = completionService.take();
                partitions.addAll((Collection)futurePartitions.get());
            }
            futures.clear();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed to fetch partitions from Glue Data Catalog", (Throwable)e);
        }
        finally {
            futures.forEach(future -> future.cancel(true));
        }
        partitions.sort(PARTITION_VALUE_COMPARATOR);
        return partitions;
    }

    private List<List<String>> getPartitionValues(String databaseName, String tableName, String expression, @Nullable Segment segment) {
        try {
            return (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getPartitions(arg_0), new GetPartitionsRequest().withDatabaseName(databaseName).withTableName(tableName).withExpression(expression).withSegment(segment).withExcludeColumnSchema(Boolean.valueOf(true)).withMaxResults(Integer.valueOf(1000)), GetPartitionsRequest::setNextToken, GetPartitionsResult::getNextToken, this.stats.getGetPartitions()).map(GetPartitionsResult::getPartitions).flatMap(Collection::stream).map(com.amazonaws.services.glue.model.Partition::getValues).collect(ImmutableList.toImmutableList());
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private static List<String> buildPartitionNames(List<String> partitionColumns, List<List<String>> partitions) {
        return GlueToTrinoConverter.mappedCopy(partitions, partition -> MetastoreUtil.toPartitionName(partitionColumns, partition));
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        return this.stats.getGetPartitionByName().call(() -> this.getPartitionsByNamesInternal(table, partitionNames));
    }

    private Map<String, Optional<Partition>> getPartitionsByNamesInternal(Table table, Collection<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        List<Partition> partitions = this.batchGetPartition(table, partitionNames);
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), HiveUtil::toPartitionValues));
        Map partitionValuesToPartitionMap = partitions.stream().collect(Collectors.toMap(Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            Partition partition = (Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put((Object)((String)entry.getKey()), Optional.ofNullable(partition));
        }
        return resultBuilder.buildOrThrow();
    }

    private List<Partition> batchGetPartition(Table table, Collection<String> partitionNames) {
        ArrayList<Future> batchGetPartitionFutures = new ArrayList<Future>();
        try {
            List pendingPartitions = partitionNames.stream().map(partitionName -> new PartitionValueList().withValues(HiveUtil.toPartitionValues(partitionName))).collect(Collectors.toCollection(ArrayList::new));
            ImmutableList.Builder resultsBuilder = ImmutableList.builderWithExpectedSize((int)partitionNames.size());
            GlueToTrinoConverter.GluePartitionConverter converter = new GlueToTrinoConverter.GluePartitionConverter(table.getDatabaseName(), table.getTableName());
            while (!pendingPartitions.isEmpty()) {
                for (List partitions : Lists.partition((List)pendingPartitions, (int)1000)) {
                    batchGetPartitionFutures.add(this.glueClient.batchGetPartitionAsync(new BatchGetPartitionRequest().withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withPartitionsToGet((Collection)partitions), new StatsRecordingAsyncHandler(this.stats.getGetPartitions())));
                }
                pendingPartitions.clear();
                for (Future future2 : batchGetPartitionFutures) {
                    BatchGetPartitionResult batchGetPartitionResult = (BatchGetPartitionResult)future2.get();
                    List partitions = batchGetPartitionResult.getPartitions();
                    List unprocessedKeys = batchGetPartitionResult.getUnprocessedKeys();
                    if (partitions.isEmpty()) {
                        Verify.verify((!unprocessedKeys.isEmpty() ? 1 : 0) != 0, (String)"Empty unprocessedKeys for non-empty BatchGetPartitionRequest and empty partitions result", (Object[])new Object[0]);
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Cannot make progress retrieving partitions. Unable to retrieve partitions: " + String.valueOf(unprocessedKeys));
                    }
                    partitions.stream().map(converter).forEach(arg_0 -> ((ImmutableList.Builder)resultsBuilder).add(arg_0));
                    pendingPartitions.addAll(unprocessedKeys);
                }
                batchGetPartitionFutures.clear();
            }
            ImmutableList immutableList = resultsBuilder.build();
            return immutableList;
        }
        catch (AmazonServiceException | InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
        finally {
            batchGetPartitionFutures.forEach(future -> future.cancel(true));
        }
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            this.stats.getCreatePartitions().call(() -> {
                ArrayList<Future> futures = new ArrayList<Future>();
                for (List partitionBatch : Lists.partition((List)partitions, (int)100)) {
                    List<PartitionInput> partitionInputs = GlueToTrinoConverter.mappedCopy(partitionBatch, GlueInputConverter::convertPartition);
                    futures.add(this.glueClient.batchCreatePartitionAsync(new BatchCreatePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionInputList(partitionInputs), new StatsRecordingAsyncHandler(this.stats.getBatchCreatePartition())));
                }
                for (Future future : futures) {
                    try {
                        BatchCreatePartitionResult result = (BatchCreatePartitionResult)future.get();
                        GlueHiveMetastore.propagatePartitionErrorToTrinoException(databaseName, tableName, result.getErrors());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
                    }
                }
                Set updates = (Set)partitions.stream().map(partitionWithStatistics -> new GlueColumnStatisticsProvider.PartitionStatisticsUpdate(partitionWithStatistics.getPartition(), partitionWithStatistics.getStatistics().getColumnStatistics())).collect(ImmutableSet.toImmutableSet());
                this.columnStatisticsProvider.updatePartitionStatistics(updates);
                return null;
            });
        }
        catch (AmazonServiceException | ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e);
        }
    }

    private static void propagatePartitionErrorToTrinoException(String databaseName, String tableName, List<PartitionError> partitionErrors) {
        if (partitionErrors != null && !partitionErrors.isEmpty()) {
            String glueExceptionCode;
            ErrorDetail errorDetail = partitionErrors.get(0).getErrorDetail();
            switch (glueExceptionCode = errorDetail.getErrorCode()) {
                case "AlreadyExistsException": {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, errorDetail.getErrorMessage());
                }
                case "EntityNotFoundException": {
                    throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), errorDetail.getErrorMessage());
                }
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, errorDetail.getErrorCode() + ": " + errorDetail.getErrorMessage());
        }
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        Table table = this.getExistingTable(databaseName, tableName);
        Partition partition = this.getPartition(table, parts).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts));
        try {
            this.stats.getDeletePartition().call(() -> this.glueClient.deletePartition(new DeletePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionValues((Collection)parts)));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        String partLocation = partition.getStorage().getLocation();
        if (deleteData && GlueHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)partLocation)) {
            this.deleteDir(Location.of((String)partLocation));
        }
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            PartitionInput newPartition = GlueInputConverter.convertPartition(partition);
            this.stats.getUpdatePartition().call(() -> this.glueClient.updatePartition(new UpdatePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionInput(newPartition).withPartitionValueList(partition.getPartition().getValues())));
            this.columnStatisticsProvider.updatePartitionStatistics(partition.getPartition(), partition.getStatistics().getColumnStatistics());
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getPartition().getValues(), e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createRole is not supported by Glue");
    }

    @Override
    public void dropRole(String role) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropRole is not supported by Glue");
    }

    @Override
    public Set<String> listRoles() {
        return ImmutableSet.of((Object)PUBLIC_ROLE_NAME);
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantRoles is not supported by Glue");
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeRoles is not supported by Glue");
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        if (principal.getType() == PrincipalType.USER) {
            return ImmutableSet.of((Object)new RoleGrant(principal.toTrinoPrincipal(), PUBLIC_ROLE_NAME, false));
        }
        return ImmutableSet.of();
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantTablePrivileges is not supported by Glue");
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeTablePrivileges is not supported by Glue");
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return ImmutableSet.of();
    }

    @Override
    public void checkSupportsTransactions() {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Glue does not support ACID tables");
    }

    @Override
    public boolean functionExists(String databaseName, String functionName, String signatureToken) {
        try {
            this.stats.getGetUserDefinedFunction().call(() -> this.glueClient.getUserDefinedFunction(new GetUserDefinedFunctionRequest().withDatabaseName(databaseName).withFunctionName(ThriftMetastoreUtil.metastoreFunctionName(functionName, signatureToken))));
            return true;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Collection<LanguageFunction> getAllFunctions(String databaseName) {
        return this.getFunctionsByPattern(databaseName, "trino__.*");
    }

    @Override
    public Collection<LanguageFunction> getFunctions(String databaseName, String functionName) {
        return this.getFunctionsByPattern(databaseName, "trino__" + Pattern.quote(functionName) + "__.*");
    }

    private Collection<LanguageFunction> getFunctionsByPattern(String databaseName, String functionNamePattern) {
        try {
            return (Collection)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getUserDefinedFunctions(arg_0), new GetUserDefinedFunctionsRequest().withDatabaseName(databaseName).withPattern(functionNamePattern).withMaxResults(Integer.valueOf(100)), GetUserDefinedFunctionsRequest::setNextToken, GetUserDefinedFunctionsResult::getNextToken, this.stats.getGetUserDefinedFunctions()).map(GetUserDefinedFunctionsResult::getUserDefinedFunctions).flatMap(Collection::stream).map(GlueToTrinoConverter::convertFunction).collect(ImmutableList.toImmutableList());
        }
        catch (AccessDeniedException | EntityNotFoundException e) {
            return ImmutableList.of();
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createFunction(String databaseName, String functionName, LanguageFunction function) {
        if (functionName.contains("__")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Function names with double underscore are not supported");
        }
        try {
            UserDefinedFunctionInput functionInput = GlueInputConverter.convertFunction(functionName, function);
            this.stats.getCreateUserDefinedFunction().call(() -> this.glueClient.createUserDefinedFunction(new CreateUserDefinedFunctionRequest().withDatabaseName(databaseName).withFunctionInput(functionInput)));
        }
        catch (AlreadyExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Function already exists", (Throwable)e);
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(databaseName, (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void replaceFunction(String databaseName, String functionName, LanguageFunction function) {
        try {
            UserDefinedFunctionInput functionInput = GlueInputConverter.convertFunction(functionName, function);
            this.stats.getUpdateUserDefinedFunction().call(() -> this.glueClient.updateUserDefinedFunction(new UpdateUserDefinedFunctionRequest().withDatabaseName(databaseName).withFunctionName(ThriftMetastoreUtil.metastoreFunctionName(functionName, function.signatureToken())).withFunctionInput(functionInput)));
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropFunction(String databaseName, String functionName, String signatureToken) {
        try {
            this.stats.getDeleteUserDefinedFunction().call(() -> this.glueClient.deleteUserDefinedFunction(new DeleteUserDefinedFunctionRequest().withDatabaseName(databaseName).withFunctionName(ThriftMetastoreUtil.metastoreFunctionName(functionName, signatureToken))));
        }
        catch (EntityNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "Function not found", (Throwable)e);
        }
        catch (AmazonServiceException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private Stream<com.amazonaws.services.glue.model.Table> getGlueTables(String databaseName) {
        return AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)this.glueClient).getTables(arg_0), new GetTablesRequest().withDatabaseName(databaseName).withMaxResults(Integer.valueOf(100)), GetTablesRequest::setNextToken, GetTablesResult::getNextToken, this.stats.getGetTables()).map(GetTablesResult::getTableList).flatMap(Collection::stream);
    }

    static class StatsRecordingAsyncHandler<Request extends AmazonWebServiceRequest, Result>
    implements AsyncHandler<Request, Result> {
        private final AwsApiCallStats stats;
        private final Stopwatch stopwatch;

        public StatsRecordingAsyncHandler(AwsApiCallStats stats) {
            this.stats = Objects.requireNonNull(stats, "stats is null");
            this.stopwatch = Stopwatch.createStarted();
        }

        public void onError(Exception e) {
            this.stats.recordCall(this.stopwatch.elapsed(TimeUnit.NANOSECONDS), true);
        }

        public void onSuccess(AmazonWebServiceRequest request, Object o) {
            this.stats.recordCall(this.stopwatch.elapsed(TimeUnit.NANOSECONDS), false);
        }
    }
}

