/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.hive.thrift.metastore.AlreadyExistsException;
import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.ConfigValSecurityException;
import io.trino.hive.thrift.metastore.DataOperationType;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.EnvironmentContext;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.Function;
import io.trino.hive.thrift.metastore.HiveObjectPrivilege;
import io.trino.hive.thrift.metastore.HiveObjectRef;
import io.trino.hive.thrift.metastore.HiveObjectType;
import io.trino.hive.thrift.metastore.InvalidInputException;
import io.trino.hive.thrift.metastore.InvalidObjectException;
import io.trino.hive.thrift.metastore.InvalidOperationException;
import io.trino.hive.thrift.metastore.LockComponent;
import io.trino.hive.thrift.metastore.LockLevel;
import io.trino.hive.thrift.metastore.LockRequest;
import io.trino.hive.thrift.metastore.LockResponse;
import io.trino.hive.thrift.metastore.LockState;
import io.trino.hive.thrift.metastore.LockType;
import io.trino.hive.thrift.metastore.MetaException;
import io.trino.hive.thrift.metastore.NoSuchLockException;
import io.trino.hive.thrift.metastore.NoSuchObjectException;
import io.trino.hive.thrift.metastore.NoSuchTxnException;
import io.trino.hive.thrift.metastore.Partition;
import io.trino.hive.thrift.metastore.PrivilegeBag;
import io.trino.hive.thrift.metastore.PrivilegeGrantInfo;
import io.trino.hive.thrift.metastore.TxnAbortedException;
import io.trino.hive.thrift.metastore.TxnToWriteId;
import io.trino.hive.thrift.metastore.UnknownDBException;
import io.trino.hive.thrift.metastore.UnknownTableException;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionNotFoundException;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.AcidTransactionOwner;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.SparkMetastoreUtil;
import io.trino.plugin.hive.metastore.StatisticsUpdateMode;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.RetryDriver;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

@ThreadSafe
public final class ThriftHiveMetastore
implements ThriftMetastore {
    private static final Logger log = Logger.get(ThriftHiveMetastore.class);
    private static final String DEFAULT_METASTORE_USER = "presto";
    private static final CharMatcher DOT_MATCHER = CharMatcher.is((char)'.');
    private final Optional<ConnectorIdentity> identity;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final IdentityAwareMetastoreClientFactory metastoreClientFactory;
    private final double backoffScaleFactor;
    private final Duration minBackoffDelay;
    private final Duration maxBackoffDelay;
    private final Duration maxRetryTime;
    private final Duration maxWaitForLock;
    private final int maxRetries;
    private final boolean deleteFilesOnDrop;
    private final boolean translateHiveViews;
    private final boolean assumeCanonicalPartitionKeys;
    private final boolean useSparkTableStatisticsFallback;
    private final boolean batchMetadataFetchEnabled;
    private final ThriftMetastoreStats stats;
    private final ExecutorService writeStatisticsExecutor;

    public ThriftHiveMetastore(Optional<ConnectorIdentity> identity, TrinoFileSystemFactory fileSystemFactory, IdentityAwareMetastoreClientFactory metastoreClientFactory, double backoffScaleFactor, Duration minBackoffDelay, Duration maxBackoffDelay, Duration maxRetryTime, Duration maxWaitForLock, int maxRetries, boolean deleteFilesOnDrop, boolean translateHiveViews, boolean assumeCanonicalPartitionKeys, boolean useSparkTableStatisticsFallback, boolean batchMetadataFetchEnabled, ThriftMetastoreStats stats, ExecutorService writeStatisticsExecutor) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.metastoreClientFactory = Objects.requireNonNull(metastoreClientFactory, "metastoreClientFactory is null");
        this.backoffScaleFactor = backoffScaleFactor;
        this.minBackoffDelay = Objects.requireNonNull(minBackoffDelay, "minBackoffDelay is null");
        this.maxBackoffDelay = Objects.requireNonNull(maxBackoffDelay, "maxBackoffDelay is null");
        this.maxRetryTime = Objects.requireNonNull(maxRetryTime, "maxRetryTime is null");
        this.maxWaitForLock = Objects.requireNonNull(maxWaitForLock, "maxWaitForLock is null");
        this.maxRetries = maxRetries;
        this.deleteFilesOnDrop = deleteFilesOnDrop;
        this.translateHiveViews = translateHiveViews;
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        this.useSparkTableStatisticsFallback = useSparkTableStatisticsFallback;
        this.batchMetadataFetchEnabled = batchMetadataFetchEnabled;
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.writeStatisticsExecutor = Objects.requireNonNull(writeStatisticsExecutor, "writeStatisticsExecutor is null");
    }

    @VisibleForTesting
    public ThriftMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            return this.retry().stopOnIllegalExceptions().run("getAllDatabases", this.stats.getGetAllDatabases().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<String> list = client.getAllDatabases();
                    return list;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getDatabase", this.stats.getGetDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<Database> optional = Optional.of(client.getDatabase(databaseName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getAllTables", () -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<String> list = client.getAllTables(databaseName);
                    return list;
                }
            });
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getTablesWithParameter", this.stats.getGetTablesWithParameter().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<String> list = client.getTablesWithParameter(databaseName, parameterKey, parameterValue);
                    return list;
                }
            }));
        }
        catch (UnknownDBException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<io.trino.hive.thrift.metastore.Table> getTable(String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getTable", this.stats.getGetTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<io.trino.hive.thrift.metastore.Table> optional = Optional.of(client.getTable(databaseName, tableName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return ThriftMetastoreUtil.getSupportedColumnStatistics(type);
    }

    @Override
    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getTableColumnStatistics", this.stats.getGetTableColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Map<String, HiveColumnStatistics> map = ThriftHiveMetastore.groupStatisticsByColumn(client.getTableColumnStatistics(databaseName, tableName, (List<String>)ImmutableList.copyOf((Collection)columnNames)));
                    return map;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
        return (Map)this.getPartitionColumnStatistics(databaseName, tableName, partitionNames, (List<String>)ImmutableList.copyOf(columnNames)).entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ThriftHiveMetastore.groupStatisticsByColumn((List)entry.getValue())));
    }

    @Override
    public boolean useSparkTableStatistics() {
        return this.useSparkTableStatisticsFallback;
    }

    @Override
    public Optional<List<FieldSchema>> getFields(String databaseName, String tableName) {
        try {
            return this.retry().stopOn(MetaException.class, UnknownTableException.class, UnknownDBException.class).stopOnIllegalExceptions().run("getFields", this.stats.getGetFields().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<ImmutableList> optional = Optional.of(ImmutableList.copyOf(client.getFields(databaseName, tableName)));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, List<String> columnNames) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionColumnStatistics", this.stats.getGetPartitionColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Map<String, List<ColumnStatisticsObj>> map = client.getPartitionColumnStatistics(databaseName, tableName, (List<String>)ImmutableList.copyOf((Collection)partitionNames), columnNames);
                    return map;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private static Map<String, HiveColumnStatistics> groupStatisticsByColumn(List<ColumnStatisticsObj> statistics) {
        HashMap<String, HiveColumnStatistics> statisticsByColumn = new HashMap<String, HiveColumnStatistics>();
        for (ColumnStatisticsObj stats : statistics) {
            HiveColumnStatistics newColumnStatistics = ThriftMetastoreUtil.fromMetastoreApiColumnStatistics(stats);
            if (statisticsByColumn.containsKey(stats.getColName())) {
                HiveColumnStatistics existingColumnStatistics = (HiveColumnStatistics)statisticsByColumn.get(stats.getColName());
                if (newColumnStatistics.equals(existingColumnStatistics)) continue;
                log.warn("Ignore inconsistent statistics in %s column: %s and %s", new Object[]{stats.getColName(), newColumnStatistics, existingColumnStatistics});
                continue;
            }
            statisticsByColumn.put(stats.getColName(), newColumnStatistics);
        }
        return ImmutableMap.copyOf(statisticsByColumn);
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
        io.trino.hive.thrift.metastore.Table originalTable = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        PartitionStatistics currentStatistics = this.getCurrentTableStatistics(originalTable);
        PartitionStatistics updatedStatistics = mode.updatePartitionStatistics(currentStatistics, statisticsUpdate);
        io.trino.hive.thrift.metastore.Table modifiedTable = originalTable.deepCopy();
        modifiedTable.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(modifiedTable.getParameters(), updatedStatistics.getBasicStatistics()));
        if (transaction.isAcidTransactionRunning()) {
            modifiedTable.setWriteId(transaction.getWriteId());
        }
        this.alterTable(databaseName, tableName, modifiedTable);
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable(modifiedTable);
        List metastoreColumnStatistics = (List)updatedStatistics.getColumnStatistics().entrySet().stream().flatMap(entry -> {
            Optional<Column> column = table.getColumn((String)entry.getKey());
            if (column.isEmpty() && ThriftMetastoreUtil.isAvroTableWithSchemaSet(modifiedTable)) {
                return Stream.of(new ColumnStatisticsObj[0]);
            }
            HiveType type = column.orElseThrow(() -> new IllegalStateException("Column not found: " + (String)entry.getKey())).getType();
            return Stream.of(ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), type, (HiveColumnStatistics)entry.getValue()));
        }).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setTableColumnStatistics(databaseName, tableName, metastoreColumnStatistics);
        }
        Sets.SetView removedColumnStatistics = Sets.difference(currentStatistics.getColumnStatistics().keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedColumnStatistics.forEach(column -> this.deleteTableColumnStatistics(databaseName, tableName, (String)column));
    }

    private PartitionStatistics getCurrentTableStatistics(io.trino.hive.thrift.metastore.Table table) {
        Optional<PartitionStatistics> sparkTableStatistics;
        Map columns = (Map)table.getSd().getCols().stream().collect(ImmutableMap.toImmutableMap(FieldSchema::getName, fieldSchema -> HiveType.valueOf(fieldSchema.getType())));
        if (this.useSparkTableStatisticsFallback && (sparkTableStatistics = SparkMetastoreUtil.getSparkTableStatistics(table.getParameters(), columns)).isPresent()) {
            return sparkTableStatistics.get();
        }
        HiveBasicStatistics basicStatistics = ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters());
        Map<String, HiveColumnStatistics> columnStatistics = this.getTableColumnStatistics(table.getDbName(), table.getTableName(), columns.keySet());
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    private void setTableColumnStatistics(String databaseName, String tableName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setTableColumnStatistics", this.stats.getSetTableColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.setTableColumnStatistics(databaseName, tableName, statistics);
                    Object var5_5 = null;
                    return var5_5;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deleteTableColumnStatistics(String databaseName, String tableName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deleteTableColumnStatistics", this.stats.getDeleteTableColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.deleteTableColumnStatistics(databaseName, tableName, columnName);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void updatePartitionStatistics(io.trino.hive.thrift.metastore.Table table, String partitionName, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
        List<Partition> partitions = this.getPartitionsByNames(table.getDbName(), table.getTableName(), (List<String>)ImmutableList.of((Object)partitionName));
        if (partitions.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "No partition found for name: " + partitionName);
        }
        if (partitions.size() != 1) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Metastore returned multiple partitions for name: " + partitionName);
        }
        Partition originalPartition = (Partition)Iterables.getOnlyElement(partitions);
        HiveBasicStatistics currentBasicStats = ThriftMetastoreUtil.getHiveBasicStatistics(originalPartition.getParameters());
        Map<String, HiveColumnStatistics> currentColumnStats = this.getPartitionColumnStatistics(table.getDbName(), table.getTableName(), (Set<String>)ImmutableSet.of((Object)partitionName), (Set)table.getSd().getCols().stream().map(FieldSchema::getName).collect(ImmutableSet.toImmutableSet())).getOrDefault(partitionName, (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        PartitionStatistics updatedStatistics = mode.updatePartitionStatistics(new PartitionStatistics(currentBasicStats, currentColumnStats), statisticsUpdate);
        Partition modifiedPartition = originalPartition.deepCopy();
        HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
        modifiedPartition.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(modifiedPartition.getParameters(), basicStatistics));
        this.alterPartitionWithoutStatistics(table.getDbName(), table.getTableName(), modifiedPartition);
        Map columns = (Map)modifiedPartition.getSd().getCols().stream().collect(ImmutableMap.toImmutableMap(FieldSchema::getName, schema -> HiveType.valueOf(schema.getType())));
        this.setPartitionColumnStatistics(table.getDbName(), table.getTableName(), partitionName, columns, updatedStatistics.getColumnStatistics());
        Sets.SetView removedStatistics = Sets.difference(currentColumnStats.keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedStatistics.forEach(column -> this.deletePartitionColumnStatistics(table.getDbName(), table.getTableName(), partitionName, (String)column));
    }

    private void setPartitionColumnStatistics(String databaseName, String tableName, String partitionName, Map<String, HiveType> columns, Map<String, HiveColumnStatistics> columnStatistics) {
        List metastoreColumnStatistics = (List)columnStatistics.entrySet().stream().filter(entry -> columns.containsKey(entry.getKey())).map(entry -> ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), (HiveType)columns.get(entry.getKey()), (HiveColumnStatistics)entry.getValue())).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setPartitionColumnStatistics(databaseName, tableName, partitionName, metastoreColumnStatistics);
        }
    }

    private void setPartitionColumnStatistics(String databaseName, String tableName, String partitionName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setPartitionColumnStatistics", this.stats.getSetPartitionColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.setPartitionColumnStatistics(databaseName, tableName, partitionName, statistics);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deletePartitionColumnStatistics(String databaseName, String tableName, String partitionName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deletePartitionColumnStatistics", this.stats.getDeletePartitionColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.deletePartitionColumnStatistics(databaseName, tableName, partitionName, columnName);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("createRole", this.stats.getCreateRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.createRole(role, grantor);
                    Object var4_4 = null;
                    return var4_4;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("dropRole", this.stats.getDropRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.dropRole(role);
                    Object var3_3 = null;
                    return var3_3;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<String> listRoles() {
        try {
            return (Set)this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoles", this.stats.getListRoles().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    ImmutableSet immutableSet = ImmutableSet.copyOf(client.getRoleNames());
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        for (HivePrincipal grantee : grantees) {
            for (String role : roles) {
                this.grantRole(role, grantee.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(grantee.getType()), grantor.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(grantor.getType()), adminOption);
            }
        }
    }

    private void grantRole(String role, String granteeName, io.trino.hive.thrift.metastore.PrincipalType granteeType, String grantorName, io.trino.hive.thrift.metastore.PrincipalType grantorType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("grantRole", this.stats.getGrantRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.grantRole(role, granteeName, granteeType, grantorName, grantorType, grantOption);
                    Object var8_8 = null;
                    return var8_8;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        for (HivePrincipal grantee : grantees) {
            for (String role : roles) {
                this.revokeRole(role, grantee.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(grantee.getType()), adminOption);
            }
        }
    }

    private void revokeRole(String role, String granteeName, io.trino.hive.thrift.metastore.PrincipalType granteeType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("revokeRole", this.stats.getRevokeRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.revokeRole(role, granteeName, granteeType, grantOption);
                    Object var6_6 = null;
                    return var6_6;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        try {
            return this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoleGrants", this.stats.getListRoleGrants().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Set<RoleGrant> set = ThriftMetastoreUtil.fromRolePrincipalGrants(client.listRoleGrants(principal.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(principal.getType())));
                    return set;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllViews", this.stats.getGetAllViews().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    if (this.translateHiveViews) {
                        List<String> list = client.getAllViews(databaseName);
                        return list;
                    }
                    List<String> list = client.getTablesWithParameter(databaseName, "presto_view", "true");
                    return list;
                }
            }));
        }
        catch (UnknownDBException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<SchemaTableName>> getAllTables() {
        if (!this.batchMetadataFetchEnabled) {
            return Optional.empty();
        }
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllTables", this.stats.getGetAllTables().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<List<SchemaTableName>> optional = client.getAllTables();
                    return optional;
                }
            }));
        }
        catch (TTransportException e) {
            log.warn((Throwable)e, "Failed to get all views");
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<SchemaTableName>> getAllViews() {
        if (!this.translateHiveViews) {
            return Optional.empty();
        }
        if (!this.batchMetadataFetchEnabled) {
            return Optional.empty();
        }
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllViews", this.stats.getGetAllViews().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<List<SchemaTableName>> optional = client.getAllViews();
                    return optional;
                }
            }));
        }
        catch (TTransportException e) {
            log.warn((Throwable)e, "Failed to get all tables");
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createDatabase(Database database) {
        ThriftHiveMetastore.validateObjectName(database.getName());
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class).stopOnIllegalExceptions().run("createDatabase", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.createDatabase(database);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getName(), e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidOperationException.class).stopOnIllegalExceptions().run("dropDatabase", this.stats.getDropDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.dropDatabase(databaseName, deleteData, false);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName, (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterDatabase(String databaseName, Database database) {
        if (!Objects.equals(databaseName, database.getName())) {
            ThriftHiveMetastore.validateObjectName(database.getName());
        }
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterDatabase", this.stats.getAlterDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.alterDatabase(databaseName, database);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName, (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createTable(io.trino.hive.thrift.metastore.Table table) {
        ThriftHiveMetastore.validateObjectName(table.getTableName());
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createTable", this.stats.getCreateTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.createTable(table);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDbName(), table.getTableName()), e);
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(table.getDbName(), (Throwable)e);
        }
        catch (InvalidObjectException e) {
            boolean databaseMissing;
            try {
                databaseMissing = this.getDatabase(table.getDbName()).isEmpty();
            }
            catch (Exception databaseCheckException) {
                e.addSuppressed((Throwable)databaseCheckException);
                databaseMissing = false;
            }
            if (databaseMissing) {
                throw new SchemaNotFoundException(table.getDbName(), (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        AtomicInteger attemptCount = new AtomicInteger();
        try {
            this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropTable", this.stats.getDropTable().wrap(() -> {
                ThriftMetastoreClient client = this.createMetastoreClient();
                try {
                    io.trino.hive.thrift.metastore.Table table;
                    attemptCount.incrementAndGet();
                    try {
                        table = client.getTable(databaseName, tableName);
                    }
                    catch (NoSuchObjectException e) {
                        if (attemptCount.get() == 1) {
                            throw e;
                        }
                        Object var8_11 = null;
                        if (client != null) {
                            client.close();
                        }
                        return var8_11;
                    }
                    client.dropTable(databaseName, tableName, deleteData);
                    String tableLocation = table.getSd().getLocation();
                    if (this.deleteFilesOnDrop && deleteData && ThriftHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)tableLocation)) {
                        this.deleteDirRecursive(Location.of((String)tableLocation));
                    }
                }
                finally {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName), (Throwable)e);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deleteDirRecursive(Location path) {
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(this.identity.orElseGet(() -> ConnectorIdentity.ofUser((String)DEFAULT_METASTORE_USER)));
            fileSystem.deleteDirectory(path);
        }
        catch (IOException | RuntimeException e) {
            log.warn((Throwable)e, "Failed to delete path: %s", new Object[]{path});
        }
    }

    private static boolean isManagedTable(io.trino.hive.thrift.metastore.Table table) {
        return table.getTableType().equals(TableType.MANAGED_TABLE.name());
    }

    @Override
    public void alterTable(String databaseName, String tableName, io.trino.hive.thrift.metastore.Table table) {
        if (!Objects.equals(databaseName, table.getDbName())) {
            ThriftHiveMetastore.validateObjectName(table.getDbName());
        }
        if (!Objects.equals(tableName, table.getTableName())) {
            ThriftHiveMetastore.validateObjectName(table.getTableName());
        }
        try {
            this.retry().stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("alterTable", this.stats.getAlterTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    EnvironmentContext context = new EnvironmentContext();
                    context.setProperties((Map)ImmutableMap.of((Object)"DO_NOT_UPDATE_STATS", (Object)"true"));
                    client.alterTableWithEnvironmentContext(databaseName, tableName, table, context);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterTransactionalTable(io.trino.hive.thrift.metastore.Table table, long transactionId, long writeId) {
        try {
            this.retry().stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("alterTransactionalTable", this.stats.getAlterTransactionalTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.alterTransactionalTable(table, transactionId, writeId, new EnvironmentContext());
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        Preconditions.checkArgument((!columnNames.isEmpty() || partitionKeysFilter.isAll() ? 1 : 0) != 0, (Object)"must pass in all columnNames or the filter must be all");
        Optional<List<String>> parts = MetastoreUtil.partitionKeyFilterToStringList(columnNames, partitionKeysFilter, this.assumeCanonicalPartitionKeys);
        if (parts.isEmpty()) {
            return Optional.of(ImmutableList.of());
        }
        try {
            if (partitionKeysFilter.isAll()) {
                return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNames", this.stats.getGetPartitionNames().wrap(() -> {
                    try (ThriftMetastoreClient client = this.createMetastoreClient();){
                        Optional<List<String>> optional = Optional.of(client.getPartitionNames(databaseName, tableName));
                        return optional;
                    }
                }));
            }
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNamesByParts", this.stats.getGetPartitionNamesByParts().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<List<String>> optional = Optional.of(client.getPartitionNamesFiltered(databaseName, tableName, (List)parts.get()));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitionsWithStatistics) {
        List partitions = (List)partitionsWithStatistics.stream().map(ThriftMetastoreUtil::toMetastoreApiPartition).collect(ImmutableList.toImmutableList());
        this.addPartitionsWithoutStatistics(databaseName, tableName, partitions);
        ArrayList updateStatisticsFutures = new ArrayList();
        for (PartitionWithStatistics partitionWithStatistics : partitionsWithStatistics) {
            updateStatisticsFutures.add(this.writeStatisticsExecutor.submit(() -> this.storePartitionColumnStatistics(databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics)));
        }
        try {
            updateStatisticsFutures.forEach(MoreFutures::getFutureValue);
        }
        catch (Throwable failure) {
            block5: {
                try {
                    updateStatisticsFutures.forEach(future -> future.cancel(true));
                }
                catch (RuntimeException e) {
                    if (failure == e) break block5;
                    failure.addSuppressed(e);
                }
            }
            throw failure;
        }
    }

    private void addPartitionsWithoutStatistics(String databaseName, String tableName, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return;
        }
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class, TrinoException.class).stopOnIllegalExceptions().run("addPartitions", this.stats.getAddPartitions().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    int partitionsAdded = client.addPartitions(partitions);
                    if (partitionsAdded != partitions.size()) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, String.format("Hive metastore only added %s of %s partitions", partitionsAdded, partitions.size()));
                    }
                    Object var4_5 = null;
                    return var4_5;
                }
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("One or more partitions already exist for table '%s.%s'", databaseName, tableName), (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("dropPartition", this.stats.getDropPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Partition partition = client.getPartition(databaseName, tableName, parts);
                    client.dropPartition(databaseName, tableName, parts, deleteData);
                    String partitionLocation = partition.getSd().getLocation();
                    if (this.deleteFilesOnDrop && deleteData && !Strings.isNullOrEmpty((String)partitionLocation) && ThriftHiveMetastore.isManagedTable(client.getTable(databaseName, tableName))) {
                        this.deleteDirRecursive(Location.of((String)partitionLocation));
                    }
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        this.alterPartitionWithoutStatistics(databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiPartition(partitionWithStatistics));
        this.storePartitionColumnStatistics(databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics);
        this.dropExtraColumnStatisticsAfterAlterPartition(databaseName, tableName, partitionWithStatistics);
    }

    private void alterPartitionWithoutStatistics(String databaseName, String tableName, Partition partition) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterPartition", this.stats.getAlterPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.alterPartition(databaseName, tableName, partition);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getValues());
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void storePartitionColumnStatistics(String databaseName, String tableName, String partitionName, PartitionWithStatistics partitionWithStatistics) {
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        Map<String, HiveColumnStatistics> columnStatistics = statistics.getColumnStatistics();
        if (columnStatistics.isEmpty()) {
            return;
        }
        Map columnTypes = (Map)partitionWithStatistics.getPartition().getColumns().stream().collect(ImmutableMap.toImmutableMap(Column::getName, Column::getType));
        this.setPartitionColumnStatistics(databaseName, tableName, partitionName, columnTypes, columnStatistics);
    }

    private void dropExtraColumnStatisticsAfterAlterPartition(String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        List dataColumns = (List)partitionWithStatistics.getPartition().getColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        HashSet columnsWithMissingStatistics = new HashSet(dataColumns);
        columnsWithMissingStatistics.removeAll(partitionWithStatistics.getStatistics().getColumnStatistics().keySet());
        if (columnsWithMissingStatistics.isEmpty()) {
            return;
        }
        String partitionName = partitionWithStatistics.getPartitionName();
        List<ColumnStatisticsObj> statisticsToBeRemoved = this.getPartitionColumnStatistics(databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName), (List<String>)ImmutableList.copyOf(columnsWithMissingStatistics)).getOrDefault(partitionName, (List<ColumnStatisticsObj>)ImmutableList.of());
        for (ColumnStatisticsObj statistics : statisticsToBeRemoved) {
            this.deletePartitionColumnStatistics(databaseName, tableName, partitionName, statistics.getColName());
        }
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartition", this.stats.getGetPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<Partition> optional = Optional.of(client.getPartition(databaseName, tableName, partitionValues));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!partitionNames.isEmpty() ? 1 : 0) != 0, (Object)"partitionNames is empty");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionsByNames().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<Partition> list = client.getPartitionsByNames(databaseName, tableName, partitionNames);
                    return list;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        Set requestedPrivileges = (Set)privileges.stream().map(privilege -> new HivePrivilegeInfo((HivePrivilegeInfo.HivePrivilege)((Object)privilege), grantOption, grantor, grantee)).map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((!ThriftHiveMetastore.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("grantTablePrivileges", this.stats.getGrantTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    Set<HivePrivilegeInfo> existingPrivileges = this.listTablePrivileges(databaseName, tableName, Optional.of(tableOwner), Optional.of(grantee));
                    HashSet<PrivilegeGrantInfo> privilegesToGrant = new HashSet<PrivilegeGrantInfo>(requestedPrivileges);
                    Iterator iterator = privilegesToGrant.iterator();
                    while (iterator.hasNext()) {
                        HivePrivilegeInfo requestedPrivilege = (HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege((PrivilegeGrantInfo)iterator.next(), Optional.empty()));
                        for (HivePrivilegeInfo existingPrivilege : existingPrivileges) {
                            if (requestedPrivilege.isContainedIn(existingPrivilege)) {
                                iterator.remove();
                                continue;
                            }
                            if (!existingPrivilege.isContainedIn(requestedPrivilege)) continue;
                            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Granting %s WITH GRANT OPTION is not supported while %s possesses %s", requestedPrivilege.getHivePrivilege().name(), grantee, requestedPrivilege.getHivePrivilege().name()));
                        }
                    }
                    if (privilegesToGrant.isEmpty()) {
                        Object var10_12 = null;
                        return var10_12;
                    }
                    metastoreClient.grantPrivileges(ThriftHiveMetastore.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToGrant));
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        Set requestedPrivileges = (Set)privileges.stream().map(privilege -> new HivePrivilegeInfo((HivePrivilegeInfo.HivePrivilege)((Object)privilege), grantOption, grantor, grantee)).map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((!ThriftHiveMetastore.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("revokeTablePrivileges", this.stats.getRevokeTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    Set existingHivePrivileges = (Set)this.listTablePrivileges(databaseName, tableName, Optional.of(tableOwner), Optional.of(grantee)).stream().map(HivePrivilegeInfo::getHivePrivilege).collect(ImmutableSet.toImmutableSet());
                    Set privilegesToRevoke = (Set)requestedPrivileges.stream().filter(privilegeGrantInfo -> existingHivePrivileges.contains((Object)((HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege(privilegeGrantInfo, Optional.empty()))).getHivePrivilege())).collect(ImmutableSet.toImmutableSet());
                    if (privilegesToRevoke.isEmpty()) {
                        Object var10_12 = null;
                        return var10_12;
                    }
                    metastoreClient.revokePrivileges(ThriftHiveMetastore.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToRevoke), grantOption);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        try {
            return (Set)this.retry().stopOnIllegalExceptions().run("listTablePrivileges", this.stats.getListTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<HiveObjectPrivilege> hiveObjectPrivilegeList;
                    ImmutableSet.Builder privileges = ImmutableSet.builder();
                    if (principal.isEmpty()) {
                        tableOwner.ifPresent(owner -> privileges.add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, new HivePrincipal(PrincipalType.USER, (String)owner), new HivePrincipal(PrincipalType.USER, (String)owner))));
                        hiveObjectPrivilegeList = client.listPrivileges(null, null, new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                    } else {
                        if (tableOwner.isPresent() && ((HivePrincipal)principal.get()).getType() == PrincipalType.USER && ((String)tableOwner.get()).equals(((HivePrincipal)principal.get()).getName())) {
                            privileges.add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, (HivePrincipal)principal.get(), (HivePrincipal)principal.get()));
                        }
                        hiveObjectPrivilegeList = client.listPrivileges(((HivePrincipal)principal.get()).getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(((HivePrincipal)principal.get()).getType()), new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                    }
                    for (HiveObjectPrivilege hiveObjectPrivilege : hiveObjectPrivilegeList) {
                        HivePrincipal grantee = new HivePrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(hiveObjectPrivilege.getPrincipalType()), hiveObjectPrivilege.getPrincipalName());
                        privileges.addAll(ThriftMetastoreUtil.parsePrivilege(hiveObjectPrivilege.getGrantInfo(), Optional.of(grantee)));
                    }
                    ImmutableSet immutableSet = privileges.build();
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void checkSupportsTransactions() {
    }

    @Override
    public long openTransaction(AcidTransactionOwner transactionOwner) {
        Objects.requireNonNull(transactionOwner, "transactionOwner is null");
        try {
            return this.retry().stopOnIllegalExceptions().run("openTransaction", this.stats.getOpenTransaction().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    Long l = metastoreClient.openTransaction(transactionOwner.toString());
                    return l;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void commitTransaction(long transactionId) {
        try {
            this.retry().stopOnIllegalExceptions().run("commitTransaction", this.stats.getCommitTransaction().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    metastoreClient.commitTransaction(transactionId);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void abortTransaction(long transactionId) {
        try {
            this.retry().stopOnIllegalExceptions().run("abortTransaction", this.stats.getAbortTransaction().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    metastoreClient.abortTransaction(transactionId);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void sendTransactionHeartbeat(long transactionId) {
        try {
            this.retry().stopOnIllegalExceptions().run("sendTransactionHeartbeat", () -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    metastoreClient.sendTransactionHeartbeat(transactionId);
                }
                return null;
            });
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void acquireSharedReadLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.acquireSharedLock(transactionOwner, queryId, transactionId, fullTables, partitions, DataOperationType.SELECT, false);
    }

    @Override
    public void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        this.acquireSharedLock(transactionOwner, queryId, transactionId, (List<SchemaTableName>)ImmutableList.of((Object)new SchemaTableName(dbName, tableName)), Collections.emptyList(), operation, isDynamicPartitionWrite);
    }

    private void acquireSharedLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions, DataOperationType operation, boolean isDynamicPartitionWrite) {
        Objects.requireNonNull(operation, "operation is null");
        Objects.requireNonNull(transactionOwner, "transactionOwner is null");
        Objects.requireNonNull(queryId, "queryId is null");
        if (fullTables.isEmpty() && partitions.isEmpty()) {
            return;
        }
        LockRequest request = new LockRequest().setHostname(ThriftHiveMetastore.getLocalHostName()).setAgentInfo(queryId).setUser(transactionOwner.toString()).setTxnid(transactionId);
        for (SchemaTableName table : fullTables) {
            request.addToComponent(ThriftHiveMetastore.createLockComponentForOperation(table, operation, isDynamicPartitionWrite, Optional.empty()));
        }
        for (HivePartition partition : partitions) {
            request.addToComponent(ThriftHiveMetastore.createLockComponentForOperation(partition.getTableName(), operation, isDynamicPartitionWrite, Optional.of(partition.getPartitionId())));
        }
        this.acquireLock(String.format("hive transaction %s for query %s", transactionId, queryId), request);
    }

    @Override
    public long acquireTableExclusiveLock(AcidTransactionOwner transactionOwner, String queryId, String dbName, String tableName) {
        Objects.requireNonNull(transactionOwner, "transactionOwner is null");
        LockRequest request = new LockRequest().setHostname(ThriftHiveMetastore.getLocalHostName()).setAgentInfo(queryId).setUser(transactionOwner.toString());
        request.addToComponent(new LockComponent().setType(LockType.EXCLUSIVE).setLevel(LockLevel.TABLE).setDbname(dbName).setTablename(tableName));
        return this.acquireLock(String.format("query %s", queryId), request);
    }

    private long acquireLock(String context, LockRequest lockRequest) {
        try {
            LockResponse response = this.retry().stopOn(NoSuchTxnException.class, TxnAbortedException.class, MetaException.class).run("acquireLock", this.stats.getAcquireLock().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    LockResponse lockResponse = metastoreClient.acquireLock(lockRequest);
                    return lockResponse;
                }
            }));
            long lockId = response.getLockid();
            long waitStart = System.nanoTime();
            while (response.getState() == LockState.WAITING) {
                if (Duration.nanosSince((long)waitStart).compareTo(this.maxWaitForLock) > 0) {
                    throw this.unlockSuppressing(lockId, new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_LOCK_NOT_ACQUIRED, String.format("Timed out waiting for lock %d for %s", lockId, context)));
                }
                log.debug("Waiting for lock %d for %s", new Object[]{lockId, context});
                response = this.retry().stopOn(NoSuchTxnException.class, NoSuchLockException.class, TxnAbortedException.class, MetaException.class).run("checkLock", this.stats.getCheckLock().wrap(() -> {
                    try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                        LockResponse lockResponse = metastoreClient.checkLock(lockId);
                        return lockResponse;
                    }
                }));
            }
            if (response.getState() != LockState.ACQUIRED) {
                throw this.unlockSuppressing(lockId, new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_LOCK_NOT_ACQUIRED, "Could not acquire lock. Lock in state " + String.valueOf(response.getState())));
            }
            return response.getLockid();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private <T extends Exception> T unlockSuppressing(long lockId, T exception) {
        try {
            this.releaseTableLock(lockId);
        }
        catch (RuntimeException e) {
            exception.addSuppressed(e);
        }
        return exception;
    }

    @Override
    public void releaseTableLock(long lockId) {
        try {
            this.retry().stopOn(NoSuchTxnException.class, NoSuchLockException.class, TxnAbortedException.class, MetaException.class).run("unlock", this.stats.getUnlock().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    metastoreClient.unlock(lockId);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private static LockComponent createLockComponentForOperation(SchemaTableName table, DataOperationType operation, boolean isDynamicPartitionWrite, Optional<String> partitionName) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitionName, "partitionName is null");
        LockComponent component = new LockComponent().setType(LockType.SHARED_READ).setOperationType(operation).setDbname(table.getSchemaName()).setTablename(table.getTableName()).setIsTransactional(true).setIsDynamicPartitionWrite(isDynamicPartitionWrite).setLevel(LockLevel.TABLE);
        partitionName.ifPresent(name -> component.setPartitionname(name).setLevel(LockLevel.PARTITION));
        return component;
    }

    private static String getLocalHostName() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to determine local host");
        }
        return hostName;
    }

    @Override
    public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        try {
            return this.retry().stopOnIllegalExceptions().run("getValidWriteIds", this.stats.getValidWriteIds().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    String string = metastoreClient.getValidWriteIds((List)tables.stream().map(table -> String.format("%s.%s", table.getSchemaName(), table.getTableName())).collect(ImmutableList.toImmutableList()), currentTransactionId);
                    return string;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed to open transaction. Transactional tables support requires Hive metastore version at least 3.0", (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        try {
            return this.retry().stopOnIllegalExceptions().run("getConfigValueFromServer", () -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    Optional<String> optional = Optional.ofNullable(metastoreClient.getConfigValue(name, null));
                    return optional;
                }
            });
        }
        catch (ConfigValSecurityException e) {
            log.debug((Throwable)e, "Could not fetch value for config '%s' from Hive", new Object[]{name});
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public long allocateWriteId(String dbName, String tableName, long transactionId) {
        try {
            return this.retry().stopOnIllegalExceptions().run("allocateWriteId", this.stats.getAllocateWriteId().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    List<TxnToWriteId> list = metastoreClient.allocateTableWriteIds(dbName, tableName, (List<Long>)ImmutableList.of((Object)transactionId));
                    Long l = ((TxnToWriteId)Iterables.getOnlyElement(list)).getWriteId();
                    return l;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        Preconditions.checkArgument((transactionId > 0L ? 1 : 0) != 0, (String)"transactionId should be a positive integer, but was %s", (long)transactionId);
        Objects.requireNonNull(dbName, "dbName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Preconditions.checkArgument((writeId > 0L ? 1 : 0) != 0, (String)"writeId should be a positive integer, but was %s", (long)writeId);
        try {
            io.trino.hive.thrift.metastore.Table table = this.getTable(dbName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(dbName, tableName)));
            rowCountChange.ifPresent(rowCount -> table.setParameters(MetastoreUtil.adjustRowCount(table.getParameters(), tableName, rowCount)));
            this.retry().stopOnIllegalExceptions().run("updateTableWriteId", this.stats.getUpdateTableWriteId().wrap(() -> {
                this.alterTransactionalTable(table, transactionId, writeId);
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        Preconditions.checkArgument((writeId > 0L ? 1 : 0) != 0, (String)"writeId should be a positive integer, but was %s", (long)writeId);
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!partitionNames.isEmpty() ? 1 : 0) != 0, (Object)"partitionNames is empty");
        try {
            this.retry().stopOnIllegalExceptions().run("alterPartitions", this.stats.getAddDynamicPartitions().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    metastoreClient.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<Function> getFunction(String databaseName, String functionName) {
        try {
            return this.retry().stopOn(MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("getFunction", this.stats.getGetFunction().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<Function> optional = Optional.of(client.getFunction(databaseName, functionName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            if (e instanceof MetaException && Strings.nullToEmpty((String)e.getMessage()).startsWith("NoSuchObjectException(")) {
                return Optional.empty();
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Collection<String> getFunctions(String databaseName, String functionNamePattern) {
        try {
            return this.retry().stopOnIllegalExceptions().run("getFunctions", this.stats.getGetFunctions().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Collection<String> collection = client.getFunctions(databaseName, functionNamePattern);
                    return collection;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createFunction(Function function) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createFunction", this.stats.getCreateFunction().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.createFunction(function);
                    Object var3_3 = null;
                    return var3_3;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(function.getDbName());
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterFunction(Function function) {
        try {
            this.retry().stopOn(InvalidOperationException.class).stopOnIllegalExceptions().run("alterFunction", this.stats.getAlterFunction().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.alterFunction(function);
                    Object var3_3 = null;
                    return var3_3;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropFunction(String databaseName, String functionName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropFunction", this.stats.getDropFunction().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.dropFunction(databaseName, functionName);
                    Object var4_4 = null;
                    return var4_4;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private static PrivilegeBag buildPrivilegeBag(String databaseName, String tableName, HivePrincipal grantee, Set<PrivilegeGrantInfo> privilegeGrantInfos) {
        ImmutableList.Builder privilegeBagBuilder = ImmutableList.builder();
        for (PrivilegeGrantInfo privilegeGrantInfo : privilegeGrantInfos) {
            privilegeBagBuilder.add((Object)new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null), grantee.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(grantee.getType()), privilegeGrantInfo, "SQL"));
        }
        return new PrivilegeBag((List)privilegeBagBuilder.build());
    }

    private static boolean containsAllPrivilege(Set<PrivilegeGrantInfo> requestedPrivileges) {
        return requestedPrivileges.stream().anyMatch(privilege -> privilege.getPrivilege().equalsIgnoreCase("all"));
    }

    private ThriftMetastoreClient createMetastoreClient() throws TException {
        return this.metastoreClientFactory.createMetastoreClientFor(this.identity);
    }

    private RetryDriver retry() {
        return RetryDriver.retry().exponentialBackoff(this.minBackoffDelay, this.maxBackoffDelay, this.maxRetryTime, this.backoffScaleFactor).maxAttempts(this.maxRetries + 1).stopOn(TrinoException.class);
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }

    private static void validateObjectName(String objectName) {
        if (Strings.isNullOrEmpty((String)objectName)) {
            throw new IllegalArgumentException("The provided objectName cannot be null or empty");
        }
        if (DOT_MATCHER.matchesAllOf((CharSequence)objectName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Invalid object name: '%s'", objectName));
        }
        if (objectName.contains("/")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Invalid object name: '%s'", objectName));
        }
    }
}

