/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.EnvironmentContext;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.Function;
import io.trino.hive.thrift.metastore.HiveObjectPrivilege;
import io.trino.hive.thrift.metastore.HiveObjectRef;
import io.trino.hive.thrift.metastore.LockRequest;
import io.trino.hive.thrift.metastore.LockResponse;
import io.trino.hive.thrift.metastore.Partition;
import io.trino.hive.thrift.metastore.PrincipalType;
import io.trino.hive.thrift.metastore.PrivilegeBag;
import io.trino.hive.thrift.metastore.Role;
import io.trino.hive.thrift.metastore.RolePrincipalGrant;
import io.trino.hive.thrift.metastore.Table;
import io.trino.hive.thrift.metastore.TxnToWriteId;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.spi.connector.SchemaTableName;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.thrift.TException;

public interface ThriftMetastoreClient
extends Closeable {
    @Override
    public void close();

    public List<String> getAllDatabases() throws TException;

    public Database getDatabase(String var1) throws TException;

    public List<String> getAllTables(String var1) throws TException;

    public Optional<List<SchemaTableName>> getAllTables() throws TException;

    public List<String> getAllViews(String var1) throws TException;

    public Optional<List<SchemaTableName>> getAllViews() throws TException;

    public List<String> getTablesWithParameter(String var1, String var2, String var3) throws TException;

    public void createDatabase(Database var1) throws TException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws TException;

    public void alterDatabase(String var1, Database var2) throws TException;

    public void createTable(Table var1) throws TException;

    public void dropTable(String var1, String var2, boolean var3) throws TException;

    public void alterTableWithEnvironmentContext(String var1, String var2, Table var3, EnvironmentContext var4) throws TException;

    public Table getTable(String var1, String var2) throws TException;

    public List<FieldSchema> getFields(String var1, String var2) throws TException;

    public List<ColumnStatisticsObj> getTableColumnStatistics(String var1, String var2, List<String> var3) throws TException;

    public void setTableColumnStatistics(String var1, String var2, List<ColumnStatisticsObj> var3) throws TException;

    public void deleteTableColumnStatistics(String var1, String var2, String var3) throws TException;

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String var1, String var2, List<String> var3, List<String> var4) throws TException;

    public void setPartitionColumnStatistics(String var1, String var2, String var3, List<ColumnStatisticsObj> var4) throws TException;

    public void deletePartitionColumnStatistics(String var1, String var2, String var3, String var4) throws TException;

    public List<String> getPartitionNames(String var1, String var2) throws TException;

    public List<String> getPartitionNamesFiltered(String var1, String var2, List<String> var3) throws TException;

    public int addPartitions(List<Partition> var1) throws TException;

    public boolean dropPartition(String var1, String var2, List<String> var3, boolean var4) throws TException;

    public void alterPartition(String var1, String var2, Partition var3) throws TException;

    public Partition getPartition(String var1, String var2, List<String> var3) throws TException;

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3) throws TException;

    public List<Role> listRoles(String var1, PrincipalType var2) throws TException;

    public List<HiveObjectPrivilege> listPrivileges(String var1, PrincipalType var2, HiveObjectRef var3) throws TException;

    public List<String> getRoleNames() throws TException;

    public void createRole(String var1, String var2) throws TException;

    public void dropRole(String var1) throws TException;

    public boolean grantPrivileges(PrivilegeBag var1) throws TException;

    public boolean revokePrivileges(PrivilegeBag var1, boolean var2) throws TException;

    public void grantRole(String var1, String var2, PrincipalType var3, String var4, PrincipalType var5, boolean var6) throws TException;

    public void revokeRole(String var1, String var2, PrincipalType var3, boolean var4) throws TException;

    public List<RolePrincipalGrant> listRoleGrants(String var1, PrincipalType var2) throws TException;

    public void setUGI(String var1) throws TException;

    public long openTransaction(String var1) throws TException;

    public void commitTransaction(long var1) throws TException;

    default public void abortTransaction(long transactionId) throws TException {
        throw new UnsupportedOperationException();
    }

    public void sendTransactionHeartbeat(long var1) throws TException;

    public LockResponse acquireLock(LockRequest var1) throws TException;

    public LockResponse checkLock(long var1) throws TException;

    public void unlock(long var1) throws TException;

    public String getValidWriteIds(List<String> var1, long var2) throws TException;

    public String getConfigValue(String var1, String var2) throws TException;

    public String getDelegationToken(String var1) throws TException;

    default public List<TxnToWriteId> allocateTableWriteIds(String database, String tableName, List<Long> transactionIds) throws TException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitions(String var1, String var2, List<Partition> var3, long var4) throws TException;

    public void addDynamicPartitions(String var1, String var2, List<String> var3, long var4, long var6, AcidOperation var8) throws TException;

    public void alterTransactionalTable(Table var1, long var2, long var4, EnvironmentContext var6) throws TException;

    public Function getFunction(String var1, String var2) throws TException;

    public Collection<String> getFunctions(String var1, String var2) throws TException;

    public void createFunction(Function var1) throws TException;

    public void alterFunction(Function var1) throws TException;

    public void dropFunction(String var1, String var2) throws TException;
}

