/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.LegacyConfig;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import io.trino.plugin.hive.util.RetryDriver;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class ThriftMetastoreConfig {
    private Duration connectTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration readTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private HostAndPort socksProxy;
    private int maxRetries = 9;
    private double backoffScaleFactor = 2.0;
    private Duration minBackoffDelay = RetryDriver.DEFAULT_SLEEP_TIME;
    private Duration maxBackoffDelay = RetryDriver.DEFAULT_SLEEP_TIME;
    private Duration maxRetryTime = RetryDriver.DEFAULT_MAX_RETRY_TIME;
    private boolean impersonationEnabled;
    private boolean useSparkTableStatisticsFallback = true;
    private Duration delegationTokenCacheTtl = new Duration(1.0, TimeUnit.HOURS);
    private long delegationTokenCacheMaximumSize = 1000L;
    private boolean deleteFilesOnDrop;
    private Duration maxWaitForTransactionLock = new Duration(10.0, TimeUnit.MINUTES);
    private boolean tlsEnabled;
    private File keystorePath;
    private String keystorePassword;
    private File truststorePath;
    private String trustStorePassword;
    private boolean assumeCanonicalPartitionKeys;
    private int writeStatisticsThreads = 20;
    private boolean batchMetadataFetchEnabled = true;

    @NotNull
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="hive.metastore.thrift.client.connect-timeout")
    @LegacyConfig(value={"hive.metastore-timeout"})
    @ConfigDescription(value="Socket connect timeout for metastore client")
    public ThriftMetastoreConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @NotNull
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Config(value="hive.metastore.thrift.client.read-timeout")
    @LegacyConfig(value={"hive.metastore-timeout"})
    @ConfigDescription(value="Socket read timeout for metastore client")
    public ThriftMetastoreConfig setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="hive.metastore.thrift.client.socks-proxy")
    public ThriftMetastoreConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxRetries() {
        return this.maxRetries;
    }

    @Config(value="hive.metastore.thrift.client.max-retries")
    @ConfigDescription(value="Maximum number of retry attempts for metastore requests")
    public ThriftMetastoreConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public double getBackoffScaleFactor() {
        return this.backoffScaleFactor;
    }

    @Config(value="hive.metastore.thrift.client.backoff-scale-factor")
    @ConfigDescription(value="Scale factor for metastore request retry delay")
    public ThriftMetastoreConfig setBackoffScaleFactor(double backoffScaleFactor) {
        this.backoffScaleFactor = backoffScaleFactor;
        return this;
    }

    @NotNull
    public Duration getMaxRetryTime() {
        return this.maxRetryTime;
    }

    @Config(value="hive.metastore.thrift.client.max-retry-time")
    @ConfigDescription(value="Total time limit for a metastore request to be retried")
    public ThriftMetastoreConfig setMaxRetryTime(Duration maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
        return this;
    }

    public Duration getMinBackoffDelay() {
        return this.minBackoffDelay;
    }

    @Config(value="hive.metastore.thrift.client.min-backoff-delay")
    @ConfigDescription(value="Minimum delay between metastore request retries")
    public ThriftMetastoreConfig setMinBackoffDelay(Duration minBackoffDelay) {
        this.minBackoffDelay = minBackoffDelay;
        return this;
    }

    public Duration getMaxBackoffDelay() {
        return this.maxBackoffDelay;
    }

    @Config(value="hive.metastore.thrift.client.max-backoff-delay")
    @ConfigDescription(value="Maximum delay between metastore request retries")
    public ThriftMetastoreConfig setMaxBackoffDelay(Duration maxBackoffDelay) {
        this.maxBackoffDelay = maxBackoffDelay;
        return this;
    }

    public boolean isImpersonationEnabled() {
        return this.impersonationEnabled;
    }

    @Config(value="hive.metastore.thrift.impersonation.enabled")
    @LegacyConfig(value={"hive.metastore.impersonation-enabled"})
    @ConfigDescription(value="Should end user be impersonated when communicating with metastore")
    public ThriftMetastoreConfig setImpersonationEnabled(boolean impersonationEnabled) {
        this.impersonationEnabled = impersonationEnabled;
        return this;
    }

    public boolean isUseSparkTableStatisticsFallback() {
        return this.useSparkTableStatisticsFallback;
    }

    @Config(value="hive.metastore.thrift.use-spark-table-statistics-fallback")
    @ConfigDescription(value="Enable usage of table statistics generated by Apache Spark when hive table statistics are not available")
    public ThriftMetastoreConfig setUseSparkTableStatisticsFallback(boolean useSparkTableStatisticsFallback) {
        this.useSparkTableStatisticsFallback = useSparkTableStatisticsFallback;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getDelegationTokenCacheTtl() {
        return this.delegationTokenCacheTtl;
    }

    @Config(value="hive.metastore.thrift.delegation-token.cache-ttl")
    @ConfigDescription(value="Time to live delegation token cache for metastore")
    public ThriftMetastoreConfig setDelegationTokenCacheTtl(Duration delegationTokenCacheTtl) {
        this.delegationTokenCacheTtl = delegationTokenCacheTtl;
        return this;
    }

    @NotNull
    @Min(value=0L)
    public @NotNull @Min(value=0L) long getDelegationTokenCacheMaximumSize() {
        return this.delegationTokenCacheMaximumSize;
    }

    @Config(value="hive.metastore.thrift.delegation-token.cache-maximum-size")
    @ConfigDescription(value="Delegation token cache maximum size")
    public ThriftMetastoreConfig setDelegationTokenCacheMaximumSize(long delegationTokenCacheMaximumSize) {
        this.delegationTokenCacheMaximumSize = delegationTokenCacheMaximumSize;
        return this;
    }

    public boolean isDeleteFilesOnDrop() {
        return this.deleteFilesOnDrop;
    }

    @Config(value="hive.metastore.thrift.delete-files-on-drop")
    @ConfigDescription(value="Delete files on drop in case the metastore doesn't do it")
    public ThriftMetastoreConfig setDeleteFilesOnDrop(boolean deleteFilesOnDrop) {
        this.deleteFilesOnDrop = deleteFilesOnDrop;
        return this;
    }

    public Duration getMaxWaitForTransactionLock() {
        return this.maxWaitForTransactionLock;
    }

    @Config(value="hive.metastore.thrift.txn-lock-max-wait")
    @ConfigDescription(value="Maximum time to wait to acquire hive transaction lock")
    public ThriftMetastoreConfig setMaxWaitForTransactionLock(Duration maxWaitForTransactionLock) {
        this.maxWaitForTransactionLock = maxWaitForTransactionLock;
        return this;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Config(value="hive.metastore.thrift.client.ssl.enabled")
    @ConfigDescription(value="Whether TLS security is enabled")
    public ThriftMetastoreConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    @FileExists
    public File getKeystorePath() {
        return this.keystorePath;
    }

    @Config(value="hive.metastore.thrift.client.ssl.key")
    @ConfigDescription(value="Path to the key store")
    public ThriftMetastoreConfig setKeystorePath(File keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Config(value="hive.metastore.thrift.client.ssl.key-password")
    @ConfigDescription(value="Password for the key store")
    @ConfigSecuritySensitive
    public ThriftMetastoreConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    @FileExists
    public File getTruststorePath() {
        return this.truststorePath;
    }

    @Config(value="hive.metastore.thrift.client.ssl.trust-certificate")
    @ConfigDescription(value="Path to the trust store")
    public ThriftMetastoreConfig setTruststorePath(File truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public String getTruststorePassword() {
        return this.trustStorePassword;
    }

    @Config(value="hive.metastore.thrift.client.ssl.trust-certificate-password")
    @ConfigDescription(value="Password for the trust store")
    @ConfigSecuritySensitive
    public ThriftMetastoreConfig setTruststorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    @AssertTrue(message="Trust store must be provided when TLS is enabled")
    public @AssertTrue(message="Trust store must be provided when TLS is enabled") boolean isTruststorePathValid() {
        return !this.tlsEnabled || this.getTruststorePath() != null;
    }

    public boolean isAssumeCanonicalPartitionKeys() {
        return this.assumeCanonicalPartitionKeys;
    }

    @Config(value="hive.metastore.thrift.assume-canonical-partition-keys")
    public ThriftMetastoreConfig setAssumeCanonicalPartitionKeys(boolean assumeCanonicalPartitionKeys) {
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getWriteStatisticsThreads() {
        return this.writeStatisticsThreads;
    }

    @Config(value="hive.metastore.thrift.write-statistics-threads")
    @ConfigDescription(value="Number of threads for parallel statistics writes")
    public ThriftMetastoreConfig setWriteStatisticsThreads(int writeStatisticsThreads) {
        this.writeStatisticsThreads = writeStatisticsThreads;
        return this;
    }

    public boolean isBatchMetadataFetchEnabled() {
        return this.batchMetadataFetchEnabled;
    }

    @Config(value="hive.metastore.thrift.batch-fetch.enabled")
    @ConfigDescription(value="Enables fetching tables and views from all schemas in a single request")
    public ThriftMetastoreConfig setBatchMetadataFetchEnabled(boolean batchMetadataFetchEnabled) {
        this.batchMetadataFetchEnabled = batchMetadataFetchEnabled;
        return this;
    }
}

