/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveViewNotSupportedException;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetadataMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.PrivilegeInfo;
import io.trino.spi.security.RoleGrant;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SqlStandardAccessControlMetadata
implements AccessControlMetadata {
    private static final Set<String> RESERVED_ROLES = ImmutableSet.of((Object)"all", (Object)"default", (Object)"none");
    private final SqlStandardAccessControlMetadataMetastore metastore;

    public SqlStandardAccessControlMetadata(SqlStandardAccessControlMetadataMetastore metastore) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    @Override
    public void createRole(ConnectorSession session, String role, Optional<HivePrincipal> grantor) {
        SqlStandardAccessControlMetadata.checkRoleIsNotReserved(role);
        this.metastore.createRole(role, null);
    }

    @Override
    public void dropRole(ConnectorSession session, String role) {
        SqlStandardAccessControlMetadata.checkRoleIsNotReserved(role);
        this.metastore.dropRole(role);
    }

    private static void checkRoleIsNotReserved(String role) {
        if (RESERVED_ROLES.contains(role.toLowerCase(Locale.ENGLISH))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Role name cannot be one of the reserved roles: " + String.valueOf(RESERVED_ROLES));
        }
    }

    @Override
    public Set<String> listRoles(ConnectorSession session) {
        return ImmutableSet.copyOf(this.metastore.listRoles());
    }

    @Override
    public Set<RoleGrant> listRoleGrants(ConnectorSession session, HivePrincipal principal) {
        return ImmutableSet.copyOf(this.metastore.listRoleGrants(principal));
    }

    @Override
    public void grantRoles(ConnectorSession session, Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, Optional<HivePrincipal> grantor) {
        this.metastore.grantRoles(roles, grantees, adminOption, grantor.orElse(new HivePrincipal(PrincipalType.USER, session.getUser())));
    }

    @Override
    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, Optional<HivePrincipal> grantor) {
        this.metastore.revokeRoles(roles, grantees, adminOption, grantor.orElse(new HivePrincipal(PrincipalType.USER, session.getUser())));
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, HivePrincipal principal) {
        return (Set)ThriftMetastoreUtil.listApplicableRoles(principal, this.metastore::listRoleGrants).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Set<String> listEnabledRoles(ConnectorSession session) {
        return (Set)ThriftMetastoreUtil.listEnabledRoles(session.getIdentity(), this.metastore::listRoleGrants).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Optional<HivePrincipal> getSchemaOwner(ConnectorSession session, String schemaName) {
        return this.metastore.getDatabaseOwner(schemaName);
    }

    @Override
    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, HivePrincipal grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        privileges = (Set)privileges.stream().filter(Predicate.not(arg_0 -> Privilege.CREATE.equals(arg_0))).collect(ImmutableSet.toImmutableSet());
        this.metastore.grantTablePrivileges(schemaName, tableName, grantee, new HivePrincipal(PrincipalType.USER, session.getUser()), privileges.stream().map(HivePrivilegeInfo::toHivePrivilege).collect(Collectors.toSet()), grantOption);
    }

    @Override
    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, HivePrincipal grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        privileges = (Set)privileges.stream().filter(Predicate.not(arg_0 -> Privilege.CREATE.equals(arg_0))).collect(ImmutableSet.toImmutableSet());
        this.metastore.revokeTablePrivileges(schemaName, tableName, grantee, new HivePrincipal(PrincipalType.USER, session.getUser()), privileges.stream().map(HivePrivilegeInfo::toHivePrivilege).collect(Collectors.toSet()), grantOption);
    }

    @Override
    public List<GrantInfo> listTablePrivileges(ConnectorSession session, List<SchemaTableName> tableNames) {
        Set principals = (Set)ThriftMetastoreUtil.listEnabledPrincipals(session.getIdentity(), this.metastore::listRoleGrants).collect(ImmutableSet.toImmutableSet());
        boolean isAdminRoleSet = SqlStandardAccessControlMetadata.hasAdminRole(principals);
        ImmutableList.Builder result = ImmutableList.builder();
        for (SchemaTableName tableName : tableNames) {
            try {
                result.addAll(this.buildGrants(principals, isAdminRoleSet, tableName));
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (HiveViewNotSupportedException hiveViewNotSupportedException) {}
        }
        return result.build();
    }

    private List<GrantInfo> buildGrants(Set<HivePrincipal> principals, boolean isAdminRoleSet, SchemaTableName tableName) {
        if (isAdminRoleSet) {
            return this.buildGrants(tableName, Optional.empty());
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (HivePrincipal grantee : principals) {
            result.addAll(this.buildGrants(tableName, Optional.of(grantee)));
        }
        return result.build();
    }

    private List<GrantInfo> buildGrants(SchemaTableName tableName, Optional<HivePrincipal> principal) {
        ImmutableList.Builder result = ImmutableList.builder();
        Set<HivePrivilegeInfo> hivePrivileges = this.metastore.listTablePrivileges(tableName.getSchemaName(), tableName.getTableName(), principal);
        for (HivePrivilegeInfo hivePrivilege : hivePrivileges) {
            Set<PrivilegeInfo> prestoPrivileges = hivePrivilege.toPrivilegeInfo();
            for (PrivilegeInfo prestoPrivilege : prestoPrivileges) {
                GrantInfo grant = new GrantInfo(prestoPrivilege, hivePrivilege.getGrantee().toTrinoPrincipal(), tableName, Optional.of(hivePrivilege.getGrantor().toTrinoPrincipal()), Optional.empty());
                result.add((Object)grant);
            }
        }
        return result.build();
    }

    private static boolean hasAdminRole(Set<HivePrincipal> roles) {
        return roles.stream().anyMatch(principal -> principal.getName().equalsIgnoreCase("admin"));
    }
}

