/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.ListTypeInfo;
import io.trino.plugin.hive.type.MapTypeInfo;
import io.trino.plugin.hive.type.StructTypeInfo;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;

public final class HiveCoercionPolicy {
    private final TypeManager typeManager;

    private HiveCoercionPolicy(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public static boolean canCoerce(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        return new HiveCoercionPolicy(typeManager).canCoerce(fromHiveType, toHiveType, hiveTimestampPrecision);
    }

    private boolean canCoerce(HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        Type fromType = this.typeManager.getType(fromHiveType.getTypeSignature(hiveTimestampPrecision));
        Type toType = this.typeManager.getType(toHiveType.getTypeSignature(hiveTimestampPrecision));
        if (fromType instanceof VarcharType) {
            return toType instanceof VarcharType || toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG) || toHiveType.equals(HiveType.HIVE_DOUBLE) || toHiveType.equals(HiveType.HIVE_DATE) || toHiveType.equals(HiveType.HIVE_TIMESTAMP);
        }
        if (fromType instanceof CharType) {
            return toType instanceof CharType;
        }
        if (toType instanceof VarcharType) {
            return fromHiveType.equals(HiveType.HIVE_BOOLEAN) || fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG) || fromHiveType.equals(HiveType.HIVE_TIMESTAMP) || fromHiveType.equals(HiveType.HIVE_DOUBLE) || fromHiveType.equals(HiveType.HIVE_DATE) || fromType instanceof DecimalType;
        }
        if (toHiveType.equals(HiveType.HIVE_DATE)) {
            return fromHiveType.equals(HiveType.HIVE_TIMESTAMP);
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE)) {
            return toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG) || toHiveType.equals(HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT)) {
            return toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG) || toHiveType.equals(HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals(HiveType.HIVE_INT)) {
            return toHiveType.equals(HiveType.HIVE_LONG) || toHiveType.equals(HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals(HiveType.HIVE_LONG)) {
            return toHiveType.equals(HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT)) {
            return toHiveType.equals(HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals(HiveType.HIVE_DOUBLE)) {
            return toHiveType.equals(HiveType.HIVE_FLOAT) || toType instanceof DecimalType;
        }
        if (fromType instanceof DecimalType) {
            return toType instanceof DecimalType || toHiveType.equals(HiveType.HIVE_FLOAT) || toHiveType.equals(HiveType.HIVE_DOUBLE) || toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG);
        }
        return this.canCoerceForList(fromHiveType, toHiveType, hiveTimestampPrecision) || this.canCoerceForMap(fromHiveType, toHiveType, hiveTimestampPrecision) || this.canCoerceForStructOrUnion(fromHiveType, toHiveType, hiveTimestampPrecision);
    }

    private boolean canCoerceForMap(HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        if (fromHiveType.getCategory() != Category.MAP || toHiveType.getCategory() != Category.MAP) {
            return false;
        }
        HiveType fromKeyType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
        HiveType fromValueType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
        HiveType toKeyType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
        HiveType toValueType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
        return !(!fromKeyType.equals(toKeyType) && !this.canCoerce(fromKeyType, toKeyType, hiveTimestampPrecision) || !fromValueType.equals(toValueType) && !this.canCoerce(fromValueType, toValueType, hiveTimestampPrecision));
    }

    private boolean canCoerceForList(HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        HiveType toElementType;
        if (fromHiveType.getCategory() != Category.LIST || toHiveType.getCategory() != Category.LIST) {
            return false;
        }
        HiveType fromElementType = HiveType.valueOf(((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
        return fromElementType.equals(toElementType = HiveType.valueOf(((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName())) || this.canCoerce(fromElementType, toElementType, hiveTimestampPrecision);
    }

    private boolean canCoerceForStructOrUnion(HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        if (!HiveCoercionPolicy.isStructOrUnion(fromHiveType) || !HiveCoercionPolicy.isStructOrUnion(toHiveType)) {
            return false;
        }
        HiveType fromHiveTypeStruct = fromHiveType.getCategory() == Category.UNION ? HiveCoercionPolicy.convertUnionToStruct(fromHiveType, this.typeManager, hiveTimestampPrecision) : fromHiveType;
        HiveType toHiveTypeStruct = toHiveType.getCategory() == Category.UNION ? HiveCoercionPolicy.convertUnionToStruct(toHiveType, this.typeManager, hiveTimestampPrecision) : toHiveType;
        List<String> fromFieldNames = ((StructTypeInfo)fromHiveTypeStruct.getTypeInfo()).getAllStructFieldNames();
        List<String> toFieldNames = ((StructTypeInfo)toHiveTypeStruct.getTypeInfo()).getAllStructFieldNames();
        List<HiveType> fromFieldTypes = HiveUtil.extractStructFieldTypes(fromHiveTypeStruct);
        List<HiveType> toFieldTypes = HiveUtil.extractStructFieldTypes(toHiveTypeStruct);
        for (int i = 0; i < Math.min(fromFieldTypes.size(), toFieldTypes.size()); ++i) {
            if (!fromFieldNames.get(i).equalsIgnoreCase(toFieldNames.get(i))) {
                return false;
            }
            if (fromFieldTypes.get(i).equals(toFieldTypes.get(i)) || this.canCoerce(fromFieldTypes.get(i), toFieldTypes.get(i), hiveTimestampPrecision)) continue;
            return false;
        }
        return true;
    }

    private static boolean isStructOrUnion(HiveType hiveType) {
        return hiveType.getCategory() == Category.STRUCT || hiveType.getCategory() == Category.UNION;
    }

    private static HiveType convertUnionToStruct(HiveType unionType, TypeManager typeManager, HiveTimestampPrecision hiveTimestampPrecision) {
        Preconditions.checkArgument((unionType.getCategory() == Category.UNION ? 1 : 0) != 0, (Object)String.format("Can only convert union type to struct type, given type: %s", unionType.getTypeSignature(hiveTimestampPrecision)));
        return HiveType.toHiveType(unionType.getType(typeManager, hiveTimestampPrecision));
    }
}

