/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.FormatMethod;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.orc.OrcWriterOptions;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.projection.PartitionProjectionProperties;
import io.trino.plugin.hive.type.StructTypeInfo;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;

public final class HiveUtil {
    public static final String SPARK_TABLE_PROVIDER_KEY = "spark.sql.sources.provider";
    public static final String DELTA_LAKE_PROVIDER = "delta";
    private static final String SPARK_TABLE_BUCKET_NUMBER_KEY = "spark.sql.sources.schema.numBuckets";
    public static final String ICEBERG_TABLE_TYPE_NAME = "table_type";
    public static final String ICEBERG_TABLE_TYPE_VALUE = "iceberg";
    private static final HexFormat HEX_UPPER_FORMAT = HexFormat.of().withUpperCase();
    private static final LocalDateTime EPOCH_DAY = new LocalDateTime(1970, 1, 1, 0, 0);
    private static final DateTimeFormatter HIVE_DATE_PARSER;
    private static final DateTimeFormatter HIVE_TIMESTAMP_PARSER;
    private static final String BIG_DECIMAL_POSTFIX = "BD";
    private static final Splitter COLUMN_NAMES_SPLITTER;
    private static final CharMatcher PATH_CHAR_TO_ESCAPE;
    private static final CharMatcher DOT_MATCHER;

    public static String splitError(Throwable t, Location location, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", location, start, length, t.getMessage());
    }

    private HiveUtil() {
    }

    public static Optional<String> getInputFormatName(Map<String, String> schema) {
        return Optional.ofNullable(schema.get("file.inputformat"));
    }

    private static long parseHiveDate(String value) {
        LocalDateTime date = HIVE_DATE_PARSER.parseLocalDateTime(value);
        if (!date.toLocalTime().equals((Object)LocalTime.MIDNIGHT)) {
            throw new IllegalArgumentException(String.format("The value should be a whole round date: '%s'", value));
        }
        return Days.daysBetween((ReadablePartial)EPOCH_DAY, (ReadablePartial)date).getDays();
    }

    public static long parseHiveTimestamp(String value) {
        return HIVE_TIMESTAMP_PARSER.parseMillis(value) * 1000L;
    }

    public static String getDeserializerClassName(Map<String, String> schema) {
        String name = schema.get("serialization.lib");
        HiveUtil.checkCondition(name != null, HiveErrorCode.HIVE_INVALID_METADATA, "Table or partition is missing Hive deserializer property: %s", "serialization.lib");
        return name;
    }

    private static boolean isHiveNull(byte[] bytes) {
        return bytes.length == 2 && bytes[0] == 92 && bytes[1] == 78;
    }

    public static void verifyPartitionTypeSupported(String partitionName, Type type) {
        if (!HiveUtil.isValidPartitionType(type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported type [%s] for partition: %s", type, partitionName));
        }
    }

    private static boolean isValidPartitionType(Type type) {
        return type instanceof DecimalType || BooleanType.BOOLEAN.equals((Object)type) || TinyintType.TINYINT.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || RealType.REAL.equals((Object)type) || DoubleType.DOUBLE.equals((Object)type) || DateType.DATE.equals((Object)type) || TimestampType.TIMESTAMP_MILLIS.equals((Object)type) || type instanceof VarcharType || type instanceof CharType;
    }

    public static NullableValue parsePartitionValue(String partitionName, String value, Type type) {
        HiveUtil.verifyPartitionTypeSupported(partitionName, type);
        boolean isNull = "__HIVE_DEFAULT_PARTITION__".equals(value);
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (isNull) {
                return NullableValue.asNull((Type)decimalType);
            }
            if (decimalType.isShort()) {
                if (value.isEmpty()) {
                    return NullableValue.of((Type)decimalType, (Object)0L);
                }
                return NullableValue.of((Type)decimalType, (Object)HiveUtil.shortDecimalPartitionKey(value, decimalType, partitionName));
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)decimalType, (Object)Int128.ZERO);
            }
            return NullableValue.of((Type)decimalType, (Object)HiveUtil.longDecimalPartitionKey(value, decimalType, partitionName));
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)BooleanType.BOOLEAN);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)BooleanType.BOOLEAN, (Object)false);
            }
            return NullableValue.of((Type)BooleanType.BOOLEAN, (Object)HiveUtil.booleanPartitionKey(value, partitionName));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)TinyintType.TINYINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)TinyintType.TINYINT, (Object)0L);
            }
            return NullableValue.of((Type)TinyintType.TINYINT, (Object)HiveUtil.tinyintPartitionKey(value, partitionName));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)SmallintType.SMALLINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)SmallintType.SMALLINT, (Object)0L);
            }
            return NullableValue.of((Type)SmallintType.SMALLINT, (Object)HiveUtil.smallintPartitionKey(value, partitionName));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)IntegerType.INTEGER);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)IntegerType.INTEGER, (Object)0L);
            }
            return NullableValue.of((Type)IntegerType.INTEGER, (Object)HiveUtil.integerPartitionKey(value, partitionName));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)BigintType.BIGINT);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)BigintType.BIGINT, (Object)0L);
            }
            return NullableValue.of((Type)BigintType.BIGINT, (Object)HiveUtil.bigintPartitionKey(value, partitionName));
        }
        if (DateType.DATE.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)DateType.DATE);
            }
            return NullableValue.of((Type)DateType.DATE, (Object)HiveUtil.datePartitionKey(value, partitionName));
        }
        if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)TimestampType.TIMESTAMP_MILLIS);
            }
            return NullableValue.of((Type)TimestampType.TIMESTAMP_MILLIS, (Object)HiveUtil.timestampPartitionKey(value, partitionName));
        }
        if (RealType.REAL.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)RealType.REAL);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)RealType.REAL, (Object)Float.floatToRawIntBits(0.0f));
            }
            return NullableValue.of((Type)RealType.REAL, (Object)HiveUtil.floatPartitionKey(value, partitionName));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            if (isNull) {
                return NullableValue.asNull((Type)DoubleType.DOUBLE);
            }
            if (value.isEmpty()) {
                return NullableValue.of((Type)DoubleType.DOUBLE, (Object)0.0);
            }
            return NullableValue.of((Type)DoubleType.DOUBLE, (Object)HiveUtil.doublePartitionKey(value, partitionName));
        }
        if (type instanceof VarcharType) {
            if (isNull) {
                return NullableValue.asNull((Type)type);
            }
            return NullableValue.of((Type)type, (Object)HiveUtil.varcharPartitionKey(value, partitionName, type));
        }
        if (type instanceof CharType) {
            if (isNull) {
                return NullableValue.asNull((Type)type);
            }
            return NullableValue.of((Type)type, (Object)HiveUtil.charPartitionKey(value, partitionName, type));
        }
        if (type instanceof VarbinaryType) {
            if (isNull) {
                return NullableValue.asNull((Type)type);
            }
            return NullableValue.of((Type)type, (Object)Slices.utf8Slice((String)value));
        }
        throw new VerifyException(String.format("Unhandled type [%s] for partition: %s", type, partitionName));
    }

    public static boolean isStructuralType(Type type) {
        return type instanceof ArrayType || type instanceof MapType || type instanceof RowType;
    }

    private static boolean booleanPartitionKey(String value, String name) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for BOOLEAN partition key: %s", value, name));
    }

    private static long bigintPartitionKey(String value, String name) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for BIGINT partition key: %s", value, name));
        }
    }

    private static long integerPartitionKey(String value, String name) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for INTEGER partition key: %s", value, name));
        }
    }

    private static long smallintPartitionKey(String value, String name) {
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for SMALLINT partition key: %s", value, name));
        }
    }

    private static long tinyintPartitionKey(String value, String name) {
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for TINYINT partition key: %s", value, name));
        }
    }

    private static long floatPartitionKey(String value, String name) {
        try {
            return Float.floatToRawIntBits(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for FLOAT partition key: %s", value, name));
        }
    }

    private static double doublePartitionKey(String value, String name) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for DOUBLE partition key: %s", value, name));
        }
    }

    private static long datePartitionKey(String value, String name) {
        try {
            return HiveUtil.parseHiveDate(value);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for DATE partition key: %s", value, name));
        }
    }

    private static long timestampPartitionKey(String value, String name) {
        try {
            return HiveUtil.parseHiveTimestamp(value);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for TIMESTAMP partition key: %s", value, name));
        }
    }

    private static long shortDecimalPartitionKey(String value, DecimalType type, String name) {
        return HiveUtil.decimalPartitionKey(value, type, name).unscaledValue().longValue();
    }

    private static Int128 longDecimalPartitionKey(String value, DecimalType type, String name) {
        return Int128.valueOf((BigInteger)HiveUtil.decimalPartitionKey(value, type, name).unscaledValue());
    }

    private static BigDecimal decimalPartitionKey(String value, DecimalType type, String name) {
        try {
            if (value.endsWith(BIG_DECIMAL_POSTFIX)) {
                value = value.substring(0, value.length() - BIG_DECIMAL_POSTFIX.length());
            }
            BigDecimal decimal = new BigDecimal(value);
            if ((decimal = decimal.setScale(type.getScale(), RoundingMode.UNNECESSARY)).precision() > type.getPrecision()) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, type, name));
            }
            return decimal;
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, type, name));
        }
    }

    private static Slice varcharPartitionKey(String value, String name, Type columnType) {
        Slice partitionKey = Slices.utf8Slice((String)value);
        VarcharType varcharType = (VarcharType)columnType;
        if (!varcharType.isUnbounded() && SliceUtf8.countCodePoints((Slice)partitionKey) > varcharType.getBoundedLength()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, columnType, name));
        }
        return partitionKey;
    }

    private static Slice charPartitionKey(String value, String name, Type columnType) {
        Slice partitionKey = Chars.trimTrailingSpaces((Slice)Slices.utf8Slice((String)value));
        CharType charType = (CharType)columnType;
        if (SliceUtf8.countCodePoints((Slice)partitionKey) > charType.getLength()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", value, columnType, name));
        }
        return partitionKey;
    }

    public static List<ColumnMetadata> getTableColumnMetadata(ConnectorSession session, Table table, TypeManager typeManager) {
        return (List)HiveUtil.hiveColumnHandles(table, typeManager, HiveSessionProperties.getTimestampPrecision(session)).stream().map(HiveUtil.columnMetadataGetter(table)).collect(ImmutableList.toImmutableList());
    }

    public static List<HiveColumnHandle> hiveColumnHandles(Table table, TypeManager typeManager, HiveTimestampPrecision timestampPrecision) {
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll(HiveUtil.getRegularColumnHandles(table, typeManager, timestampPrecision));
        columns.addAll(HiveUtil.getPartitionKeyColumnHandles(table, typeManager));
        columns.add((Object)HiveColumnHandle.pathColumnHandle());
        if (table.getStorage().getBucketProperty().isPresent() && HiveBucketing.isSupportedBucketing(table)) {
            columns.add((Object)HiveColumnHandle.bucketColumnHandle());
        }
        columns.add((Object)HiveColumnHandle.fileSizeColumnHandle());
        columns.add((Object)HiveColumnHandle.fileModifiedTimeColumnHandle());
        if (!table.getPartitionColumns().isEmpty()) {
            columns.add((Object)HiveColumnHandle.partitionColumnHandle());
        }
        return columns.build();
    }

    public static List<HiveColumnHandle> getRegularColumnHandles(Table table, TypeManager typeManager, HiveTimestampPrecision timestampPrecision) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int hiveColumnIndex = 0;
        for (Column field : table.getDataColumns()) {
            HiveType hiveType = field.getType();
            if (hiveType.isSupportedType(table.getStorage().getStorageFormat())) {
                columns.add((Object)HiveColumnHandle.createBaseColumn(field.getName(), hiveColumnIndex, hiveType, hiveType.getType(typeManager, timestampPrecision), HiveColumnHandle.ColumnType.REGULAR, field.getComment()));
            }
            ++hiveColumnIndex;
        }
        return columns.build();
    }

    public static List<HiveColumnHandle> getPartitionKeyColumnHandles(Table table, TypeManager typeManager) {
        ImmutableList.Builder columns = ImmutableList.builder();
        List<Column> partitionKeys = table.getPartitionColumns();
        for (Column field : partitionKeys) {
            HiveType hiveType = field.getType();
            if (!hiveType.isSupportedType(table.getStorage().getStorageFormat())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            columns.add((Object)HiveColumnHandle.createBaseColumn(field.getName(), -1, hiveType, typeManager.getType(hiveType.getTypeSignature()), HiveColumnHandle.ColumnType.PARTITION_KEY, field.getComment()));
        }
        return columns.build();
    }

    @FormatMethod
    public static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new TrinoException(errorCode, String.format(formatString, args));
        }
    }

    @Nullable
    public static String columnExtraInfo(boolean partitionKey) {
        return partitionKey ? "partition key" : null;
    }

    public static List<String> toPartitionValues(String partitionName) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        int start = 0;
        while (true) {
            int end;
            if (start < partitionName.length() && partitionName.charAt(start) != '=') {
                ++start;
                continue;
            }
            for (end = ++start; end < partitionName.length() && partitionName.charAt(end) != '/'; ++end) {
            }
            if (start > partitionName.length()) break;
            resultBuilder.add((Object)HiveUtil.unescapePathName(partitionName.substring(start, end)));
            start = end + 1;
        }
        return resultBuilder.build();
    }

    public static NullableValue getPrefilledColumnValue(HiveColumnHandle columnHandle, HivePartitionKey partitionKey, String path, OptionalInt bucketNumber, long fileSize, long fileModifiedTime, String partitionName) {
        String columnValue;
        if (partitionKey != null) {
            columnValue = partitionKey.getValue();
        } else if (HiveColumnHandle.isPathColumnHandle(columnHandle)) {
            columnValue = path;
        } else if (HiveColumnHandle.isBucketColumnHandle(columnHandle)) {
            columnValue = String.valueOf(bucketNumber.getAsInt());
        } else if (HiveColumnHandle.isFileSizeColumnHandle(columnHandle)) {
            columnValue = String.valueOf(fileSize);
        } else if (HiveColumnHandle.isFileModifiedTimeColumnHandle(columnHandle)) {
            columnValue = HIVE_TIMESTAMP_PARSER.print(fileModifiedTime);
        } else if (HiveColumnHandle.isPartitionColumnHandle(columnHandle)) {
            columnValue = partitionName;
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported hidden column: " + String.valueOf(columnHandle));
        }
        byte[] bytes = columnValue.getBytes(StandardCharsets.UTF_8);
        String name = columnHandle.getName();
        Type type = columnHandle.getType();
        if (HiveUtil.isHiveNull(bytes)) {
            return NullableValue.asNull((Type)type);
        }
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return NullableValue.of((Type)type, (Object)HiveUtil.booleanPartitionKey(columnValue, name));
        }
        if (type.equals((Object)BigintType.BIGINT)) {
            return NullableValue.of((Type)type, (Object)HiveUtil.bigintPartitionKey(columnValue, name));
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return NullableValue.of((Type)type, (Object)HiveUtil.integerPartitionKey(columnValue, name));
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return NullableValue.of((Type)type, (Object)HiveUtil.smallintPartitionKey(columnValue, name));
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return NullableValue.of((Type)type, (Object)HiveUtil.tinyintPartitionKey(columnValue, name));
        }
        if (type.equals((Object)RealType.REAL)) {
            return NullableValue.of((Type)type, (Object)HiveUtil.floatPartitionKey(columnValue, name));
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return NullableValue.of((Type)type, (Object)HiveUtil.doublePartitionKey(columnValue, name));
        }
        if (type instanceof VarcharType) {
            return NullableValue.of((Type)type, (Object)HiveUtil.varcharPartitionKey(columnValue, name, type));
        }
        if (type instanceof CharType) {
            return NullableValue.of((Type)type, (Object)HiveUtil.charPartitionKey(columnValue, name, type));
        }
        if (type.equals((Object)DateType.DATE)) {
            return NullableValue.of((Type)type, (Object)HiveUtil.datePartitionKey(columnValue, name));
        }
        if (type.equals((Object)TimestampType.TIMESTAMP_MILLIS)) {
            return NullableValue.of((Type)type, (Object)HiveUtil.timestampPartitionKey(columnValue, name));
        }
        if (type.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            return NullableValue.of((Type)type, (Object)DateTimeEncoding.packDateTimeWithZone((long)Math.floorDiv(HiveUtil.timestampPartitionKey(columnValue, name), 1000), (String)DateTimeZone.getDefault().getID()));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return NullableValue.of((Type)type, (Object)HiveUtil.shortDecimalPartitionKey(columnValue, decimalType, name));
            }
            return NullableValue.of((Type)type, (Object)HiveUtil.longDecimalPartitionKey(columnValue, decimalType, name));
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return NullableValue.of((Type)type, (Object)Slices.utf8Slice((String)columnValue));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for prefilled column: %s", type.getDisplayName(), name));
    }

    public static List<HiveType> extractStructFieldTypes(HiveType hiveType) {
        return (List)((StructTypeInfo)hiveType.getTypeInfo()).getAllStructFieldTypeInfos().stream().map(typeInfo -> HiveType.valueOf(typeInfo.getTypeName())).collect(ImmutableList.toImmutableList());
    }

    public static int getHeaderCount(Map<String, String> schema) {
        return HiveUtil.getPositiveIntegerValue(schema, "skip.header.line.count", "0");
    }

    public static int getFooterCount(Map<String, String> schema) {
        return HiveUtil.getPositiveIntegerValue(schema, "skip.footer.line.count", "0");
    }

    private static int getPositiveIntegerValue(Map<String, String> schema, String key, String defaultValue) {
        String value = schema.getOrDefault(key, defaultValue);
        try {
            int intValue = Integer.parseInt(value);
            if (intValue < 0) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", key, value));
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", key, value));
        }
    }

    public static List<String> getColumnNames(Map<String, String> schema) {
        return COLUMN_NAMES_SPLITTER.splitToList((CharSequence)schema.getOrDefault("columns", ""));
    }

    public static List<HiveType> getColumnTypes(Map<String, String> schema) {
        return HiveType.toHiveTypes(schema.getOrDefault("columns.types", ""));
    }

    public static OrcWriterOptions getOrcWriterOptions(Map<String, String> schema, OrcWriterOptions orcWriterOptions) {
        if (schema.containsKey("orc.bloom.filter.columns")) {
            try {
                double fpp = schema.containsKey("orc.bloom.filter.fpp") ? Double.parseDouble(schema.get("orc.bloom.filter.fpp")) : orcWriterOptions.getBloomFilterFpp();
                return orcWriterOptions.withBloomFilterColumns((Set)ImmutableSet.copyOf((Collection)COLUMN_NAMES_SPLITTER.splitToList((CharSequence)schema.get("orc.bloom.filter.columns")))).withBloomFilterFpp(fpp);
            }
            catch (NumberFormatException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Invalid value for %s property: %s", "orc_bloom_filter_fpp", schema.get("orc.bloom.filter.fpp")));
            }
        }
        return orcWriterOptions;
    }

    public static SortingColumn sortingColumnFromString(String name) {
        SortingColumn.Order order = SortingColumn.Order.ASCENDING;
        String lower = name.toUpperCase(Locale.ENGLISH);
        if (lower.endsWith(" ASC")) {
            name = name.substring(0, name.length() - 4).trim();
        } else if (lower.endsWith(" DESC")) {
            name = name.substring(0, name.length() - 5).trim();
            order = SortingColumn.Order.DESCENDING;
        }
        return new SortingColumn(name, order);
    }

    public static String sortingColumnToString(SortingColumn column) {
        return column.getColumnName() + (column.getOrder() == SortingColumn.Order.DESCENDING ? " DESC" : "");
    }

    public static boolean isHiveSystemSchema(String schemaName) {
        if ("information_schema".equals(schemaName)) {
            return true;
        }
        return "sys".equals(schemaName);
    }

    public static boolean isDeltaLakeTable(Table table) {
        return HiveUtil.isDeltaLakeTable(table.getParameters());
    }

    public static boolean isDeltaLakeTable(Map<String, String> tableParameters) {
        return DELTA_LAKE_PROVIDER.equalsIgnoreCase(tableParameters.get(SPARK_TABLE_PROVIDER_KEY));
    }

    public static boolean isIcebergTable(Table table) {
        return HiveUtil.isIcebergTable(table.getParameters());
    }

    public static boolean isIcebergTable(Map<String, String> tableParameters) {
        return ICEBERG_TABLE_TYPE_VALUE.equalsIgnoreCase(tableParameters.get(ICEBERG_TABLE_TYPE_NAME));
    }

    public static boolean isHudiTable(Table table) {
        Objects.requireNonNull(table, "table is null");
        String inputFormat = table.getStorage().getStorageFormat().getInputFormatNullable();
        return "org.apache.hudi.hadoop.HoodieParquetInputFormat".equals(inputFormat) || "org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat".equals(inputFormat) || "com.uber.hoodie.hadoop.HoodieInputFormat".equals(inputFormat) || "com.uber.hoodie.hadoop.realtime.HoodieRealtimeInputFormat".equals(inputFormat);
    }

    public static boolean isSparkBucketedTable(Table table) {
        return table.getParameters().containsKey(SPARK_TABLE_PROVIDER_KEY) && table.getParameters().containsKey(SPARK_TABLE_BUCKET_NUMBER_KEY);
    }

    public static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter(Table table) {
        ImmutableList.Builder columnNames = ImmutableList.builder();
        table.getPartitionColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        table.getDataColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        ImmutableList allColumnNames = columnNames.build();
        if (allColumnNames.size() > Sets.newHashSet((Iterable)allColumnNames).size()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Hive metadata for table %s is invalid: Table descriptor contains duplicate columns", table.getTableName()));
        }
        List<Column> tableColumns = table.getDataColumns();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Column field : Iterables.concat(tableColumns, table.getPartitionColumns())) {
            if (field.getComment().isPresent() && !field.getComment().get().equals("from deserializer")) {
                builder.put((Object)field.getName(), field.getComment());
                continue;
            }
            builder.put((Object)field.getName(), Optional.empty());
        }
        ImmutableMap columnComment = builder.buildOrThrow();
        return arg_0 -> HiveUtil.lambda$columnMetadataGetter$1((Map)columnComment, table, arg_0);
    }

    public static String unescapePathName(String path) {
        int escapedAtIndex = path.indexOf(37);
        if (escapedAtIndex < 0 || escapedAtIndex + 2 >= path.length()) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        int fromIndex = 0;
        while (escapedAtIndex >= 0 && escapedAtIndex + 2 < path.length()) {
            if (escapedAtIndex > fromIndex) {
                sb.append(path, fromIndex, escapedAtIndex);
            }
            try {
                int code = HexFormat.fromHexDigits(path, escapedAtIndex + 1, escapedAtIndex + 3);
                sb.append((char)code);
                fromIndex = escapedAtIndex + 3;
            }
            catch (NumberFormatException e) {
                sb.append('%');
                fromIndex = escapedAtIndex + 1;
            }
            escapedAtIndex = path.indexOf(37, fromIndex);
        }
        if (fromIndex < path.length()) {
            sb.append(path, fromIndex, path.length());
        }
        return sb.toString();
    }

    public static String escapeSchemaName(String schemaName) {
        if (Strings.isNullOrEmpty((String)schemaName)) {
            throw new IllegalArgumentException("The provided schemaName cannot be null or empty");
        }
        if (DOT_MATCHER.matchesAllOf((CharSequence)schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Invalid schema name");
        }
        return HiveUtil.escapePathName(schemaName);
    }

    public static String escapeTableName(String tableName) {
        if (Strings.isNullOrEmpty((String)tableName)) {
            throw new IllegalArgumentException("The provided tableName cannot be null or empty");
        }
        if (DOT_MATCHER.matchesAllOf((CharSequence)tableName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Invalid table name");
        }
        return HiveUtil.escapePathName(tableName);
    }

    public static String escapePathName(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return "__HIVE_DEFAULT_PARTITION__";
        }
        int escapeAtIndex = PATH_CHAR_TO_ESCAPE.indexIn((CharSequence)path);
        if (escapeAtIndex < 0) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        int fromIndex = 0;
        while (escapeAtIndex >= 0 && escapeAtIndex < path.length()) {
            if (escapeAtIndex > fromIndex) {
                sb.append(path, fromIndex, escapeAtIndex);
            }
            char c = path.charAt(escapeAtIndex);
            sb.append('%').append(HEX_UPPER_FORMAT.toHighHexDigit(c)).append(HEX_UPPER_FORMAT.toLowHexDigit(c));
            fromIndex = escapeAtIndex + 1;
            if (fromIndex < path.length()) {
                escapeAtIndex = PATH_CHAR_TO_ESCAPE.indexIn((CharSequence)path, fromIndex);
                continue;
            }
            escapeAtIndex = -1;
        }
        if (fromIndex < path.length()) {
            sb.append(path, fromIndex, path.length());
        }
        return sb.toString();
    }

    public static String makePartName(List<String> columns, List<String> values) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                name.append('/');
            }
            name.append(HiveUtil.escapePathName(columns.get(i).toLowerCase(Locale.ENGLISH)));
            name.append('=');
            name.append(HiveUtil.escapePathName(values.get(i)));
        }
        return name.toString();
    }

    private static /* synthetic */ ColumnMetadata lambda$columnMetadataGetter$1(Map columnComment, Table table, HiveColumnHandle handle) {
        return ColumnMetadata.builder().setName(handle.getName()).setType(handle.getType()).setComment(handle.isHidden() ? Optional.empty() : (Optional)columnComment.get(handle.getName())).setExtraInfo(Optional.ofNullable(HiveUtil.columnExtraInfo(handle.isPartitionKey()))).setHidden(handle.isHidden()).setProperties(PartitionProjectionProperties.getPartitionProjectionTrinoColumnProperties(table, handle.getName())).build();
    }

    static {
        COLUMN_NAMES_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
        PATH_CHAR_TO_ESCAPE = CharMatcher.inRange((char)'\u0000', (char)'\u001f').or(CharMatcher.anyOf((CharSequence)"\"#%'*/:=?\\\u007f{[]^")).precomputed();
        DOT_MATCHER = CharMatcher.is((char)'.');
        DateTimeParser[] timestampWithoutTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-M-d").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSSSS").getParser()};
        DateTimePrinter timestampWithoutTimeZonePrinter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS").getPrinter();
        HIVE_TIMESTAMP_PARSER = new DateTimeFormatterBuilder().append(timestampWithoutTimeZonePrinter, timestampWithoutTimeZoneParser).toFormatter().withZoneUTC();
        HIVE_DATE_PARSER = new DateTimeFormatterBuilder().append(timestampWithoutTimeZonePrinter, timestampWithoutTimeZoneParser).toFormatter().withZoneUTC();
    }
}

