/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.metastore.BooleanStatistics;
import io.trino.plugin.hive.metastore.DateStatistics;
import io.trino.plugin.hive.metastore.DecimalStatistics;
import io.trino.plugin.hive.metastore.DoubleStatistics;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.IntegerStatistics;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;

public final class Statistics {
    private Statistics() {
    }

    public static PartitionStatistics createEmptyPartitionStatistics(Map<String, Type> columnTypes, Map<String, Set<HiveColumnStatisticType>> columnStatisticsMetadataTypes) {
        Map columnStatistics = (Map)columnStatisticsMetadataTypes.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Statistics.createColumnStatisticsForEmptyPartition((Type)columnTypes.get(entry.getKey()), (Set)entry.getValue())));
        return new PartitionStatistics(HiveBasicStatistics.createZeroStatistics(), columnStatistics);
    }

    private static HiveColumnStatistics createColumnStatisticsForEmptyPartition(Type columnType, Set<HiveColumnStatisticType> columnStatisticTypes) {
        Objects.requireNonNull(columnType, "columnType is null");
        HiveColumnStatistics.Builder result = HiveColumnStatistics.builder();
        for (HiveColumnStatisticType columnStatisticType : columnStatisticTypes) {
            Statistics.setColumnStatisticsForEmptyPartition(columnType, result, columnStatisticType);
        }
        return result.build();
    }

    private static void setColumnStatisticsForEmptyPartition(Type columnType, HiveColumnStatistics.Builder result, HiveColumnStatisticType columnStatisticType) {
        switch (columnStatisticType) {
            case MAX_VALUE_SIZE_IN_BYTES: {
                result.setMaxValueSizeInBytes(0L);
                return;
            }
            case TOTAL_SIZE_IN_BYTES: {
                result.setAverageColumnLength(0.0);
                return;
            }
            case NUMBER_OF_DISTINCT_VALUES: {
                result.setDistinctValuesWithNullCount(0L);
                return;
            }
            case NUMBER_OF_NON_NULL_VALUES: {
                result.setNullsCount(0L);
                return;
            }
            case NUMBER_OF_TRUE_VALUES: {
                result.setBooleanStatistics(new BooleanStatistics(OptionalLong.of(0L), OptionalLong.of(0L)));
                return;
            }
            case MIN_VALUE: 
            case MAX_VALUE: {
                Statistics.setMinMaxForEmptyPartition(columnType, result);
                return;
            }
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_COLUMN_STATISTIC_TYPE, "Unknown column statistics type: " + columnStatisticType.name());
    }

    private static void setMinMaxForEmptyPartition(Type type, HiveColumnStatistics.Builder result) {
        if (type.equals((Object)BigintType.BIGINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)TinyintType.TINYINT)) {
            result.setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty()));
        } else if (type.equals((Object)DoubleType.DOUBLE) || type.equals((Object)RealType.REAL)) {
            result.setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        } else if (type.equals((Object)DateType.DATE)) {
            result.setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty()));
        } else if (type instanceof DecimalType) {
            result.setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty()));
        } else {
            throw new IllegalArgumentException("Unexpected type: " + String.valueOf(type));
        }
    }

    public static Map<List<String>, ComputedStatistics> createComputedStatisticsToPartitionMap(Collection<ComputedStatistics> computedStatistics, List<String> partitionColumns, Map<String, Type> columnTypes) {
        List partitionColumnTypes = (List)partitionColumns.stream().map(columnTypes::get).collect(ImmutableList.toImmutableList());
        return (Map)computedStatistics.stream().collect(ImmutableMap.toImmutableMap(statistics -> Statistics.getPartitionValues(statistics, partitionColumns, partitionColumnTypes), Function.identity()));
    }

    private static List<String> getPartitionValues(ComputedStatistics statistics, List<String> partitionColumns, List<Type> partitionColumnTypes) {
        Preconditions.checkArgument((boolean)statistics.getGroupingColumns().equals(partitionColumns), (String)"Unexpected grouping. Partition columns: %s. Grouping columns: %s", partitionColumns, (Object)statistics.getGroupingColumns());
        Page partitionColumnsPage = new Page(1, statistics.getGroupingValues().toArray(new Block[0]));
        return HiveWriteUtils.createPartitionValues(partitionColumnTypes, partitionColumnsPage, 0);
    }

    public static Map<String, HiveColumnStatistics> fromComputedStatistics(Map<ColumnStatisticMetadata, Block> computedStatistics, Map<String, Type> columnTypes, long rowCount) {
        return (Map)Statistics.createColumnToComputedStatisticsMap(computedStatistics).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Statistics.createHiveColumnStatistics((Map)entry.getValue(), (Type)columnTypes.get(entry.getKey()), rowCount)));
    }

    private static Map<String, Map<HiveColumnStatisticType, Block>> createColumnToComputedStatisticsMap(Map<ColumnStatisticMetadata, Block> computedStatistics) {
        HashMap result = new HashMap();
        computedStatistics.forEach((metadata, block) -> {
            Map columnStatistics = result.computeIfAbsent(metadata.getColumnName(), key -> new HashMap());
            columnStatistics.put(HiveColumnStatisticType.from(metadata), block);
        });
        return (Map)result.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
    }

    @VisibleForTesting
    public static HiveColumnStatistics createHiveColumnStatistics(Map<HiveColumnStatisticType, Block> computedStatistics, Type columnType, long rowCount) {
        HiveColumnStatistics.Builder result = HiveColumnStatistics.builder();
        Verify.verify((computedStatistics.containsKey((Object)HiveColumnStatisticType.MIN_VALUE) == computedStatistics.containsKey((Object)HiveColumnStatisticType.MAX_VALUE) ? 1 : 0) != 0);
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.MIN_VALUE)) {
            Statistics.setMinMax(columnType, computedStatistics.get((Object)HiveColumnStatisticType.MIN_VALUE), computedStatistics.get((Object)HiveColumnStatisticType.MAX_VALUE), result);
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES)) {
            result.setMaxValueSizeInBytes(Statistics.getIntegerValue((Type)BigintType.BIGINT, computedStatistics.get((Object)HiveColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES)));
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.TOTAL_SIZE_IN_BYTES)) {
            OptionalLong totalSizeInBytes = Statistics.getIntegerValue((Type)BigintType.BIGINT, computedStatistics.get((Object)HiveColumnStatisticType.TOTAL_SIZE_IN_BYTES));
            OptionalLong numNonNullValues = Statistics.getIntegerValue((Type)BigintType.BIGINT, computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES));
            result.setAverageColumnLength(Statistics.getAverageColumnLength(totalSizeInBytes, numNonNullValues));
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES)) {
            result.setNullsCount(rowCount - BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), 0));
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES) && computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES)) {
            long numberOfNonNullValues = BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), 0);
            long numberOfDistinctValues = BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES), 0);
            result.setDistinctValuesWithNullCount(Math.min(numberOfDistinctValues, numberOfNonNullValues) + (long)(rowCount > numberOfNonNullValues ? 1 : 0));
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_TRUE_VALUES) && computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES)) {
            long numberOfTrue = BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_TRUE_VALUES), 0);
            long numberOfNonNullValues = BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), 0);
            result.setBooleanStatistics(new BooleanStatistics(OptionalLong.of(numberOfTrue), OptionalLong.of(numberOfNonNullValues - numberOfTrue)));
        }
        return result.build();
    }

    private static void setMinMax(Type type, Block min, Block max, HiveColumnStatistics.Builder result) {
        if (type.equals((Object)BigintType.BIGINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)TinyintType.TINYINT)) {
            result.setIntegerStatistics(new IntegerStatistics(Statistics.getIntegerValue(type, min), Statistics.getIntegerValue(type, max)));
        } else if (type.equals((Object)DoubleType.DOUBLE) || type.equals((Object)RealType.REAL)) {
            result.setDoubleStatistics(new DoubleStatistics(Statistics.getDoubleValue(type, min), Statistics.getDoubleValue(type, max)));
        } else if (type.equals((Object)DateType.DATE)) {
            result.setDateStatistics(new DateStatistics(Statistics.getDateValue(type, min), Statistics.getDateValue(type, max)));
        } else if (type instanceof DecimalType) {
            result.setDecimalStatistics(new DecimalStatistics(Statistics.getDecimalValue(type, min), Statistics.getDecimalValue(type, max)));
        } else {
            throw new IllegalArgumentException("Unexpected type: " + String.valueOf(type));
        }
    }

    private static OptionalLong getIntegerValue(Type type, Block block) {
        Verify.verify((type == BigintType.BIGINT || type == IntegerType.INTEGER || type == SmallintType.SMALLINT || type == TinyintType.TINYINT ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
        if (block.isNull(0)) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(type.getLong(block, 0));
    }

    private static OptionalDouble getDoubleValue(Type type, Block block) {
        double value;
        Verify.verify((type == DoubleType.DOUBLE || type == RealType.REAL ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
        if (block.isNull(0)) {
            return OptionalDouble.empty();
        }
        if (type == DoubleType.DOUBLE) {
            value = type.getDouble(block, 0);
        } else {
            Verify.verify((type == RealType.REAL ? 1 : 0) != 0);
            value = Float.intBitsToFloat(Math.toIntExact(type.getLong(block, 0)));
        }
        if (!Double.isFinite(value)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(value);
    }

    private static Optional<LocalDate> getDateValue(Type type, Block block) {
        Verify.verify((type == DateType.DATE ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
        if (block.isNull(0)) {
            return Optional.empty();
        }
        int days = Math.toIntExact(type.getLong(block, 0));
        return Optional.of(LocalDate.ofEpochDay(days));
    }

    private static Optional<BigDecimal> getDecimalValue(Type type, Block block) {
        Verify.verify((boolean)(type instanceof DecimalType), (String)"Unsupported type: %s", (Object)type);
        if (block.isNull(0)) {
            return Optional.empty();
        }
        return Optional.of(Decimals.readBigDecimal((DecimalType)((DecimalType)type), (Block)block, (int)0));
    }

    private static OptionalDouble getAverageColumnLength(OptionalLong totalSizeInBytes, OptionalLong numNonNullValues) {
        if (totalSizeInBytes.isEmpty() || numNonNullValues.isEmpty()) {
            return OptionalDouble.empty();
        }
        long nonNullsCount = numNonNullValues.getAsLong();
        if (nonNullsCount <= 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((double)totalSizeInBytes.getAsLong() / (double)nonNullsCount);
    }
}

