/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import io.airlift.slice.Slices;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ByteBitUnpackers;
import io.trino.parquet.reader.decoders.IntBitUnpackers;
import io.trino.parquet.reader.decoders.LongBitUnpackers;
import io.trino.parquet.reader.decoders.ShortBitUnpackers;
import java.util.Arrays;

public final class DeltaPackingUtils {
    private DeltaPackingUtils() {
    }

    public static void unpackDelta(byte[] output, int outputOffset, int length, SimpleSliceInputStream input, long minDelta, byte bitWidth) {
        if (bitWidth == 0) {
            DeltaPackingUtils.unpackEmpty(output, outputOffset, length, ParquetReaderUtils.toByteExact(minDelta));
        } else {
            DeltaPackingUtils.unpackByte(output, outputOffset, input, length, bitWidth, minDelta);
        }
    }

    public static void unpackDelta(short[] output, int outputOffset, int length, SimpleSliceInputStream input, long minDelta, byte bitWidth) {
        if (bitWidth == 0) {
            DeltaPackingUtils.unpackEmpty(output, outputOffset, length, ParquetReaderUtils.toShortExact(minDelta));
        } else {
            DeltaPackingUtils.unpackShort(output, outputOffset, input, length, bitWidth, minDelta);
        }
    }

    public static void unpackDelta(int[] output, int outputOffset, int length, SimpleSliceInputStream input, long minDelta, byte bitWidth) {
        if (bitWidth == 0) {
            DeltaPackingUtils.unpackEmpty(output, outputOffset, length, (int)minDelta);
        } else {
            DeltaPackingUtils.unpackInt(output, outputOffset, input, length, bitWidth, (int)minDelta);
        }
    }

    public static void unpackDelta(long[] output, int outputOffset, int length, SimpleSliceInputStream input, long minDelta, byte bitWidth) {
        if (bitWidth == 0) {
            DeltaPackingUtils.unpackEmpty(output, outputOffset, length, minDelta);
        } else {
            DeltaPackingUtils.unpackLong(output, outputOffset, input, length, bitWidth, minDelta);
        }
    }

    private static void unpackEmpty(byte[] output, int outputOffset, int length, byte delta) {
        if (delta == 0) {
            DeltaPackingUtils.fillArray8(output, outputOffset, length / 8, output[outputOffset - 1]);
        } else {
            DeltaPackingUtils.fillArray8(output, outputOffset, length / 8, delta);
            for (int i = outputOffset; i < outputOffset + length; i += 32) {
                int n = i;
                output[n] = (byte)(output[n] + output[i - 1]);
                int n2 = i + 1;
                output[n2] = (byte)(output[n2] + output[i]);
                int n3 = i + 2;
                output[n3] = (byte)(output[n3] + output[i + 1]);
                int n4 = i + 3;
                output[n4] = (byte)(output[n4] + output[i + 2]);
                int n5 = i + 4;
                output[n5] = (byte)(output[n5] + output[i + 3]);
                int n6 = i + 5;
                output[n6] = (byte)(output[n6] + output[i + 4]);
                int n7 = i + 6;
                output[n7] = (byte)(output[n7] + output[i + 5]);
                int n8 = i + 7;
                output[n8] = (byte)(output[n8] + output[i + 6]);
                int n9 = i + 8;
                output[n9] = (byte)(output[n9] + output[i + 7]);
                int n10 = i + 9;
                output[n10] = (byte)(output[n10] + output[i + 8]);
                int n11 = i + 10;
                output[n11] = (byte)(output[n11] + output[i + 9]);
                int n12 = i + 11;
                output[n12] = (byte)(output[n12] + output[i + 10]);
                int n13 = i + 12;
                output[n13] = (byte)(output[n13] + output[i + 11]);
                int n14 = i + 13;
                output[n14] = (byte)(output[n14] + output[i + 12]);
                int n15 = i + 14;
                output[n15] = (byte)(output[n15] + output[i + 13]);
                int n16 = i + 15;
                output[n16] = (byte)(output[n16] + output[i + 14]);
                int n17 = i + 16;
                output[n17] = (byte)(output[n17] + output[i + 15]);
                int n18 = i + 17;
                output[n18] = (byte)(output[n18] + output[i + 16]);
                int n19 = i + 18;
                output[n19] = (byte)(output[n19] + output[i + 17]);
                int n20 = i + 19;
                output[n20] = (byte)(output[n20] + output[i + 18]);
                int n21 = i + 20;
                output[n21] = (byte)(output[n21] + output[i + 19]);
                int n22 = i + 21;
                output[n22] = (byte)(output[n22] + output[i + 20]);
                int n23 = i + 22;
                output[n23] = (byte)(output[n23] + output[i + 21]);
                int n24 = i + 23;
                output[n24] = (byte)(output[n24] + output[i + 22]);
                int n25 = i + 24;
                output[n25] = (byte)(output[n25] + output[i + 23]);
                int n26 = i + 25;
                output[n26] = (byte)(output[n26] + output[i + 24]);
                int n27 = i + 26;
                output[n27] = (byte)(output[n27] + output[i + 25]);
                int n28 = i + 27;
                output[n28] = (byte)(output[n28] + output[i + 26]);
                int n29 = i + 28;
                output[n29] = (byte)(output[n29] + output[i + 27]);
                int n30 = i + 29;
                output[n30] = (byte)(output[n30] + output[i + 28]);
                int n31 = i + 30;
                output[n31] = (byte)(output[n31] + output[i + 29]);
                int n32 = i + 31;
                output[n32] = (byte)(output[n32] + output[i + 30]);
            }
        }
    }

    private static void unpackEmpty(short[] output, int outputOffset, int length, short delta) {
        if (delta == 0) {
            Arrays.fill(output, outputOffset, outputOffset + length, output[outputOffset - 1]);
        } else {
            Arrays.fill(output, outputOffset, outputOffset + length, delta);
            for (int i = outputOffset; i < outputOffset + length; i += 32) {
                int n = i;
                output[n] = (short)(output[n] + output[i - 1]);
                int n2 = i + 1;
                output[n2] = (short)(output[n2] + output[i]);
                int n3 = i + 2;
                output[n3] = (short)(output[n3] + output[i + 1]);
                int n4 = i + 3;
                output[n4] = (short)(output[n4] + output[i + 2]);
                int n5 = i + 4;
                output[n5] = (short)(output[n5] + output[i + 3]);
                int n6 = i + 5;
                output[n6] = (short)(output[n6] + output[i + 4]);
                int n7 = i + 6;
                output[n7] = (short)(output[n7] + output[i + 5]);
                int n8 = i + 7;
                output[n8] = (short)(output[n8] + output[i + 6]);
                int n9 = i + 8;
                output[n9] = (short)(output[n9] + output[i + 7]);
                int n10 = i + 9;
                output[n10] = (short)(output[n10] + output[i + 8]);
                int n11 = i + 10;
                output[n11] = (short)(output[n11] + output[i + 9]);
                int n12 = i + 11;
                output[n12] = (short)(output[n12] + output[i + 10]);
                int n13 = i + 12;
                output[n13] = (short)(output[n13] + output[i + 11]);
                int n14 = i + 13;
                output[n14] = (short)(output[n14] + output[i + 12]);
                int n15 = i + 14;
                output[n15] = (short)(output[n15] + output[i + 13]);
                int n16 = i + 15;
                output[n16] = (short)(output[n16] + output[i + 14]);
                int n17 = i + 16;
                output[n17] = (short)(output[n17] + output[i + 15]);
                int n18 = i + 17;
                output[n18] = (short)(output[n18] + output[i + 16]);
                int n19 = i + 18;
                output[n19] = (short)(output[n19] + output[i + 17]);
                int n20 = i + 19;
                output[n20] = (short)(output[n20] + output[i + 18]);
                int n21 = i + 20;
                output[n21] = (short)(output[n21] + output[i + 19]);
                int n22 = i + 21;
                output[n22] = (short)(output[n22] + output[i + 20]);
                int n23 = i + 22;
                output[n23] = (short)(output[n23] + output[i + 21]);
                int n24 = i + 23;
                output[n24] = (short)(output[n24] + output[i + 22]);
                int n25 = i + 24;
                output[n25] = (short)(output[n25] + output[i + 23]);
                int n26 = i + 25;
                output[n26] = (short)(output[n26] + output[i + 24]);
                int n27 = i + 26;
                output[n27] = (short)(output[n27] + output[i + 25]);
                int n28 = i + 27;
                output[n28] = (short)(output[n28] + output[i + 26]);
                int n29 = i + 28;
                output[n29] = (short)(output[n29] + output[i + 27]);
                int n30 = i + 29;
                output[n30] = (short)(output[n30] + output[i + 28]);
                int n31 = i + 30;
                output[n31] = (short)(output[n31] + output[i + 29]);
                int n32 = i + 31;
                output[n32] = (short)(output[n32] + output[i + 30]);
            }
        }
    }

    private static void unpackEmpty(int[] output, int outputOffset, int length, int delta) {
        if (delta == 0) {
            Arrays.fill(output, outputOffset, outputOffset + length, output[outputOffset - 1]);
        } else {
            Arrays.fill(output, outputOffset, outputOffset + length, delta);
            for (int i = outputOffset; i < outputOffset + length; i += 32) {
                int n = i;
                output[n] = output[n] + output[i - 1];
                int n2 = i + 1;
                output[n2] = output[n2] + output[i];
                int n3 = i + 2;
                output[n3] = output[n3] + output[i + 1];
                int n4 = i + 3;
                output[n4] = output[n4] + output[i + 2];
                int n5 = i + 4;
                output[n5] = output[n5] + output[i + 3];
                int n6 = i + 5;
                output[n6] = output[n6] + output[i + 4];
                int n7 = i + 6;
                output[n7] = output[n7] + output[i + 5];
                int n8 = i + 7;
                output[n8] = output[n8] + output[i + 6];
                int n9 = i + 8;
                output[n9] = output[n9] + output[i + 7];
                int n10 = i + 9;
                output[n10] = output[n10] + output[i + 8];
                int n11 = i + 10;
                output[n11] = output[n11] + output[i + 9];
                int n12 = i + 11;
                output[n12] = output[n12] + output[i + 10];
                int n13 = i + 12;
                output[n13] = output[n13] + output[i + 11];
                int n14 = i + 13;
                output[n14] = output[n14] + output[i + 12];
                int n15 = i + 14;
                output[n15] = output[n15] + output[i + 13];
                int n16 = i + 15;
                output[n16] = output[n16] + output[i + 14];
                int n17 = i + 16;
                output[n17] = output[n17] + output[i + 15];
                int n18 = i + 17;
                output[n18] = output[n18] + output[i + 16];
                int n19 = i + 18;
                output[n19] = output[n19] + output[i + 17];
                int n20 = i + 19;
                output[n20] = output[n20] + output[i + 18];
                int n21 = i + 20;
                output[n21] = output[n21] + output[i + 19];
                int n22 = i + 21;
                output[n22] = output[n22] + output[i + 20];
                int n23 = i + 22;
                output[n23] = output[n23] + output[i + 21];
                int n24 = i + 23;
                output[n24] = output[n24] + output[i + 22];
                int n25 = i + 24;
                output[n25] = output[n25] + output[i + 23];
                int n26 = i + 25;
                output[n26] = output[n26] + output[i + 24];
                int n27 = i + 26;
                output[n27] = output[n27] + output[i + 25];
                int n28 = i + 27;
                output[n28] = output[n28] + output[i + 26];
                int n29 = i + 28;
                output[n29] = output[n29] + output[i + 27];
                int n30 = i + 29;
                output[n30] = output[n30] + output[i + 28];
                int n31 = i + 30;
                output[n31] = output[n31] + output[i + 29];
                int n32 = i + 31;
                output[n32] = output[n32] + output[i + 30];
            }
        }
    }

    private static void unpackEmpty(long[] output, int outputOffset, int length, long delta) {
        if (delta == 0L) {
            Arrays.fill(output, outputOffset, outputOffset + length, output[outputOffset - 1]);
        } else {
            Arrays.fill(output, outputOffset, outputOffset + length, delta);
            for (int i = outputOffset; i < outputOffset + length; i += 32) {
                int n = i;
                output[n] = output[n] + output[i - 1];
                int n2 = i + 1;
                output[n2] = output[n2] + output[i];
                int n3 = i + 2;
                output[n3] = output[n3] + output[i + 1];
                int n4 = i + 3;
                output[n4] = output[n4] + output[i + 2];
                int n5 = i + 4;
                output[n5] = output[n5] + output[i + 3];
                int n6 = i + 5;
                output[n6] = output[n6] + output[i + 4];
                int n7 = i + 6;
                output[n7] = output[n7] + output[i + 5];
                int n8 = i + 7;
                output[n8] = output[n8] + output[i + 6];
                int n9 = i + 8;
                output[n9] = output[n9] + output[i + 7];
                int n10 = i + 9;
                output[n10] = output[n10] + output[i + 8];
                int n11 = i + 10;
                output[n11] = output[n11] + output[i + 9];
                int n12 = i + 11;
                output[n12] = output[n12] + output[i + 10];
                int n13 = i + 12;
                output[n13] = output[n13] + output[i + 11];
                int n14 = i + 13;
                output[n14] = output[n14] + output[i + 12];
                int n15 = i + 14;
                output[n15] = output[n15] + output[i + 13];
                int n16 = i + 15;
                output[n16] = output[n16] + output[i + 14];
                int n17 = i + 16;
                output[n17] = output[n17] + output[i + 15];
                int n18 = i + 17;
                output[n18] = output[n18] + output[i + 16];
                int n19 = i + 18;
                output[n19] = output[n19] + output[i + 17];
                int n20 = i + 19;
                output[n20] = output[n20] + output[i + 18];
                int n21 = i + 20;
                output[n21] = output[n21] + output[i + 19];
                int n22 = i + 21;
                output[n22] = output[n22] + output[i + 20];
                int n23 = i + 22;
                output[n23] = output[n23] + output[i + 21];
                int n24 = i + 23;
                output[n24] = output[n24] + output[i + 22];
                int n25 = i + 24;
                output[n25] = output[n25] + output[i + 23];
                int n26 = i + 25;
                output[n26] = output[n26] + output[i + 24];
                int n27 = i + 26;
                output[n27] = output[n27] + output[i + 25];
                int n28 = i + 27;
                output[n28] = output[n28] + output[i + 26];
                int n29 = i + 28;
                output[n29] = output[n29] + output[i + 27];
                int n30 = i + 29;
                output[n30] = output[n30] + output[i + 28];
                int n31 = i + 30;
                output[n31] = output[n31] + output[i + 29];
                int n32 = i + 31;
                output[n32] = output[n32] + output[i + 30];
            }
        }
    }

    private static void unpackByte(byte[] output, int outputOffset, SimpleSliceInputStream input, int length, byte bitWidth, long minDelta) {
        ByteBitUnpackers.getByteBitUnpacker(bitWidth).unpack(output, outputOffset, input, length);
        DeltaPackingUtils.inPlacePrefixSum(output, outputOffset, length, (short)minDelta);
    }

    private static void unpackShort(short[] output, int outputOffset, SimpleSliceInputStream input, int length, byte bitWidth, long minDelta) {
        ShortBitUnpackers.getShortBitUnpacker(bitWidth).unpack(output, outputOffset, input, length);
        DeltaPackingUtils.inPlacePrefixSum(output, outputOffset, length, (int)minDelta);
    }

    private static void unpackInt(int[] output, int outputOffset, SimpleSliceInputStream input, int length, byte bitWidth, int minDelta) {
        IntBitUnpackers.getIntBitUnpacker(bitWidth).unpack(output, outputOffset, input, length);
        DeltaPackingUtils.inPlacePrefixSum(output, outputOffset, length, minDelta);
    }

    private static void unpackLong(long[] output, int outputOffset, SimpleSliceInputStream input, int length, byte bitWidth, long minDelta) {
        LongBitUnpackers.getLongBitUnpacker(bitWidth).unpack(output, outputOffset, input, length);
        DeltaPackingUtils.inPlacePrefixSum(output, outputOffset, length, minDelta);
    }

    private static void fillArray8(byte[] output, int outputOffset, int length, byte baseValue) {
        int lengthInBytes = length * 8;
        Slices.wrappedBuffer((byte[])output, (int)outputOffset, (int)lengthInBytes).fill(baseValue);
    }

    private static void inPlacePrefixSum(byte[] output, int outputOffset, int length, short minDelta) {
        for (int i = outputOffset; i < outputOffset + length; i += 32) {
            output[i] = (byte)(output[i] + (output[i - 1] + minDelta));
            output[i + 1] = (byte)(output[i + 1] + (output[i] + minDelta));
            output[i + 2] = (byte)(output[i + 2] + (output[i + 1] + minDelta));
            output[i + 3] = (byte)(output[i + 3] + (output[i + 2] + minDelta));
            output[i + 4] = (byte)(output[i + 4] + (output[i + 3] + minDelta));
            output[i + 5] = (byte)(output[i + 5] + (output[i + 4] + minDelta));
            output[i + 6] = (byte)(output[i + 6] + (output[i + 5] + minDelta));
            output[i + 7] = (byte)(output[i + 7] + (output[i + 6] + minDelta));
            output[i + 8] = (byte)(output[i + 8] + (output[i + 7] + minDelta));
            output[i + 9] = (byte)(output[i + 9] + (output[i + 8] + minDelta));
            output[i + 10] = (byte)(output[i + 10] + (output[i + 9] + minDelta));
            output[i + 11] = (byte)(output[i + 11] + (output[i + 10] + minDelta));
            output[i + 12] = (byte)(output[i + 12] + (output[i + 11] + minDelta));
            output[i + 13] = (byte)(output[i + 13] + (output[i + 12] + minDelta));
            output[i + 14] = (byte)(output[i + 14] + (output[i + 13] + minDelta));
            output[i + 15] = (byte)(output[i + 15] + (output[i + 14] + minDelta));
            output[i + 16] = (byte)(output[i + 16] + (output[i + 15] + minDelta));
            output[i + 17] = (byte)(output[i + 17] + (output[i + 16] + minDelta));
            output[i + 18] = (byte)(output[i + 18] + (output[i + 17] + minDelta));
            output[i + 19] = (byte)(output[i + 19] + (output[i + 18] + minDelta));
            output[i + 20] = (byte)(output[i + 20] + (output[i + 19] + minDelta));
            output[i + 21] = (byte)(output[i + 21] + (output[i + 20] + minDelta));
            output[i + 22] = (byte)(output[i + 22] + (output[i + 21] + minDelta));
            output[i + 23] = (byte)(output[i + 23] + (output[i + 22] + minDelta));
            output[i + 24] = (byte)(output[i + 24] + (output[i + 23] + minDelta));
            output[i + 25] = (byte)(output[i + 25] + (output[i + 24] + minDelta));
            output[i + 26] = (byte)(output[i + 26] + (output[i + 25] + minDelta));
            output[i + 27] = (byte)(output[i + 27] + (output[i + 26] + minDelta));
            output[i + 28] = (byte)(output[i + 28] + (output[i + 27] + minDelta));
            output[i + 29] = (byte)(output[i + 29] + (output[i + 28] + minDelta));
            output[i + 30] = (byte)(output[i + 30] + (output[i + 29] + minDelta));
            output[i + 31] = (byte)(output[i + 31] + (output[i + 30] + minDelta));
        }
    }

    private static void inPlacePrefixSum(short[] output, int outputOffset, int length, int minDelta) {
        for (int i = outputOffset; i < outputOffset + length; i += 32) {
            output[i] = (short)(output[i] + output[i - 1] + minDelta);
            output[i + 1] = (short)(output[i + 1] + output[i] + minDelta);
            output[i + 2] = (short)(output[i + 2] + output[i + 1] + minDelta);
            output[i + 3] = (short)(output[i + 3] + output[i + 2] + minDelta);
            output[i + 4] = (short)(output[i + 4] + output[i + 3] + minDelta);
            output[i + 5] = (short)(output[i + 5] + output[i + 4] + minDelta);
            output[i + 6] = (short)(output[i + 6] + output[i + 5] + minDelta);
            output[i + 7] = (short)(output[i + 7] + output[i + 6] + minDelta);
            output[i + 8] = (short)(output[i + 8] + output[i + 7] + minDelta);
            output[i + 9] = (short)(output[i + 9] + output[i + 8] + minDelta);
            output[i + 10] = (short)(output[i + 10] + output[i + 9] + minDelta);
            output[i + 11] = (short)(output[i + 11] + output[i + 10] + minDelta);
            output[i + 12] = (short)(output[i + 12] + output[i + 11] + minDelta);
            output[i + 13] = (short)(output[i + 13] + output[i + 12] + minDelta);
            output[i + 14] = (short)(output[i + 14] + output[i + 13] + minDelta);
            output[i + 15] = (short)(output[i + 15] + output[i + 14] + minDelta);
            output[i + 16] = (short)(output[i + 16] + output[i + 15] + minDelta);
            output[i + 17] = (short)(output[i + 17] + output[i + 16] + minDelta);
            output[i + 18] = (short)(output[i + 18] + output[i + 17] + minDelta);
            output[i + 19] = (short)(output[i + 19] + output[i + 18] + minDelta);
            output[i + 20] = (short)(output[i + 20] + output[i + 19] + minDelta);
            output[i + 21] = (short)(output[i + 21] + output[i + 20] + minDelta);
            output[i + 22] = (short)(output[i + 22] + output[i + 21] + minDelta);
            output[i + 23] = (short)(output[i + 23] + output[i + 22] + minDelta);
            output[i + 24] = (short)(output[i + 24] + output[i + 23] + minDelta);
            output[i + 25] = (short)(output[i + 25] + output[i + 24] + minDelta);
            output[i + 26] = (short)(output[i + 26] + output[i + 25] + minDelta);
            output[i + 27] = (short)(output[i + 27] + output[i + 26] + minDelta);
            output[i + 28] = (short)(output[i + 28] + output[i + 27] + minDelta);
            output[i + 29] = (short)(output[i + 29] + output[i + 28] + minDelta);
            output[i + 30] = (short)(output[i + 30] + output[i + 29] + minDelta);
            output[i + 31] = (short)(output[i + 31] + output[i + 30] + minDelta);
        }
    }

    private static void inPlacePrefixSum(int[] output, int outputOffset, int length, int minDelta) {
        for (int i = outputOffset; i < outputOffset + length; i += 32) {
            int n = i;
            output[n] = output[n] + (output[i - 1] + minDelta);
            int n2 = i + 1;
            output[n2] = output[n2] + (output[i] + minDelta);
            int n3 = i + 2;
            output[n3] = output[n3] + (output[i + 1] + minDelta);
            int n4 = i + 3;
            output[n4] = output[n4] + (output[i + 2] + minDelta);
            int n5 = i + 4;
            output[n5] = output[n5] + (output[i + 3] + minDelta);
            int n6 = i + 5;
            output[n6] = output[n6] + (output[i + 4] + minDelta);
            int n7 = i + 6;
            output[n7] = output[n7] + (output[i + 5] + minDelta);
            int n8 = i + 7;
            output[n8] = output[n8] + (output[i + 6] + minDelta);
            int n9 = i + 8;
            output[n9] = output[n9] + (output[i + 7] + minDelta);
            int n10 = i + 9;
            output[n10] = output[n10] + (output[i + 8] + minDelta);
            int n11 = i + 10;
            output[n11] = output[n11] + (output[i + 9] + minDelta);
            int n12 = i + 11;
            output[n12] = output[n12] + (output[i + 10] + minDelta);
            int n13 = i + 12;
            output[n13] = output[n13] + (output[i + 11] + minDelta);
            int n14 = i + 13;
            output[n14] = output[n14] + (output[i + 12] + minDelta);
            int n15 = i + 14;
            output[n15] = output[n15] + (output[i + 13] + minDelta);
            int n16 = i + 15;
            output[n16] = output[n16] + (output[i + 14] + minDelta);
            int n17 = i + 16;
            output[n17] = output[n17] + (output[i + 15] + minDelta);
            int n18 = i + 17;
            output[n18] = output[n18] + (output[i + 16] + minDelta);
            int n19 = i + 18;
            output[n19] = output[n19] + (output[i + 17] + minDelta);
            int n20 = i + 19;
            output[n20] = output[n20] + (output[i + 18] + minDelta);
            int n21 = i + 20;
            output[n21] = output[n21] + (output[i + 19] + minDelta);
            int n22 = i + 21;
            output[n22] = output[n22] + (output[i + 20] + minDelta);
            int n23 = i + 22;
            output[n23] = output[n23] + (output[i + 21] + minDelta);
            int n24 = i + 23;
            output[n24] = output[n24] + (output[i + 22] + minDelta);
            int n25 = i + 24;
            output[n25] = output[n25] + (output[i + 23] + minDelta);
            int n26 = i + 25;
            output[n26] = output[n26] + (output[i + 24] + minDelta);
            int n27 = i + 26;
            output[n27] = output[n27] + (output[i + 25] + minDelta);
            int n28 = i + 27;
            output[n28] = output[n28] + (output[i + 26] + minDelta);
            int n29 = i + 28;
            output[n29] = output[n29] + (output[i + 27] + minDelta);
            int n30 = i + 29;
            output[n30] = output[n30] + (output[i + 28] + minDelta);
            int n31 = i + 30;
            output[n31] = output[n31] + (output[i + 29] + minDelta);
            int n32 = i + 31;
            output[n32] = output[n32] + (output[i + 30] + minDelta);
        }
    }

    private static void inPlacePrefixSum(long[] output, int outputOffset, int length, long minDelta) {
        for (int i = outputOffset; i < outputOffset + length; i += 32) {
            int n = i;
            output[n] = output[n] + (output[i - 1] + minDelta);
            int n2 = i + 1;
            output[n2] = output[n2] + (output[i] + minDelta);
            int n3 = i + 2;
            output[n3] = output[n3] + (output[i + 1] + minDelta);
            int n4 = i + 3;
            output[n4] = output[n4] + (output[i + 2] + minDelta);
            int n5 = i + 4;
            output[n5] = output[n5] + (output[i + 3] + minDelta);
            int n6 = i + 5;
            output[n6] = output[n6] + (output[i + 4] + minDelta);
            int n7 = i + 6;
            output[n7] = output[n7] + (output[i + 5] + minDelta);
            int n8 = i + 7;
            output[n8] = output[n8] + (output[i + 6] + minDelta);
            int n9 = i + 8;
            output[n9] = output[n9] + (output[i + 7] + minDelta);
            int n10 = i + 9;
            output[n10] = output[n10] + (output[i + 8] + minDelta);
            int n11 = i + 10;
            output[n11] = output[n11] + (output[i + 9] + minDelta);
            int n12 = i + 11;
            output[n12] = output[n12] + (output[i + 10] + minDelta);
            int n13 = i + 12;
            output[n13] = output[n13] + (output[i + 11] + minDelta);
            int n14 = i + 13;
            output[n14] = output[n14] + (output[i + 12] + minDelta);
            int n15 = i + 14;
            output[n15] = output[n15] + (output[i + 13] + minDelta);
            int n16 = i + 15;
            output[n16] = output[n16] + (output[i + 14] + minDelta);
            int n17 = i + 16;
            output[n17] = output[n17] + (output[i + 15] + minDelta);
            int n18 = i + 17;
            output[n18] = output[n18] + (output[i + 16] + minDelta);
            int n19 = i + 18;
            output[n19] = output[n19] + (output[i + 17] + minDelta);
            int n20 = i + 19;
            output[n20] = output[n20] + (output[i + 18] + minDelta);
            int n21 = i + 20;
            output[n21] = output[n21] + (output[i + 19] + minDelta);
            int n22 = i + 21;
            output[n22] = output[n22] + (output[i + 20] + minDelta);
            int n23 = i + 22;
            output[n23] = output[n23] + (output[i + 21] + minDelta);
            int n24 = i + 23;
            output[n24] = output[n24] + (output[i + 22] + minDelta);
            int n25 = i + 24;
            output[n25] = output[n25] + (output[i + 23] + minDelta);
            int n26 = i + 25;
            output[n26] = output[n26] + (output[i + 24] + minDelta);
            int n27 = i + 26;
            output[n27] = output[n27] + (output[i + 25] + minDelta);
            int n28 = i + 27;
            output[n28] = output[n28] + (output[i + 26] + minDelta);
            int n29 = i + 28;
            output[n29] = output[n29] + (output[i + 27] + minDelta);
            int n30 = i + 29;
            output[n30] = output[n30] + (output[i + 28] + minDelta);
            int n31 = i + 30;
            output[n31] = output[n31] + (output[i + 29] + minDelta);
            int n32 = i + 31;
            output[n32] = output[n32] + (output[i + 30] + minDelta);
        }
    }
}

