/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.base.Verify;
import io.trino.parquet.ParquetMetadataConverter;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetMetadataUtils {
    private ParquetMetadataUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Comparable<T>> org.apache.parquet.format.Statistics toParquetStatistics(Statistics<T> stats, int truncateLength) {
        if (ParquetMetadataUtils.isTruncationPossible(stats, truncateLength)) {
            Verify.verify((2L * (long)truncateLength < 4096L ? 1 : 0) != 0, (String)"Twice of truncateLength %s must be less than MAX_STATS_SIZE %s", (int)truncateLength, (long)4096L);
            Class<ParquetMetadataUtils> clazz = ParquetMetadataUtils.class;
            synchronized (ParquetMetadataUtils.class) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ParquetMetadataConverter.toParquetStatistics(stats, truncateLength);
            }
        }
        return ParquetMetadataConverter.toParquetStatistics(stats);
    }

    private static <T extends Comparable<T>> boolean isTruncationPossible(Statistics<T> stats, int truncateLength) {
        PrimitiveType.PrimitiveTypeName primitiveType = stats.type().getPrimitiveTypeName();
        if (!primitiveType.equals((Object)PrimitiveType.PrimitiveTypeName.BINARY) && !primitiveType.equals((Object)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY)) {
            return false;
        }
        if (stats.isEmpty() || !stats.hasNonNullValue() || !(stats instanceof BinaryStatistics)) {
            return false;
        }
        BinaryStatistics binaryStatistics = (BinaryStatistics)stats;
        Binary min = binaryStatistics.genericGetMin();
        Binary max = binaryStatistics.genericGetMax();
        return min.length() > truncateLength || max.length() > truncateLength;
    }
}

