/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.CacheContext;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.CacheUsage;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.exception.PageNotFoundException;
import alluxio.file.ReadTargetBuffer;
import alluxio.network.protocol.databuffer.DataFileChannel;
import io.airlift.units.DataSize;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.alluxio.AlluxioTracing;
import io.trino.filesystem.tracing.CacheSystemAttributes;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class TracingCacheManager
implements CacheManager {
    private final Tracer tracer;
    private final String cacheKey;
    private final CacheManager delegate;
    private final long pageSizeBytes;

    public TracingCacheManager(Tracer tracer, String cacheKey, DataSize pageSize, CacheManager delegate) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.pageSizeBytes = Objects.requireNonNull(pageSize, "pageSize is null").toBytes();
        this.cacheKey = Objects.requireNonNull(cacheKey, "cacheKey is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public boolean put(PageId pageId, ByteBuffer byteBuffer, CacheContext cacheContext) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.put").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_POSITION, (Object)this.positionInFile(pageId, 0L)).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_SIZE, (Object)byteBuffer.remaining()).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.put(pageId, byteBuffer, cacheContext));
    }

    public int get(PageId pageId, int position, int length, ReadTargetBuffer readTargetBuffer, CacheContext cacheContext) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.get").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_POSITION, (Object)this.positionInFile(pageId, position)).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_SIZE, (Object)length).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.get(pageId, position, length, readTargetBuffer, cacheContext));
    }

    public int getAndLoad(PageId pageId, int position, int length, ReadTargetBuffer readTargetBuffer, CacheContext cacheContext, Supplier<byte[]> supplier) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.getAndLoad").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_POSITION, (Object)this.positionInFile(pageId, position)).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_SIZE, (Object)length).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.getAndLoad(pageId, position, length, readTargetBuffer, cacheContext, supplier));
    }

    public void deleteFile(String fileId) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.deleteFile").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).startSpan();
        AlluxioTracing.withTracing(span, () -> this.delegate.deleteFile(fileId));
    }

    public void deleteTempFile(String fileId) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.deleteTempFile").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).startSpan();
        AlluxioTracing.withTracing(span, () -> this.delegate.deleteTempFile(fileId));
    }

    public boolean delete(PageId pageId) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.delete").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.delete(pageId));
    }

    public boolean append(PageId pageId, int position, byte[] bytes, CacheContext cacheContext) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.append").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_POSITION, (Object)this.positionInFile(pageId, position)).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_SIZE, (Object)bytes.length).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.append(pageId, position, bytes, cacheContext));
    }

    public void commitFile(String fileId) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.commitFile").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).startSpan();
        AlluxioTracing.withTracing(span, () -> this.delegate.commitFile(fileId));
    }

    public Optional<DataFileChannel> getDataFileChannel(PageId pageId, int position, int length, CacheContext cacheContext) throws PageNotFoundException {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.getDataFileChannel").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_POSITION, (Object)this.positionInFile(pageId, position)).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_POSITION, (Object)length).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.getDataFileChannel(pageId, position, length, cacheContext));
    }

    public void close() throws Exception {
        this.delegate.close();
    }

    public boolean put(PageId pageId, byte[] page) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.put").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_POSITION, (Object)this.positionInFile(pageId, 0L)).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_SIZE, (Object)page.length).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.put(pageId, page));
    }

    public boolean put(PageId pageId, ByteBuffer page) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.put").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_POSITION, (Object)this.positionInFile(pageId, 0L)).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_SIZE, (Object)page.remaining()).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.put(pageId, page));
    }

    public boolean put(PageId pageId, byte[] page, CacheContext cacheContext) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.put").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_POSITION, (Object)this.positionInFile(pageId, 0L)).setAttribute(CacheSystemAttributes.CACHE_FILE_WRITE_SIZE, (Object)page.length).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.put(pageId, page, cacheContext));
    }

    public int get(PageId pageId, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.get").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_POSITION, (Object)this.positionInFile(pageId, 0L)).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_SIZE, (Object)bytesToRead).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.get(pageId, bytesToRead, buffer, offsetInBuffer));
    }

    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.get").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_POSITION, (Object)this.positionInFile(pageId, pageOffset)).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_SIZE, (Object)bytesToRead).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.get(pageId, bytesToRead, buffer, offsetInBuffer));
    }

    public int get(PageId pageId, int pageOffset, ReadTargetBuffer buffer, CacheContext cacheContext) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.get").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_POSITION, (Object)this.positionInFile(pageId, pageOffset)).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_SIZE, (Object)buffer.remaining()).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.get(pageId, pageOffset, buffer, cacheContext));
    }

    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer, CacheContext cacheContext) {
        Span span = this.tracer.spanBuilder("AlluxioCacheManager.get").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_POSITION, (Object)this.positionInFile(pageId, pageOffset)).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_SIZE, (Object)bytesToRead).startSpan();
        return AlluxioTracing.withTracing(span, () -> this.delegate.get(pageId, pageOffset, bytesToRead, buffer, offsetInBuffer, cacheContext));
    }

    public List<PageId> getCachedPageIdsByFileId(String fileId, long fileLength) {
        return this.delegate.getCachedPageIdsByFileId(fileId, fileLength);
    }

    public boolean hasPageUnsafe(PageId pageId) {
        return this.delegate.hasPageUnsafe(pageId);
    }

    public void invalidate(Predicate<PageInfo> predicate) {
        this.delegate.invalidate(predicate);
    }

    public Optional<CacheUsage> getUsage() {
        return this.delegate.getUsage();
    }

    public CacheManager.State state() {
        return this.delegate.state();
    }

    private long positionInFile(PageId pageId, long position) {
        return pageId.getPageIndex() * this.pageSizeBytes + position;
    }
}

