/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.gcs.GcsLocation;
import io.trino.filesystem.gcs.GcsOutputStream;
import io.trino.filesystem.gcs.GcsUtils;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.Objects;

public class GcsOutputFile
implements TrinoOutputFile {
    private static final Storage.BlobTargetOption[] DOES_NOT_EXIST_TARGET_OPTION = new Storage.BlobTargetOption[]{Storage.BlobTargetOption.doesNotExist()};
    private static final Storage.BlobTargetOption[] EMPTY_TARGET_OPTIONS = new Storage.BlobTargetOption[0];
    private final GcsLocation location;
    private final Storage storage;
    private final long writeBlockSizeBytes;

    public GcsOutputFile(GcsLocation location, Storage storage, long writeBlockSizeBytes) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.storage = Objects.requireNonNull(storage, "storage is null");
        Preconditions.checkArgument((writeBlockSizeBytes >= 0L ? 1 : 0) != 0, (Object)"writeBlockSizeBytes is negative");
        this.writeBlockSizeBytes = writeBlockSizeBytes;
    }

    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        return this.createOutputStream(memoryContext, false);
    }

    public OutputStream createOrOverwrite(AggregatedMemoryContext memoryContext) throws IOException {
        return this.createOutputStream(memoryContext, true);
    }

    public void createExclusive(Slice content, AggregatedMemoryContext memoryContext) throws IOException {
        try {
            if (GcsUtils.getBlob(this.storage, this.location, new Storage.BlobGetOption[0]).isPresent()) {
                throw new FileAlreadyExistsException("File %s already exists".formatted(this.location));
            }
            this.storage.create(BlobInfo.newBuilder((BlobId)BlobId.of((String)this.location.bucket(), (String)this.location.path())).build(), content.getBytes(), DOES_NOT_EXIST_TARGET_OPTION);
        }
        catch (FileAlreadyExistsException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "writing file", this.location);
        }
    }

    private OutputStream createOutputStream(AggregatedMemoryContext memoryContext, boolean overwrite) throws IOException {
        try {
            Storage.BlobTargetOption[] blobTargetOptions = EMPTY_TARGET_OPTIONS;
            if (!overwrite) {
                if (!GcsUtils.getBlob(this.storage, this.location, new Storage.BlobGetOption[0]).isEmpty()) {
                    throw new FileAlreadyExistsException("File %s already exists".formatted(this.location));
                }
                blobTargetOptions = DOES_NOT_EXIST_TARGET_OPTION;
            }
            Blob blob = this.storage.create(BlobInfo.newBuilder((BlobId)BlobId.of((String)this.location.bucket(), (String)this.location.path())).build(), blobTargetOptions);
            return new GcsOutputStream(this.location, blob, memoryContext, this.writeBlockSizeBytes);
        }
        catch (FileAlreadyExistsException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "writing file", this.location);
        }
    }

    public Location location() {
        return this.location.location();
    }
}

