/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.trino.hive.formats.UnionToRowCoercionUtils;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.avro.Schema;

public final class AvroTypeUtils {
    private AvroTypeUtils() {
    }

    public static Type typeFromAvro(Schema schema, AvroTypeManager avroTypeManager) throws AvroTypeException {
        return AvroTypeUtils.typeFromAvro(schema, avroTypeManager, new HashSet<Schema>());
    }

    private static Type typeFromAvro(Schema schema, AvroTypeManager avroTypeManager, Set<Schema> enclosingRecords) throws AvroTypeException {
        Optional<Type> customType = avroTypeManager.overrideTypeForSchema(schema);
        if (customType.isPresent()) {
            return customType.get();
        }
        return switch (schema.getType()) {
            default -> throw new MatchException(null, null);
            case Schema.Type.NULL -> throw new UnsupportedOperationException("No null column type support");
            case Schema.Type.BOOLEAN -> BooleanType.BOOLEAN;
            case Schema.Type.INT -> IntegerType.INTEGER;
            case Schema.Type.LONG -> BigintType.BIGINT;
            case Schema.Type.FLOAT -> RealType.REAL;
            case Schema.Type.DOUBLE -> DoubleType.DOUBLE;
            case Schema.Type.ENUM, Schema.Type.STRING -> VarcharType.VARCHAR;
            case Schema.Type.FIXED, Schema.Type.BYTES -> VarbinaryType.VARBINARY;
            case Schema.Type.ARRAY -> new ArrayType(AvroTypeUtils.typeFromAvro(schema.getElementType(), avroTypeManager, enclosingRecords));
            case Schema.Type.MAP -> new MapType((Type)VarcharType.VARCHAR, AvroTypeUtils.typeFromAvro(schema.getValueType(), avroTypeManager, enclosingRecords), new TypeOperators());
            case Schema.Type.RECORD -> {
                if (!enclosingRecords.add(schema)) {
                    throw new UnsupportedOperationException("Unable to represent recursive avro schemas in Trino Type form");
                }
                ImmutableList.Builder rowFieldTypes = ImmutableList.builder();
                for (Schema.Field field : schema.getFields()) {
                    rowFieldTypes.add((Object)new RowType.Field(Optional.of(field.name()), AvroTypeUtils.typeFromAvro(field.schema(), avroTypeManager, new HashSet<Schema>(enclosingRecords))));
                }
                yield RowType.from((List)rowFieldTypes.build());
            }
            case Schema.Type.UNION -> AvroTypeUtils.isSimpleNullableUnion(schema) ? AvroTypeUtils.typeFromAvro(AvroTypeUtils.unwrapNullableUnion(schema), avroTypeManager, enclosingRecords) : AvroTypeUtils.rowTypeForUnion(schema, avroTypeManager, enclosingRecords);
        };
    }

    static boolean isSimpleNullableUnion(Schema schema) {
        Verify.verify((boolean)schema.isUnion(), (String)"Schema must be union", (Object[])new Object[0]);
        return schema.getTypes().stream().filter(Predicate.not(Schema::isNullable)).count() == 1L;
    }

    static Schema unwrapNullableUnion(Schema schema) {
        Verify.verify((boolean)schema.isUnion(), (String)"Schema must be union", (Object[])new Object[0]);
        Verify.verify((schema.isNullable() && schema.getTypes().size() == 2 ? 1 : 0) != 0);
        return (Schema)schema.getTypes().stream().filter(Predicate.not(Schema::isNullable)).collect(MoreCollectors.onlyElement());
    }

    private static RowType rowTypeForUnion(Schema schema, AvroTypeManager avroTypeManager, Set<Schema> enclosingRecords) throws AvroTypeException {
        Verify.verify((boolean)schema.isUnion());
        ImmutableList.Builder unionTypes = ImmutableList.builder();
        for (Schema variant : schema.getTypes()) {
            if (variant.isNullable()) continue;
            unionTypes.add((Object)AvroTypeUtils.typeFromAvro(variant, avroTypeManager, enclosingRecords));
        }
        return UnionToRowCoercionUtils.rowTypeForUnionOfTypes((List<Type>)unionTypes.build());
    }

    public static SimpleUnionNullIndex getSimpleNullableUnionNullIndex(Schema schema) {
        Verify.verify((boolean)schema.isUnion(), (String)"Schema must be union", (Object[])new Object[0]);
        Verify.verify((schema.isNullable() && schema.getTypes().size() == 2 ? 1 : 0) != 0, (String)"Invalid null union: %s", (Object)schema);
        return ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL ? SimpleUnionNullIndex.ZERO : SimpleUnionNullIndex.ONE;
    }

    static Schema lowerCaseAllFieldsForWriter(Schema schema) {
        return switch (schema.getType()) {
            default -> throw new MatchException(null, null);
            case Schema.Type.RECORD -> Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), (List)((List)schema.getFields().stream().map(field -> new Schema.Field(field.name().toLowerCase(Locale.ENGLISH), AvroTypeUtils.lowerCaseAllFieldsForWriter(field.schema()), field.doc())).collect(ImmutableList.toImmutableList())));
            case Schema.Type.ARRAY -> Schema.createArray((Schema)AvroTypeUtils.lowerCaseAllFieldsForWriter(schema.getElementType()));
            case Schema.Type.MAP -> Schema.createMap((Schema)AvroTypeUtils.lowerCaseAllFieldsForWriter(schema.getValueType()));
            case Schema.Type.UNION -> Schema.createUnion((List)((List)schema.getTypes().stream().map(AvroTypeUtils::lowerCaseAllFieldsForWriter).collect(ImmutableList.toImmutableList())));
            case Schema.Type.NULL, Schema.Type.BOOLEAN, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.ENUM, Schema.Type.STRING, Schema.Type.FIXED, Schema.Type.BYTES -> schema;
        };
    }

    static enum SimpleUnionNullIndex {
        ZERO(0),
        ONE(1);

        private final int index;

        private SimpleUnionNullIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

