/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.openxjson;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.HiveFormatUtils;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineSerializer;
import io.trino.hive.formats.line.openxjson.InvalidJsonException;
import io.trino.hive.formats.line.openxjson.JsonWriter;
import io.trino.hive.formats.line.openxjson.OpenXJsonOptions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OpenXJsonSerializer
implements LineSerializer {
    private static final DateTimeFormatter UTC_PRINT_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NORMAL).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NORMAL).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().appendLiteral('Z').toFormatter();
    private final List<Column> columns;
    private final OpenXJsonOptions options;

    public OpenXJsonSerializer(List<Column> columns, OpenXJsonOptions options) {
        this.columns = ImmutableList.copyOf(columns);
        this.options = Objects.requireNonNull(options, "options is null");
        for (Column column : columns) {
            if (OpenXJsonSerializer.isSupportedType(column.type())) continue;
            throw new IllegalArgumentException("Unsupported column type: " + String.valueOf(column));
        }
    }

    @Override
    public List<? extends Type> getTypes() {
        return (List)this.columns.stream().map(Column::type).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void write(Page page, int position, SliceOutput sliceOutput) throws IOException {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        for (int columnIndex = 0; columnIndex < this.columns.size(); ++columnIndex) {
            Column column = this.columns.get(columnIndex);
            String fieldName = column.name();
            Block block = page.getBlock(columnIndex);
            Object fieldValue = this.writeValue(column.type(), block, position);
            if (!this.options.isExplicitNull() && fieldValue == null) continue;
            jsonObject.put(fieldName, fieldValue);
        }
        sliceOutput.write(JsonWriter.writeJsonObject(jsonObject).getBytes(StandardCharsets.UTF_8));
    }

    private Object writeValue(Type type, Block block, int position) throws InvalidJsonException {
        if (block.isNull(position)) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return BooleanType.BOOLEAN.getBoolean(block, position);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return BigintType.BIGINT.getLong(block, position);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return IntegerType.INTEGER.getInt(block, position);
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return SmallintType.SMALLINT.getShort(block, position);
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return TinyintType.TINYINT.getByte(block, position);
        }
        if (type instanceof DecimalType) {
            SqlDecimal value = (SqlDecimal)type.getObjectValue(null, block, position);
            return value.toBigDecimal().toString();
        }
        if (RealType.REAL.equals((Object)type)) {
            return Float.valueOf(RealType.REAL.getFloat(block, position));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return DoubleType.DOUBLE.getDouble(block, position);
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveFormatUtils.formatHiveDate(block, position);
        }
        if (type instanceof TimestampType) {
            SqlTimestamp objectValue = (SqlTimestamp)type.getObjectValue(null, block, position);
            LocalDateTime localDateTime = objectValue.toLocalDateTime();
            return UTC_PRINT_FORMATTER.format(localDateTime);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return Base64.getEncoder().encodeToString(VarbinaryType.VARBINARY.getSlice(block, position).getBytes());
        }
        if (type instanceof VarcharType) {
            return type.getSlice(block, position).toStringUtf8();
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return Chars.padSpaces((Slice)charType.getSlice(block, position), (CharType)charType).toStringUtf8();
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            Block arrayBlock = arrayType.getObject(block, position);
            ArrayList<Object> jsonArray = new ArrayList<Object>();
            for (int arrayIndex = 0; arrayIndex < arrayBlock.getPositionCount(); ++arrayIndex) {
                Object elementValue = this.writeValue(elementType, arrayBlock, arrayIndex);
                jsonArray.add(elementValue);
            }
            return jsonArray;
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Type keyType = mapType.getKeyType();
            if (OpenXJsonSerializer.isStructuralType(keyType)) {
                throw new RuntimeException("Unsupported map key type: " + String.valueOf(keyType));
            }
            Type valueType = mapType.getValueType();
            SqlMap sqlMap = mapType.getObject(block, position);
            int rawOffset = sqlMap.getRawOffset();
            Block rawKeyBlock = sqlMap.getRawKeyBlock();
            Block rawValueBlock = sqlMap.getRawValueBlock();
            LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
            for (int mapIndex = 0; mapIndex < sqlMap.getSize(); ++mapIndex) {
                try {
                    String fieldName;
                    Object key = this.writeValue(keyType, rawKeyBlock, rawOffset + mapIndex);
                    if (key == null) {
                        throw new RuntimeException("OpenX JsonSerDe can not write a null map key");
                    }
                    if (key instanceof Map) {
                        Map jsonObject = (Map)key;
                        fieldName = JsonWriter.writeJsonObject(jsonObject);
                    } else if (key instanceof List) {
                        List list = (List)key;
                        fieldName = JsonWriter.writeJsonArray(list);
                    } else {
                        fieldName = key.toString();
                    }
                    Object value = this.writeValue(valueType, rawValueBlock, rawOffset + mapIndex);
                    jsonMap.put(fieldName, value);
                    continue;
                }
                catch (InvalidJsonException key) {
                    // empty catch block
                }
            }
            return jsonMap;
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            List fields = rowType.getFields();
            SqlRow sqlRow = rowType.getObject(block, position);
            int rawIndex = sqlRow.getRawIndex();
            LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
            for (int fieldIndex = 0; fieldIndex < fields.size(); ++fieldIndex) {
                RowType.Field field = (RowType.Field)fields.get(fieldIndex);
                Block fieldBlock = sqlRow.getRawFieldBlock(fieldIndex);
                String fieldName = (String)field.getName().orElseThrow();
                Object fieldValue = this.writeValue(field.getType(), fieldBlock, rawIndex);
                if (!this.options.isExplicitNull() && fieldValue == null) continue;
                jsonObject.put(fieldName, fieldValue);
            }
            return jsonObject;
        }
        throw new UnsupportedOperationException("Unsupported column type: " + String.valueOf(type));
    }

    public static boolean isSupportedType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return OpenXJsonSerializer.isSupportedType(arrayType.getElementType());
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return !OpenXJsonSerializer.isStructuralType(mapType.getKeyType()) && OpenXJsonSerializer.isSupportedType(mapType.getKeyType()) && OpenXJsonSerializer.isSupportedType(mapType.getValueType());
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return rowType.getFields().stream().map(RowType.Field::getType).allMatch(OpenXJsonSerializer::isSupportedType);
        }
        return BooleanType.BOOLEAN.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type) || type instanceof DecimalType || RealType.REAL.equals((Object)type) || DoubleType.DOUBLE.equals((Object)type) || DateType.DATE.equals((Object)type) || type instanceof TimestampType || VarbinaryType.VARBINARY.equals((Object)type) || type instanceof VarcharType || type instanceof CharType;
    }

    private static boolean isStructuralType(Type type) {
        return type instanceof MapType || type instanceof ArrayType || type instanceof RowType;
    }
}

