/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Response;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsProcessRequest;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

enum SqsProcessRequestAttributesGetter implements MessagingAttributesGetter<SqsProcessRequest, Response<?>>
{
    INSTANCE;


    public String getSystem(SqsProcessRequest request) {
        return "AmazonSQS";
    }

    public String getDestination(SqsProcessRequest request) {
        AmazonWebServiceRequest originalRequest = request.getRequest().getOriginalRequest();
        String queueUrl = RequestAccess.getQueueUrl(originalRequest);
        int i = queueUrl.lastIndexOf(47);
        return i > 0 ? queueUrl.substring(i + 1) : null;
    }

    public boolean isTemporaryDestination(SqsProcessRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadSize(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadCompressedSize(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(SqsProcessRequest request, @Nullable Response<?> response) {
        return request.getMessage().getMessageId();
    }

    public List<String> getMessageHeader(SqsProcessRequest request, String name) {
        String value = request.getMessage().getMessageAttribute(name);
        return value != null ? Collections.singletonList(value) : Collections.emptyList();
    }
}

