/*
 * Decompiled with CFR 0.152.
 */
package com.github.oxo42.stateless4j;

import com.github.oxo42.stateless4j.StateRepresentation;
import com.github.oxo42.stateless4j.delegates.Action;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Action2;
import com.github.oxo42.stateless4j.delegates.Action3;
import com.github.oxo42.stateless4j.delegates.Action4;
import com.github.oxo42.stateless4j.delegates.Func;
import com.github.oxo42.stateless4j.delegates.Func2;
import com.github.oxo42.stateless4j.delegates.Func3;
import com.github.oxo42.stateless4j.delegates.Func4;
import com.github.oxo42.stateless4j.delegates.FuncBoolean;
import com.github.oxo42.stateless4j.transitions.Transition;
import com.github.oxo42.stateless4j.transitions.TransitioningTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.DynamicTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.InternalTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters1;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters2;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters3;

public class StateConfiguration<S, T> {
    private static final String GUARD_IS_NULL = "guard is null";
    private static final String ENTRY_ACTION_IS_NULL = "entryAction is null";
    private static final String EXIT_ACTION_IS_NULL = "exitAction is null";
    private static final String ACTION_IS_NULL = "action is null";
    private static final String TRIGGER_IS_NULL = "trigger is null";
    private static final String DESTINATION_STATE_SELECTOR_IS_NULL = "destinationStateSelector is null";
    private static final FuncBoolean NO_GUARD = new FuncBoolean(){

        @Override
        public boolean call() {
            return true;
        }
    };
    private static final Action NO_ACTION = new Action(){

        @Override
        public void doIt() {
        }
    };
    private static final Action1<Object[]> NO_ACTION_N = new Action1<Object[]>(){

        @Override
        public void doIt(Object[] args) {
        }
    };
    private final StateRepresentation<S, T> representation;
    private final Func2<S, StateRepresentation<S, T>> lookup;

    public StateConfiguration(StateRepresentation<S, T> representation, Func2<S, StateRepresentation<S, T>> lookup) {
        assert (representation != null) : "representation is null";
        assert (lookup != null) : "lookup is null";
        this.representation = representation;
        this.lookup = lookup;
    }

    public StateConfiguration<S, T> permit(T trigger, S destinationState) {
        this.enforceNotIdentityTransition(destinationState);
        return this.publicPermit(trigger, destinationState);
    }

    public StateConfiguration<S, T> permit(T trigger, S destinationState, Action action) {
        this.enforceNotIdentityTransition(destinationState);
        return this.publicPermit(trigger, destinationState, action);
    }

    public StateConfiguration<S, T> permitIf(T trigger, S destinationState, FuncBoolean guard) {
        this.enforceNotIdentityTransition(destinationState);
        return this.publicPermitIf(trigger, destinationState, guard);
    }

    public StateConfiguration<S, T> permitIf(T trigger, S destinationState, FuncBoolean guard, Action action) {
        this.enforceNotIdentityTransition(destinationState);
        return this.publicPermitIf(trigger, destinationState, guard, action);
    }

    public StateConfiguration<S, T> permitIfElseIgnore(T trigger, S destinationState, final FuncBoolean guard) {
        this.enforceNotIdentityTransition(destinationState);
        this.ignoreIf(trigger, new FuncBoolean(){

            @Override
            public boolean call() {
                return !guard.call();
            }
        });
        return this.publicPermitIf(trigger, destinationState, guard);
    }

    public StateConfiguration<S, T> permitIfElseIgnore(T trigger, S destinationState, final FuncBoolean guard, Action action) {
        this.enforceNotIdentityTransition(destinationState);
        this.ignoreIf(trigger, new FuncBoolean(){

            @Override
            public boolean call() {
                return !guard.call();
            }
        });
        return this.publicPermitIf(trigger, destinationState, guard, action);
    }

    public StateConfiguration<S, T> permitInternal(T trigger, Action action) {
        return this.permitInternalIf(trigger, NO_GUARD, action);
    }

    public StateConfiguration<S, T> permitInternalIf(T trigger, FuncBoolean guard, Action action) {
        assert (guard != null) : "guard is null";
        assert (action != null) : "action is null";
        this.representation.addTriggerBehaviour(new InternalTriggerBehaviour(trigger, guard, action));
        return this;
    }

    public StateConfiguration<S, T> permitReentry(T trigger) {
        return this.publicPermit(trigger, this.representation.getUnderlyingState());
    }

    public StateConfiguration<S, T> permitReentry(T trigger, Action action) {
        return this.publicPermit(trigger, this.representation.getUnderlyingState(), action);
    }

    public StateConfiguration<S, T> permitReentryIf(T trigger, FuncBoolean guard) {
        return this.publicPermitIf(trigger, this.representation.getUnderlyingState(), guard);
    }

    public StateConfiguration<S, T> permitReentryIf(T trigger, FuncBoolean guard, Action action) {
        return this.publicPermitIf(trigger, this.representation.getUnderlyingState(), guard, action);
    }

    public StateConfiguration<S, T> ignore(T trigger) {
        return this.ignoreIf(trigger, NO_GUARD);
    }

    public StateConfiguration<S, T> ignoreIf(T trigger, FuncBoolean guard) {
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new InternalTriggerBehaviour(trigger, guard, NO_ACTION));
        return this;
    }

    public StateConfiguration<S, T> onEntry(final Action entryAction) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntry(new Action1<Transition<S, T>>(){

            @Override
            public void doIt(Transition<S, T> t) {
                entryAction.doIt();
            }
        });
    }

    public StateConfiguration<S, T> onEntry(final Action1<Transition<S, T>> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> arg1, Object[] arg2) {
                entryAction.doIt(arg1);
            }
        });
        return this;
    }

    public StateConfiguration<S, T> onEntry(final Action2<Transition<S, T>, Object[]> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> arg1, Object[] arg2) {
                entryAction.doIt(arg1, arg2);
            }
        });
        return this;
    }

    public StateConfiguration<S, T> onEntryFrom(T trigger, final Action entryAction) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action1<Transition<S, T>>(){

            @Override
            public void doIt(Transition<S, T> arg1) {
                entryAction.doIt();
            }
        });
    }

    public StateConfiguration<S, T> onEntryFrom(T trigger, final Action1<Transition<S, T>> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger, new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> arg1, Object[] arg2) {
                entryAction.doIt(arg1);
            }
        });
        return this;
    }

    public <TArg0> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters1<TArg0, T> trigger, final Action1<TArg0> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action2<TArg0, Transition<S, T>>(){

            @Override
            public void doIt(TArg0 arg1, Transition<S, T> arg2) {
                entryAction.doIt(arg1);
            }
        });
    }

    @Deprecated
    public <TArg0> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters1<TArg0, T> trigger, Action1<TArg0> entryAction, Class<TArg0> classe0) {
        return this.onEntryFrom(trigger, entryAction);
    }

    public <TArg0> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters1<TArg0, T> trigger, final Action2<TArg0, Transition<S, T>> entryAction) {
        assert (trigger != null) : "trigger is null";
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger.getTrigger(), new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> t, Object[] arg2) {
                entryAction.doIt(arg2[0], t);
            }
        });
        return this;
    }

    @Deprecated
    public <TArg0> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters1<TArg0, T> trigger, Action2<TArg0, Transition<S, T>> entryAction, Class<TArg0> classe0) {
        return this.onEntryFrom(trigger, entryAction);
    }

    public <TArg0, TArg1> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters2<TArg0, TArg1, T> trigger, final Action2<TArg0, TArg1> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action3<TArg0, TArg1, Transition<S, T>>(){

            @Override
            public void doIt(TArg0 a0, TArg1 a1, Transition<S, T> t) {
                entryAction.doIt(a0, a1);
            }
        });
    }

    @Deprecated
    public <TArg0, TArg1> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters2<TArg0, TArg1, T> trigger, Action2<TArg0, TArg1> entryAction, Class<TArg0> classe0, Class<TArg1> classe1) {
        return this.onEntryFrom(trigger, entryAction);
    }

    public <TArg0, TArg1> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters2<TArg0, TArg1, T> trigger, final Action3<TArg0, TArg1, Transition<S, T>> entryAction) {
        assert (trigger != null) : "trigger is null";
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger.getTrigger(), new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> t, Object[] args) {
                entryAction.doIt(args[0], args[1], t);
            }
        });
        return this;
    }

    @Deprecated
    public <TArg0, TArg1> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters2<TArg0, TArg1, T> trigger, Action3<TArg0, TArg1, Transition<S, T>> entryAction, Class<TArg0> classe0, Class<TArg1> classe1) {
        return this.onEntryFrom(trigger, entryAction);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters3<TArg0, TArg1, TArg2, T> trigger, final Action3<TArg0, TArg1, TArg2> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action4<TArg0, TArg1, TArg2, Transition<S, T>>(){

            @Override
            public void doIt(TArg0 a0, TArg1 a1, TArg2 a2, Transition<S, T> t) {
                entryAction.doIt(a0, a1, a2);
            }
        });
    }

    @Deprecated
    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters3<TArg0, TArg1, TArg2, T> trigger, Action3<TArg0, TArg1, TArg2> entryAction, Class<TArg0> classe0, Class<TArg1> classe1, Class<TArg2> classe2) {
        return this.onEntryFrom(trigger, entryAction);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters3<TArg0, TArg1, TArg2, T> trigger, final Action4<TArg0, TArg1, TArg2, Transition<S, T>> entryAction) {
        assert (trigger != null) : "trigger is null";
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger.getTrigger(), new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> t, Object[] args) {
                entryAction.doIt(args[0], args[1], args[2], t);
            }
        });
        return this;
    }

    @Deprecated
    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters3<TArg0, TArg1, TArg2, T> trigger, Action4<TArg0, TArg1, TArg2, Transition<S, T>> entryAction, Class<TArg0> classe0, Class<TArg1> classe1, Class<TArg2> classe2) {
        return this.onEntryFrom(trigger, entryAction);
    }

    public StateConfiguration<S, T> onExit(final Action exitAction) {
        assert (exitAction != null) : "exitAction is null";
        return this.onExit(new Action1<Transition<S, T>>(){

            @Override
            public void doIt(Transition<S, T> arg1) {
                exitAction.doIt();
            }
        });
    }

    public StateConfiguration<S, T> onExit(Action1<Transition<S, T>> exitAction) {
        assert (exitAction != null) : "exitAction is null";
        this.representation.addExitAction(exitAction);
        return this;
    }

    public StateConfiguration<S, T> substateOf(S superstate) {
        StateRepresentation<S, T> superRepresentation = this.lookup.call(superstate);
        this.representation.setSuperstate(superRepresentation);
        superRepresentation.addSubstate(this.representation);
        return this;
    }

    public StateConfiguration<S, T> permitDynamic(T trigger, Func<S> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public StateConfiguration<S, T> permitDynamic(T trigger, Func<S> destinationStateSelector, Action action) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD, action);
    }

    public <TArg0> StateConfiguration<S, T> permitDynamic(TriggerWithParameters1<TArg0, T> trigger, Func2<TArg0, S> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public <TArg0> StateConfiguration<S, T> permitDynamic(TriggerWithParameters1<TArg0, T> trigger, Func2<TArg0, S> destinationStateSelector, Action1<TArg0> action) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD, action);
    }

    public <TArg0, TArg1> StateConfiguration<S, T> permitDynamic(TriggerWithParameters2<TArg0, TArg1, T> trigger, Func3<TArg0, TArg1, S> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public <TArg0, TArg1> StateConfiguration<S, T> permitDynamic(TriggerWithParameters2<TArg0, TArg1, T> trigger, Func3<TArg0, TArg1, S> destinationStateSelector, Action2<TArg0, TArg1> action) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD, action);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> permitDynamic(TriggerWithParameters3<TArg0, TArg1, TArg2, T> trigger, Func4<TArg0, TArg1, TArg2, S> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> permitDynamic(TriggerWithParameters3<TArg0, TArg1, TArg2, T> trigger, Func4<TArg0, TArg1, TArg2, S> destinationStateSelector, Action3<TArg0, TArg1, TArg2> action) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD, action);
    }

    public StateConfiguration<S, T> permitDynamicIf(T trigger, final Func<S> destinationStateSelector, FuncBoolean guard) {
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger, new Func2<Object[], S>(){

            @Override
            public S call(Object[] arg0) {
                return destinationStateSelector.call();
            }
        }, guard, NO_ACTION_N);
    }

    public StateConfiguration<S, T> permitDynamicIf(T trigger, final Func<S> destinationStateSelector, FuncBoolean guard, final Action action) {
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger, new Func2<Object[], S>(){

            @Override
            public S call(Object[] arg0) {
                return destinationStateSelector.call();
            }
        }, guard, new Action1<Object[]>(){

            @Override
            public void doIt(Object[] args) {
                action.doIt();
            }
        });
    }

    public <TArg0> StateConfiguration<S, T> permitDynamicIf(TriggerWithParameters1<TArg0, T> trigger, final Func2<TArg0, S> destinationStateSelector, FuncBoolean guard) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], S>(){

            @Override
            public S call(Object[] args) {
                return destinationStateSelector.call(args[0]);
            }
        }, guard, NO_ACTION_N);
    }

    public <TArg0> StateConfiguration<S, T> permitDynamicIf(TriggerWithParameters1<TArg0, T> trigger, final Func2<TArg0, S> destinationStateSelector, FuncBoolean guard, final Action1<TArg0> action) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], S>(){

            @Override
            public S call(Object[] args) {
                return destinationStateSelector.call(args[0]);
            }
        }, guard, new Action1<Object[]>(){

            @Override
            public void doIt(Object[] args) {
                action.doIt(args[0]);
            }
        });
    }

    public <TArg0, TArg1> StateConfiguration<S, T> permitDynamicIf(TriggerWithParameters2<TArg0, TArg1, T> trigger, final Func3<TArg0, TArg1, S> destinationStateSelector, FuncBoolean guard) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], S>(){

            @Override
            public S call(Object[] args) {
                return destinationStateSelector.call(args[0], args[1]);
            }
        }, guard, NO_ACTION_N);
    }

    public <TArg0, TArg1> StateConfiguration<S, T> permitDynamicIf(TriggerWithParameters2<TArg0, TArg1, T> trigger, final Func3<TArg0, TArg1, S> destinationStateSelector, FuncBoolean guard, final Action2<TArg0, TArg1> action) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], S>(){

            @Override
            public S call(Object[] args) {
                return destinationStateSelector.call(args[0], args[1]);
            }
        }, guard, new Action1<Object[]>(){

            @Override
            public void doIt(Object[] args) {
                action.doIt(args[0], args[1]);
            }
        });
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> permitDynamicIf(TriggerWithParameters3<TArg0, TArg1, TArg2, T> trigger, final Func4<TArg0, TArg1, TArg2, S> destinationStateSelector, FuncBoolean guard) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], S>(){

            @Override
            public S call(Object[] args) {
                return destinationStateSelector.call(args[0], args[1], args[2]);
            }
        }, guard, NO_ACTION_N);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> permitDynamicIf(TriggerWithParameters3<TArg0, TArg1, TArg2, T> trigger, final Func4<TArg0, TArg1, TArg2, S> destinationStateSelector, FuncBoolean guard, final Action3<TArg0, TArg1, TArg2> action) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], S>(){

            @Override
            public S call(Object[] args) {
                return destinationStateSelector.call(args[0], args[1], args[2]);
            }
        }, guard, new Action1<Object[]>(){

            @Override
            public void doIt(Object[] args) {
                action.doIt(args[0], args[1], args[2]);
            }
        });
    }

    void enforceNotIdentityTransition(S destination) {
        if (destination.equals(this.representation.getUnderlyingState())) {
            throw new IllegalStateException("Permit() (and PermitIf()) require that the destination state is not equal to the source state. To accept a trigger without changing state, use either ignore(), permitInternal() or permitReentry().");
        }
    }

    StateConfiguration<S, T> publicPermit(T trigger, S destinationState) {
        return this.publicPermitIf(trigger, destinationState, NO_GUARD, NO_ACTION);
    }

    StateConfiguration<S, T> publicPermit(T trigger, S destinationState, Action action) {
        return this.publicPermitIf(trigger, destinationState, NO_GUARD, action);
    }

    StateConfiguration<S, T> publicPermitIf(T trigger, S destinationState, FuncBoolean guard) {
        return this.publicPermitIf(trigger, destinationState, guard, NO_ACTION);
    }

    StateConfiguration<S, T> publicPermitIf(T trigger, S destinationState, FuncBoolean guard, Action action) {
        assert (action != null) : "action is null";
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new TransitioningTriggerBehaviour<S, T>(trigger, destinationState, guard, action));
        return this;
    }

    StateConfiguration<S, T> publicPermitDynamic(T trigger, Func2<Object[], S> destinationStateSelector) {
        return this.publicPermitDynamicIf(trigger, destinationStateSelector, NO_GUARD, NO_ACTION_N);
    }

    StateConfiguration<S, T> publicPermitDynamicIf(T trigger, Func2<Object[], S> destinationStateSelector, FuncBoolean guard) {
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new DynamicTriggerBehaviour<S, T>(trigger, destinationStateSelector, guard, NO_ACTION_N));
        return this;
    }

    StateConfiguration<S, T> publicPermitDynamicIf(T trigger, Func2<Object[], S> destinationStateSelector, FuncBoolean guard, Action1<Object[]> action) {
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new DynamicTriggerBehaviour<S, T>(trigger, destinationStateSelector, guard, action));
        return this;
    }
}

