/*
 * Decompiled with CFR 0.152.
 */
package com.github.oxo42.stateless4j;

import com.github.oxo42.stateless4j.StateConfiguration;
import com.github.oxo42.stateless4j.StateMachineConfig;
import com.github.oxo42.stateless4j.StateReference;
import com.github.oxo42.stateless4j.StateRepresentation;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Action2;
import com.github.oxo42.stateless4j.delegates.Action3;
import com.github.oxo42.stateless4j.delegates.Func;
import com.github.oxo42.stateless4j.delegates.Trace;
import com.github.oxo42.stateless4j.transitions.Transition;
import com.github.oxo42.stateless4j.triggers.TriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters1;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters2;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters3;
import java.util.ArrayList;
import java.util.List;

public class StateMachine<S, T> {
    private static final String TRIGGER_IS_NULL = "trigger is null";
    protected final StateMachineConfig<S, T> config;
    protected final Func<S> stateAccessor;
    protected final Action1<S> stateMutator;
    private Trace<S, T> trace = null;
    private boolean isStarted = false;
    private S initialState;
    protected Action3<S, T, Object[]> unhandledTriggerAction = new Action3<S, T, Object[]>(){

        @Override
        public void doIt(S state, T trigger, Object[] args) {
            throw new IllegalStateException(String.format("No valid leaving transitions are permitted from state '%s' for trigger '%s'. Consider ignoring the trigger.", state, trigger));
        }
    };

    public StateMachine(S initialState) {
        this(initialState, new StateMachineConfig());
    }

    public StateMachine(S initialState, StateMachineConfig<S, T> config) {
        this.initialState = initialState;
        this.config = config;
        final StateReference reference = new StateReference();
        reference.setState(initialState);
        this.stateAccessor = new Func<S>(){

            @Override
            public S call() {
                return reference.getState();
            }
        };
        this.stateMutator = new Action1<S>(){

            @Override
            public void doIt(S s) {
                reference.setState(s);
            }
        };
    }

    public StateMachine(S initialState, Func<S> stateAccessor, Action1<S> stateMutator, StateMachineConfig<S, T> config) {
        this.config = config;
        this.stateAccessor = stateAccessor;
        this.stateMutator = stateMutator;
        stateMutator.doIt(initialState);
    }

    public void fireInitialTransition() {
        S currentState = this.getCurrentRepresentation().getUnderlyingState();
        if (this.isStarted || !currentState.equals(this.initialState)) {
            throw new IllegalStateException("Firing initial transition after state machine has been started");
        }
        this.isStarted = true;
        Transition<Object, Object> initialTransition = new Transition<Object, Object>(null, currentState, null);
        this.getCurrentRepresentation().enter(initialTransition, new Object[0]);
    }

    public StateConfiguration<S, T> configure(S state) {
        return this.config.configure(state);
    }

    public StateMachineConfig<S, T> configuration() {
        return this.config;
    }

    public S getState() {
        return this.stateAccessor.call();
    }

    private void setState(S value) {
        this.stateMutator.doIt(value);
    }

    public List<T> getPermittedTriggers() {
        return this.getCurrentRepresentation().getPermittedTriggers();
    }

    StateRepresentation<S, T> getCurrentRepresentation() {
        StateRepresentation representation = this.config.getRepresentation(this.getState());
        return representation == null ? new StateRepresentation(this.getState()) : representation;
    }

    public void fire(T trigger) {
        this.publicFire(trigger, new Object[0]);
    }

    public <TArg0> void fire(TriggerWithParameters1<TArg0, T> trigger, TArg0 arg0) {
        assert (trigger != null) : "trigger is null";
        this.publicFire(trigger.getTrigger(), arg0);
    }

    public <TArg0, TArg1> void fire(TriggerWithParameters2<TArg0, TArg1, T> trigger, TArg0 arg0, TArg1 arg1) {
        assert (trigger != null) : "trigger is null";
        this.publicFire(trigger.getTrigger(), arg0, arg1);
    }

    public <TArg0, TArg1, TArg2> void fire(TriggerWithParameters3<TArg0, TArg1, TArg2, T> trigger, TArg0 arg0, TArg1 arg1, TArg2 arg2) {
        assert (trigger != null) : "trigger is null";
        this.publicFire(trigger.getTrigger(), arg0, arg1, arg2);
    }

    protected void publicFire(T trigger, Object ... args) {
        TriggerBehaviour<S, T> triggerBehaviour;
        TriggerWithParameters<T> configuration;
        this.isStarted = true;
        if (this.trace != null) {
            this.trace.trigger(trigger);
        }
        if ((configuration = this.config.getTriggerConfiguration(trigger)) != null) {
            configuration.validateParameters(args);
        }
        if ((triggerBehaviour = this.getCurrentRepresentation().tryFindHandler(trigger)) == null) {
            this.unhandledTriggerAction.doIt(this.getCurrentRepresentation().getUnderlyingState(), trigger, args);
            return;
        }
        if (triggerBehaviour.isInternal()) {
            triggerBehaviour.performAction(args);
        } else {
            S source = this.getState();
            S destination = triggerBehaviour.transitionsTo(source, args);
            Transition<S, T> transition = new Transition<S, T>(source, destination, trigger);
            this.getCurrentRepresentation().exit(transition);
            triggerBehaviour.performAction(args);
            this.setState(destination);
            this.getCurrentRepresentation().enter(transition, args);
            if (this.trace != null) {
                this.trace.transition(trigger, source, destination);
            }
        }
    }

    public void onUnhandledTrigger(final Action2<S, T> unhandledTriggerAction) {
        if (unhandledTriggerAction == null) {
            throw new IllegalStateException("unhandledTriggerAction");
        }
        this.unhandledTriggerAction = new Action3<S, T, Object[]>(){

            @Override
            public void doIt(S state, T trigger, Object[] arg3) {
                unhandledTriggerAction.doIt(state, trigger);
            }
        };
    }

    public void onUnhandledTrigger(Action3<S, T, Object[]> unhandledTriggerAction) {
        if (unhandledTriggerAction == null) {
            throw new IllegalStateException("unhandledTriggerAction");
        }
        this.unhandledTriggerAction = unhandledTriggerAction;
    }

    public boolean isInState(S state) {
        return this.getCurrentRepresentation().isIncludedIn(state);
    }

    public boolean canFire(T trigger) {
        return this.getCurrentRepresentation().canHandle(trigger);
    }

    public void setTrace(Trace<S, T> trace) {
        this.trace = trace;
    }

    public String toString() {
        List<T> permittedTriggers = this.getPermittedTriggers();
        ArrayList<String> parameters = new ArrayList<String>();
        for (T tTrigger : permittedTriggers) {
            parameters.add(tTrigger.toString());
        }
        StringBuilder params = new StringBuilder();
        String delim = "";
        for (String param : parameters) {
            params.append(delim);
            params.append(param);
            delim = ", ";
        }
        return String.format("StateMachine {{ State = %s, PermittedTriggers = {{ %s }}}}", this.getState(), params.toString());
    }
}

