/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.query;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.filesystem.FileEntry;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hudi.HudiFileStatus;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.files.HudiBaseFile;
import io.trino.plugin.hudi.partition.HiveHudiPartitionInfo;
import io.trino.plugin.hudi.partition.HudiPartitionInfo;
import io.trino.plugin.hudi.query.HudiDirectoryLister;
import io.trino.plugin.hudi.table.HudiTableFileSystemView;
import io.trino.plugin.hudi.table.HudiTableMetaClient;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HudiReadOptimizedDirectoryLister
implements HudiDirectoryLister {
    private static final long MIN_BLOCK_SIZE = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
    private final HudiTableFileSystemView fileSystemView;
    private final List<Column> partitionColumns;
    private final Map<String, HudiPartitionInfo> allPartitionInfoMap;

    public HudiReadOptimizedDirectoryLister(HudiTableHandle tableHandle, HudiTableMetaClient metaClient, HiveMetastore hiveMetastore, Table hiveTable, List<HiveColumnHandle> partitionColumnHandles, List<String> hivePartitionNames) {
        this.fileSystemView = new HudiTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants());
        this.partitionColumns = hiveTable.getPartitionColumns();
        this.allPartitionInfoMap = hivePartitionNames.stream().collect(Collectors.toMap(Function.identity(), hivePartitionName -> new HiveHudiPartitionInfo((String)hivePartitionName, this.partitionColumns, partitionColumnHandles, tableHandle.getPartitionPredicates(), hiveTable, hiveMetastore)));
    }

    @Override
    public List<HudiFileStatus> listStatus(HudiPartitionInfo partitionInfo) {
        return (List)this.fileSystemView.getLatestBaseFiles(partitionInfo.getRelativePartitionPath()).map(HudiBaseFile::getFileEntry).map(fileEntry -> new HudiFileStatus(fileEntry.location(), false, fileEntry.length(), fileEntry.lastModified().toEpochMilli(), Math.max(HudiReadOptimizedDirectoryLister.blockSize(fileEntry.blocks()), Math.min(fileEntry.length(), MIN_BLOCK_SIZE)))).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<HudiPartitionInfo> getPartitionInfo(String partition) {
        return Optional.ofNullable(this.allPartitionInfoMap.get(partition));
    }

    @Override
    public void close() {
        if (this.fileSystemView != null && !this.fileSystemView.isClosed()) {
            this.fileSystemView.close();
        }
    }

    private static long blockSize(Optional<List<FileEntry.Block>> blocks) {
        return blocks.stream().flatMap(Collection::stream).mapToLong(FileEntry.Block::length).findFirst().orElse(0L);
    }
}

