/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.model.HudiFileFormat;
import io.trino.plugin.hudi.table.HudiTableMetaClient;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class HudiUtil {
    private HudiUtil() {
    }

    public static HudiFileFormat getHudiFileFormat(String path) {
        String extension = HudiUtil.getFileExtension(path);
        if (extension.equals(HudiFileFormat.PARQUET.getFileExtension())) {
            return HudiFileFormat.PARQUET;
        }
        if (extension.equals(HudiFileFormat.HOODIE_LOG.getFileExtension())) {
            return HudiFileFormat.HOODIE_LOG;
        }
        if (extension.equals(HudiFileFormat.ORC.getFileExtension())) {
            return HudiFileFormat.ORC;
        }
        if (extension.equals(HudiFileFormat.HFILE.getFileExtension())) {
            return HudiFileFormat.HFILE;
        }
        throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_UNSUPPORTED_FILE_FORMAT, "Hoodie InputFormat not implemented for base file of type " + extension);
    }

    private static String getFileExtension(String fullName) {
        String fileName = Location.of((String)fullName).fileName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex);
    }

    public static boolean hudiMetadataExists(TrinoFileSystem trinoFileSystem, Location baseLocation) {
        try {
            Location metaLocation = baseLocation.appendPath(".hoodie");
            FileIterator iterator = trinoFileSystem.listFiles(metaLocation);
            return iterator.hasNext();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_FILESYSTEM_ERROR, "Failed to check for Hudi table at location: " + String.valueOf(baseLocation), (Throwable)e);
        }
    }

    public static boolean partitionMatchesPredicates(SchemaTableName tableName, String hivePartitionName, List<HiveColumnHandle> partitionColumnHandles, TupleDomain<HiveColumnHandle> constraintSummary) {
        HivePartition partition = HivePartitionManager.parsePartition((SchemaTableName)tableName, (String)hivePartitionName, partitionColumnHandles);
        return HudiUtil.partitionMatches(partitionColumnHandles, constraintSummary, partition);
    }

    public static boolean partitionMatches(List<HiveColumnHandle> partitionColumns, TupleDomain<HiveColumnHandle> constraintSummary, HivePartition partition) {
        if (constraintSummary.isNone()) {
            return false;
        }
        Map domains = constraintSummary.getDomains().orElseGet(ImmutableMap::of);
        for (HiveColumnHandle column : partitionColumns) {
            NullableValue value = (NullableValue)partition.getKeys().get(column);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return false;
        }
        return true;
    }

    public static List<HivePartitionKey> buildPartitionKeys(List<Column> keys, List<String> values) {
        HiveUtil.checkCondition((keys.size() == values.size() ? 1 : 0) != 0, (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, (String)"Expected %s partition key values, but got %s. Keys: %s, Values: %s.", (Object[])new Object[]{keys.size(), values.size(), keys, values});
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        for (int i = 0; i < keys.size(); ++i) {
            String name = keys.get(i).getName();
            String value = values.get(i);
            partitionKeys.add((Object)new HivePartitionKey(name, value));
        }
        return partitionKeys.build();
    }

    public static HudiTableMetaClient buildTableMetaClient(TrinoFileSystem fileSystem, String basePath) {
        return HudiTableMetaClient.builder().setTrinoFileSystem(fileSystem).setBasePath(Location.of((String)basePath)).build();
    }
}

