/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.files;

import io.trino.filesystem.FileEntry;
import io.trino.filesystem.Location;
import io.trino.plugin.hudi.files.FSUtils;
import java.util.Objects;

public class HudiBaseFile {
    private final transient FileEntry fileEntry;
    private final String fullPath;
    private final String fileName;
    private final long fileLen;

    public HudiBaseFile(FileEntry fileEntry) {
        this(fileEntry, fileEntry.location().path(), fileEntry.location().fileName(), fileEntry.length());
    }

    private HudiBaseFile(FileEntry fileEntry, String fullPath, String fileName, long fileLen) {
        this.fileEntry = Objects.requireNonNull(fileEntry, "fileEntry is null");
        this.fullPath = Objects.requireNonNull(fullPath, "fullPath is null");
        this.fileLen = fileLen;
        this.fileName = Objects.requireNonNull(fileName, "fileName is null");
    }

    public String getPath() {
        return this.fullPath;
    }

    public Location getFullPath() {
        if (this.fileEntry != null) {
            return this.fileEntry.location();
        }
        return Location.of((String)this.fullPath);
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    public String getFileId() {
        return this.getFileName().split("_")[0];
    }

    public String getCommitTime() {
        String fileName = this.getFileName();
        if (FSUtils.isLogFile(fileName)) {
            return fileName.split("_")[1].split("\\.")[0];
        }
        return fileName.split("_")[2].split("\\.")[0];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiBaseFile dataFile = (HudiBaseFile)o;
        return Objects.equals(this.fullPath, dataFile.fullPath);
    }

    public int hashCode() {
        return Objects.hash(this.fullPath);
    }

    public String toString() {
        return "BaseFile{fullPath=" + this.fullPath + ", fileLen=" + this.fileLen + "}";
    }
}

