/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.metadata;

import java.util.Arrays;
import java.util.Set;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.hadoop.metadata.Canonicalizer;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ColumnChunkProperties {
    private static final Canonicalizer<ColumnChunkProperties> PROPERTIES = new Canonicalizer();
    private final CompressionCodecName codec;
    private final ColumnPath path;
    private final PrimitiveType type;
    private final Set<Encoding> encodings;

    @Deprecated
    public static ColumnChunkProperties get(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings) {
        return ColumnChunkProperties.get(path, new PrimitiveType(Type.Repetition.OPTIONAL, type, ""), codec, encodings);
    }

    public static ColumnChunkProperties get(ColumnPath path, PrimitiveType type, CompressionCodecName codec, Set<Encoding> encodings) {
        return (ColumnChunkProperties)PROPERTIES.canonicalize((Object)new ColumnChunkProperties(codec, path, type, encodings));
    }

    private ColumnChunkProperties(CompressionCodecName codec, ColumnPath path, PrimitiveType type, Set<Encoding> encodings) {
        this.codec = codec;
        this.path = path;
        this.type = type;
        this.encodings = encodings;
    }

    public CompressionCodecName getCodec() {
        return this.codec;
    }

    public ColumnPath getPath() {
        return this.path;
    }

    @Deprecated
    public PrimitiveType.PrimitiveTypeName getType() {
        return this.type.getPrimitiveTypeName();
    }

    public PrimitiveType getPrimitiveType() {
        return this.type;
    }

    public Set<Encoding> getEncodings() {
        return this.encodings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnChunkProperties)) return false;
        ColumnChunkProperties other = (ColumnChunkProperties)obj;
        if (other.codec != this.codec) return false;
        if (!other.path.equals((Object)this.path)) return false;
        if (!other.type.equals((Object)this.type)) return false;
        if (other.encodings.size() != this.encodings.size()) return false;
        if (!other.encodings.containsAll(this.encodings)) return false;
        return true;
    }

    public int hashCode() {
        return this.codec.hashCode() ^ this.path.hashCode() ^ this.type.hashCode() ^ Arrays.hashCode(this.encodings.toArray());
    }

    public String toString() {
        return String.valueOf(this.codec) + " " + String.valueOf(this.path) + " " + String.valueOf(this.type) + "  " + String.valueOf(this.encodings);
    }
}

