/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.repdef;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.repdef.DefLevelWriterProvider;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.RowBlock;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.column.values.ValuesWriter;

public class DefLevelWriterProviders {
    private DefLevelWriterProviders() {
    }

    public static DefLevelWriterProvider of(Block block, int maxDefinitionLevel) {
        if (block.getUnderlyingValueBlock() instanceof RowBlock) {
            return new RowDefLevelWriterProvider(block, maxDefinitionLevel);
        }
        return new PrimitiveDefLevelWriterProvider(block, maxDefinitionLevel);
    }

    public static DefLevelWriterProvider of(ColumnarArray columnarArray, int maxDefinitionLevel) {
        return new ColumnArrayDefLevelWriterProvider(columnarArray, maxDefinitionLevel);
    }

    public static DefLevelWriterProvider of(ColumnarMap columnarMap, int maxDefinitionLevel) {
        return new ColumnMapDefLevelWriterProvider(columnarMap, maxDefinitionLevel);
    }

    private static void checkValidPosition(int offset, int positionsCount, int totalPositionsCount) {
        if (offset < 0 || positionsCount < 0 || offset + positionsCount > totalPositionsCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid offset %s and positionsCount %s in block with %s positions", offset, positionsCount, totalPositionsCount));
        }
    }

    static class RowDefLevelWriterProvider
    implements DefLevelWriterProvider {
        private final Block block;
        private final int maxDefinitionLevel;

        RowDefLevelWriterProvider(Block block, int maxDefinitionLevel) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
            Preconditions.checkArgument((boolean)(block.getUnderlyingValueBlock() instanceof RowBlock), (Object)"block is not a row block");
        }

        @Override
        public DefLevelWriterProvider.DefinitionLevelWriter getDefinitionLevelWriter(final Optional<DefLevelWriterProvider.DefinitionLevelWriter> nestedWriterOptional, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column row definition level writer");
            return new DefLevelWriterProvider.DefinitionLevelWriter(){
                private final DefLevelWriterProvider.DefinitionLevelWriter nestedWriter;
                private int offset;
                final /* synthetic */ RowDefLevelWriterProvider this$0;
                {
                    this.this$0 = this$0;
                    this.nestedWriter = (DefLevelWriterProvider.DefinitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels() {
                    return this.writeDefinitionLevels(this.this$0.block.getPositionCount());
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels(int positionsCount) {
                    DefLevelWriterProviders.checkValidPosition(this.offset, positionsCount, this.this$0.block.getPositionCount());
                    if (!this.this$0.block.mayHaveNull()) {
                        this.offset += positionsCount;
                        return this.nestedWriter.writeDefinitionLevels(positionsCount);
                    }
                    int maxDefinitionValuesCount = 0;
                    int totalValuesCount = 0;
                    int position = this.offset;
                    while (position < this.offset + positionsCount) {
                        if (this.this$0.block.isNull(position)) {
                            encoder.writeInteger(this.this$0.maxDefinitionLevel - 1);
                            ++totalValuesCount;
                            ++position;
                            continue;
                        }
                        int consecutiveNonNullsCount = 1;
                        ++position;
                        while (position < this.offset + positionsCount && !this.this$0.block.isNull(position)) {
                            ++position;
                            ++consecutiveNonNullsCount;
                        }
                        DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(consecutiveNonNullsCount);
                        maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                        totalValuesCount += valuesCount.totalValuesCount();
                    }
                    this.offset += positionsCount;
                    return new DefLevelWriterProvider.ValuesCount(totalValuesCount, maxDefinitionValuesCount);
                }
            };
        }
    }

    static class PrimitiveDefLevelWriterProvider
    implements DefLevelWriterProvider {
        private final Block block;
        private final int maxDefinitionLevel;

        PrimitiveDefLevelWriterProvider(Block block, int maxDefinitionLevel) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
            Preconditions.checkArgument((!(block.getUnderlyingValueBlock() instanceof RowBlock) ? 1 : 0) != 0, (Object)"block is a row block");
            Preconditions.checkArgument((!(block.getUnderlyingValueBlock() instanceof ArrayBlock) ? 1 : 0) != 0, (Object)"block is an array block");
            Preconditions.checkArgument((!(block.getUnderlyingValueBlock() instanceof MapBlock) ? 1 : 0) != 0, (Object)"block is a map block");
        }

        @Override
        public DefLevelWriterProvider.DefinitionLevelWriter getDefinitionLevelWriter(Optional<DefLevelWriterProvider.DefinitionLevelWriter> nestedWriter, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriter.isEmpty(), (Object)"nestedWriter should be empty for primitive definition level writer");
            return new DefLevelWriterProvider.DefinitionLevelWriter(){
                private int offset;
                final /* synthetic */ PrimitiveDefLevelWriterProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels() {
                    return this.writeDefinitionLevels(this.this$0.block.getPositionCount());
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels(int positionsCount) {
                    DefLevelWriterProviders.checkValidPosition(this.offset, positionsCount, this.this$0.block.getPositionCount());
                    int nonNullsCount = 0;
                    if (!this.this$0.block.mayHaveNull()) {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            encoder.writeInteger(this.this$0.maxDefinitionLevel);
                        }
                        nonNullsCount = positionsCount;
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            int isNull = this.this$0.block.isNull(position) ? 1 : 0;
                            encoder.writeInteger(this.this$0.maxDefinitionLevel - isNull);
                            nonNullsCount += isNull ^ 1;
                        }
                    }
                    this.offset += positionsCount;
                    return new DefLevelWriterProvider.ValuesCount(positionsCount, nonNullsCount);
                }
            };
        }
    }

    static class ColumnArrayDefLevelWriterProvider
    implements DefLevelWriterProvider {
        private final ColumnarArray columnarArray;
        private final int maxDefinitionLevel;

        ColumnArrayDefLevelWriterProvider(ColumnarArray columnarArray, int maxDefinitionLevel) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelWriterProvider.DefinitionLevelWriter getDefinitionLevelWriter(final Optional<DefLevelWriterProvider.DefinitionLevelWriter> nestedWriterOptional, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column map definition level writer");
            return new DefLevelWriterProvider.DefinitionLevelWriter(){
                private final DefLevelWriterProvider.DefinitionLevelWriter nestedWriter;
                private int offset;
                final /* synthetic */ ColumnArrayDefLevelWriterProvider this$0;
                {
                    this.this$0 = this$0;
                    this.nestedWriter = (DefLevelWriterProvider.DefinitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels() {
                    return this.writeDefinitionLevels(this.this$0.columnarArray.getPositionCount());
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels(int positionsCount) {
                    DefLevelWriterProviders.checkValidPosition(this.offset, positionsCount, this.this$0.columnarArray.getPositionCount());
                    int maxDefinitionValuesCount = 0;
                    int totalValuesCount = 0;
                    if (!this.this$0.columnarArray.mayHaveNull()) {
                        int position = this.offset;
                        while (position < this.offset + positionsCount) {
                            int arrayLength = this.this$0.columnarArray.getLength(position);
                            if (arrayLength == 0) {
                                encoder.writeInteger(this.this$0.maxDefinitionLevel - 1);
                                ++totalValuesCount;
                                ++position;
                                continue;
                            }
                            int consecutiveNonEmptyArrayLength = arrayLength;
                            ++position;
                            while (position < this.offset + positionsCount && (arrayLength = this.this$0.columnarArray.getLength(position)) != 0) {
                                ++position;
                                consecutiveNonEmptyArrayLength += arrayLength;
                            }
                            DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(consecutiveNonEmptyArrayLength);
                            maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                            totalValuesCount += valuesCount.totalValuesCount();
                        }
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            if (this.this$0.columnarArray.isNull(position)) {
                                encoder.writeInteger(this.this$0.maxDefinitionLevel - 2);
                                ++totalValuesCount;
                                continue;
                            }
                            int arrayLength = this.this$0.columnarArray.getLength(position);
                            if (arrayLength == 0) {
                                encoder.writeInteger(this.this$0.maxDefinitionLevel - 1);
                                ++totalValuesCount;
                                continue;
                            }
                            DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(arrayLength);
                            maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                            totalValuesCount += valuesCount.totalValuesCount();
                        }
                    }
                    this.offset += positionsCount;
                    return new DefLevelWriterProvider.ValuesCount(totalValuesCount, maxDefinitionValuesCount);
                }
            };
        }
    }

    static class ColumnMapDefLevelWriterProvider
    implements DefLevelWriterProvider {
        private final ColumnarMap columnarMap;
        private final int maxDefinitionLevel;

        ColumnMapDefLevelWriterProvider(ColumnarMap columnarMap, int maxDefinitionLevel) {
            this.columnarMap = Objects.requireNonNull(columnarMap, "columnarMap is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelWriterProvider.DefinitionLevelWriter getDefinitionLevelWriter(final Optional<DefLevelWriterProvider.DefinitionLevelWriter> nestedWriterOptional, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column map definition level writer");
            return new DefLevelWriterProvider.DefinitionLevelWriter(){
                private final DefLevelWriterProvider.DefinitionLevelWriter nestedWriter;
                private int offset;
                final /* synthetic */ ColumnMapDefLevelWriterProvider this$0;
                {
                    this.this$0 = this$0;
                    this.nestedWriter = (DefLevelWriterProvider.DefinitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels() {
                    return this.writeDefinitionLevels(this.this$0.columnarMap.getPositionCount());
                }

                @Override
                public DefLevelWriterProvider.ValuesCount writeDefinitionLevels(int positionsCount) {
                    DefLevelWriterProviders.checkValidPosition(this.offset, positionsCount, this.this$0.columnarMap.getPositionCount());
                    int maxDefinitionValuesCount = 0;
                    int totalValuesCount = 0;
                    if (!this.this$0.columnarMap.mayHaveNull()) {
                        int position = this.offset;
                        while (position < this.offset + positionsCount) {
                            int mapLength = this.this$0.columnarMap.getEntryCount(position);
                            if (mapLength == 0) {
                                encoder.writeInteger(this.this$0.maxDefinitionLevel - 1);
                                ++totalValuesCount;
                                ++position;
                                continue;
                            }
                            int consecutiveNonEmptyArrayLength = mapLength;
                            ++position;
                            while (position < this.offset + positionsCount && (mapLength = this.this$0.columnarMap.getEntryCount(position)) != 0) {
                                ++position;
                                consecutiveNonEmptyArrayLength += mapLength;
                            }
                            DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(consecutiveNonEmptyArrayLength);
                            maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                            totalValuesCount += valuesCount.totalValuesCount();
                        }
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            if (this.this$0.columnarMap.isNull(position)) {
                                encoder.writeInteger(this.this$0.maxDefinitionLevel - 2);
                                ++totalValuesCount;
                                continue;
                            }
                            int mapLength = this.this$0.columnarMap.getEntryCount(position);
                            if (mapLength == 0) {
                                encoder.writeInteger(this.this$0.maxDefinitionLevel - 1);
                                ++totalValuesCount;
                                continue;
                            }
                            DefLevelWriterProvider.ValuesCount valuesCount = this.nestedWriter.writeDefinitionLevels(mapLength);
                            maxDefinitionValuesCount += valuesCount.maxDefinitionLevelValuesCount();
                            totalValuesCount += valuesCount.totalValuesCount();
                        }
                    }
                    this.offset += positionsCount;
                    return new DefLevelWriterProvider.ValuesCount(totalValuesCount, maxDefinitionValuesCount);
                }
            };
        }
    }
}

