/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.io.api.Binary;

public class BloomFilterValuesWriter
extends ValuesWriter {
    private final ValuesWriter writer;
    private final BloomFilter bloomFilter;

    public static ValuesWriter createBloomFilterValuesWriter(ValuesWriter writer, Optional<BloomFilter> bloomFilter) {
        if (bloomFilter.isPresent()) {
            return new BloomFilterValuesWriter(writer, bloomFilter.orElseThrow());
        }
        return writer;
    }

    private BloomFilterValuesWriter(ValuesWriter writer, BloomFilter bloomFilter) {
        this.writer = writer;
        this.bloomFilter = bloomFilter;
    }

    @VisibleForTesting
    public ValuesWriter getWriter() {
        return this.writer;
    }

    public long getBufferedSize() {
        return this.writer.getBufferedSize() + (long)this.bloomFilter.getBitsetSize();
    }

    public BytesInput getBytes() {
        return this.writer.getBytes();
    }

    public Encoding getEncoding() {
        return this.writer.getEncoding();
    }

    public void reset() {
        this.writer.reset();
    }

    public void close() {
        this.writer.close();
    }

    public DictionaryPage toDictPageAndClose() {
        return this.writer.toDictPageAndClose();
    }

    public void resetDictionary() {
        this.writer.resetDictionary();
    }

    public long getAllocatedSize() {
        return this.writer.getAllocatedSize();
    }

    public void writeByte(int value) {
        throw new UnsupportedOperationException();
    }

    public void writeBoolean(boolean v) {
        throw new UnsupportedOperationException();
    }

    public void writeBytes(Binary v) {
        this.writer.writeBytes(v);
        this.bloomFilter.insertHash(this.bloomFilter.hash(v));
    }

    public void writeInteger(int v) {
        this.writer.writeInteger(v);
        this.bloomFilter.insertHash(this.bloomFilter.hash(Math.toIntExact(((Number)v).longValue())));
    }

    public void writeLong(long v) {
        this.writer.writeLong(v);
        this.bloomFilter.insertHash(this.bloomFilter.hash(((Number)v).longValue()));
    }

    public void writeDouble(double v) {
        this.writer.writeDouble(v);
        this.bloomFilter.insertHash(this.bloomFilter.hash(v));
    }

    public void writeFloat(float v) {
        this.writer.writeFloat(v);
        this.bloomFilter.insertHash(this.bloomFilter.hash(v));
    }

    public String memUsageString(String s) {
        return this.writer.memUsageString(s);
    }
}

