/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import io.airlift.configuration.Config;
import io.airlift.units.DataSize;
import jakarta.validation.constraints.NotNull;

public class AzureFileSystemConfig {
    private AuthType authType = AuthType.DEFAULT;
    private DataSize readBlockSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize writeBlockSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int maxWriteConcurrency = 8;
    private DataSize maxSingleUploadSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    @NotNull
    public AuthType getAuthType() {
        return this.authType;
    }

    @Config(value="azure.auth-type")
    public AzureFileSystemConfig setAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    @NotNull
    public DataSize getReadBlockSize() {
        return this.readBlockSize;
    }

    @Config(value="azure.read-block-size")
    public AzureFileSystemConfig setReadBlockSize(DataSize readBlockSize) {
        this.readBlockSize = readBlockSize;
        return this;
    }

    @NotNull
    public DataSize getWriteBlockSize() {
        return this.writeBlockSize;
    }

    @Config(value="azure.write-block-size")
    public AzureFileSystemConfig setWriteBlockSize(DataSize writeBlockSize) {
        this.writeBlockSize = writeBlockSize;
        return this;
    }

    public int getMaxWriteConcurrency() {
        return this.maxWriteConcurrency;
    }

    @Config(value="azure.max-write-concurrency")
    public AzureFileSystemConfig setMaxWriteConcurrency(int maxWriteConcurrency) {
        this.maxWriteConcurrency = maxWriteConcurrency;
        return this;
    }

    @NotNull
    public DataSize getMaxSingleUploadSize() {
        return this.maxSingleUploadSize;
    }

    @Config(value="azure.max-single-upload-size")
    public AzureFileSystemConfig setMaxSingleUploadSize(DataSize maxSingleUploadSize) {
        this.maxSingleUploadSize = maxSingleUploadSize;
        return this;
    }

    public static enum AuthType {
        ACCESS_KEY,
        OAUTH,
        DEFAULT;

    }
}

