/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import java.util.Objects;
import java.util.Optional;

class AzureLocation {
    private static final String INVALID_LOCATION_MESSAGE = "Invalid Azure location. Expected form is 'abfs://[<containerName>@]<accountName>.dfs.core.windows.net/<filePath>': %s";
    private static final CharMatcher CONTAINER_VALID_CHARACTERS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.is((char)'-'));
    private static final CharMatcher STORAGE_ACCOUNT_VALID_CHARACTERS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'0', (char)'9'));
    private final Location location;
    private final String account;

    public AzureLocation(Location location) {
        this.location = Objects.requireNonNull(location, "location is null");
        String scheme = (String)location.scheme().orElseThrow(() -> new IllegalArgumentException(String.format(INVALID_LOCATION_MESSAGE, location)));
        Preconditions.checkArgument(("abfs".equals(scheme) || "abfss".equals(scheme) ? 1 : 0) != 0, (String)INVALID_LOCATION_MESSAGE, (Object)location);
        location.userInfo().ifPresent(container -> {
            Preconditions.checkArgument((!container.isEmpty() ? 1 : 0) != 0, (String)INVALID_LOCATION_MESSAGE, (Object)location);
            Preconditions.checkArgument((boolean)CONTAINER_VALID_CHARACTERS.matchesAllOf((CharSequence)container), (String)"Invalid Azure storage container name. Valid characters are 'a-z', '0-9', and '-': %s", (Object)location);
            Preconditions.checkArgument((!container.startsWith("-") && !container.endsWith("-") ? 1 : 0) != 0, (String)"Invalid Azure storage container name. Cannot start or end with a hyphen: %s", (Object)location);
            Preconditions.checkArgument((!container.contains("--") ? 1 : 0) != 0, (String)"Invalid Azure storage container name. Cannot contain consecutive hyphens: %s", (Object)location);
        });
        Preconditions.checkArgument((boolean)location.host().isPresent(), (String)INVALID_LOCATION_MESSAGE, (Object)location);
        String host = (String)location.host().get();
        int accountSplit = host.indexOf(46);
        Preconditions.checkArgument((accountSplit > 0 ? 1 : 0) != 0, (String)INVALID_LOCATION_MESSAGE, (Object)this.location);
        this.account = host.substring(0, accountSplit);
        Preconditions.checkArgument((boolean)host.substring(accountSplit).equals(".dfs.core.windows.net"), (String)INVALID_LOCATION_MESSAGE, (Object)location);
        Preconditions.checkArgument((boolean)STORAGE_ACCOUNT_VALID_CHARACTERS.matchesAllOf((CharSequence)this.account), (String)"Invalid Azure storage account name. Valid characters are 'a-z' and '0-9': %s", (Object)location);
    }

    public static AzureLocation from(String location) {
        return new AzureLocation(Location.of((String)location));
    }

    public Location location() {
        return this.location;
    }

    public Optional<String> container() {
        return this.location.userInfo();
    }

    public String account() {
        return this.account;
    }

    public String path() {
        return this.location.path();
    }

    public String directoryPath() {
        Object path = this.location.path();
        if (!((String)path).isEmpty() && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }

    public String toString() {
        return this.location.toString();
    }

    public Location baseLocation() {
        return Location.of((String)"abfs://%s%s.dfs.core.windows.net/".formatted(this.container().map(container -> container + "@").orElse(""), this.account()));
    }
}

