/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.AbstractMasterClient;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.options.GetWorkerReportOptions;
import alluxio.grpc.BlockMasterClientServiceGrpc;
import alluxio.grpc.DecommissionWorkerPOptions;
import alluxio.grpc.GetBlockInfoPRequest;
import alluxio.grpc.GetBlockMasterInfoPOptions;
import alluxio.grpc.GetCapacityBytesPOptions;
import alluxio.grpc.GetUsedBytesPOptions;
import alluxio.grpc.GetWorkerInfoListPOptions;
import alluxio.grpc.GetWorkerLostStoragePOptions;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.RemoveDisabledWorkerPOptions;
import alluxio.grpc.ServiceType;
import alluxio.grpc.WorkerInfo;
import alluxio.grpc.WorkerLostStorageInfo;
import alluxio.master.MasterClientContext;
import alluxio.master.selectionpolicy.MasterSelectionPolicy;
import alluxio.retry.RetryPolicy;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockMasterInfo;
import io.grpc.Channel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class RetryHandlingBlockMasterClient
extends AbstractMasterClient
implements BlockMasterClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(BlockMasterClient.class);
    private BlockMasterClientServiceGrpc.BlockMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingBlockMasterClient(MasterClientContext conf) {
        super(conf);
    }

    public RetryHandlingBlockMasterClient(MasterClientContext conf, InetSocketAddress address) {
        super(conf, MasterSelectionPolicy.Factory.specifiedMaster((InetSocketAddress)address));
    }

    public RetryHandlingBlockMasterClient(MasterClientContext conf, InetSocketAddress address, Supplier<RetryPolicy> retryPolicy) {
        super(conf, MasterSelectionPolicy.Factory.specifiedMaster((InetSocketAddress)address), retryPolicy);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.BLOCK_MASTER_CLIENT_SERVICE;
    }

    protected String getServiceName() {
        return "BlockMasterClient";
    }

    protected long getServiceVersion() {
        return 2L;
    }

    protected void afterConnect() {
        this.mClient = BlockMasterClientServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public List<alluxio.wire.WorkerInfo> getWorkerInfoList() throws IOException {
        return (List)this.retryRPC(() -> {
            ArrayList<alluxio.wire.WorkerInfo> result = new ArrayList<alluxio.wire.WorkerInfo>();
            for (WorkerInfo workerInfo : this.mClient.getWorkerInfoList(GetWorkerInfoListPOptions.getDefaultInstance()).getWorkerInfosList()) {
                result.add(GrpcUtils.fromProto((WorkerInfo)workerInfo));
            }
            return result;
        }, RPC_LOG, "GetWorkerInfoList", "", new Object[0]);
    }

    @Override
    public List<alluxio.wire.WorkerInfo> getLostWorkerInfoList() throws IOException {
        return (List)this.retryRPC(() -> {
            ArrayList<alluxio.wire.WorkerInfo> result = new ArrayList<alluxio.wire.WorkerInfo>();
            for (WorkerInfo workerInfo : this.mClient.getLostWorkerList(GetWorkerInfoListPOptions.getDefaultInstance()).getWorkerInfosList()) {
                result.add(GrpcUtils.fromProto((WorkerInfo)workerInfo));
            }
            return result;
        }, RPC_LOG, "GetLostWorkerInfoList", "", new Object[0]);
    }

    @Override
    public void removeDisabledWorker(RemoveDisabledWorkerPOptions options) throws IOException {
        this.retryRPC(() -> this.mClient.removeDisabledWorker(options), RPC_LOG, "RemoveDisabledWorker", "", new Object[0]);
    }

    @Override
    public List<alluxio.wire.WorkerInfo> getWorkerReport(GetWorkerReportOptions options) throws IOException {
        return (List)this.retryRPC(() -> {
            ArrayList<alluxio.wire.WorkerInfo> result = new ArrayList<alluxio.wire.WorkerInfo>();
            for (WorkerInfo workerInfo : this.mClient.getWorkerReport(options.toProto()).getWorkerInfosList()) {
                result.add(GrpcUtils.fromProto((WorkerInfo)workerInfo));
            }
            return result;
        }, RPC_LOG, "GetWorkerReport", "options=%s", new Object[]{options});
    }

    @Override
    public List<WorkerLostStorageInfo> getWorkerLostStorage() throws IOException {
        return (List)this.retryRPC(() -> this.mClient.getWorkerLostStorage(GetWorkerLostStoragePOptions.getDefaultInstance()).getWorkerLostStorageInfoList(), RPC_LOG, "GetWorkerLostStorage", "", new Object[0]);
    }

    @Override
    public BlockInfo getBlockInfo(long blockId) throws IOException {
        return (BlockInfo)this.retryRPC(() -> GrpcUtils.fromProto((alluxio.grpc.BlockInfo)this.mClient.getBlockInfo(GetBlockInfoPRequest.newBuilder().setBlockId(blockId).build()).getBlockInfo()), RPC_LOG, "GetBlockInfo", "blockId=%d", new Object[]{blockId});
    }

    @Override
    public BlockMasterInfo getBlockMasterInfo(Set<BlockMasterInfo.BlockMasterInfoField> fields) throws IOException {
        return (BlockMasterInfo)this.retryRPC(() -> BlockMasterInfo.fromProto((alluxio.grpc.BlockMasterInfo)this.mClient.getBlockMasterInfo(GetBlockMasterInfoPOptions.newBuilder().addAllFilters((Iterable)fields.stream().map(BlockMasterInfo.BlockMasterInfoField::toProto).collect(Collectors.toList())).build()).getBlockMasterInfo()), RPC_LOG, "GetBlockMasterInfo", "fields=%s", new Object[]{fields});
    }

    @Override
    public long getCapacityBytes() throws IOException {
        return (Long)this.retryRPC(() -> this.mClient.getCapacityBytes(GetCapacityBytesPOptions.getDefaultInstance()).getBytes(), RPC_LOG, "GetCapacityBytes", "", new Object[0]);
    }

    @Override
    public long getUsedBytes() throws IOException {
        return (Long)this.retryRPC(() -> this.mClient.getUsedBytes(GetUsedBytesPOptions.getDefaultInstance()).getBytes(), RPC_LOG, "GetUsedBytes", "", new Object[0]);
    }

    @Override
    public void decommissionWorker(DecommissionWorkerPOptions options) throws IOException {
        this.retryRPC(() -> this.mClient.decommissionWorker(options), RPC_LOG, "DecommissionWorker", "workerHostName=%s,workerWebPort=%s,options=%s", new Object[]{options.getWorkerHostname(), options.getWorkerWebPort(), options});
    }
}

