/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.AlluxioURI;
import alluxio.CloseableSupplier;
import alluxio.PositionReader;
import alluxio.client.file.CacheContext;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.PageId;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.PageNotFoundException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.file.FileId;
import alluxio.file.ReadTargetBuffer;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.metrics.MultiDimensionalMetricsSystem;
import alluxio.network.protocol.databuffer.DataFileChannel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalCachePositionReader
implements PositionReader {
    protected final long mPageSize;
    private final CacheManager mCacheManager;
    private final CacheContext mCacheContext;
    private final CloseableSupplier<PositionReader> mFallbackReader;
    private final FileId mFileId;
    private final long mFileSize;
    private volatile boolean mClosed;
    private final CounterDataPoint mExternalMetric;

    public static LocalCachePositionReader create(AlluxioConfiguration conf, CacheManager cacheManager, CloseableSupplier<PositionReader> fallbackReader, URIStatus status, long pageSize, CacheContext cacheContext) {
        String fileId = conf.getBoolean(PropertyKey.DORA_ENABLED) ? new AlluxioURI(status.getUfsPath()).hash() : Long.toString(status.getFileId());
        return new LocalCachePositionReader(cacheManager, fallbackReader, FileId.of((String)fileId), status.getLength(), pageSize, cacheContext, (CounterDataPoint)MultiDimensionalMetricsSystem.EXTERNAL_DATA_READ);
    }

    public static LocalCachePositionReader create(CacheManager cacheManager, CloseableSupplier<PositionReader> fallbackReader, FileId fileId, long fileSize, long pageSize, CacheContext cacheContext) {
        return new LocalCachePositionReader(cacheManager, fallbackReader, fileId, fileSize, pageSize, cacheContext, (CounterDataPoint)MultiDimensionalMetricsSystem.UFS_DATA_ACCESS.labelValues(new String[]{"read"}));
    }

    private LocalCachePositionReader(CacheManager cacheManager, CloseableSupplier<PositionReader> fallbackReader, FileId fileId, long fileSize, long pageSize, CacheContext context, CounterDataPoint externalMetric) {
        this.mCacheManager = (CacheManager)Preconditions.checkNotNull((Object)cacheManager);
        this.mFallbackReader = (CloseableSupplier)Preconditions.checkNotNull(fallbackReader);
        this.mFileId = fileId;
        this.mFileSize = fileSize;
        this.mPageSize = pageSize;
        this.mCacheContext = (CacheContext)Preconditions.checkNotNull((Object)context);
        this.mExternalMetric = externalMetric;
    }

    public int readInternal(long position, ReadTargetBuffer buffer, int length) throws IOException {
        int bytesRead;
        Preconditions.checkArgument((!this.mClosed ? 1 : 0) != 0, (Object)"position reader is closed");
        if (position >= this.mFileSize) {
            return -1;
        }
        Stopwatch stopwatch = this.createUnstartedStopwatch();
        int totalBytesRead = 0;
        long lengthToRead = Math.min((long)length, this.mFileSize - position);
        while ((long)totalBytesRead < lengthToRead && (bytesRead = this.localCachedRead(buffer, (int)(lengthToRead - (long)totalBytesRead), position, stopwatch)) > 0) {
            totalBytesRead += bytesRead;
            position += (long)bytesRead;
        }
        if (totalBytesRead > length || totalBytesRead < length && position < this.mFileSize) {
            throw new IOException(String.format("Invalid number of bytes read - bytes to read = %d, actual bytes read = %d, bytes remains in file %d", length, totalBytesRead, this.mFileSize - position));
        }
        return totalBytesRead;
    }

    public synchronized void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mFallbackReader.close();
    }

    public Optional<DataFileChannel> getDataFileChannel(long position, int length) {
        long currentPage = position / this.mPageSize;
        PageId pageId = this.mCacheContext.getCacheIdentifier() != null ? new PageId(this.mCacheContext.getCacheIdentifier(), currentPage) : new PageId(this.mFileId.toString(), currentPage);
        int currentPageOffset = (int)(position % this.mPageSize);
        int bytesLeftInPage = (int)(this.mPageSize - (long)currentPageOffset);
        int bytesToReadInPage = Math.min(bytesLeftInPage, length);
        try {
            return this.mCacheManager.getDataFileChannel(pageId, currentPageOffset, bytesToReadInPage, this.mCacheContext);
        }
        catch (PageNotFoundException e) {
            return Optional.empty();
        }
    }

    private int localCachedRead(ReadTargetBuffer bytesBuffer, int length, long position, Stopwatch stopwatch) {
        long currentPage = position / this.mPageSize;
        PageId pageId = this.mCacheContext.getCacheIdentifier() != null ? new PageId(this.mCacheContext.getCacheIdentifier(), currentPage) : new PageId(this.mFileId.toString(), currentPage);
        int currentPageOffset = (int)(position % this.mPageSize);
        int bytesLeftInPage = (int)(this.mPageSize - (long)currentPageOffset);
        int bytesToReadInPage = Math.min(bytesLeftInPage, length);
        return this.mCacheManager.getAndLoad(pageId, currentPageOffset, bytesToReadInPage, bytesBuffer, this.mCacheContext, () -> this.readExternalPage(position));
    }

    private byte[] readExternalPage(long position) {
        int totalBytesRead;
        int bytesRead;
        long pageStart = position - position % this.mPageSize;
        int pageSize = (int)Math.min(this.mPageSize, this.mFileSize - pageStart);
        byte[] page = new byte[pageSize];
        for (totalBytesRead = 0; totalBytesRead < pageSize; totalBytesRead += bytesRead) {
            try {
                bytesRead = ((PositionReader)this.mFallbackReader.get()).read(pageStart + (long)totalBytesRead, page, totalBytesRead, pageSize - totalBytesRead);
            }
            catch (IOException e) {
                throw AlluxioRuntimeException.from((IOException)e);
            }
            if (bytesRead <= 0) break;
        }
        this.mExternalMetric.inc((long)totalBytesRead);
        MetricsSystem.meter((String)MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL.getName()).mark((long)totalBytesRead);
        if (totalBytesRead != pageSize) {
            throw new FailedPreconditionRuntimeException("Failed to read complete page from external storage. Bytes read: " + totalBytesRead + " Page size: " + pageSize);
        }
        return page;
    }

    @VisibleForTesting
    protected Stopwatch createUnstartedStopwatch() {
        return Stopwatch.createUnstarted((Ticker)Ticker.systemTicker());
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    static {
        MetricsSystem.registerGaugeIfAbsent((String)MetricsSystem.getMetricName((String)MetricKey.CLIENT_CACHE_HIT_RATE.getName()), () -> {
            long cacheMisses;
            long cacheHits = MetricsSystem.meter((String)MetricKey.CLIENT_CACHE_BYTES_READ_CACHE.getName()).getCount();
            long total = cacheHits + (cacheMisses = MetricsSystem.meter((String)MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL.getName()).getCount());
            if (total > 0L) {
                return (double)cacheHits / (1.0 * (double)total);
            }
            return 0;
        });
    }
}

