/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora.netty;

import alluxio.PositionReader;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.dora.netty.NettyDataReaderStateMachine;
import alluxio.client.file.dora.netty.PartialReadException;
import alluxio.file.ReadTargetBuffer;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.proto.dataserver.Protocol;
import alluxio.wire.WorkerNetAddress;
import com.codahale.metrics.Counter;
import java.io.IOException;
import java.util.function.Supplier;

public class NettyDataReader
implements PositionReader {
    private final FileSystemContext mContext;
    private final WorkerNetAddress mAddress;
    private final Supplier<Protocol.ReadRequest.Builder> mRequestBuilder;

    public NettyDataReader(FileSystemContext context, WorkerNetAddress address, Protocol.ReadRequest.Builder requestBuilder) {
        this.mContext = context;
        this.mAddress = address;
        this.mRequestBuilder = () -> ((Protocol.ReadRequest.Builder)requestBuilder).clone();
    }

    public int readInternal(long position, ReadTargetBuffer buffer, int length) throws IOException {
        Protocol.ReadRequest.Builder builder = this.mRequestBuilder.get().setLength((long)length).setOffset(position).clearCancel();
        NettyDataReaderStateMachine clientStateMachine = new NettyDataReaderStateMachine(this.mContext, this.mAddress, builder, buffer);
        clientStateMachine.run();
        int bytesRead = clientStateMachine.getBytesRead();
        PartialReadException exception = clientStateMachine.getException();
        if (exception != null) {
            throw exception;
        }
        if (bytesRead == 0) {
            return -1;
        }
        Metrics.BYTES_READ_FROM_WORKERS.inc((long)bytesRead);
        return bytesRead;
    }

    private static final class Metrics {
        private static final Counter BYTES_READ_FROM_WORKERS = MetricsSystem.counter((String)MetricKey.CLIENT_BYTES_READ_FROM_WORKERS.getName());

        private Metrics() {
        }
    }
}

