/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.hive.thrift.metastore.StorageDescriptor;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public record HiveBucketProperty(List<String> bucketedBy, int bucketCount, List<SortingColumn> sortedBy) {
    public HiveBucketProperty {
        bucketedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketedBy, "bucketedBy is null"));
        sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
    }

    public static Optional<HiveBucketProperty> fromStorageDescriptor(StorageDescriptor storageDescriptor, String tablePartitionName) {
        boolean numBucketsSet;
        boolean bucketColsSet = storageDescriptor.isSetBucketCols() && !storageDescriptor.getBucketCols().isEmpty();
        boolean bl = numBucketsSet = storageDescriptor.isSetNumBuckets() && storageDescriptor.getNumBuckets() > 0;
        if (!numBucketsSet) {
            return Optional.empty();
        }
        if (!bucketColsSet) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set: " + tablePartitionName);
        }
        Object sortedBy = ImmutableList.of();
        if (storageDescriptor.isSetSortCols()) {
            sortedBy = (List)storageDescriptor.getSortCols().stream().map(order -> SortingColumn.fromMetastoreApiOrder(order, tablePartitionName)).collect(ImmutableList.toImmutableList());
        }
        List bucketColumnNames = (List)storageDescriptor.getBucketCols().stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
        return Optional.of(new HiveBucketProperty(bucketColumnNames, storageDescriptor.getNumBuckets(), (List<SortingColumn>)sortedBy));
    }
}

