/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.hive.thrift.metastore.DataOperationType;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.AcidTransactionOwner;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StatisticsUpdateMode;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.TableInfo;
import io.trino.plugin.hive.projection.PartitionProjection;
import io.trino.plugin.hive.projection.PartitionProjectionProperties;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public class HiveMetastoreClosure {
    private final HiveMetastore delegate;
    private final TypeManager typeManager;
    private final boolean partitionProjectionEnabled;

    public HiveMetastoreClosure(HiveMetastore delegate, TypeManager typeManager, boolean partitionProjectionEnabled) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.partitionProjectionEnabled = partitionProjectionEnabled;
    }

    public Optional<Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    private Table getExistingTable(String databaseName, String tableName) {
        return this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    public Optional<Table> getTable(String databaseName, String tableName) {
        return this.delegate.getTable(databaseName, tableName);
    }

    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        return this.delegate.getTableColumnStatistics(databaseName, tableName, columnNames);
    }

    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
        return this.delegate.getPartitionColumnStatistics(databaseName, tableName, partitionNames, columnNames);
    }

    public boolean useSparkTableStatistics() {
        return this.delegate.useSparkTableStatistics();
    }

    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
        this.delegate.updateTableStatistics(databaseName, tableName, transaction, mode, statisticsUpdate);
    }

    public void updatePartitionStatistics(String databaseName, String tableName, StatisticsUpdateMode mode, Map<String, PartitionStatistics> partitionUpdates) {
        Table table = this.getExistingTable(databaseName, tableName);
        this.delegate.updatePartitionStatistics(table, mode, partitionUpdates);
    }

    public List<TableInfo> getTables(String databaseName) {
        return this.delegate.getTables(databaseName);
    }

    public void createDatabase(Database database) {
        this.delegate.createDatabase(database);
    }

    public void dropDatabase(String databaseName, boolean deleteData) {
        this.delegate.dropDatabase(databaseName, deleteData);
    }

    public void renameDatabase(String databaseName, String newDatabaseName) {
        this.delegate.renameDatabase(databaseName, newDatabaseName);
    }

    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        this.delegate.setDatabaseOwner(databaseName, principal);
    }

    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        this.delegate.setTableOwner(databaseName, tableName, principal);
    }

    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        this.delegate.createTable(table, principalPrivileges);
    }

    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        this.delegate.dropTable(databaseName, tableName, deleteData);
    }

    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges);
    }

    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
    }

    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        this.delegate.commentTable(databaseName, tableName, comment);
    }

    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        this.delegate.commentColumn(databaseName, tableName, columnName, comment);
    }

    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment);
    }

    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName);
    }

    public void dropColumn(String databaseName, String tableName, String columnName) {
        this.delegate.dropColumn(databaseName, tableName, columnName);
    }

    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        return this.delegate.getTable(databaseName, tableName).flatMap(table -> this.delegate.getPartition((Table)table, partitionValues));
    }

    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        Table table;
        Optional<PartitionProjection> projection;
        if (this.partitionProjectionEnabled && (projection = PartitionProjectionProperties.getPartitionProjectionFromTable(table = this.getTable(databaseName, tableName).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY, "Table does not exists: " + tableName)), this.typeManager)).isPresent()) {
            return projection.get().getProjectedPartitionNamesByFilter(columnNames, partitionKeysFilter);
        }
        return this.delegate.getPartitionNamesByFilter(databaseName, tableName, columnNames, partitionKeysFilter);
    }

    public Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        return this.delegate.getTable(databaseName, tableName).map(table -> this.getPartitionsByNames((Table)table, partitionNames)).orElseGet(() -> (Map)partitionNames.stream().collect(ImmutableMap.toImmutableMap(name -> name, name -> Optional.empty())));
    }

    private Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        Optional<PartitionProjection> projection;
        if (this.partitionProjectionEnabled && (projection = PartitionProjectionProperties.getPartitionProjectionFromTable(table, this.typeManager)).isPresent()) {
            return projection.get().getProjectedPartitionsByNames(table, partitionNames);
        }
        return this.delegate.getPartitionsByNames(table, partitionNames);
    }

    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.delegate.addPartitions(databaseName, tableName, partitions);
    }

    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
    }

    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        this.delegate.alterPartition(databaseName, tableName, partition);
    }

    public void createRole(String role, String grantor) {
        this.delegate.createRole(role, grantor);
    }

    public void dropRole(String role) {
        this.delegate.dropRole(role);
    }

    public Set<String> listRoles() {
        return this.delegate.listRoles();
    }

    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.grantRoles(roles, grantees, adminOption, grantor);
    }

    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
    }

    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal);
    }

    public void checkSupportsTransactions() {
        this.delegate.checkSupportsTransactions();
    }

    public long openTransaction(AcidTransactionOwner transactionOwner) {
        this.checkSupportsTransactions();
        return this.delegate.openTransaction(transactionOwner);
    }

    public void commitTransaction(long transactionId) {
        this.delegate.commitTransaction(transactionId);
    }

    public void abortTransaction(long transactionId) {
        this.delegate.abortTransaction(transactionId);
    }

    public void sendTransactionHeartbeat(long transactionId) {
        this.delegate.sendTransactionHeartbeat(transactionId);
    }

    public void acquireSharedReadLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(transactionOwner, queryId, transactionId, fullTables, partitions);
    }

    public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        return this.delegate.getValidWriteIds(tables, currentTransactionId);
    }

    public Optional<String> getConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    public long allocateWriteId(String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(dbName, tableName, transactionId);
    }

    public void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isPartitioned) {
        this.delegate.acquireTableWriteLock(transactionOwner, queryId, transactionId, dbName, tableName, operation, isPartitioned);
    }

    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        this.delegate.updateTableWriteId(dbName, tableName, transactionId, writeId, rowCountChange);
    }

    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        this.delegate.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation);
    }

    public void alterTransactionalTable(Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        this.delegate.alterTransactionalTable(table, transactionId, writeId, principalPrivileges);
    }

    public boolean functionExists(SchemaFunctionName name, String signatureToken) {
        return this.delegate.functionExists(name.getSchemaName(), name.getFunctionName(), signatureToken);
    }

    public Collection<LanguageFunction> getAllFunctions(String schemaName) {
        return this.delegate.getAllFunctions(schemaName);
    }

    public Collection<LanguageFunction> getFunctions(SchemaFunctionName name) {
        return this.delegate.getFunctions(name.getSchemaName(), name.getFunctionName());
    }

    public void createFunction(SchemaFunctionName name, LanguageFunction function) {
        this.delegate.createFunction(name.getSchemaName(), name.getFunctionName(), function);
    }

    public void replaceFunction(SchemaFunctionName name, LanguageFunction function) {
        this.delegate.replaceFunction(name.getSchemaName(), name.getFunctionName(), function);
    }

    public void dropFunction(SchemaFunctionName name, String signatureToken) {
        this.delegate.dropFunction(name.getSchemaName(), name.getFunctionName(), signatureToken);
    }
}

