/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.HivePageSinkMetadata;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveWritableTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<HiveColumnHandle> inputColumns;
    private final HivePageSinkMetadata pageSinkMetadata;
    private final LocationHandle locationHandle;
    private final Optional<BucketInfo> bucketInfo;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final AcidTransaction transaction;
    private final boolean retriesEnabled;

    public HiveWritableTableHandle(String schemaName, String tableName, List<HiveColumnHandle> inputColumns, HivePageSinkMetadata pageSinkMetadata, LocationHandle locationHandle, Optional<BucketInfo> bucketInfo, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, AcidTransaction transaction, boolean retriesEnabled) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.inputColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputColumns, "inputColumns is null"));
        this.pageSinkMetadata = Objects.requireNonNull(pageSinkMetadata, "pageSinkMetadata is null");
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.bucketInfo = Objects.requireNonNull(bucketInfo, "bucketInfo is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.retriesEnabled = retriesEnabled;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonIgnore
    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonProperty
    public List<HiveColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonProperty
    public HivePageSinkMetadata getPageSinkMetadata() {
        return this.pageSinkMetadata;
    }

    @JsonProperty
    public LocationHandle getLocationHandle() {
        return this.locationHandle;
    }

    @JsonProperty
    public Optional<BucketInfo> getBucketInfo() {
        return this.bucketInfo;
    }

    @JsonProperty
    public HiveStorageFormat getTableStorageFormat() {
        return this.tableStorageFormat;
    }

    @JsonProperty
    public HiveStorageFormat getPartitionStorageFormat() {
        return this.partitionStorageFormat;
    }

    @JsonProperty
    public AcidTransaction getTransaction() {
        return this.transaction;
    }

    @JsonIgnore
    public boolean isTransactional() {
        return this.transaction.isTransactional();
    }

    @JsonProperty
    public boolean isRetriesEnabled() {
        return this.retriesEnabled;
    }

    public String toString() {
        return this.schemaName + "." + this.tableName;
    }

    public record BucketInfo(List<String> bucketedBy, HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, List<SortingColumn> sortedBy) {
        public BucketInfo {
            bucketedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketedBy, "bucketedBy is null"));
            Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
        }

        public static Optional<BucketInfo> createBucketInfo(Table table) {
            if (table.getStorage().getBucketProperty().isEmpty()) {
                return Optional.empty();
            }
            HiveBucketProperty bucketProperty = table.getStorage().getBucketProperty().get();
            HiveBucketing.BucketingVersion bucketingVersion = HiveBucketing.getBucketingVersion(table.getParameters());
            return Optional.of(new BucketInfo(bucketProperty.bucketedBy(), bucketingVersion, bucketProperty.bucketCount(), bucketProperty.sortedBy()));
        }
    }
}

