/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.TrinoViewUtil;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.TableInfo;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class TrinoViewHiveMetastore {
    private final boolean isUsingSystemSecurity;
    private final HiveMetastore metastore;
    private final String trinoVersion;
    private final String connectorName;

    public TrinoViewHiveMetastore(HiveMetastore metastore, boolean isUsingSystemSecurity, String trinoVersion, String connectorName) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.isUsingSystemSecurity = isUsingSystemSecurity;
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.connectorName = Objects.requireNonNull(connectorName, "connectorName is null");
    }

    public void createView(ConnectorSession session, SchemaTableName schemaViewName, ConnectorViewDefinition definition, boolean replace) {
        if (this.isUsingSystemSecurity) {
            definition = definition.withoutOwner();
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaViewName.getSchemaName()).setTableName(schemaViewName.getTableName()).setOwner(this.isUsingSystemSecurity ? Optional.empty() : Optional.of(session.getUser())).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List<Column>)ImmutableList.of((Object)new Column("dummy", HiveType.HIVE_STRING, Optional.empty(), Map.of()))).setPartitionColumns((List<Column>)ImmutableList.of()).setParameters(TrinoViewUtil.createViewProperties(session, this.trinoVersion, this.connectorName)).setViewOriginalText(Optional.of(ViewReaderUtil.encodeViewData(definition))).setViewExpandedText(Optional.of("/* Presto View */"));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("");
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet(session.getUser());
        Optional<Table> existing = this.metastore.getTable(schemaViewName.getSchemaName(), schemaViewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !ViewReaderUtil.isTrinoView(existing.get())) {
                throw new ViewAlreadyExistsException(schemaViewName);
            }
            this.metastore.replaceTable(schemaViewName.getSchemaName(), schemaViewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(table, principalPrivileges);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void dropView(SchemaTableName schemaViewName) {
        if (this.getView(schemaViewName).isEmpty()) {
            throw new ViewNotFoundException(schemaViewName);
        }
        try {
            this.metastore.dropTable(schemaViewName.getSchemaName(), schemaViewName.getTableName(), true);
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(Optional<String> database) {
        return (List)this.listDatabases(database).stream().flatMap(this::listViews).collect(ImmutableList.toImmutableList());
    }

    private List<String> listDatabases(Optional<String> database) {
        if (database.isPresent()) {
            if (HiveUtil.isHiveSystemSchema(database.get())) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)database.get());
        }
        return this.metastore.getAllDatabases();
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(Optional<String> schemaName) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        for (SchemaTableName name : this.listViews(schemaName)) {
            try {
                this.getView(name).ifPresent(view -> views.put((Object)name, view));
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode()) || e instanceof TableNotFoundException || e instanceof ViewNotFoundException) continue;
                throw e;
            }
        }
        return views.buildOrThrow();
    }

    private Stream<SchemaTableName> listViews(String schema) {
        return this.metastore.getTables(schema).stream().filter(tableInfo -> tableInfo.extendedRelationType() == TableInfo.ExtendedRelationType.TRINO_VIEW).map(TableInfo::tableName);
    }

    public Optional<ConnectorViewDefinition> getView(SchemaTableName viewName) {
        if (HiveUtil.isHiveSystemSchema(viewName.getSchemaName())) {
            return Optional.empty();
        }
        return this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).flatMap(view -> TrinoViewUtil.getView(view.getViewOriginalText(), view.getTableType(), view.getParameters(), view.getOwner()));
    }

    public void updateViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        Table view = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition definition = TrinoViewUtil.getView(view.getViewOriginalText(), view.getTableType(), view.getParameters(), view.getOwner()).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), comment, definition.getOwner(), definition.isRunAsInvoker(), definition.getPath());
        this.replaceView(session, viewName, view, newDefinition);
    }

    public void updateViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        Table view = this.metastore.getTable(viewName.getSchemaName(), viewName.getTableName()).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition definition = TrinoViewUtil.getView(view.getViewOriginalText(), view.getTableType(), view.getParameters(), view.getOwner()).orElseThrow(() -> new ViewNotFoundException(viewName));
        ConnectorViewDefinition newDefinition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), (List)definition.getColumns().stream().map(currentViewColumn -> Objects.equals(columnName, currentViewColumn.getName()) ? new ConnectorViewDefinition.ViewColumn(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), definition.getComment(), definition.getOwner(), definition.isRunAsInvoker(), definition.getPath());
        this.replaceView(session, viewName, view, newDefinition);
    }

    private void replaceView(ConnectorSession session, SchemaTableName viewName, Table view, ConnectorViewDefinition newDefinition) {
        Table.Builder viewBuilder = Table.builder(view).setViewOriginalText(Optional.of(ViewReaderUtil.encodeViewData(newDefinition)));
        PrincipalPrivileges principalPrivileges = this.isUsingSystemSecurity ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet(session.getUser());
        this.metastore.replaceTable(viewName.getSchemaName(), viewName.getTableName(), viewBuilder.build(), principalPrivileges);
    }
}

