/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import com.google.common.base.Preconditions;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;

public final class VarcharToIntegralNumericCoercers {
    private VarcharToIntegralNumericCoercers() {
    }

    public static TypeCoercer<VarcharType, ? extends Type> createVarcharToIntegerNumberCoercer(VarcharType fromType, Type toType, boolean isOrcFile) {
        return isOrcFile ? new OrcVarcharToIntegralNumericCoercer<Type>(fromType, toType) : new VarcharToIntegralNumericCoercer<Type>(fromType, toType);
    }

    public static class OrcVarcharToIntegralNumericCoercer<T extends Type>
    extends TypeCoercer<VarcharType, T> {
        private final long minValue;
        private final long maxValue;

        public OrcVarcharToIntegralNumericCoercer(VarcharType fromType, T toType) {
            super(fromType, toType);
            if (toType.equals((Object)TinyintType.TINYINT)) {
                this.minValue = -128L;
                this.maxValue = 127L;
            } else if (toType.equals((Object)SmallintType.SMALLINT)) {
                this.minValue = -32768L;
                this.maxValue = 32767L;
            } else if (toType.equals((Object)IntegerType.INTEGER)) {
                this.minValue = Integer.MIN_VALUE;
                this.maxValue = Integer.MAX_VALUE;
            } else if (toType.equals((Object)BigintType.BIGINT)) {
                this.minValue = Long.MIN_VALUE;
                this.maxValue = Long.MAX_VALUE;
            } else {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not create Coercer from varchar to %s", toType));
            }
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            try {
                long value = Long.parseLong(((VarcharType)this.fromType).getSlice(block, position).toStringUtf8());
                if (this.minValue <= value && value <= this.maxValue) {
                    this.toType.writeLong(blockBuilder, value);
                } else {
                    blockBuilder.appendNull();
                }
            }
            catch (NumberFormatException e) {
                blockBuilder.appendNull();
            }
        }
    }

    public static class VarcharToIntegralNumericCoercer<T extends Type>
    extends TypeCoercer<VarcharType, T> {
        public VarcharToIntegralNumericCoercer(VarcharType fromType, T toType) {
            super(fromType, toType);
            Preconditions.checkArgument((toType.equals((Object)TinyintType.TINYINT) || toType.equals((Object)SmallintType.SMALLINT) || toType.equals((Object)IntegerType.INTEGER) || toType.equals((Object)BigintType.BIGINT) ? 1 : 0) != 0, (String)"Unsupported datatype for coercion from varchar to %s", toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            try {
                String valueToBeCoerced = ((VarcharType)this.fromType).getSlice(block, position).toStringUtf8();
                if (this.toType.equals((Object)TinyintType.TINYINT) || this.toType.equals((Object)SmallintType.SMALLINT) || this.toType.equals((Object)IntegerType.INTEGER)) {
                    int intValue = Integer.parseInt(valueToBeCoerced);
                    if (this.toType.equals((Object)TinyintType.TINYINT)) {
                        this.toType.writeLong(blockBuilder, (long)((byte)intValue));
                    } else if (this.toType.equals((Object)SmallintType.SMALLINT)) {
                        this.toType.writeLong(blockBuilder, (long)((short)intValue));
                    } else {
                        this.toType.writeLong(blockBuilder, (long)intValue);
                    }
                } else if (this.toType.equals((Object)BigintType.BIGINT)) {
                    this.toType.writeLong(blockBuilder, Long.parseLong(valueToBeCoerced));
                }
            }
            catch (NumberFormatException e) {
                blockBuilder.appendNull();
            }
        }
    }
}

