/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.DirectoryListingFilter;
import io.trino.plugin.hive.fs.RemoteIterator;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class HiveFileIterator
extends AbstractIterator<TrinoFileStatus> {
    private final Location location;
    private final NestedDirectoryPolicy nestedDirectoryPolicy;
    private final Iterator<TrinoFileStatus> remoteIterator;

    public HiveFileIterator(Table table, Location location, TrinoFileSystem fileSystem, DirectoryLister directoryLister, NestedDirectoryPolicy nestedDirectoryPolicy) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.nestedDirectoryPolicy = Objects.requireNonNull(nestedDirectoryPolicy, "nestedDirectoryPolicy is null");
        this.remoteIterator = new FileStatusIterator(table, location, fileSystem, directoryLister, nestedDirectoryPolicy);
    }

    protected TrinoFileStatus computeNext() {
        while (this.remoteIterator.hasNext()) {
            TrinoFileStatus status = this.remoteIterator.next();
            if (this.nestedDirectoryPolicy == NestedDirectoryPolicy.RECURSE ? HiveFileIterator.isHiddenOrWithinHiddenParentDirectory(Location.of((String)status.getPath()), this.location) : HiveFileIterator.isHiddenFileOrDirectory(Location.of((String)status.getPath()))) continue;
            return status;
        }
        return (TrinoFileStatus)this.endOfData();
    }

    @VisibleForTesting
    static boolean isHiddenFileOrDirectory(Location location) {
        String path = location.path();
        int lastSeparator = path.lastIndexOf(47);
        return HiveFileIterator.containsHiddenPathPartAfterIndex(path, lastSeparator + 1);
    }

    @VisibleForTesting
    static boolean isHiddenOrWithinHiddenParentDirectory(Location path, Location rootLocation) {
        String pathString = path.toString();
        String prefix = rootLocation.toString();
        Preconditions.checkArgument((boolean)pathString.startsWith(prefix), (String)"path %s does not start with prefix %s", (Object)pathString, (Object)prefix);
        return HiveFileIterator.containsHiddenPathPartAfterIndex(pathString, prefix.endsWith("/") ? prefix.length() : prefix.length() + 1);
    }

    @VisibleForTesting
    static boolean containsHiddenPathPartAfterIndex(String pathString, int startFromIndex) {
        while (startFromIndex < pathString.length()) {
            char firstNameChar = pathString.charAt(startFromIndex);
            if (firstNameChar == '.' || firstNameChar == '_') {
                return true;
            }
            int nextSeparator = pathString.indexOf(47, startFromIndex);
            if (nextSeparator < 0) break;
            startFromIndex = nextSeparator + 1;
        }
        return false;
    }

    public static enum NestedDirectoryPolicy {
        IGNORED,
        RECURSE,
        FAIL;

    }

    private static class FileStatusIterator
    implements Iterator<TrinoFileStatus> {
        private final Location location;
        private final RemoteIterator<TrinoFileStatus> fileStatusIterator;

        private FileStatusIterator(Table table, Location location, TrinoFileSystem fileSystem, DirectoryLister directoryLister, NestedDirectoryPolicy nestedDirectoryPolicy) {
            this.location = Objects.requireNonNull(location, "location is null");
            try {
                this.fileStatusIterator = nestedDirectoryPolicy == NestedDirectoryPolicy.RECURSE ? directoryLister.listFilesRecursively(fileSystem, table, location) : new DirectoryListingFilter(location, directoryLister.listFilesRecursively(fileSystem, table, location), nestedDirectoryPolicy == NestedDirectoryPolicy.FAIL);
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.fileStatusIterator.hasNext();
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        @Override
        public TrinoFileStatus next() {
            try {
                return this.fileStatusIterator.next();
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        private TrinoException processException(IOException exception) {
            if (exception instanceof FileNotFoundException) {
                return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, "Partition location does not exist: " + String.valueOf(this.location));
            }
            return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to list directory: " + String.valueOf(this.location), (Throwable)exception);
        }
    }

    public static class NestedDirectoryNotAllowedException
    extends RuntimeException {
        private final String nestedDirectoryPath;

        public NestedDirectoryNotAllowedException(String nestedDirectoryPath) {
            super("Nested sub-directories are not allowed: " + nestedDirectoryPath);
            this.nestedDirectoryPath = Objects.requireNonNull(nestedDirectoryPath, "nestedDirectoryPath is null");
        }

        public String getNestedDirectoryPath() {
            return this.nestedDirectoryPath;
        }
    }
}

