/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.hive.thrift.metastore.DataOperationType;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.PartitionNotFoundException;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.PartitionUpdateAndMergeResults;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.TableInvalidationCallback;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.AcidTransactionOwner;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HivePageSinkMetadata;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.HiveTransaction;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.SparkMetastoreUtil;
import io.trino.plugin.hive.metastore.StatisticsUpdateMode;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.TableInfo;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetadataMetastore;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.plugin.hive.util.ValidTxnWriteIdList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SemiTransactionalHiveMetastore
implements SqlStandardAccessControlMetadataMetastore {
    private static final Logger log = Logger.get(SemiTransactionalHiveMetastore.class);
    private static final int PARTITION_COMMIT_BATCH_SIZE = 20;
    private static final Pattern DELTA_DIRECTORY_MATCHER = Pattern.compile("(delete_)?delta_\\d+_\\d+_\\d+$");
    private static final RetryPolicy<?> DELETE_RETRY_POLICY = RetryPolicy.builder().withDelay(java.time.Duration.ofSeconds(1L)).withMaxDuration(java.time.Duration.ofSeconds(30L)).withMaxAttempts(3).build();
    private static final Map<AcidOperation, ActionType> ACID_OPERATION_ACTION_TYPES = ImmutableMap.of((Object)((Object)AcidOperation.INSERT), (Object)((Object)ActionType.INSERT_EXISTING), (Object)((Object)AcidOperation.MERGE), (Object)((Object)ActionType.MERGE));
    private final HiveMetastoreClosure delegate;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final Executor fileSystemExecutor;
    private final Executor dropExecutor;
    private final Executor updateExecutor;
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final boolean deleteSchemaLocationsFallback;
    private final ScheduledExecutorService heartbeatExecutor;
    private final Optional<Duration> configuredTransactionHeartbeatInterval;
    private final TableInvalidationCallback tableInvalidationCallback;
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Action<TableAndMore>> tableActions = new HashMap<SchemaTableName, Action<TableAndMore>>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>> partitionActions = new HashMap<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>>();
    @GuardedBy(value="this")
    private long declaredIntentionsToWriteCounter;
    @GuardedBy(value="this")
    private final List<DeclaredIntentionToWrite> declaredIntentionsToWrite = new ArrayList<DeclaredIntentionToWrite>();
    @GuardedBy(value="this")
    private ExclusiveOperation bufferedExclusiveOperation;
    @GuardedBy(value="this")
    private State state = State.EMPTY;
    @GuardedBy(value="this")
    private Optional<String> currentQueryId = Optional.empty();
    @GuardedBy(value="this")
    private Optional<Supplier<HiveTransaction>> hiveTransactionSupplier = Optional.empty();
    @GuardedBy(value="this")
    private Optional<HiveTransaction> currentHiveTransaction = Optional.empty();
    private static final Pattern METASTORE_TIME = Pattern.compile("([0-9]+)([a-zA-Z]+)");

    public SemiTransactionalHiveMetastore(TrinoFileSystemFactory fileSystemFactory, HiveMetastoreClosure delegate, Executor fileSystemExecutor, Executor dropExecutor, Executor updateExecutor, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean deleteSchemaLocationsFallback, Optional<Duration> hiveTransactionHeartbeatInterval, ScheduledExecutorService heartbeatService, TableInvalidationCallback tableInvalidationCallback) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.fileSystemExecutor = Objects.requireNonNull(fileSystemExecutor, "fileSystemExecutor is null");
        this.dropExecutor = Objects.requireNonNull(dropExecutor, "dropExecutor is null");
        this.updateExecutor = Objects.requireNonNull(updateExecutor, "updateExecutor is null");
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        this.heartbeatExecutor = heartbeatService;
        this.configuredTransactionHeartbeatInterval = Objects.requireNonNull(hiveTransactionHeartbeatInterval, "hiveTransactionHeartbeatInterval is null");
        this.tableInvalidationCallback = Objects.requireNonNull(tableInvalidationCallback, "tableInvalidationCallback is null");
    }

    public synchronized List<String> getAllDatabases() {
        this.checkReadable();
        return this.delegate.getAllDatabases();
    }

    public HiveMetastoreClosure unsafeGetRawHiveMetastoreClosure() {
        return this.delegate;
    }

    public synchronized Optional<Database> getDatabase(String databaseName) {
        this.checkReadable();
        return this.delegate.getDatabase(databaseName);
    }

    public synchronized List<TableInfo> getTables(String databaseName) {
        this.checkReadable();
        if (!this.tableActions.isEmpty()) {
            throw new UnsupportedOperationException("Listing all tables after adding/dropping/altering tables/views in a transaction is not supported");
        }
        return this.delegate.getTables(databaseName);
    }

    public synchronized Optional<Table> getTable(String databaseName, String tableName) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return this.delegate.getTable(databaseName, tableName);
        }
        return switch (tableAction.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 2, 3, 4, 5 -> Optional.of(tableAction.data().getTable());
            case 0 -> Optional.empty();
            case 1 -> throw new IllegalStateException("Unsupported action type: " + String.valueOf((Object)tableAction.type()));
        };
    }

    public synchronized boolean isReadableWithinTransaction(String databaseName, String tableName) {
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return true;
        }
        return switch (tableAction.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 2, 3 -> true;
            case 4, 5 -> false;
            case 0, 1 -> false;
        };
    }

    public synchronized PartitionStatistics getTableStatistics(String databaseName, String tableName, Optional<Set<String>> columns) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            Table table = this.getExistingTable(databaseName, tableName);
            Set columnNames = columns.orElseGet(() -> (Set)Stream.concat(table.getDataColumns().stream(), table.getPartitionColumns().stream()).map(Column::getName).collect(ImmutableSet.toImmutableSet()));
            if (this.delegate.useSparkTableStatistics()) {
                Optional<PartitionStatistics> sparkTableStatistics = SparkMetastoreUtil.getSparkTableStatistics(table.getParameters(), (Map)columnNames.stream().map(table::getColumn).flatMap(Optional::stream).collect(ImmutableMap.toImmutableMap(Column::getName, Column::getType)));
                if (sparkTableStatistics.isPresent()) {
                    return sparkTableStatistics.get();
                }
            }
            HiveBasicStatistics basicStatistics = MetastoreUtil.getHiveBasicStatistics(table.getParameters());
            if (columnNames.isEmpty()) {
                return new PartitionStatistics(basicStatistics, (Map<String, HiveColumnStatistics>)ImmutableMap.of());
            }
            return new PartitionStatistics(basicStatistics, this.delegate.getTableColumnStatistics(databaseName, tableName, columnNames));
        }
        return switch (tableAction.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 2, 3, 4, 5 -> tableAction.data().getStatistics();
            case 0 -> PartitionStatistics.empty();
            case 1 -> throw new IllegalStateException("Unsupported action type: " + String.valueOf((Object)tableAction.type()));
        };
    }

    public synchronized Map<String, PartitionStatistics> getPartitionStatistics(String databaseName, String tableName, Set<String> columns, Set<String> partitionNames) {
        this.checkReadable();
        Optional<Table> table = this.getTable(databaseName, tableName);
        if (table.isEmpty()) {
            return ImmutableMap.of();
        }
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableSet.Builder partitionNamesToQuery = ImmutableSet.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (String partitionName2 : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName2);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource.ordinal()) {
                    case 1: {
                        partitionNamesToQuery.add((Object)partitionName2);
                        break;
                    }
                    case 0: {
                        resultBuilder.put((Object)partitionName2, (Object)PartitionStatistics.empty());
                    }
                }
                continue;
            }
            resultBuilder.put((Object)partitionName2, (Object)((PartitionAndMore)partitionAction.data()).statistics());
        }
        ImmutableSet missingPartitions = partitionNamesToQuery.build();
        if (missingPartitions.isEmpty()) {
            return resultBuilder.buildOrThrow();
        }
        Map<String, Partition> existingPartitions = this.getExistingPartitions(databaseName, tableName, partitionNames);
        if (this.delegate.useSparkTableStatistics()) {
            HashMap<String, Partition> unprocessedPartitions = new HashMap<String, Partition>();
            existingPartitions.forEach((partitionName, partition) -> {
                Optional<PartitionStatistics> sparkPartitionStatistics = SparkMetastoreUtil.getSparkTableStatistics(partition.getParameters(), (Map)columns.stream().map(((Table)table.get())::getColumn).flatMap(Optional::stream).collect(ImmutableMap.toImmutableMap(Column::getName, Column::getType)));
                sparkPartitionStatistics.ifPresentOrElse(statistics -> resultBuilder.put(partitionName, statistics), () -> unprocessedPartitions.put((String)partitionName, (Partition)partition));
            });
            existingPartitions = unprocessedPartitions;
        }
        if (!existingPartitions.isEmpty()) {
            Map basicStats = (Map)existingPartitions.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
                if (this.delegate.useSparkTableStatistics()) {
                    return MetastoreUtil.getBasicStatisticsWithSparkFallback(((Partition)entry.getValue()).getParameters());
                }
                return MetastoreUtil.getHiveBasicStatistics(((Partition)entry.getValue()).getParameters());
            }));
            if (columns.isEmpty()) {
                basicStats.forEach((partitionName, basicStatistics) -> resultBuilder.put(partitionName, (Object)new PartitionStatistics((HiveBasicStatistics)basicStatistics, (Map<String, HiveColumnStatistics>)ImmutableMap.of())));
            } else {
                Map<String, Map<String, HiveColumnStatistics>> columnStats = this.delegate.getPartitionColumnStatistics(databaseName, tableName, basicStats.keySet(), columns);
                basicStats.forEach((key, value) -> resultBuilder.put(key, (Object)new PartitionStatistics((HiveBasicStatistics)value, (Map)columnStats.getOrDefault(key, (Map<String, HiveColumnStatistics>)ImmutableMap.of()))));
            }
        }
        return SemiTransactionalHiveMetastore.clearRowCountWhenAllPartitionsHaveNoRows((Map<String, PartitionStatistics>)resultBuilder.buildOrThrow());
    }

    private static Map<String, PartitionStatistics> clearRowCountWhenAllPartitionsHaveNoRows(Map<String, PartitionStatistics> partitionStatistics) {
        if (partitionStatistics.isEmpty()) {
            return partitionStatistics;
        }
        long tableRowCount = partitionStatistics.values().stream().mapToLong(statistics -> statistics.basicStatistics().getRowCount().orElse(0L)).sum();
        if (tableRowCount != 0L) {
            return partitionStatistics;
        }
        return (Map)partitionStatistics.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, PartitionStatistics>((String)entry.getKey(), ((PartitionStatistics)entry.getValue()).withBasicStatistics(((PartitionStatistics)entry.getValue()).basicStatistics().withEmptyRowCount()))).collect(ImmutableMap.toImmutableMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    @GuardedBy(value="this")
    private TableSource getTableSource(String databaseName, String tableName) {
        this.checkHoldsLock();
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return TableSource.PRE_EXISTING_TABLE;
        }
        return switch (tableAction.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> TableSource.CREATED_IN_THIS_TRANSACTION;
            case 0 -> throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            case 3, 4, 5 -> TableSource.PRE_EXISTING_TABLE;
            case 1 -> throw new IllegalStateException("Unsupported action type: " + String.valueOf((Object)tableAction.type()));
        };
    }

    public synchronized HivePageSinkMetadata generatePageSinkMetadata(SchemaTableName schemaTableName) {
        ImmutableMap modifiedPartitionMap;
        this.checkReadable();
        Optional<Table> table = this.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        if (table.isEmpty()) {
            return new HivePageSinkMetadata(schemaTableName, Optional.empty(), (Map<List<String>, Optional<Partition>>)ImmutableMap.of());
        }
        Map<List<String>, Action<PartitionAndMore>> partitionActionMap = this.partitionActions.get(schemaTableName);
        if (partitionActionMap == null) {
            modifiedPartitionMap = ImmutableMap.of();
        } else {
            ImmutableMap.Builder modifiedPartitionMapBuilder = ImmutableMap.builder();
            for (Map.Entry<List<String>, Action<PartitionAndMore>> entry : partitionActionMap.entrySet()) {
                modifiedPartitionMapBuilder.put(entry.getKey(), SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(entry.getValue()));
            }
            modifiedPartitionMap = modifiedPartitionMapBuilder.buildOrThrow();
        }
        return new HivePageSinkMetadata(schemaTableName, table, (Map<List<String>, Optional<Partition>>)modifiedPartitionMap);
    }

    public synchronized void createDatabase(ConnectorSession session, Database database) {
        String queryId = session.getQueryId();
        Verify.verify((boolean)SemiTransactionalHiveMetastore.getQueryId(database).orElseThrow(() -> new IllegalArgumentException("Query id is not present")).equals(queryId), (String)"Database '%s' does not have correct query id set", (Object)database.getDatabaseName());
        this.setExclusive(delegate -> delegate.createDatabase(database));
    }

    public synchronized void dropDatabase(ConnectorSession session, String schemaName) {
        this.setExclusive(delegate -> {
            boolean deleteData = this.shouldDeleteDatabaseData(session, schemaName);
            delegate.dropDatabase(schemaName, deleteData);
        });
    }

    public boolean shouldDeleteDatabaseData(ConnectorSession session, String schemaName) {
        Optional<Location> location = this.delegate.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName)).getLocation().map(Location::of);
        return location.map(path -> {
            try {
                TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
                return !fileSystem.listFiles(path).hasNext() && fileSystem.listDirectories(path).isEmpty();
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Could not check schema directory '%s'", new Object[]{path});
                return this.deleteSchemaLocationsFallback;
            }
        }).orElse(this.deleteSchemaLocationsFallback);
    }

    public synchronized void renameDatabase(String source, String target) {
        this.setExclusive(delegate -> delegate.renameDatabase(source, target));
    }

    public synchronized void setDatabaseOwner(String source, HivePrincipal principal) {
        this.setExclusive(delegate -> delegate.setDatabaseOwner(source, principal));
    }

    public synchronized void setTableStatistics(Table table, PartitionStatistics tableStatistics) {
        AcidTransaction transaction = this.getOptionalAcidTransaction();
        this.setExclusive(delegate -> delegate.updateTableStatistics(table.getDatabaseName(), table.getTableName(), transaction, StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS, tableStatistics));
    }

    public synchronized void setPartitionStatistics(Table table, Map<List<String>, PartitionStatistics> partitionStatisticsMap) {
        Map updates = (Map)partitionStatisticsMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> SemiTransactionalHiveMetastore.getPartitionName(table, (List)entry.getKey()), Map.Entry::getValue));
        this.setExclusive(delegate -> delegate.updatePartitionStatistics(table.getDatabaseName(), table.getTableName(), StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS, updates));
    }

    public synchronized void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges, Optional<Location> currentLocation, Optional<List<String>> files, boolean ignoreExisting, PartitionStatistics statistics, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        this.checkNoPartitionAction(table.getDatabaseName(), table.getTableName());
        Action<TableAndMore> oldTableAction = this.tableActions.get(table.getSchemaTableName());
        TableAndMore tableAndMore = new TableAndMore(table, Optional.of(principalPrivileges), currentLocation, files, ignoreExisting, statistics, statistics, cleanExtraOutputFilesOnCommit);
        if (oldTableAction == null) {
            this.tableActions.put(table.getSchemaTableName(), new Action<TableAndMore>(ActionType.ADD, tableAndMore, session.getIdentity(), session.getQueryId()));
            return;
        }
        switch (oldTableAction.type().ordinal()) {
            case 0: {
                if (!oldTableAction.identity().getUser().equals(session.getUser())) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Operation on the same table with different user in the same transaction is not supported");
                }
                this.tableActions.put(table.getSchemaTableName(), new Action<TableAndMore>(ActionType.ALTER, tableAndMore, session.getIdentity(), session.getQueryId()));
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new TableAlreadyExistsException(table.getSchemaTableName());
            }
            case 1: {
                throw new IllegalStateException("Unsupported action type: " + String.valueOf((Object)oldTableAction.type()));
            }
        }
    }

    public synchronized void dropTable(ConnectorSession session, String databaseName, String tableName) {
        this.setShared();
        this.checkNoPartitionAction(databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null || oldTableAction.type() == ActionType.ALTER) {
            this.tableActions.put(schemaTableName, new Action<Object>(ActionType.DROP, null, session.getIdentity(), session.getQueryId()));
            return;
        }
        switch (oldTableAction.type().ordinal()) {
            case 0: {
                throw new TableNotFoundException(schemaTableName);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new UnsupportedOperationException("dropping a table added/modified in the same transaction is not supported");
            }
            case 1: {
                throw new IllegalStateException("Unsupported action type: " + String.valueOf((Object)oldTableAction.type()));
            }
        }
    }

    public synchronized void replaceTable(String databaseName, String tableName, Table table, PrincipalPrivileges principalPrivileges) {
        this.setExclusive(delegate -> delegate.replaceTable(databaseName, tableName, table, principalPrivileges));
    }

    public synchronized void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.setExclusive(delegate -> {
            Optional<Table> oldTable = delegate.getTable(databaseName, tableName);
            try {
                delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
            }
            finally {
                oldTable.ifPresent(this.tableInvalidationCallback::invalidate);
            }
        });
    }

    public synchronized void commentTable(String databaseName, String tableName, Optional<String> comment) {
        this.setExclusive(delegate -> delegate.commentTable(databaseName, tableName, comment));
    }

    public synchronized void setTableOwner(String schema, String table, HivePrincipal principal) {
        this.setExclusive(delegate -> delegate.setTableOwner(schema, table, principal));
    }

    public synchronized void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        this.setExclusive(delegate -> delegate.commentColumn(databaseName, tableName, columnName, comment));
    }

    public synchronized void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.setExclusive(delegate -> delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment));
    }

    public synchronized void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.setExclusive(delegate -> delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName));
    }

    public synchronized void dropColumn(String databaseName, String tableName, String columnName) {
        this.setExclusive(delegate -> delegate.dropColumn(databaseName, tableName, columnName));
    }

    public synchronized void finishChangingExistingTable(AcidOperation acidOperation, ConnectorSession session, String databaseName, String tableName, Location currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        ActionType actionType = Objects.requireNonNull(ACID_OPERATION_ACTION_TYPES.get((Object)acidOperation), "ACID_OPERATION_ACTION_TYPES doesn't contain the acidOperation");
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null) {
            Table table = this.getExistingTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
            if (this.isAcidTransactionRunning()) {
                table = Table.builder(table).setWriteId(OptionalLong.of(this.getRequiredAcidTransaction().getWriteId())).build();
            }
            PartitionStatistics currentStatistics = this.getTableStatistics(databaseName, tableName, Optional.empty());
            this.tableActions.put(schemaTableName, new Action<TableAndMore>(actionType, new TableAndMore(table, Optional.empty(), Optional.of(currentLocation), Optional.of(fileNames), false, StatisticsUpdateMode.MERGE_INCREMENTAL.updatePartitionStatistics(currentStatistics, statisticsUpdate), statisticsUpdate, cleanExtraOutputFilesOnCommit), session.getIdentity(), session.getQueryId()));
            return;
        }
        switch (oldTableAction.type().ordinal()) {
            case 0: {
                throw new TableNotFoundException(schemaTableName);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new UnsupportedOperationException("Inserting into an unpartitioned table that were added, altered, or inserted into in the same transaction is not supported");
            }
            case 1: {
                throw new IllegalStateException("Unsupported action type: " + String.valueOf((Object)oldTableAction.type()));
            }
        }
    }

    private synchronized boolean isAcidTransactionRunning() {
        return this.currentHiveTransaction.isPresent() && this.currentHiveTransaction.get().getTransaction().isAcidTransactionRunning();
    }

    public synchronized void truncateUnpartitionedTable(ConnectorSession session, String databaseName, String tableName) {
        this.checkReadable();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        if (!table.getTableType().equals(TableType.MANAGED_TABLE.name())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot delete from non-managed Hive table");
        }
        if (!table.getPartitionColumns().isEmpty()) {
            throw new IllegalArgumentException("Table is partitioned");
        }
        Location location = Location.of((String)table.getStorage().getLocation());
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        this.setExclusive(delegate -> {
            RecursiveDeleteResult recursiveDeleteResult = SemiTransactionalHiveMetastore.recursiveDeleteFiles(fileSystem, location, (Set<String>)ImmutableSet.of((Object)""), false);
            if (!recursiveDeleteResult.notDeletedEligibleItems().isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error deleting from unpartitioned table %s. These items cannot be deleted: %s", schemaTableName, recursiveDeleteResult.notDeletedEligibleItems()));
            }
        });
    }

    public synchronized void finishMerge(ConnectorSession session, String databaseName, String tableName, Location currentLocation, List<PartitionUpdateAndMergeResults> partitionUpdateAndMergeResults, List<Partition> partitions) {
        if (partitionUpdateAndMergeResults.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((partitionUpdateAndMergeResults.size() >= partitions.size() ? 1 : 0) != 0, (String)"partitionUpdateAndMergeResults.size() (%s) < partitions.size() (%s)", (int)partitionUpdateAndMergeResults.size(), (int)partitions.size());
        this.setShared();
        if (partitions.isEmpty()) {
            return;
        }
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null) {
            Table table = this.getExistingTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
            PrincipalPrivileges principalPrivileges = table.getOwner().isEmpty() ? PrincipalPrivileges.NO_PRIVILEGES : MetastoreUtil.buildInitialPrivilegeSet(table.getOwner().get());
            this.tableActions.put(schemaTableName, new Action<TableAndMergeResults>(ActionType.MERGE, new TableAndMergeResults(table, Optional.of(principalPrivileges), Optional.of(currentLocation), partitionUpdateAndMergeResults), session.getIdentity(), session.getQueryId()));
            return;
        }
        switch (oldTableAction.type().ordinal()) {
            case 0: {
                throw new TableNotFoundException(schemaTableName);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new UnsupportedOperationException("Inserting, updating or deleting in a table that was added, altered, inserted into, updated or deleted from in the same transaction is not supported");
            }
            case 1: {
                throw new IllegalStateException("Unsupported action type: " + String.valueOf((Object)oldTableAction.type()));
            }
        }
    }

    public synchronized Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        Optional<Table> table = this.getTable(databaseName, tableName);
        if (table.isEmpty()) {
            return Optional.empty();
        }
        List columnNames = (List)table.get().getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        return this.doGetPartitionNames(databaseName, tableName, columnNames, (TupleDomain<String>)TupleDomain.all());
    }

    public synchronized Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.doGetPartitionNames(databaseName, tableName, columnNames, partitionKeysFilter);
    }

    @GuardedBy(value="this")
    private Optional<List<String>> doGetPartitionNames(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        this.checkHoldsLock();
        this.checkReadable();
        if (partitionKeysFilter.isNone()) {
            return Optional.of(ImmutableList.of());
        }
        Optional<Table> table = this.getTable(databaseName, tableName);
        if (table.isEmpty()) {
            return Optional.empty();
        }
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        ImmutableList partitionNames = switch (tableSource.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ImmutableList.of();
            case 1 -> this.delegate.getPartitionNamesByFilter(databaseName, tableName, columnNames, partitionKeysFilter).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table '%s.%s' was dropped by another transaction", databaseName, tableName)));
        };
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (String partitionName : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                resultBuilder.add((Object)partitionName);
                continue;
            }
            switch (partitionAction.type().ordinal()) {
                case 2: {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Another transaction created partition %s in table %s.%s", partitionValues, databaseName, tableName));
                }
                case 0: 
                case 1: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    resultBuilder.add((Object)partitionName);
                }
            }
        }
        if (!partitionActionsOfTable.isEmpty()) {
            for (Action partitionAction : partitionActionsOfTable.values()) {
                if (partitionAction.type() != ActionType.ADD) continue;
                List<String> values = ((PartitionAndMore)partitionAction.data()).partition().getValues();
                resultBuilder.add((Object)HiveUtil.makePartName(columnNames, values));
            }
        }
        return Optional.of(resultBuilder.build());
    }

    public synchronized Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        this.checkReadable();
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        ImmutableList.Builder partitionNamesToQueryBuilder = ImmutableList.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (String partitionName : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource.ordinal()) {
                    case 1: {
                        partitionNamesToQueryBuilder.add((Object)partitionName);
                        break;
                    }
                    case 0: {
                        resultBuilder.put((Object)partitionName, Optional.empty());
                    }
                }
                continue;
            }
            resultBuilder.put((Object)partitionName, SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(partitionAction));
        }
        ImmutableList partitionNamesToQuery = partitionNamesToQueryBuilder.build();
        if (!partitionNamesToQuery.isEmpty()) {
            Map<String, Optional<Partition>> delegateResult = this.delegate.getPartitionsByNames(databaseName, tableName, (List<String>)partitionNamesToQuery);
            resultBuilder.putAll(delegateResult);
        }
        return resultBuilder.buildOrThrow();
    }

    private static Optional<Partition> getPartitionFromPartitionAction(Action<PartitionAndMore> partitionAction) {
        return switch (partitionAction.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 2, 3, 4, 5 -> Optional.of(partitionAction.data().getAugmentedPartitionForInTransactionRead());
            case 0, 1 -> Optional.empty();
        };
    }

    public synchronized void addPartition(ConnectorSession session, String databaseName, String tableName, Partition partition, Location currentLocation, Optional<List<String>> files, PartitionStatistics statistics, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getQueryId(partition).isPresent());
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partition.getValues());
        if (oldPartitionAction == null) {
            partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ADD, new PartitionAndMore(partition, currentLocation, files, statistics, statistics, cleanExtraOutputFilesOnCommit), session.getIdentity(), session.getQueryId()));
            return;
        }
        switch (oldPartitionAction.type().ordinal()) {
            case 0: 
            case 1: {
                if (!oldPartitionAction.identity().getUser().equals(session.getUser())) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Operation on the same partition with different user in the same transaction is not supported");
                }
                partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ALTER, new PartitionAndMore(partition, currentLocation, files, statistics, statistics, cleanExtraOutputFilesOnCommit), session.getIdentity(), session.getQueryId()));
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Partition already exists for table '%s.%s': %s", databaseName, tableName, partition.getValues()));
            }
        }
    }

    public synchronized void dropPartition(ConnectorSession session, String databaseName, String tableName, List<String> partitionValues, boolean deleteData) {
        this.setShared();
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (oldPartitionAction == null) {
            if (deleteData) {
                partitionActionsOfTable.put(partitionValues, new Action<Object>(ActionType.DROP, null, session.getIdentity(), session.getQueryId()));
            } else {
                partitionActionsOfTable.put(partitionValues, new Action<Object>(ActionType.DROP_PRESERVE_DATA, null, session.getIdentity(), session.getQueryId()));
            }
            return;
        }
        switch (oldPartitionAction.type().ordinal()) {
            case 0: 
            case 1: {
                throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropping a partition added in the same transaction is not supported: %s %s %s".formatted(databaseName, tableName, partitionValues));
            }
        }
    }

    public synchronized void finishInsertIntoExistingPartitions(ConnectorSession session, String databaseName, String tableName, List<PartitionUpdateInfo> partitionUpdateInfos, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        Table table = this.getExistingTable(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.getSchemaTableName(), k -> new HashMap());
        for (PartitionUpdateInfo partitionInfo : partitionUpdateInfos) {
            Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionInfo.partitionValues());
            if (oldPartitionAction == null) continue;
            switch (oldPartitionAction.type().ordinal()) {
                case 0: 
                case 1: {
                    throw new PartitionNotFoundException(table.getSchemaTableName(), partitionInfo.partitionValues());
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    throw new UnsupportedOperationException("Inserting into a partition that were added, altered, or inserted into in the same transaction is not supported");
                }
            }
            throw new IllegalStateException("Unknown action type: " + String.valueOf((Object)oldPartitionAction.type()));
        }
        Set columnNames = (Set)table.getDataColumns().stream().map(Column::getName).collect(ImmutableSet.toImmutableSet());
        for (List partitionInfoBatch : Iterables.partition(partitionUpdateInfos, (int)100)) {
            List partitionNames = (List)partitionInfoBatch.stream().map(PartitionUpdateInfo::partitionValues).map(partitionValues -> this.getPartitionName(databaseName, tableName, (List<String>)partitionValues)).collect(ImmutableList.toImmutableList());
            Map<String, Partition> partitionsByNames = this.getExistingPartitions(databaseName, tableName, partitionNames);
            Map basicStats = (Map)partitionsByNames.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> MetastoreUtil.getHiveBasicStatistics(((Partition)entry.getValue()).getParameters())));
            Map<String, Map<String, HiveColumnStatistics>> columnStats = this.delegate.getPartitionColumnStatistics(databaseName, tableName, basicStats.keySet(), columnNames);
            for (int i = 0; i < partitionInfoBatch.size(); ++i) {
                PartitionUpdateInfo partitionInfo = (PartitionUpdateInfo)partitionInfoBatch.get(i);
                String partitionName = (String)partitionNames.get(i);
                Partition partition = partitionsByNames.get(partitionName);
                PartitionStatistics currentStatistics = new PartitionStatistics((HiveBasicStatistics)basicStats.get(partitionName), columnStats.get(partitionName));
                partitionActionsOfTable.put(partitionInfo.partitionValues(), new Action<PartitionAndMore>(ActionType.INSERT_EXISTING, new PartitionAndMore(partition, partitionInfo.currentLocation(), Optional.of(partitionInfo.fileNames()), StatisticsUpdateMode.MERGE_INCREMENTAL.updatePartitionStatistics(currentStatistics, partitionInfo.statisticsUpdate()), partitionInfo.statisticsUpdate(), cleanExtraOutputFilesOnCommit), session.getIdentity(), session.getQueryId()));
            }
        }
    }

    private synchronized AcidTransaction getRequiredAcidTransaction() {
        return this.currentHiveTransaction.orElseThrow(() -> new IllegalStateException("currentHiveTransaction not present")).getTransaction();
    }

    private synchronized AcidTransaction getOptionalAcidTransaction() {
        return this.currentHiveTransaction.map(HiveTransaction::getTransaction).orElse(AcidTransaction.NO_ACID_TRANSACTION);
    }

    private String getPartitionName(String databaseName, String tableName, List<String> partitionValues) {
        Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        return SemiTransactionalHiveMetastore.getPartitionName(table, partitionValues);
    }

    private static String getPartitionName(Table table, List<String> partitionValues) {
        List columnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        return HiveUtil.makePartName(columnNames, partitionValues);
    }

    @Override
    public synchronized void createRole(String role, String grantor) {
        this.setExclusive(delegate -> delegate.createRole(role, grantor));
    }

    @Override
    public synchronized void dropRole(String role) {
        this.setExclusive(delegate -> delegate.dropRole(role));
    }

    @Override
    public synchronized Set<String> listRoles() {
        this.checkReadable();
        return this.delegate.listRoles();
    }

    @Override
    public synchronized void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.setExclusive(delegate -> delegate.grantRoles(roles, grantees, adminOption, grantor));
    }

    @Override
    public synchronized void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.setExclusive(delegate -> delegate.revokeRoles(roles, grantees, adminOption, grantor));
    }

    @Override
    public synchronized Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        this.checkReadable();
        return this.delegate.listRoleGrants(principal);
    }

    @Override
    public Optional<HivePrincipal> getDatabaseOwner(String databaseName) {
        Database database = this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
        return database.getOwnerName().map(ownerName -> new HivePrincipal(database.getOwnerType().orElseThrow(), (String)ownerName));
    }

    @Override
    public synchronized Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<HivePrincipal> principal) {
        this.checkReadable();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> tableAction = this.tableActions.get(schemaTableName);
        if (tableAction == null) {
            return this.delegate.listTablePrivileges(databaseName, tableName, this.getExistingTable(databaseName, tableName).getOwner(), principal);
        }
        return switch (tableAction.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 2, 3 -> {
                if (principal.isPresent() && principal.get().getType() == PrincipalType.ROLE) {
                    yield ImmutableSet.of();
                }
                Optional<String> owner = tableAction.data().getTable().getOwner();
                if (owner.isEmpty()) {
                    yield ImmutableSet.of();
                }
                String ownerUsername = owner.orElseThrow();
                if (principal.isPresent() && !principal.get().getName().equals(ownerUsername)) {
                    yield ImmutableSet.of();
                }
                Set privileges = tableAction.data().getPrincipalPrivileges().getUserPrivileges().get((Object)ownerUsername);
                yield ImmutableSet.builder().addAll((Iterable)privileges).add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, new HivePrincipal(PrincipalType.USER, ownerUsername), new HivePrincipal(PrincipalType.USER, ownerUsername))).build();
            }
            case 4, 5 -> this.delegate.listTablePrivileges(databaseName, tableName, this.getExistingTable(databaseName, tableName).getOwner(), principal);
            case 0 -> throw new TableNotFoundException(schemaTableName);
            case 1 -> throw new IllegalStateException("Unsupported action type: " + String.valueOf((Object)tableAction.type()));
        };
    }

    private synchronized String getRequiredTableOwner(String databaseName, String tableName) {
        return this.getExistingTable(databaseName, tableName).getOwner().orElseThrow();
    }

    private Table getExistingTable(String databaseName, String tableName) {
        return this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    private Map<String, Partition> getExistingPartitions(String databaseName, String tableName, Collection<String> partitionNames) {
        return (Map)this.delegate.getPartitionsByNames(databaseName, tableName, (List<String>)ImmutableList.copyOf(partitionNames)).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Partition)((Optional)entry.getValue()).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), HivePartitionManager.extractPartitionValues((String)entry.getKey())))));
    }

    @Override
    public synchronized void grantTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.setExclusive(delegate -> delegate.grantTablePrivileges(databaseName, tableName, this.getRequiredTableOwner(databaseName, tableName), grantee, grantor, privileges, grantOption));
    }

    @Override
    public synchronized void revokeTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.setExclusive(delegate -> delegate.revokeTablePrivileges(databaseName, tableName, this.getRequiredTableOwner(databaseName, tableName), grantee, grantor, privileges, grantOption));
    }

    public synchronized boolean functionExists(SchemaFunctionName name, String signatureToken) {
        this.checkReadable();
        return this.delegate.functionExists(name, signatureToken);
    }

    public synchronized Collection<LanguageFunction> getFunctions(String schemaName) {
        this.checkReadable();
        return this.delegate.getAllFunctions(schemaName);
    }

    public synchronized Collection<LanguageFunction> getFunctions(SchemaFunctionName name) {
        this.checkReadable();
        return this.delegate.getFunctions(name);
    }

    public synchronized void createFunction(SchemaFunctionName name, LanguageFunction function) {
        this.setExclusive(delegate -> delegate.createFunction(name, function));
    }

    public synchronized void replaceFunction(SchemaFunctionName name, LanguageFunction function) {
        this.setExclusive(delegate -> delegate.replaceFunction(name, function));
    }

    public synchronized void dropFunction(SchemaFunctionName name, String signatureToken) {
        this.setExclusive(delegate -> delegate.dropFunction(name, signatureToken));
    }

    public synchronized String declareIntentionToWrite(ConnectorSession session, LocationHandle.WriteMode writeMode, Location stagingPathRoot, SchemaTableName schemaTableName) {
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable;
        this.setShared();
        if (writeMode == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY && (partitionActionsOfTable = this.partitionActions.get(schemaTableName)) != null && !partitionActionsOfTable.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot insert into a table with a partition that has been modified in the same transaction when Trino is configured to skip temporary directories.");
        }
        ConnectorIdentity identity = session.getIdentity();
        String queryId = session.getQueryId();
        String declarationId = queryId + "_" + this.declaredIntentionsToWriteCounter;
        ++this.declaredIntentionsToWriteCounter;
        this.declaredIntentionsToWrite.add(new DeclaredIntentionToWrite(declarationId, writeMode, identity, queryId, stagingPathRoot, schemaTableName));
        return declarationId;
    }

    public synchronized void dropDeclaredIntentionToWrite(String declarationId) {
        boolean removed = this.declaredIntentionsToWrite.removeIf(intention -> intention.declarationId().equals(declarationId));
        if (!removed) {
            throw new IllegalArgumentException("Declaration with id " + declarationId + " not found");
        }
    }

    public synchronized boolean isFinished() {
        return this.state == State.FINISHED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void commit() {
        try {
            switch (this.state.ordinal()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.commitShared();
                    return;
                }
                case 2: {
                    this.bufferedExclusiveOperation.execute(this.delegate);
                    return;
                }
                case 3: {
                    throw new IllegalStateException("Tried to commit buffered metastore operations after transaction has been committed/aborted");
                }
            }
            return;
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback() {
        try {
            switch (this.state.ordinal()) {
                case 0: 
                case 2: {
                    return;
                }
                case 1: {
                    this.rollbackShared();
                    return;
                }
                case 3: {
                    throw new IllegalStateException("Tried to rollback buffered metastore operations after transaction has been committed/aborted");
                }
            }
            return;
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    public void checkSupportsHiveAcidTransactions() {
        this.delegate.checkSupportsTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginQuery(ConnectorSession session) {
        String queryId = session.getQueryId();
        SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = this;
        synchronized (semiTransactionalHiveMetastore) {
            Preconditions.checkState((this.currentQueryId.isEmpty() && this.hiveTransactionSupplier.isEmpty() ? 1 : 0) != 0, (String)"Query already begun: %s while starting query %s", this.currentQueryId, (Object)queryId);
            this.currentQueryId = Optional.of(queryId);
            this.hiveTransactionSupplier = Optional.of(() -> this.makeHiveTransaction(session, transactionId -> AcidTransaction.NO_ACID_TRANSACTION));
        }
    }

    public AcidTransaction beginInsert(ConnectorSession session, Table table) {
        return this.beginOperation(session, table, AcidOperation.INSERT, DataOperationType.INSERT);
    }

    public AcidTransaction beginMerge(ConnectorSession session, Table table) {
        return this.beginOperation(session, table, AcidOperation.MERGE, DataOperationType.UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcidTransaction beginOperation(ConnectorSession session, Table table, AcidOperation operation, DataOperationType hiveOperation) {
        String queryId = session.getQueryId();
        SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = this;
        synchronized (semiTransactionalHiveMetastore) {
            this.currentQueryId = Optional.of(queryId);
            HiveTransaction hiveTransaction = this.makeHiveTransaction(session, transactionId -> {
                this.acquireTableWriteLock(new AcidTransactionOwner(session.getUser()), queryId, (long)transactionId, table.getDatabaseName(), table.getTableName(), hiveOperation, !table.getPartitionColumns().isEmpty());
                long writeId = this.allocateWriteId(table.getDatabaseName(), table.getTableName(), (long)transactionId);
                return new AcidTransaction(operation, (long)transactionId, writeId);
            });
            this.hiveTransactionSupplier = Optional.of(() -> hiveTransaction);
            this.currentHiveTransaction = Optional.of(hiveTransaction);
            return hiveTransaction.getTransaction();
        }
    }

    private HiveTransaction makeHiveTransaction(ConnectorSession session, Function<Long, AcidTransaction> transactionMaker) {
        String queryId = session.getQueryId();
        long heartbeatInterval = this.configuredTransactionHeartbeatInterval.map(Duration::toMillis).orElseGet(this::getServerExpectedHeartbeatIntervalMillis);
        long transactionId = this.delegate.openTransaction(new AcidTransactionOwner(session.getUser()));
        log.debug("Using hive transaction %s for %s", new Object[]{transactionId, queryId});
        ScheduledFuture<?> heartbeatTask = this.heartbeatExecutor.scheduleAtFixedRate(() -> this.delegate.sendTransactionHeartbeat(transactionId), 0L, heartbeatInterval, TimeUnit.MILLISECONDS);
        AcidTransaction transaction = transactionMaker.apply(transactionId);
        return new HiveTransaction(queryId, transactionId, heartbeatTask, transaction);
    }

    private long getServerExpectedHeartbeatIntervalMillis() {
        String timeout = this.delegate.getConfigValue("metastore.txn.timeout").orElse("300s");
        return SemiTransactionalHiveMetastore.metastoreTimeToMillis(timeout) / 2L;
    }

    private static long metastoreTimeToMillis(String value) {
        if (CharMatcher.inRange((char)'0', (char)'9').matches(value.charAt(value.length() - 1))) {
            return TimeUnit.SECONDS.toMillis(Long.parseLong(value));
        }
        Matcher matcher = METASTORE_TIME.matcher(value);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid time unit: %s", (Object)value);
        long duration = Long.parseLong(matcher.group(1));
        String unit = matcher.group(2).toLowerCase(Locale.ENGLISH);
        if (unit.equals("s") || unit.startsWith("sec")) {
            return TimeUnit.SECONDS.toMillis(duration);
        }
        if (unit.equals("ms") || unit.startsWith("msec")) {
            return duration;
        }
        if (unit.equals("m") || unit.startsWith("min")) {
            return TimeUnit.MINUTES.toMillis(duration);
        }
        if (unit.equals("us") || unit.startsWith("usec")) {
            return TimeUnit.MICROSECONDS.toMillis(duration);
        }
        if (unit.equals("ns") || unit.startsWith("nsec")) {
            return TimeUnit.NANOSECONDS.toMillis(duration);
        }
        if (unit.equals("h") || unit.startsWith("hour")) {
            return TimeUnit.HOURS.toMillis(duration);
        }
        if (unit.equals("d") || unit.startsWith("day")) {
            return TimeUnit.DAYS.toMillis(duration);
        }
        throw new IllegalArgumentException("Invalid time unit " + unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ValidTxnWriteIdList> getValidWriteIds(ConnectorSession session, HiveTableHandle tableHandle) {
        HiveTransaction hiveTransaction;
        SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = this;
        synchronized (semiTransactionalHiveMetastore) {
            String queryId = session.getQueryId();
            Preconditions.checkState((boolean)this.currentQueryId.equals(Optional.of(queryId)), (String)"Invalid query id %s while current query is %s", (Object)queryId, this.currentQueryId);
            if (!AcidTables.isTransactionalTable(tableHandle.getTableParameters().orElseThrow(() -> new IllegalStateException("tableParameters missing")))) {
                return Optional.empty();
            }
            if (this.currentHiveTransaction.isEmpty()) {
                this.currentHiveTransaction = Optional.of(this.hiveTransactionSupplier.orElseThrow(() -> new IllegalStateException("hiveTransactionSupplier is not set")).get());
            }
            hiveTransaction = this.currentHiveTransaction.get();
        }
        return Optional.of(hiveTransaction.getValidWriteIds(new AcidTransactionOwner(session.getUser()), this.delegate, tableHandle));
    }

    public synchronized void cleanupQuery(ConnectorSession session) {
        String queryId = session.getQueryId();
        Preconditions.checkState((boolean)this.currentQueryId.equals(Optional.of(queryId)), (String)"Invalid query id %s while current query is %s", (Object)queryId, this.currentQueryId);
        Optional<HiveTransaction> transaction = this.currentHiveTransaction;
        if (transaction.isEmpty()) {
            this.clearCurrentTransaction();
            return;
        }
        try {
            this.commit();
        }
        catch (Throwable commitFailure) {
            block5: {
                try {
                    this.postCommitCleanup(transaction, false);
                }
                catch (Throwable cleanupFailure) {
                    if (cleanupFailure == commitFailure) break block5;
                    commitFailure.addSuppressed(cleanupFailure);
                }
            }
            throw commitFailure;
        }
        this.postCommitCleanup(transaction, true);
    }

    private void postCommitCleanup(Optional<HiveTransaction> transaction, boolean commit) {
        this.clearCurrentTransaction();
        long transactionId = transaction.orElseThrow().getTransactionId();
        ScheduledFuture<?> heartbeatTask = transaction.get().getHeartbeatTask();
        heartbeatTask.cancel(true);
        if (commit) {
            this.delegate.commitTransaction(transactionId);
        } else {
            this.delegate.abortTransaction(transactionId);
        }
    }

    private synchronized void clearCurrentTransaction() {
        this.currentQueryId = Optional.empty();
        this.currentHiveTransaction = Optional.empty();
        this.hiveTransactionSupplier = Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    private void commitShared() {
        this.checkHoldsLock();
        AcidTransaction transaction = this.getOptionalAcidTransaction();
        Committer committer = new Committer(transaction);
        try {
            SchemaTableName schemaTableName;
            for (Map.Entry<SchemaTableName, Action<TableAndMore>> entry : this.tableActions.entrySet()) {
                schemaTableName = entry.getKey();
                Action<TableAndMore> action = entry.getValue();
                switch (action.type().ordinal()) {
                    case 0: {
                        committer.prepareDropTable(schemaTableName);
                        break;
                    }
                    case 3: {
                        committer.prepareAlterTable(action.identity(), action.queryId(), action.data());
                        break;
                    }
                    case 2: {
                        committer.prepareAddTable(action.identity(), action.queryId(), action.data());
                        break;
                    }
                    case 4: {
                        committer.prepareInsertExistingTable(action.identity(), action.queryId(), action.data());
                        break;
                    }
                    case 5: {
                        committer.prepareMergeExistingTable(action.identity(), action.data());
                        break;
                    }
                    case 1: {
                        throw new IllegalArgumentException("Unsupported action type: " + String.valueOf((Object)action.type()));
                    }
                }
            }
            for (Map.Entry<SchemaTableName, Object> entry : this.partitionActions.entrySet()) {
                schemaTableName = entry.getKey();
                for (Map.Entry partitionEntry : ((Map)entry.getValue()).entrySet()) {
                    List partitionValues = (List)partitionEntry.getKey();
                    Action action = (Action)partitionEntry.getValue();
                    switch (action.type().ordinal()) {
                        case 0: {
                            committer.prepareDropPartition(schemaTableName, partitionValues, true);
                            break;
                        }
                        case 1: {
                            committer.prepareDropPartition(schemaTableName, partitionValues, false);
                            break;
                        }
                        case 3: {
                            committer.prepareAlterPartition(action.identity(), action.queryId(), (PartitionAndMore)action.data());
                            break;
                        }
                        case 2: {
                            committer.prepareAddPartition(action.identity(), action.queryId(), (PartitionAndMore)action.data());
                            break;
                        }
                        case 4: 
                        case 5: {
                            committer.prepareInsertExistingPartition(action.identity(), action.queryId(), (PartitionAndMore)action.data());
                        }
                    }
                }
            }
            committer.waitForAsyncFileSystemOperations();
            committer.executeAddTableOperations(transaction);
            committer.executeAlterTableOperations();
            committer.executeAlterPartitionOperations();
            committer.executeAddPartitionOperations(transaction);
            committer.executeUpdateStatisticsOperations(transaction);
        }
        catch (Throwable t) {
            log.warn("Rolling back due to metastore commit failure: %s", new Object[]{t.getMessage()});
            try {
                committer.cancelUnstartedAsyncFileSystemOperations();
                committer.undoUpdateStatisticsOperations(transaction);
                committer.undoAddPartitionOperations();
                committer.undoAddTableOperations();
                committer.waitForAsyncFileSystemOperationSuppressThrowable();
                committer.executeCleanupTasksForAbort(this.declaredIntentionsToWrite);
                committer.executeRenameTasksForAbort();
                committer.undoAlterTableOperations();
                committer.undoAlterPartitionOperations();
                this.rollbackShared();
            }
            catch (RuntimeException runtimeException) {
                t.addSuppressed(new Exception("Failed to roll back after commit failure", runtimeException));
            }
            throw t;
        }
        finally {
            committer.executeTableInvalidationCallback();
        }
        try {
            committer.executeIrreversibleMetastoreOperations();
        }
        finally {
            committer.executeDeletionTasksForFinish();
            committer.pruneAndDeleteStagingDirectories(this.declaredIntentionsToWrite);
        }
    }

    @GuardedBy(value="this")
    private void rollbackShared() {
        this.checkHoldsLock();
        for (DeclaredIntentionToWrite declaredIntentionToWrite : this.declaredIntentionsToWrite) {
            switch (declaredIntentionToWrite.mode()) {
                case STAGE_AND_MOVE_TO_TARGET_DIRECTORY: 
                case DIRECT_TO_TARGET_NEW_DIRECTORY: {
                    if (declaredIntentionToWrite.mode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY && this.skipTargetCleanupOnRollback) break;
                    Location rootPath = declaredIntentionToWrite.rootPath();
                    this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.identity(), rootPath, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.queryId()), true, String.format("staging/target_new directory rollback for table %s", declaredIntentionToWrite.schemaTableName()));
                    break;
                }
                case DIRECT_TO_TARGET_EXISTING_DIRECTORY: {
                    HashSet<Location> pathsToClean = new HashSet<Location>();
                    Location baseDirectory = declaredIntentionToWrite.rootPath();
                    pathsToClean.add(baseDirectory);
                    SchemaTableName schemaTableName = declaredIntentionToWrite.schemaTableName();
                    Optional<Table> table = this.delegate.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    if (table.isPresent()) {
                        List<Column> partitionColumns = table.get().getPartitionColumns();
                        if (!partitionColumns.isEmpty()) {
                            List partitionColumnNames = (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
                            List<String> partitionNames = this.delegate.getPartitionNamesByFilter(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionColumnNames, (TupleDomain<String>)TupleDomain.all()).orElse((List<String>)ImmutableList.of());
                            for (List partitionNameBatch : Iterables.partition(partitionNames, (int)10)) {
                                Collection<Optional<Partition>> partitions = this.delegate.getPartitionsByNames(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionNameBatch).values();
                                partitions.stream().flatMap(Optional::stream).map(partition -> partition.getStorage().getLocation()).filter(path -> !path.startsWith(baseDirectory.toString())).map(Location::of).forEach(pathsToClean::add);
                            }
                        }
                    } else {
                        SemiTransactionalHiveMetastore.logCleanupFailure("Error rolling back write to table %s.%s. Data directory may contain temporary data. Table was dropped in another transaction.", schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    }
                    for (Location path2 : pathsToClean) {
                        this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.identity(), path2, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.queryId()), false, String.format("target_existing directory rollback for table %s", schemaTableName));
                    }
                    break;
                }
            }
        }
    }

    @VisibleForTesting
    public synchronized void testOnlyCheckIsReadOnly() {
        if (this.state != State.EMPTY) {
            throw new AssertionError((Object)"Test did not commit or rollback");
        }
    }

    @GuardedBy(value="this")
    private synchronized void checkReadable() {
        this.checkHoldsLock();
        switch (this.state.ordinal()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
            }
            case 3: {
                throw new IllegalStateException("Tried to access metastore after transaction has been committed/aborted");
            }
        }
    }

    @GuardedBy(value="this")
    private synchronized void setShared() {
        this.checkHoldsLock();
        this.checkReadable();
        this.state = State.SHARED_OPERATION_BUFFERED;
    }

    @GuardedBy(value="this")
    private synchronized void setExclusive(ExclusiveOperation exclusiveOperation) {
        this.checkHoldsLock();
        if (this.state != State.EMPTY) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
        }
        this.state = State.EXCLUSIVE_OPERATION_BUFFERED;
        this.bufferedExclusiveOperation = exclusiveOperation;
    }

    @GuardedBy(value="this")
    private void checkNoPartitionAction(String databaseName, String tableName) {
        this.checkHoldsLock();
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable = this.partitionActions.get(new SchemaTableName(databaseName, tableName));
        if (partitionActionsOfTable != null && !partitionActionsOfTable.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot make schema changes to a table/view with modified partitions in the same transaction");
        }
    }

    @FormatMethod
    private static void logCleanupFailure(String format, Object ... args) {
        log.warn(format, args);
    }

    @FormatMethod
    private static void logCleanupFailure(Throwable t, String format, Object ... args) {
        log.warn(t, format, args);
    }

    private static void addSuppressedExceptions(List<Throwable> suppressedExceptions, Throwable t, List<String> descriptions, String description) {
        descriptions.add(description);
        if (suppressedExceptions.size() < 5) {
            suppressedExceptions.add(t);
        }
    }

    private static void asyncRename(TrinoFileSystem fileSystem, Executor executor, AtomicBoolean cancelled, List<CompletableFuture<?>> fileRenameFutures, Location currentPath, Location targetPath, List<String> fileNames) {
        for (String fileName : fileNames) {
            Location source = currentPath.appendPath(fileName);
            Location target = targetPath.appendPath(fileName);
            fileRenameFutures.add(CompletableFuture.runAsync(() -> {
                if (cancelled.get()) {
                    return;
                }
                try {
                    fileSystem.renameFile(source, target);
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files from %s to final location %s", source, target), (Throwable)e);
                }
            }, executor));
        }
    }

    private void recursiveDeleteFilesAndLog(ConnectorIdentity identity, Location directory, Set<String> queryIds, boolean deleteEmptyDirectories, String reason) {
        RecursiveDeleteResult recursiveDeleteResult = SemiTransactionalHiveMetastore.recursiveDeleteFiles(this.fileSystemFactory.create(identity), directory, queryIds, deleteEmptyDirectories);
        if (!recursiveDeleteResult.notDeletedEligibleItems().isEmpty()) {
            SemiTransactionalHiveMetastore.logCleanupFailure("Error deleting directory %s for %s. Some eligible items cannot be deleted: %s.", directory.toString(), reason, recursiveDeleteResult.notDeletedEligibleItems());
        } else if (deleteEmptyDirectories && !recursiveDeleteResult.directoryNoLongerExists()) {
            SemiTransactionalHiveMetastore.logCleanupFailure("Error deleting directory %s for %s. Cannot delete the directory.", directory.toString(), reason);
        }
    }

    private static RecursiveDeleteResult recursiveDeleteFiles(TrinoFileSystem fileSystem, Location directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        try {
            if (!fileSystem.directoryExists(directory).orElse(false).booleanValue()) {
                return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
            }
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(directory.toString() + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        return SemiTransactionalHiveMetastore.doRecursiveDeleteFiles(fileSystem, directory, queryIds, deleteEmptyDirectories);
    }

    private static RecursiveDeleteResult doRecursiveDeleteFiles(TrinoFileSystem fileSystem, Location directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        Set allDirectories;
        if ((directory = SemiTransactionalHiveMetastore.asFileLocation(directory)).fileName().startsWith(".trino")) {
            return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of());
        }
        ArrayList<Location> allFiles = new ArrayList<Location>();
        try {
            FileIterator iterator = fileSystem.listFiles(directory);
            while (iterator.hasNext()) {
                Location location = iterator.next().location();
                String child = location.toString().substring(directory.toString().length());
                while (child.startsWith("/")) {
                    child = child.substring(1);
                }
                if (child.contains("/")) continue;
                allFiles.add(location);
            }
            allDirectories = fileSystem.listDirectories(directory);
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(String.valueOf(directory) + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        boolean allDescendentsDeleted = true;
        ImmutableList.Builder notDeletedEligibleItems = ImmutableList.builder();
        for (Location file : allFiles) {
            String fileName = file.fileName();
            boolean eligible = false;
            if (!fileName.startsWith(".trino")) {
                eligible = queryIds.stream().anyMatch(id -> HiveWriteUtils.isFileCreatedByQuery(fileName, id));
            }
            if (eligible) {
                if (SemiTransactionalHiveMetastore.deleteFileIfExists(fileSystem, file)) continue;
                allDescendentsDeleted = false;
                notDeletedEligibleItems.add((Object)file.toString());
                continue;
            }
            allDescendentsDeleted = false;
        }
        for (Location file : allDirectories) {
            RecursiveDeleteResult subResult = SemiTransactionalHiveMetastore.doRecursiveDeleteFiles(fileSystem, file, queryIds, deleteEmptyDirectories);
            if (!subResult.directoryNoLongerExists()) {
                allDescendentsDeleted = false;
            }
            if (subResult.notDeletedEligibleItems().isEmpty()) continue;
            notDeletedEligibleItems.addAll(subResult.notDeletedEligibleItems());
        }
        if (allDescendentsDeleted && (deleteEmptyDirectories || SemiTransactionalHiveMetastore.isDeltaDirectory(directory))) {
            Verify.verify((boolean)notDeletedEligibleItems.build().isEmpty());
            if (!SemiTransactionalHiveMetastore.deleteEmptyDirectoryIfExists(fileSystem, directory)) {
                return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of((Object)(String.valueOf(directory) + "/")));
            }
            return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
        }
        return new RecursiveDeleteResult(false, (List<String>)notDeletedEligibleItems.build());
    }

    private static boolean isDeltaDirectory(Location directory) {
        return DELTA_DIRECTORY_MATCHER.matcher(SemiTransactionalHiveMetastore.asFileLocation(directory).fileName()).matches();
    }

    private static boolean deleteFileIfExists(TrinoFileSystem fileSystem, Location location) {
        try {
            fileSystem.deleteFile(location);
            return true;
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean deleteEmptyDirectoryIfExists(TrinoFileSystem fileSystem, Location location) {
        try {
            if (fileSystem.listFiles(location).hasNext()) {
                log.warn("Not deleting non-empty directory: %s", new Object[]{location});
                return false;
            }
            fileSystem.deleteDirectory(location);
            return true;
        }
        catch (IOException e) {
            try {
                return fileSystem.directoryExists(location).orElse(false) == false;
            }
            catch (IOException ex) {
                return false;
            }
        }
    }

    private static void renameDirectory(TrinoFileSystem fileSystem, Location source, Location target, Runnable runWhenPathDoesntExist) {
        if (SemiTransactionalHiveMetastore.directoryExists(fileSystem, target)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to rename from %s to %s: target directory already exists", source, target));
        }
        Location parent = SemiTransactionalHiveMetastore.asFileLocation(target).parentDirectory();
        if (!SemiTransactionalHiveMetastore.directoryExists(fileSystem, parent)) {
            SemiTransactionalHiveMetastore.createDirectory(fileSystem, parent);
        }
        runWhenPathDoesntExist.run();
        try {
            fileSystem.renameDirectory(source, target);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s", source, target), (Throwable)e);
        }
    }

    private static void createDirectory(TrinoFileSystem fileSystem, Location directory) {
        try {
            fileSystem.createDirectory(directory);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
        }
    }

    private static boolean directoryExists(TrinoFileSystem fileSystem, Location directory) {
        try {
            return fileSystem.directoryExists(directory).orElse(false);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
        }
    }

    private static Optional<String> getQueryId(Database database) {
        return Optional.ofNullable(database.getParameters().get("trino_query_id"));
    }

    private static Optional<String> getQueryId(Table table) {
        return Optional.ofNullable(table.getParameters().get("trino_query_id"));
    }

    private static Optional<String> getQueryId(Partition partition) {
        return Optional.ofNullable(partition.getParameters().get("trino_query_id"));
    }

    private static Location asFileLocation(Location location) {
        String value = location.toString();
        while (value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        return Location.of((String)value);
    }

    private void checkHoldsLock() {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException(String.format("Thread must hold a lock on the %s", this.getClass().getSimpleName()));
        }
    }

    private long allocateWriteId(String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(dbName, tableName, transactionId);
    }

    private void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isPartitioned) {
        this.delegate.acquireTableWriteLock(transactionOwner, queryId, transactionId, dbName, tableName, operation, isPartitioned);
    }

    private void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        this.delegate.updateTableWriteId(dbName, tableName, transactionId, writeId, rowCountChange);
    }

    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        this.delegate.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation);
    }

    public static void cleanExtraOutputFiles(TrinoFileSystem fileSystem, String queryId, Location path, Set<String> filesToKeep) {
        ArrayList filesToDelete = new ArrayList();
        try {
            Failsafe.with(DELETE_RETRY_POLICY, (Policy[])new RetryPolicy[0]).run(() -> {
                log.debug("Deleting failed attempt files from %s for query %s", new Object[]{path, queryId});
                filesToDelete.clear();
                FileIterator iterator = fileSystem.listFiles(path);
                while (iterator.hasNext()) {
                    Location file = iterator.next().location();
                    if (!HiveWriteUtils.isFileCreatedByQuery(file.fileName(), queryId) || filesToKeep.contains(file.fileName())) continue;
                    filesToDelete.add(file);
                }
                log.debug("Found %s failed attempt file(s) to delete for query %s", new Object[]{filesToDelete.size(), queryId});
                fileSystem.deleteFiles((Collection)filesToDelete);
            });
        }
        catch (FailsafeException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error deleting failed retry attempt files from %s; remaining files %s; manual cleanup may be required", path, filesToDelete), (Throwable)e);
        }
    }

    private static enum State {
        EMPTY,
        SHARED_OPERATION_BUFFERED,
        EXCLUSIVE_OPERATION_BUFFERED,
        FINISHED;

    }

    private record Action<T>(ActionType type, T data, ConnectorIdentity identity, String queryId) {
        private final T data;

        private Action {
            Objects.requireNonNull(type, "type is null");
            if (type == ActionType.DROP || type == ActionType.DROP_PRESERVE_DATA) {
                Preconditions.checkArgument((data == null ? 1 : 0) != 0, (Object)"data is not null");
            } else {
                Objects.requireNonNull(data, "data is null");
            }
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(queryId, "queryId is null");
        }

        public T data() {
            Preconditions.checkState((this.type != ActionType.DROP ? 1 : 0) != 0);
            return this.data;
        }
    }

    private static enum ActionType {
        DROP,
        DROP_PRESERVE_DATA,
        ADD,
        ALTER,
        INSERT_EXISTING,
        MERGE;

    }

    private static class TableAndMore {
        private final Table table;
        private final Optional<PrincipalPrivileges> principalPrivileges;
        private final Optional<Location> currentLocation;
        private final Optional<List<String>> fileNames;
        private final boolean ignoreExisting;
        private final PartitionStatistics statistics;
        private final PartitionStatistics statisticsUpdate;
        private final boolean cleanExtraOutputFilesOnCommit;

        public TableAndMore(Table table, Optional<PrincipalPrivileges> principalPrivileges, Optional<Location> currentLocation, Optional<List<String>> fileNames, boolean ignoreExisting, PartitionStatistics statistics, PartitionStatistics statisticsUpdate, boolean cleanExtraOutputFilesOnCommit) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.principalPrivileges = Objects.requireNonNull(principalPrivileges, "principalPrivileges is null");
            this.currentLocation = Objects.requireNonNull(currentLocation, "currentLocation is null");
            this.fileNames = Objects.requireNonNull(fileNames, "fileNames is null");
            this.ignoreExisting = ignoreExisting;
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.statisticsUpdate = Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
            this.cleanExtraOutputFilesOnCommit = cleanExtraOutputFilesOnCommit;
            Preconditions.checkArgument((!table.getStorage().getOptionalLocation().orElse("").isEmpty() || currentLocation.isEmpty() ? 1 : 0) != 0, (Object)"currentLocation cannot be supplied for table without location");
            Preconditions.checkArgument((fileNames.isEmpty() || currentLocation.isPresent() ? 1 : 0) != 0, (Object)"fileNames can be supplied only when currentLocation is supplied");
        }

        public boolean isIgnoreExisting() {
            return this.ignoreExisting;
        }

        public Table getTable() {
            return this.table;
        }

        public PrincipalPrivileges getPrincipalPrivileges() {
            Preconditions.checkState((boolean)this.principalPrivileges.isPresent());
            return this.principalPrivileges.get();
        }

        public Optional<Location> getCurrentLocation() {
            return this.currentLocation;
        }

        public Optional<List<String>> getFileNames() {
            return this.fileNames;
        }

        public PartitionStatistics getStatistics() {
            return this.statistics;
        }

        public PartitionStatistics getStatisticsUpdate() {
            return this.statisticsUpdate;
        }

        public boolean isCleanExtraOutputFilesOnCommit() {
            return this.cleanExtraOutputFilesOnCommit;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("principalPrivileges", this.principalPrivileges).add("currentLocation", this.currentLocation).add("fileNames", this.fileNames).add("ignoreExisting", this.ignoreExisting).add("statistics", (Object)this.statistics).add("statisticsUpdate", (Object)this.statisticsUpdate).add("cleanExtraOutputFilesOnCommit", this.cleanExtraOutputFilesOnCommit).toString();
        }
    }

    private static enum TableSource {
        CREATED_IN_THIS_TRANSACTION,
        PRE_EXISTING_TABLE;

    }

    private record PartitionAndMore(Partition partition, Location currentLocation, Optional<List<String>> fileNames, PartitionStatistics statistics, PartitionStatistics statisticsUpdate, boolean cleanExtraOutputFilesOnCommit) {
        private PartitionAndMore {
            Objects.requireNonNull(partition, "partition is null");
            Objects.requireNonNull(currentLocation, "currentLocation is null");
            Objects.requireNonNull(fileNames, "fileNames is null");
            Objects.requireNonNull(statistics, "statistics is null");
            Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
        }

        public List<String> getFileNames() {
            Preconditions.checkState((boolean)this.fileNames.isPresent());
            return this.fileNames.get();
        }

        public boolean hasFileNames() {
            return this.fileNames.isPresent();
        }

        public Partition getAugmentedPartitionForInTransactionRead() {
            Partition partition = this.partition;
            String currentLocation = this.currentLocation.toString();
            if (!currentLocation.equals(partition.getStorage().getLocation())) {
                partition = Partition.builder(partition).withStorage(storage -> storage.setLocation(currentLocation)).build();
            }
            return partition;
        }
    }

    private static interface ExclusiveOperation {
        public void execute(HiveMetastoreClosure var1);
    }

    private static class TableAndMergeResults
    extends TableAndMore {
        private final List<PartitionUpdateAndMergeResults> partitionMergeResults;

        public TableAndMergeResults(Table table, Optional<PrincipalPrivileges> principalPrivileges, Optional<Location> currentLocation, List<PartitionUpdateAndMergeResults> partitionMergeResults) {
            super(table, principalPrivileges, currentLocation, Optional.empty(), false, PartitionStatistics.empty(), PartitionStatistics.empty(), false);
            this.partitionMergeResults = Objects.requireNonNull(partitionMergeResults, "partitionMergeResults is null");
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.getTable()).add("partitionMergeResults", this.partitionMergeResults).add("principalPrivileges", (Object)this.getPrincipalPrivileges()).add("currentLocation", this.getCurrentLocation()).toString();
        }
    }

    public record PartitionUpdateInfo(List<String> partitionValues, Location currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate) {
        public PartitionUpdateInfo {
            Objects.requireNonNull(partitionValues, "partitionValues is null");
            Objects.requireNonNull(currentLocation, "currentLocation is null");
            Objects.requireNonNull(fileNames, "fileNames is null");
            Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
        }
    }

    public record DeclaredIntentionToWrite(String declarationId, LocationHandle.WriteMode mode, ConnectorIdentity identity, String queryId, Location rootPath, SchemaTableName schemaTableName) {
        public DeclaredIntentionToWrite {
            Objects.requireNonNull(declarationId, "declarationId is null");
            Objects.requireNonNull(mode, "mode is null");
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(queryId, "queryId is null");
            Objects.requireNonNull(rootPath, "rootPath is null");
            Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }
    }

    private class Committer {
        private final AtomicBoolean fileSystemOperationsCancelled = new AtomicBoolean(false);
        private final List<CompletableFuture<?>> fileSystemOperationFutures = new ArrayList();
        private final List<DirectoryDeletionTask> deletionTasksForFinish = new ArrayList<DirectoryDeletionTask>();
        private final List<DirectoryRenameTask> renameTasksForAbort = new ArrayList<DirectoryRenameTask>();
        private final Queue<DirectoryCleanUpTask> cleanUpTasksForAbort = new ConcurrentLinkedQueue<DirectoryCleanUpTask>();
        private final Set<Table> tablesToInvalidate = new LinkedHashSet<Table>();
        private final Set<Partition> partitionsToInvalidate = new LinkedHashSet<Partition>();
        private final List<CreateTableOperation> addTableOperations = new ArrayList<CreateTableOperation>();
        private final List<AlterTableOperation> alterTableOperations = new ArrayList<AlterTableOperation>();
        private final Map<SchemaTableName, PartitionAdder> partitionAdders = new HashMap<SchemaTableName, PartitionAdder>();
        private final List<AlterPartitionOperation> alterPartitionOperations = new ArrayList<AlterPartitionOperation>();
        private final List<UpdateStatisticsOperation> updateStatisticsOperations = new ArrayList<UpdateStatisticsOperation>();
        private final List<IrreversibleMetastoreOperation> metastoreDeleteOperations = new ArrayList<IrreversibleMetastoreOperation>();
        private final AcidTransaction transaction;
        private boolean deleteOnly = true;

        Committer(AcidTransaction transaction) {
            this.transaction = transaction;
        }

        private void prepareDropTable(SchemaTableName schemaTableName) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop table %s", schemaTableName), () -> {
                Optional<Table> droppedTable = SemiTransactionalHiveMetastore.this.delegate.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
                try {
                    SemiTransactionalHiveMetastore.this.delegate.dropTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), true);
                }
                finally {
                    droppedTable.ifPresent(SemiTransactionalHiveMetastore.this.tableInvalidationCallback::invalidate);
                }
            }));
        }

        private void prepareAlterTable(ConnectorIdentity identity, String queryId, TableAndMore tableAndMore) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            Location targetLocation = Location.of((String)table.getStorage().getLocation());
            Table oldTable = SemiTransactionalHiveMetastore.this.delegate.getTable(table.getDatabaseName(), table.getTableName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "The table that this transaction modified was deleted in another transaction. " + String.valueOf(table.getSchemaTableName())));
            Location oldTableLocation = Location.of((String)oldTable.getStorage().getLocation());
            this.tablesToInvalidate.add(oldTable);
            this.cleanExtraOutputFiles(identity, queryId, tableAndMore);
            if (targetLocation.equals((Object)oldTableLocation)) {
                Location location = SemiTransactionalHiveMetastore.asFileLocation(oldTableLocation);
                Location oldTableStagingPath = location.parentDirectory().appendPath("_temp_" + location.fileName() + "_" + queryId);
                SemiTransactionalHiveMetastore.renameDirectory(SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity), oldTableLocation, oldTableStagingPath, () -> this.renameTasksForAbort.add(new DirectoryRenameTask(identity, oldTableStagingPath, oldTableLocation)));
                if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                    this.deletionTasksForFinish.add(new DirectoryDeletionTask(identity, oldTableStagingPath));
                }
            } else if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                this.deletionTasksForFinish.add(new DirectoryDeletionTask(identity, oldTableLocation));
            }
            Location currentLocation = tableAndMore.getCurrentLocation().orElseThrow(() -> new IllegalArgumentException("location should be present for alter table"));
            if (!targetLocation.equals((Object)currentLocation)) {
                SemiTransactionalHiveMetastore.renameDirectory(SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity), currentLocation, targetLocation, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(identity, targetLocation, true)));
            }
            this.alterTableOperations.add(new AlterTableOperation(tableAndMore.getTable(), oldTable, tableAndMore.getPrincipalPrivileges()));
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), false));
        }

        private void prepareAddTable(ConnectorIdentity identity, String queryId, TableAndMore tableAndMore) {
            Optional<Location> targetLocation;
            this.deleteOnly = false;
            this.cleanExtraOutputFiles(identity, queryId, tableAndMore);
            Table table = tableAndMore.getTable();
            if (table.getTableType().equals(TableType.MANAGED_TABLE.name()) && (targetLocation = table.getStorage().getOptionalLocation().map(Location::of)).isPresent()) {
                Optional<Location> currentLocation = tableAndMore.getCurrentLocation();
                Location targetPath = targetLocation.get();
                TrinoFileSystem fileSystem = SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity);
                if (table.getPartitionColumns().isEmpty() && currentLocation.isPresent()) {
                    if (!targetPath.equals((Object)currentLocation.get())) {
                        SemiTransactionalHiveMetastore.renameDirectory(fileSystem, currentLocation.get(), targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(identity, targetPath, true)));
                    }
                } else if (SemiTransactionalHiveMetastore.directoryExists(fileSystem, targetPath)) {
                    if (!currentLocation.isPresent() || !currentLocation.get().equals((Object)targetPath)) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to create directory %s: target directory already exists", targetPath));
                    }
                } else {
                    this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(identity, targetPath, true));
                    SemiTransactionalHiveMetastore.createDirectory(fileSystem, targetPath);
                }
            }
            this.addTableOperations.add(new CreateTableOperation(table, tableAndMore.getPrincipalPrivileges(), tableAndMore.isIgnoreExisting(), tableAndMore.getStatisticsUpdate()));
        }

        private void prepareInsertExistingTable(ConnectorIdentity identity, String queryId, TableAndMore tableAndMore) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            Location targetPath = Location.of((String)table.getStorage().getLocation());
            this.tablesToInvalidate.add(table);
            Location currentPath = tableAndMore.getCurrentLocation().orElseThrow();
            this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(identity, targetPath, false));
            if (!targetPath.equals((Object)currentPath)) {
                TrinoFileSystem fileSystem = SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity);
                SemiTransactionalHiveMetastore.asyncRename(fileSystem, SemiTransactionalHiveMetastore.this.fileSystemExecutor, this.fileSystemOperationsCancelled, this.fileSystemOperationFutures, currentPath, targetPath, tableAndMore.getFileNames().orElseThrow());
            } else {
                this.cleanExtraOutputFiles(identity, queryId, tableAndMore);
            }
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), true));
            if (SemiTransactionalHiveMetastore.this.isAcidTransactionRunning()) {
                AcidTransaction transaction = SemiTransactionalHiveMetastore.this.getRequiredAcidTransaction();
                SemiTransactionalHiveMetastore.this.updateTableWriteId(table.getDatabaseName(), table.getTableName(), transaction.getAcidTransactionId(), transaction.getWriteId(), OptionalLong.empty());
            }
        }

        private void prepareMergeExistingTable(ConnectorIdentity identity, TableAndMore tableAndMore) {
            AcidTransaction transaction = SemiTransactionalHiveMetastore.this.getRequiredAcidTransaction();
            Preconditions.checkArgument((boolean)transaction.isMerge(), (String)"transaction should be merge, but is %s", (Object)transaction);
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            Location targetPath = Location.of((String)table.getStorage().getLocation());
            Location currentPath = tableAndMore.getCurrentLocation().orElseThrow();
            this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(identity, targetPath, false));
            if (!targetPath.equals((Object)currentPath)) {
                TrinoFileSystem fileSystem = SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity);
                SemiTransactionalHiveMetastore.asyncRename(fileSystem, SemiTransactionalHiveMetastore.this.fileSystemExecutor, this.fileSystemOperationsCancelled, this.fileSystemOperationFutures, currentPath, targetPath, tableAndMore.getFileNames().orElseThrow());
            }
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), true));
            SemiTransactionalHiveMetastore.this.updateTableWriteId(table.getDatabaseName(), table.getTableName(), transaction.getAcidTransactionId(), transaction.getWriteId(), OptionalLong.empty());
        }

        private void prepareDropPartition(SchemaTableName schemaTableName, List<String> partitionValues, boolean deleteData) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop partition %s.%s %s", schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues), () -> {
                Optional<Partition> droppedPartition = SemiTransactionalHiveMetastore.this.delegate.getPartition(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues);
                try {
                    SemiTransactionalHiveMetastore.this.delegate.dropPartition(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues, deleteData);
                }
                finally {
                    droppedPartition.ifPresent(SemiTransactionalHiveMetastore.this.tableInvalidationCallback::invalidate);
                }
            }));
        }

        private void prepareAlterPartition(ConnectorIdentity identity, String queryId, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.partition();
            this.partitionsToInvalidate.add(partition);
            String targetLocation = partition.getStorage().getLocation();
            Partition oldPartition = SemiTransactionalHiveMetastore.this.delegate.getPartition(partition.getDatabaseName(), partition.getTableName(), partition.getValues()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues())));
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            PartitionStatistics oldPartitionStatistics = this.getExistingPartitionStatistics(partition, partitionName);
            String oldPartitionLocation = oldPartition.getStorage().getLocation();
            Location oldPartitionPath = SemiTransactionalHiveMetastore.asFileLocation(Location.of((String)oldPartitionLocation));
            this.cleanExtraOutputFiles(identity, queryId, partitionAndMore);
            if (targetLocation.equals(oldPartitionLocation)) {
                Location oldPartitionStagingPath = oldPartitionPath.sibling("_temp_" + oldPartitionPath.fileName() + "_" + queryId);
                SemiTransactionalHiveMetastore.renameDirectory(SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity), oldPartitionPath, oldPartitionStagingPath, () -> this.renameTasksForAbort.add(new DirectoryRenameTask(identity, oldPartitionStagingPath, oldPartitionPath)));
                if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                    this.deletionTasksForFinish.add(new DirectoryDeletionTask(identity, oldPartitionStagingPath));
                }
            } else if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                this.deletionTasksForFinish.add(new DirectoryDeletionTask(identity, oldPartitionPath));
            }
            Location currentPath = partitionAndMore.currentLocation();
            Location targetPath = Location.of((String)targetLocation);
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.renameDirectory(SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity), currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(identity, targetPath, true)));
            }
            this.alterPartitionOperations.add(new AlterPartitionOperation(new PartitionWithStatistics(partition, partitionName, partitionAndMore.statisticsUpdate()), new PartitionWithStatistics(oldPartition, partitionName, oldPartitionStatistics)));
        }

        private void cleanExtraOutputFiles(ConnectorIdentity identity, String queryId, PartitionAndMore partitionAndMore) {
            if (!partitionAndMore.cleanExtraOutputFilesOnCommit()) {
                return;
            }
            Verify.verify((boolean)partitionAndMore.hasFileNames(), (String)"fileNames expected to be set if isCleanExtraOutputFilesOnCommit is true", (Object[])new Object[0]);
            TrinoFileSystem fileSystem = SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity);
            SemiTransactionalHiveMetastore.cleanExtraOutputFiles(fileSystem, queryId, partitionAndMore.currentLocation(), (Set<String>)ImmutableSet.copyOf(partitionAndMore.getFileNames()));
        }

        private void cleanExtraOutputFiles(ConnectorIdentity identity, String queryId, TableAndMore tableAndMore) {
            if (!tableAndMore.isCleanExtraOutputFilesOnCommit()) {
                return;
            }
            TrinoFileSystem fileSystem = SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity);
            Location tableLocation = tableAndMore.getCurrentLocation().orElseThrow(() -> new IllegalArgumentException("currentLocation expected to be set if isCleanExtraOutputFilesOnCommit is true"));
            List<String> files = tableAndMore.getFileNames().orElseThrow(() -> new IllegalArgumentException("fileNames expected to be set if isCleanExtraOutputFilesOnCommit is true"));
            SemiTransactionalHiveMetastore.cleanExtraOutputFiles(fileSystem, queryId, tableLocation, (Set<String>)ImmutableSet.copyOf(files));
        }

        private PartitionStatistics getExistingPartitionStatistics(Partition partition, String partitionName) {
            try {
                HiveBasicStatistics basicStatistics = MetastoreUtil.getHiveBasicStatistics(partition.getParameters());
                Map<String, HiveColumnStatistics> columnStatistics = SemiTransactionalHiveMetastore.this.delegate.getPartitionColumnStatistics(partition.getDatabaseName(), partition.getTableName(), (Set<String>)ImmutableSet.of((Object)partitionName), (Set)partition.getColumns().stream().map(Column::getName).collect(ImmutableSet.toImmutableSet())).get(partitionName);
                if (columnStatistics == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues()));
                }
                return new PartitionStatistics(basicStatistics, columnStatistics);
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode())) {
                    log.warn((Throwable)e, "Corrupted statistics found when altering partition. Table: %s.%s. Partition: %s", new Object[]{partition.getDatabaseName(), partition.getTableName(), partition.getValues()});
                    return PartitionStatistics.empty();
                }
                throw e;
            }
        }

        private void prepareAddPartition(ConnectorIdentity identity, String queryId, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.partition();
            String targetLocation = partition.getStorage().getLocation();
            Location currentPath = partitionAndMore.currentLocation();
            Location targetPath = Location.of((String)targetLocation);
            this.cleanExtraOutputFiles(identity, queryId, partitionAndMore);
            PartitionAdder partitionAdder = this.partitionAdders.computeIfAbsent(partition.getSchemaTableName(), ignored -> new PartitionAdder(partition.getDatabaseName(), partition.getTableName(), SemiTransactionalHiveMetastore.this.delegate, 20));
            this.fileSystemOperationFutures.add(CompletableFuture.runAsync(() -> {
                if (this.fileSystemOperationsCancelled.get()) {
                    return;
                }
                TrinoFileSystem fileSystem = SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity);
                if (SemiTransactionalHiveMetastore.directoryExists(fileSystem, currentPath)) {
                    if (!targetPath.equals((Object)currentPath)) {
                        SemiTransactionalHiveMetastore.renameDirectory(fileSystem, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(identity, targetPath, true)));
                    }
                } else {
                    this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(identity, targetPath, true));
                    SemiTransactionalHiveMetastore.createDirectory(fileSystem, targetPath);
                }
            }, SemiTransactionalHiveMetastore.this.fileSystemExecutor));
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            partitionAdder.addPartition(new PartitionWithStatistics(partition, partitionName, partitionAndMore.statisticsUpdate()));
        }

        private void prepareInsertExistingPartition(ConnectorIdentity identity, String queryId, PartitionAndMore partitionAndMore) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.partition();
            this.partitionsToInvalidate.add(partition);
            Location targetPath = Location.of((String)partition.getStorage().getLocation());
            Location currentPath = partitionAndMore.currentLocation();
            this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(identity, targetPath, false));
            if (!targetPath.equals((Object)currentPath)) {
                TrinoFileSystem fileSystem = SemiTransactionalHiveMetastore.this.fileSystemFactory.create(identity);
                SemiTransactionalHiveMetastore.asyncRename(fileSystem, SemiTransactionalHiveMetastore.this.fileSystemExecutor, this.fileSystemOperationsCancelled, this.fileSystemOperationFutures, currentPath, targetPath, partitionAndMore.getFileNames());
            } else {
                this.cleanExtraOutputFiles(identity, queryId, partitionAndMore);
            }
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(partition.getSchemaTableName(), Optional.of(SemiTransactionalHiveMetastore.this.getPartitionName(partition.getDatabaseName(), partition.getTableName(), partition.getValues())), partitionAndMore.statisticsUpdate(), true));
        }

        private void executeCleanupTasksForAbort(Collection<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            Set queryIds = (Set)declaredIntentionsToWrite.stream().map(DeclaredIntentionToWrite::queryId).collect(ImmutableSet.toImmutableSet());
            for (DirectoryCleanUpTask cleanUpTask : this.cleanUpTasksForAbort) {
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(cleanUpTask.identity(), cleanUpTask.location(), queryIds, cleanUpTask.deleteEmptyDirectory(), "temporary directory commit abort");
            }
        }

        private void executeDeletionTasksForFinish() {
            for (DirectoryDeletionTask deletionTask : this.deletionTasksForFinish) {
                TrinoFileSystem fileSystem = SemiTransactionalHiveMetastore.this.fileSystemFactory.create(deletionTask.identity());
                try {
                    fileSystem.deleteDirectory(deletionTask.location());
                }
                catch (IOException e) {
                    SemiTransactionalHiveMetastore.logCleanupFailure(e, "Error deleting directory: %s", deletionTask.location());
                }
            }
        }

        private void executeRenameTasksForAbort() {
            for (DirectoryRenameTask directoryRenameTask : this.renameTasksForAbort) {
                try {
                    TrinoFileSystem fileSystem = SemiTransactionalHiveMetastore.this.fileSystemFactory.create(directoryRenameTask.identity());
                    if (!SemiTransactionalHiveMetastore.directoryExists(fileSystem, directoryRenameTask.renameFrom())) continue;
                    SemiTransactionalHiveMetastore.renameDirectory(fileSystem, directoryRenameTask.renameFrom(), directoryRenameTask.renameTo(), () -> {});
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.logCleanupFailure(throwable, "failed to undo rename of partition directory: %s to %s", directoryRenameTask.renameFrom(), directoryRenameTask.renameTo());
                }
            }
        }

        private void pruneAndDeleteStagingDirectories(List<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            for (DeclaredIntentionToWrite declaredIntentionToWrite : declaredIntentionsToWrite) {
                if (declaredIntentionToWrite.mode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) continue;
                Set queryIds = (Set)declaredIntentionsToWrite.stream().map(DeclaredIntentionToWrite::queryId).collect(ImmutableSet.toImmutableSet());
                Location path = declaredIntentionToWrite.rootPath();
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.identity(), path, queryIds, true, "staging directory cleanup");
            }
        }

        private void waitForAsyncFileSystemOperations() {
            for (CompletableFuture<?> future : this.fileSystemOperationFutures) {
                MoreFutures.getFutureValue(future, TrinoException.class);
            }
        }

        private void waitForAsyncFileSystemOperationSuppressThrowable() {
            for (CompletableFuture<?> future : this.fileSystemOperationFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {}
            }
        }

        private void cancelUnstartedAsyncFileSystemOperations() {
            this.fileSystemOperationsCancelled.set(true);
        }

        private void executeAddTableOperations(AcidTransaction transaction) {
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                addTableOperation.run(SemiTransactionalHiveMetastore.this.delegate, transaction);
            }
        }

        private void executeAlterTableOperations() {
            for (AlterTableOperation alterTableOperation : this.alterTableOperations) {
                alterTableOperation.run(SemiTransactionalHiveMetastore.this.delegate, this.transaction);
            }
        }

        private void executeAlterPartitionOperations() {
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                alterPartitionOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAddPartitionOperations(AcidTransaction transaction) {
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                partitionAdder.execute(transaction);
            }
        }

        private void executeUpdateStatisticsOperations(AcidTransaction transaction) {
            ImmutableList.Builder executeUpdateFutures = ImmutableList.builder();
            ArrayList failedUpdateStatisticsOperationDescriptions = new ArrayList();
            ArrayList suppressedExceptions = new ArrayList();
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                executeUpdateFutures.add(CompletableFuture.runAsync(() -> {
                    try {
                        operation.run(SemiTransactionalHiveMetastore.this.delegate, transaction);
                    }
                    catch (Throwable t) {
                        List list = failedUpdateStatisticsOperationDescriptions;
                        synchronized (list) {
                            SemiTransactionalHiveMetastore.addSuppressedExceptions(suppressedExceptions, t, failedUpdateStatisticsOperationDescriptions, operation.getDescription());
                        }
                    }
                }, SemiTransactionalHiveMetastore.this.updateExecutor));
            }
            for (CompletableFuture executeUpdateFuture : executeUpdateFutures.build()) {
                MoreFutures.getFutureValue((Future)executeUpdateFuture);
            }
            if (!suppressedExceptions.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append("All operations other than the following update operations were completed: ");
                Joiner.on((String)"; ").appendTo(message, failedUpdateStatisticsOperationDescriptions);
                TrinoException trinoException = new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, message.toString());
                suppressedExceptions.forEach(trinoException::addSuppressed);
                throw trinoException;
            }
        }

        private void executeTableInvalidationCallback() {
            this.tablesToInvalidate.forEach(SemiTransactionalHiveMetastore.this.tableInvalidationCallback::invalidate);
            this.partitionsToInvalidate.forEach(SemiTransactionalHiveMetastore.this.tableInvalidationCallback::invalidate);
        }

        private void undoAddPartitionOperations() {
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                List<List<String>> partitionsFailedToRollback = partitionAdder.rollback();
                if (partitionsFailedToRollback.isEmpty()) continue;
                SemiTransactionalHiveMetastore.logCleanupFailure("Failed to rollback: add_partition for partitions %s.%s %s", partitionAdder.getSchemaName(), partitionAdder.getTableName(), partitionsFailedToRollback);
            }
        }

        private void undoAddTableOperations() {
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                try {
                    addTableOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.logCleanupFailure(throwable, "failed to rollback: %s", addTableOperation.getDescription());
                }
            }
        }

        private void undoAlterTableOperations() {
            for (AlterTableOperation alterTableOperation : this.alterTableOperations) {
                try {
                    alterTableOperation.undo(SemiTransactionalHiveMetastore.this.delegate, this.transaction);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.logCleanupFailure(throwable, "failed to rollback: %s", alterTableOperation.getDescription());
                }
            }
        }

        private void undoAlterPartitionOperations() {
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                try {
                    alterPartitionOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.logCleanupFailure(throwable, "failed to rollback: %s", alterPartitionOperation.getDescription());
                }
            }
        }

        private void undoUpdateStatisticsOperations(AcidTransaction transaction) {
            ImmutableList.Builder undoUpdateFutures = ImmutableList.builder();
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                undoUpdateFutures.add(CompletableFuture.runAsync(() -> {
                    try {
                        operation.undo(SemiTransactionalHiveMetastore.this.delegate, transaction);
                    }
                    catch (Throwable throwable) {
                        SemiTransactionalHiveMetastore.logCleanupFailure(throwable, "failed to rollback: %s", operation.getDescription());
                    }
                }, SemiTransactionalHiveMetastore.this.updateExecutor));
            }
            for (CompletableFuture undoUpdateFuture : undoUpdateFutures.build()) {
                MoreFutures.getFutureValue((Future)undoUpdateFuture);
            }
        }

        private void executeIrreversibleMetastoreOperations() {
            ArrayList failedIrreversibleOperationDescriptions = new ArrayList();
            ArrayList suppressedExceptions = new ArrayList();
            AtomicBoolean anySucceeded = new AtomicBoolean(false);
            ImmutableList.Builder dropFutures = ImmutableList.builder();
            for (IrreversibleMetastoreOperation irreversibleMetastoreOperation : this.metastoreDeleteOperations) {
                dropFutures.add(CompletableFuture.runAsync(() -> {
                    try {
                        irreversibleMetastoreOperation.run();
                        anySucceeded.set(true);
                    }
                    catch (Throwable t) {
                        List list = failedIrreversibleOperationDescriptions;
                        synchronized (list) {
                            SemiTransactionalHiveMetastore.addSuppressedExceptions(suppressedExceptions, t, failedIrreversibleOperationDescriptions, irreversibleMetastoreOperation.description());
                        }
                    }
                }, SemiTransactionalHiveMetastore.this.dropExecutor));
            }
            for (CompletableFuture dropFuture : dropFutures.build()) {
                MoreFutures.getFutureValue((Future)dropFuture);
            }
            if (!suppressedExceptions.isEmpty()) {
                StringBuilder message = new StringBuilder();
                if (this.deleteOnly && !anySucceeded.get()) {
                    message.append("The following metastore delete operations failed: ");
                } else {
                    message.append("The transaction didn't commit cleanly. All operations other than the following delete operations were completed: ");
                }
                Joiner.on((String)"; ").appendTo(message, failedIrreversibleOperationDescriptions);
                TrinoException trinoException = new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, message.toString());
                suppressedExceptions.forEach(trinoException::addSuppressed);
                throw trinoException;
            }
        }
    }

    private record RecursiveDeleteResult(boolean directoryNoLongerExists, List<String> notDeletedEligibleItems) {
    }

    private static class PartitionAdder {
        private final String schemaName;
        private final String tableName;
        private final HiveMetastoreClosure metastore;
        private final int batchSize;
        private final List<PartitionWithStatistics> partitions;
        private List<List<String>> createdPartitionValues = new ArrayList<List<String>>();

        public PartitionAdder(String schemaName, String tableName, HiveMetastoreClosure metastore, int batchSize) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.metastore = metastore;
            this.batchSize = batchSize;
            this.partitions = new ArrayList<PartitionWithStatistics>(batchSize);
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void addPartition(PartitionWithStatistics partition) {
            Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getQueryId(partition.getPartition()).isPresent());
            this.partitions.add(partition);
        }

        public void execute(AcidTransaction transaction) {
            List batchedPartitions = Lists.partition(this.partitions, (int)this.batchSize);
            for (List batch : batchedPartitions) {
                try {
                    this.metastore.addPartitions(this.schemaName, this.tableName, batch);
                    for (PartitionWithStatistics partition : batch) {
                        this.createdPartitionValues.add(partition.getPartition().getValues());
                    }
                }
                catch (Throwable t) {
                    boolean batchCompletelyAdded = true;
                    for (PartitionWithStatistics partition : batch) {
                        try {
                            Optional<Partition> remotePartition = this.metastore.getPartition(this.schemaName, this.tableName, partition.getPartition().getValues());
                            if (remotePartition.isPresent() && SemiTransactionalHiveMetastore.getQueryId(remotePartition.get()).equals(SemiTransactionalHiveMetastore.getQueryId(partition.getPartition()))) {
                                this.createdPartitionValues.add(partition.getPartition().getValues());
                                continue;
                            }
                            batchCompletelyAdded = false;
                        }
                        catch (Throwable ignored) {
                            batchCompletelyAdded = false;
                        }
                    }
                    if (batchCompletelyAdded) continue;
                    if (t instanceof TableNotFoundException) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY, t);
                    }
                    throw t;
                }
            }
            if (transaction.isAcidTransactionRunning()) {
                List<String> partitionNames = this.partitions.stream().map(PartitionWithStatistics::getPartitionName).toList();
                this.metastore.addDynamicPartitions(this.schemaName, this.tableName, partitionNames, transaction.getAcidTransactionId(), transaction.getWriteId(), transaction.getOperation());
            }
            this.partitions.clear();
        }

        public List<List<String>> rollback() {
            ArrayList<List<String>> partitionsFailedToRollback = new ArrayList<List<String>>();
            for (List<String> createdPartitionValue : this.createdPartitionValues) {
                try {
                    this.metastore.dropPartition(this.schemaName, this.tableName, createdPartitionValue, false);
                }
                catch (PartitionNotFoundException partitionNotFoundException) {
                }
                catch (Throwable t) {
                    partitionsFailedToRollback.add(createdPartitionValue);
                }
            }
            this.createdPartitionValues = partitionsFailedToRollback;
            return partitionsFailedToRollback;
        }
    }

    private static class UpdateStatisticsOperation {
        private final SchemaTableName tableName;
        private final Optional<String> partitionName;
        private final PartitionStatistics statistics;
        private final boolean merge;
        private boolean done;

        public UpdateStatisticsOperation(SchemaTableName tableName, Optional<String> partitionName, PartitionStatistics statistics, boolean merge) {
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.merge = merge;
        }

        public void run(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            StatisticsUpdateMode mode;
            StatisticsUpdateMode statisticsUpdateMode = mode = this.merge ? StatisticsUpdateMode.MERGE_INCREMENTAL : StatisticsUpdateMode.OVERWRITE_ALL;
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.tableName.getSchemaName(), this.tableName.getTableName(), mode, (Map<String, PartitionStatistics>)ImmutableMap.of((Object)this.partitionName.get(), (Object)this.statistics));
            } else {
                metastore.updateTableStatistics(this.tableName.getSchemaName(), this.tableName.getTableName(), transaction, mode, this.statistics);
            }
            this.done = true;
        }

        public void undo(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            if (!this.done) {
                return;
            }
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.tableName.getSchemaName(), this.tableName.getTableName(), StatisticsUpdateMode.UNDO_MERGE_INCREMENTAL, (Map<String, PartitionStatistics>)ImmutableMap.of((Object)this.partitionName.get(), (Object)this.statistics));
            } else {
                metastore.updateTableStatistics(this.tableName.getSchemaName(), this.tableName.getTableName(), transaction, StatisticsUpdateMode.UNDO_MERGE_INCREMENTAL, this.statistics);
            }
        }

        public String getDescription() {
            if (this.partitionName.isPresent()) {
                return String.format("replace partition parameters %s %s", this.tableName, this.partitionName.get());
            }
            return String.format("replace table parameters %s", this.tableName);
        }
    }

    private static class AlterPartitionOperation {
        private final PartitionWithStatistics newPartition;
        private final PartitionWithStatistics oldPartition;
        private boolean undo;

        public AlterPartitionOperation(PartitionWithStatistics newPartition, PartitionWithStatistics oldPartition) {
            this.newPartition = Objects.requireNonNull(newPartition, "newPartition is null");
            this.oldPartition = Objects.requireNonNull(oldPartition, "oldPartition is null");
            Preconditions.checkArgument((boolean)newPartition.getPartition().getDatabaseName().equals(oldPartition.getPartition().getDatabaseName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getTableName().equals(oldPartition.getPartition().getTableName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getValues().equals(oldPartition.getPartition().getValues()));
        }

        public String getDescription() {
            return String.format("alter partition %s.%s %s", this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition.getPartition().getValues());
        }

        public void run(HiveMetastoreClosure metastore) {
            this.undo = true;
            metastore.alterPartition(this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition);
        }

        public void undo(HiveMetastoreClosure metastore) {
            if (!this.undo) {
                return;
            }
            metastore.alterPartition(this.oldPartition.getPartition().getDatabaseName(), this.oldPartition.getPartition().getTableName(), this.oldPartition);
        }
    }

    private static class AlterTableOperation {
        private final Table newTable;
        private final Table oldTable;
        private final PrincipalPrivileges principalPrivileges;
        private boolean undo;

        public AlterTableOperation(Table newTable, Table oldTable, PrincipalPrivileges principalPrivileges) {
            this.newTable = Objects.requireNonNull(newTable, "newTable is null");
            this.oldTable = Objects.requireNonNull(oldTable, "oldTable is null");
            this.principalPrivileges = Objects.requireNonNull(principalPrivileges, "principalPrivileges is null");
            Preconditions.checkArgument((boolean)newTable.getDatabaseName().equals(oldTable.getDatabaseName()));
            Preconditions.checkArgument((boolean)newTable.getTableName().equals(oldTable.getTableName()));
        }

        public String getDescription() {
            return String.format("alter table %s.%s", this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public void run(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            this.undo = true;
            if (transaction.isTransactional()) {
                metastore.alterTransactionalTable(this.newTable, transaction.getAcidTransactionId(), transaction.getWriteId(), this.principalPrivileges);
            } else {
                metastore.replaceTable(this.newTable.getDatabaseName(), this.newTable.getTableName(), this.newTable, this.principalPrivileges);
            }
        }

        public void undo(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            if (!this.undo) {
                return;
            }
            if (transaction.isTransactional()) {
                metastore.alterTransactionalTable(this.oldTable, transaction.getAcidTransactionId(), transaction.getWriteId(), this.principalPrivileges);
            } else {
                metastore.replaceTable(this.oldTable.getDatabaseName(), this.oldTable.getTableName(), this.oldTable, this.principalPrivileges);
            }
        }
    }

    private static class CreateTableOperation {
        private final Table newTable;
        private final PrincipalPrivileges privileges;
        private boolean tableCreated;
        private final boolean ignoreExisting;
        private final PartitionStatistics statistics;
        private final String queryId;

        public CreateTableOperation(Table newTable, PrincipalPrivileges privileges, boolean ignoreExisting, PartitionStatistics statistics) {
            Objects.requireNonNull(newTable, "newTable is null");
            this.newTable = newTable;
            this.privileges = Objects.requireNonNull(privileges, "privileges is null");
            this.ignoreExisting = ignoreExisting;
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.queryId = SemiTransactionalHiveMetastore.getQueryId(newTable).orElseThrow(() -> new IllegalArgumentException("Query id is not present"));
        }

        public String getDescription() {
            return String.format("add table %s.%s", this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public void run(HiveMetastoreClosure metastore, AcidTransaction transaction) {
            boolean created;
            block11: {
                created = false;
                try {
                    metastore.createTable(this.newTable, this.privileges);
                    created = true;
                }
                catch (RuntimeException e) {
                    Throwable failure = e;
                    try {
                        Optional<Table> existingTable = metastore.getTable(this.newTable.getDatabaseName(), this.newTable.getTableName());
                        if (existingTable.isPresent()) {
                            Table table = existingTable.get();
                            Optional<String> existingTableQueryId = SemiTransactionalHiveMetastore.getQueryId(table);
                            if (existingTableQueryId.isPresent() && existingTableQueryId.get().equals(this.queryId)) {
                                failure = null;
                                created = true;
                            } else if (!CreateTableOperation.hasTheSameSchema(this.newTable, table)) {
                                failure = new TrinoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table already exists with a different schema: '%s'", this.newTable.getTableName()));
                            } else if (this.ignoreExisting) {
                                failure = null;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    if (failure == null) break block11;
                    throw failure;
                }
            }
            this.tableCreated = true;
            if (created && !ViewReaderUtil.isTrinoView(this.newTable) && !ViewReaderUtil.isTrinoMaterializedView(this.newTable)) {
                metastore.updateTableStatistics(this.newTable.getDatabaseName(), this.newTable.getTableName(), transaction, StatisticsUpdateMode.OVERWRITE_ALL, this.statistics);
            }
        }

        private static boolean hasTheSameSchema(Table newTable, Table existingTable) {
            List<Column> newTableColumns = newTable.getDataColumns();
            List<Column> existingTableColumns = existingTable.getDataColumns();
            if (newTableColumns.size() != existingTableColumns.size()) {
                return false;
            }
            for (Column existingColumn : existingTableColumns) {
                if (!newTableColumns.stream().noneMatch(newColumn -> newColumn.getName().equals(existingColumn.getName()) && newColumn.getType().equals(existingColumn.getType()))) continue;
                return false;
            }
            return true;
        }

        public void undo(HiveMetastoreClosure metastore) {
            if (!this.tableCreated) {
                return;
            }
            metastore.dropTable(this.newTable.getDatabaseName(), this.newTable.getTableName(), false);
        }
    }

    private record IrreversibleMetastoreOperation(String description, Runnable action) {
        private IrreversibleMetastoreOperation {
            Objects.requireNonNull(description, "description is null");
            Objects.requireNonNull(action, "action is null");
        }

        public void run() {
            this.action.run();
        }
    }

    private record DirectoryRenameTask(ConnectorIdentity identity, Location renameFrom, Location renameTo) {
        private DirectoryRenameTask {
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(renameFrom, "renameFrom is null");
            Objects.requireNonNull(renameTo, "renameTo is null");
        }
    }

    private record DirectoryDeletionTask(ConnectorIdentity identity, Location location) {
        private DirectoryDeletionTask {
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(location, "location is null");
        }
    }

    private record DirectoryCleanUpTask(ConnectorIdentity identity, Location location, boolean deleteEmptyDirectory) {
        private DirectoryCleanUpTask {
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(location, "location is null");
        }
    }
}

