/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

@Immutable
public record ColumnStatistics(Optional<IntegerStatistics> integerStatistics, Optional<DoubleStatistics> doubleStatistics, Optional<DecimalStatistics> decimalStatistics, Optional<DateStatistics> dateStatistics, Optional<BooleanStatistics> booleanStatistics, OptionalLong maxValueSizeInBytes, OptionalDouble averageColumnLength, OptionalLong totalSizeInBytes, OptionalLong nullsCount, OptionalLong distinctValuesCount) {
    public ColumnStatistics {
        Objects.requireNonNull(integerStatistics, "integerStatistics is null");
        Objects.requireNonNull(doubleStatistics, "doubleStatistics is null");
        Objects.requireNonNull(decimalStatistics, "decimalStatistics is null");
        Objects.requireNonNull(dateStatistics, "dateStatistics is null");
        Objects.requireNonNull(booleanStatistics, "booleanStatistics is null");
        Objects.requireNonNull(maxValueSizeInBytes, "maxValueSizeInBytes is null");
        Objects.requireNonNull(averageColumnLength, "averageColumnLength is null");
        Objects.requireNonNull(totalSizeInBytes, "totalSizeInBytes is null");
        Preconditions.checkArgument((averageColumnLength.isEmpty() || totalSizeInBytes.isEmpty() ? 1 : 0) != 0, (Object)"both averageColumnLength and totalSizeInBytes are present");
        Objects.requireNonNull(nullsCount, "nullsCount is null");
        Objects.requireNonNull(distinctValuesCount, "distinctValuesCount is null");
        LinkedHashSet presentStatistics = new LinkedHashSet();
        integerStatistics.ifPresent(ignored -> presentStatistics.add("integerStatistics"));
        doubleStatistics.ifPresent(ignored -> presentStatistics.add("doubleStatistics"));
        decimalStatistics.ifPresent(ignored -> presentStatistics.add("decimalStatistics"));
        dateStatistics.ifPresent(ignored -> presentStatistics.add("dateStatistics"));
        booleanStatistics.ifPresent(ignored -> presentStatistics.add("booleanStatistics"));
        Preconditions.checkArgument((presentStatistics.size() <= 1 ? 1 : 0) != 0, (String)"multiple type specific statistic objects are present: %s", presentStatistics);
    }

    public static ColumnStatistics fromHiveColumnStatistics(HiveColumnStatistics hiveColumnStatistics) {
        return new ColumnStatistics(hiveColumnStatistics.getIntegerStatistics().map(stat -> new IntegerStatistics(stat.getMin(), stat.getMax())), hiveColumnStatistics.getDoubleStatistics().map(stat -> new DoubleStatistics(stat.getMin(), stat.getMax())), hiveColumnStatistics.getDecimalStatistics().map(stat -> new DecimalStatistics(stat.getMin(), stat.getMax())), hiveColumnStatistics.getDateStatistics().map(stat -> new DateStatistics(stat.getMin(), stat.getMax())), hiveColumnStatistics.getBooleanStatistics().map(stat -> new BooleanStatistics(stat.getTrueCount(), stat.getFalseCount())), hiveColumnStatistics.getMaxValueSizeInBytes(), hiveColumnStatistics.getAverageColumnLength(), OptionalLong.empty(), hiveColumnStatistics.getNullsCount(), hiveColumnStatistics.getDistinctValuesWithNullCount());
    }

    public HiveColumnStatistics toHiveColumnStatistics(HiveBasicStatistics basicStatistics) {
        long nonNullCount;
        OptionalDouble averageColumnLength = this.averageColumnLength;
        if (this.totalSizeInBytes.isPresent() && basicStatistics.getRowCount().orElse(0L) > 0L && this.nullsCount().isPresent() && (nonNullCount = basicStatistics.getRowCount().getAsLong() - this.nullsCount().orElseThrow()) > 0L) {
            averageColumnLength = OptionalDouble.of((double)this.totalSizeInBytes.getAsLong() / (double)nonNullCount);
        }
        return new HiveColumnStatistics(this.integerStatistics.map(stat -> new io.trino.plugin.hive.metastore.IntegerStatistics(stat.min(), stat.max())), this.doubleStatistics.map(stat -> new io.trino.plugin.hive.metastore.DoubleStatistics(stat.min(), stat.max())), this.decimalStatistics.map(stat -> new io.trino.plugin.hive.metastore.DecimalStatistics(stat.min(), stat.max())), this.dateStatistics.map(stat -> new io.trino.plugin.hive.metastore.DateStatistics(stat.min(), stat.max())), this.booleanStatistics.map(stat -> new io.trino.plugin.hive.metastore.BooleanStatistics(stat.trueCount(), stat.falseCount())), this.maxValueSizeInBytes, averageColumnLength, this.nullsCount, this.distinctValuesCount);
    }

    public record BooleanStatistics(OptionalLong trueCount, OptionalLong falseCount) {
        public BooleanStatistics {
            Objects.requireNonNull(trueCount, "trueCount is null");
            Objects.requireNonNull(falseCount, "falseCount is null");
        }
    }

    public record DateStatistics(Optional<LocalDate> min, Optional<LocalDate> max) {
        public DateStatistics {
            Objects.requireNonNull(min, "min is null");
            Objects.requireNonNull(max, "max is null");
        }
    }

    public record DecimalStatistics(Optional<BigDecimal> min, Optional<BigDecimal> max) {
        public DecimalStatistics {
            Objects.requireNonNull(min, "min is null");
            Objects.requireNonNull(max, "max is null");
        }
    }

    public record DoubleStatistics(OptionalDouble min, OptionalDouble max) {
        public DoubleStatistics {
            Objects.requireNonNull(min, "min is null");
            Objects.requireNonNull(max, "max is null");
        }
    }

    public record IntegerStatistics(OptionalLong min, OptionalLong max) {
        public IntegerStatistics {
            Objects.requireNonNull(min, "min is null");
            Objects.requireNonNull(max, "max is null");
        }
    }
}

