/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.hive.metastore.glue.AwsCurrentRegionHolder;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;

public class GlueCredentialsProvider
implements Provider<AWSCredentialsProvider> {
    private final AWSCredentialsProvider credentialsProvider;

    @Inject
    public GlueCredentialsProvider(GlueHiveMetastoreConfig config) {
        if (config.getAwsCredentialsProvider().isPresent()) {
            this.credentialsProvider = GlueCredentialsProvider.getCustomAWSCredentialsProvider(config.getAwsCredentialsProvider().get());
        } else {
            Object provider = config.getAwsAccessKey().isPresent() && config.getAwsSecretKey().isPresent() ? new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(config.getAwsAccessKey().get(), config.getAwsSecretKey().get())) : DefaultAWSCredentialsProviderChain.getInstance();
            if (config.getIamRole().isPresent()) {
                AWSSecurityTokenServiceClientBuilder stsClientBuilder = (AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)provider);
                if (config.getGlueStsEndpointUrl().isPresent() && config.getGlueStsRegion().isPresent()) {
                    stsClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.getGlueStsEndpointUrl().get(), config.getGlueStsRegion().get()));
                } else if (config.getGlueStsRegion().isPresent()) {
                    stsClientBuilder.setRegion(config.getGlueStsRegion().get());
                } else if (config.getPinGlueClientToCurrentRegion()) {
                    stsClientBuilder.setRegion(AwsCurrentRegionHolder.getCurrentRegionFromEc2Metadata().getName());
                }
                provider = new STSAssumeRoleSessionCredentialsProvider.Builder(config.getIamRole().get(), "trino-session").withExternalId((String)config.getExternalId().orElse(null)).withStsClient((AWSSecurityTokenService)stsClientBuilder.build()).build();
            }
            this.credentialsProvider = provider;
        }
    }

    public AWSCredentialsProvider get() {
        return this.credentialsProvider;
    }

    private static AWSCredentialsProvider getCustomAWSCredentialsProvider(String providerClass) {
        try {
            Object instance = Class.forName(providerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(instance instanceof AWSCredentialsProvider)) {
                throw new RuntimeException("Invalid credentials provider class: " + instance.getClass().getName());
            }
            return (AWSCredentialsProvider)instance;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Error creating an instance of %s", providerClass), e);
        }
    }
}

