/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import io.trino.spi.security.ConnectorIdentity;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apache.thrift.TException;

public class StaticTokenAwareHttpMetastoreClientFactory
implements IdentityAwareMetastoreClientFactory {
    private final ThriftMetastoreClientFactory clientProvider;
    private final ImmutableList<URI> metastoreUris;

    @Inject
    StaticTokenAwareHttpMetastoreClientFactory(StaticMetastoreConfig config, ThriftMetastoreClientFactory clientProvider) {
        this.clientProvider = Objects.requireNonNull(clientProvider, "clientProvider is null");
        this.metastoreUris = (ImmutableList)config.getMetastoreUris().stream().map(StaticTokenAwareHttpMetastoreClientFactory::checkMetastoreUri).collect(ImmutableList.toImmutableList());
    }

    private static URI checkMetastoreUri(URI uri) {
        Objects.requireNonNull(uri, "uri is null");
        String scheme = uri.getScheme();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scheme) ? 1 : 0) != 0, (String)"metastoreUri scheme is missing: %s", (Object)uri);
        Preconditions.checkArgument((scheme.equals("https") || scheme.equals("http") ? 1 : 0) != 0, (String)"metastoreUri scheme must be http or https: %s", (Object)uri);
        Preconditions.checkArgument((uri.getHost() != null ? 1 : 0) != 0, (String)"metastoreUri host is missing: %s", (Object)uri);
        return uri;
    }

    @Override
    public ThriftMetastoreClient createMetastoreClientFor(Optional<ConnectorIdentity> identity) throws TException {
        TException lastException = null;
        for (URI metastoreUri : this.metastoreUris) {
            try {
                return this.clientProvider.create(metastoreUri, Optional.empty());
            }
            catch (TException e) {
                lastException = e;
            }
        }
        throw lastException;
    }
}

