/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Shorts;
import io.airlift.compress.zstd.ZstdDecompressor;
import io.airlift.json.JsonCodec;
import io.trino.hive.thrift.metastore.BinaryColumnStatsData;
import io.trino.hive.thrift.metastore.BooleanColumnStatsData;
import io.trino.hive.thrift.metastore.ColumnStatisticsData;
import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.Date;
import io.trino.hive.thrift.metastore.DateColumnStatsData;
import io.trino.hive.thrift.metastore.Decimal;
import io.trino.hive.thrift.metastore.DecimalColumnStatsData;
import io.trino.hive.thrift.metastore.DoubleColumnStatsData;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.Function;
import io.trino.hive.thrift.metastore.FunctionType;
import io.trino.hive.thrift.metastore.LongColumnStatsData;
import io.trino.hive.thrift.metastore.Order;
import io.trino.hive.thrift.metastore.PrincipalPrivilegeSet;
import io.trino.hive.thrift.metastore.PrivilegeGrantInfo;
import io.trino.hive.thrift.metastore.ResourceUri;
import io.trino.hive.thrift.metastore.RolePrincipalGrant;
import io.trino.hive.thrift.metastore.SerDeInfo;
import io.trino.hive.thrift.metastore.StorageDescriptor;
import io.trino.hive.thrift.metastore.StringColumnStatsData;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class ThriftMetastoreUtil {
    private static final JsonCodec<LanguageFunction> LANGUAGE_FUNCTION_CODEC = JsonCodec.jsonCodec(LanguageFunction.class);
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String ADMIN_ROLE_NAME = "admin";

    private ThriftMetastoreUtil() {
    }

    public static io.trino.hive.thrift.metastore.Database toMetastoreApiDatabase(Database database) {
        io.trino.hive.thrift.metastore.Database result = new io.trino.hive.thrift.metastore.Database();
        result.setName(database.getDatabaseName());
        database.getLocation().ifPresent(arg_0 -> ((io.trino.hive.thrift.metastore.Database)result).setLocationUri(arg_0));
        result.setOwnerName((String)database.getOwnerName().orElse(null));
        result.setOwnerType((io.trino.hive.thrift.metastore.PrincipalType)database.getOwnerType().map(ThriftMetastoreUtil::fromTrinoPrincipalType).orElse(null));
        database.getComment().ifPresent(arg_0 -> ((io.trino.hive.thrift.metastore.Database)result).setDescription(arg_0));
        result.setParameters(database.getParameters());
        return result;
    }

    public static io.trino.hive.thrift.metastore.Table toMetastoreApiTable(Table table, PrincipalPrivileges privileges) {
        io.trino.hive.thrift.metastore.Table result = ThriftMetastoreUtil.toMetastoreApiTable(table);
        result.setPrivileges(ThriftMetastoreUtil.toMetastoreApiPrincipalPrivilegeSet(privileges));
        return result;
    }

    public static io.trino.hive.thrift.metastore.Table toMetastoreApiTable(Table table) {
        io.trino.hive.thrift.metastore.Table result = new io.trino.hive.thrift.metastore.Table();
        result.setDbName(table.getDatabaseName());
        result.setTableName(table.getTableName());
        result.setOwner((String)table.getOwner().orElse(null));
        result.setTableType(table.getTableType());
        result.setParameters(table.getParameters());
        result.setPartitionKeys((List)table.getPartitionColumns().stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList()));
        result.setSd(ThriftMetastoreUtil.makeStorageDescriptor(table.getTableName(), table.getDataColumns(), table.getStorage()));
        result.setViewOriginalText((String)table.getViewOriginalText().orElse(null));
        result.setViewExpandedText((String)table.getViewExpandedText().orElse(null));
        table.getWriteId().ifPresent(arg_0 -> ((io.trino.hive.thrift.metastore.Table)result).setWriteId(arg_0));
        return result;
    }

    private static PrincipalPrivilegeSet toMetastoreApiPrincipalPrivilegeSet(PrincipalPrivileges privileges) {
        ImmutableMap.Builder userPrivileges = ImmutableMap.builder();
        for (Map.Entry entry : privileges.getUserPrivileges().asMap().entrySet()) {
            userPrivileges.put((Object)((String)entry.getKey()), (Object)((List)((Collection)entry.getValue()).stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(ImmutableList.toImmutableList())));
        }
        ImmutableMap.Builder rolePrivileges = ImmutableMap.builder();
        for (Map.Entry entry : privileges.getRolePrivileges().asMap().entrySet()) {
            rolePrivileges.put((Object)((String)entry.getKey()), (Object)((List)((Collection)entry.getValue()).stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(ImmutableList.toImmutableList())));
        }
        return new PrincipalPrivilegeSet((Map)userPrivileges.buildOrThrow(), (Map)ImmutableMap.of(), (Map)rolePrivileges.buildOrThrow());
    }

    public static PrivilegeGrantInfo toMetastoreApiPrivilegeGrantInfo(HivePrivilegeInfo privilegeInfo) {
        return new PrivilegeGrantInfo(privilegeInfo.getHivePrivilege().name().toLowerCase(Locale.ENGLISH), 0, privilegeInfo.getGrantor().getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(privilegeInfo.getGrantor().getType()), privilegeInfo.isGrantOption());
    }

    public static Stream<RoleGrant> listApplicableRoles(final HivePrincipal principal, final java.util.function.Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        return Streams.stream((Iterator)new AbstractIterator<RoleGrant>(){
            private final Queue<RoleGrant> output = new ArrayDeque<RoleGrant>();
            private final Set<RoleGrant> seenRoles = new HashSet<RoleGrant>();
            private final Queue<HivePrincipal> queue = new ArrayDeque<HivePrincipal>();
            {
                this.queue.add(principal);
            }

            protected RoleGrant computeNext() {
                while (this.output.isEmpty() && !this.queue.isEmpty()) {
                    Set grants = (Set)listRoleGrants.apply(this.queue.remove());
                    for (RoleGrant grant : grants) {
                        if (!this.seenRoles.add(grant)) continue;
                        this.output.add(grant);
                        this.queue.add(new HivePrincipal(PrincipalType.ROLE, grant.getRoleName()));
                    }
                }
                if (!this.output.isEmpty()) {
                    return this.output.remove();
                }
                return (RoleGrant)this.endOfData();
            }
        });
    }

    public static boolean isRoleApplicable(HivePrincipal principal, String role, java.util.function.Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        if (principal.getType() == PrincipalType.ROLE && principal.getName().equals(role)) {
            return true;
        }
        return ThriftMetastoreUtil.listApplicableRoleNames(principal, listRoleGrants).anyMatch(role::equals);
    }

    private static Stream<String> listApplicableRoleNames(HivePrincipal principal, java.util.function.Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        return ThriftMetastoreUtil.listApplicableRoles(principal, listRoleGrants).map(RoleGrant::getRoleName);
    }

    public static Stream<HivePrincipal> listEnabledPrincipals(ConnectorIdentity identity, java.util.function.Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        return Stream.concat(Stream.of(new HivePrincipal(PrincipalType.USER, identity.getUser())), ThriftMetastoreUtil.listEnabledRoles(identity, listRoleGrants).map(role -> new HivePrincipal(PrincipalType.ROLE, (String)role)));
    }

    public static boolean isRoleEnabled(ConnectorIdentity identity, java.util.function.Function<HivePrincipal, Set<RoleGrant>> listRoleGrants, String role) {
        if (role.equals(PUBLIC_ROLE_NAME)) {
            return true;
        }
        if (identity.getConnectorRole().isPresent() && ((SelectedRole)identity.getConnectorRole().get()).getType() == SelectedRole.Type.NONE) {
            return false;
        }
        HivePrincipal principal = HivePrincipal.from(identity);
        if (principal.getType() == PrincipalType.ROLE && principal.getName().equals(role)) {
            return true;
        }
        if (role.equals(ADMIN_ROLE_NAME)) {
            return false;
        }
        return ThriftMetastoreUtil.listEnabledRoles(identity, listRoleGrants).anyMatch(role::equals);
    }

    public static Stream<String> listEnabledRoles(ConnectorIdentity identity, java.util.function.Function<HivePrincipal, Set<RoleGrant>> listRoleGrants) {
        if (identity.getConnectorRole().isPresent() && ((SelectedRole)identity.getConnectorRole().get()).getType() == SelectedRole.Type.NONE) {
            return Stream.of(PUBLIC_ROLE_NAME);
        }
        HivePrincipal principal = HivePrincipal.from(identity);
        Stream<String> roles = Stream.of(PUBLIC_ROLE_NAME);
        if (principal.getType() == PrincipalType.ROLE) {
            roles = Stream.concat(roles, Stream.of(principal.getName()));
        }
        return Stream.concat(roles, ThriftMetastoreUtil.listApplicableRoles(principal, listRoleGrants).map(RoleGrant::getRoleName).filter(Predicate.isEqual(ADMIN_ROLE_NAME).negate())).distinct();
    }

    public static io.trino.hive.thrift.metastore.Partition toMetastoreApiPartition(PartitionWithStatistics partitionWithStatistics) {
        io.trino.hive.thrift.metastore.Partition partition = ThriftMetastoreUtil.toMetastoreApiPartition(partitionWithStatistics.getPartition());
        partition.setParameters(MetastoreUtil.updateStatisticsParameters(partition.getParameters(), partitionWithStatistics.getStatistics().basicStatistics()));
        return partition;
    }

    public static io.trino.hive.thrift.metastore.Partition toMetastoreApiPartition(Partition partition) {
        return ThriftMetastoreUtil.toMetastoreApiPartition(partition, Optional.empty());
    }

    public static io.trino.hive.thrift.metastore.Partition toMetastoreApiPartition(Partition partition, Optional<Long> writeId) {
        io.trino.hive.thrift.metastore.Partition result = new io.trino.hive.thrift.metastore.Partition();
        result.setDbName(partition.getDatabaseName());
        result.setTableName(partition.getTableName());
        result.setValues(partition.getValues());
        result.setSd(ThriftMetastoreUtil.makeStorageDescriptor(partition.getTableName(), partition.getColumns(), partition.getStorage()));
        result.setParameters(partition.getParameters());
        writeId.ifPresent(arg_0 -> ((io.trino.hive.thrift.metastore.Partition)result).setWriteId(arg_0));
        return result;
    }

    public static Database fromMetastoreApiDatabase(io.trino.hive.thrift.metastore.Database database) {
        Map parameters;
        String ownerName = "PUBLIC";
        PrincipalType ownerType = PrincipalType.ROLE;
        if (database.getOwnerName() != null) {
            ownerName = database.getOwnerName();
            ownerType = ThriftMetastoreUtil.fromMetastoreApiPrincipalType(database.getOwnerType());
        }
        if ((parameters = database.getParameters()) == null) {
            parameters = ImmutableMap.of();
        }
        return Database.builder().setDatabaseName(database.getName()).setLocation(Optional.ofNullable(Strings.emptyToNull((String)database.getLocationUri()))).setOwnerName(Optional.of(ownerName)).setOwnerType(Optional.of(ownerType)).setComment(Optional.ofNullable(database.getDescription())).setParameters(parameters).build();
    }

    public static Table fromMetastoreApiTable(io.trino.hive.thrift.metastore.Table table) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        return ThriftMetastoreUtil.fromMetastoreApiTable(table, storageDescriptor.getCols());
    }

    public static Table fromMetastoreApiTable(io.trino.hive.thrift.metastore.Table table, List<FieldSchema> schema) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(table.getDbName()).setTableName(table.getTableName()).setOwner(Optional.ofNullable(table.getOwner())).setTableType(table.getTableType()).setDataColumns((List)schema.stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList())).setPartitionColumns((List)table.getPartitionKeys().stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList())).setParameters((Map<String, String>)(table.getParameters() == null ? ImmutableMap.of() : table.getParameters())).setViewOriginalText(Optional.ofNullable(Strings.emptyToNull((String)table.getViewOriginalText()))).setViewExpandedText(Optional.ofNullable(Strings.emptyToNull((String)table.getViewExpandedText()))).setWriteId(table.getWriteId() < 0L ? OptionalLong.empty() : OptionalLong.of(table.getWriteId()));
        ThriftMetastoreUtil.fromMetastoreApiStorageDescriptor(storageDescriptor, tableBuilder.getStorageBuilder(), table.getTableName());
        return tableBuilder.build();
    }

    public static boolean isAvroTableWithSchemaSet(io.trino.hive.thrift.metastore.Table table) {
        if (table.getParameters() == null) {
            return false;
        }
        SerDeInfo serdeInfo = ThriftMetastoreUtil.getSerdeInfo(table);
        return serdeInfo.getSerializationLib() != null && (table.getParameters().get("avro.schema.url") != null || serdeInfo.getParameters() != null && serdeInfo.getParameters().get("avro.schema.url") != null || table.getParameters().get("avro.schema.literal") != null || serdeInfo.getParameters() != null && serdeInfo.getParameters().get("avro.schema.literal") != null) && serdeInfo.getSerializationLib().equals(HiveStorageFormat.AVRO.getSerde());
    }

    public static boolean isCsvTable(io.trino.hive.thrift.metastore.Table table) {
        return HiveStorageFormat.CSV.getSerde().equals(ThriftMetastoreUtil.getSerdeInfo(table).getSerializationLib());
    }

    public static List<FieldSchema> csvSchemaFields(List<FieldSchema> schemas) {
        return (List)schemas.stream().map(schema -> new FieldSchema(schema.getName(), HiveType.HIVE_STRING.toString(), schema.getComment())).collect(ImmutableList.toImmutableList());
    }

    private static SerDeInfo getSerdeInfo(io.trino.hive.thrift.metastore.Table table) {
        StorageDescriptor storageDescriptor = table.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table does not contain a storage descriptor: " + String.valueOf(table));
        }
        SerDeInfo serdeInfo = storageDescriptor.getSerdeInfo();
        if (serdeInfo == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table storage descriptor is missing SerDe info");
        }
        return serdeInfo;
    }

    public static Partition fromMetastoreApiPartition(io.trino.hive.thrift.metastore.Partition partition) {
        StorageDescriptor storageDescriptor = partition.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Partition does not contain a storage descriptor: " + String.valueOf(partition));
        }
        return ThriftMetastoreUtil.fromMetastoreApiPartition(partition, storageDescriptor.getCols());
    }

    public static Partition fromMetastoreApiPartition(io.trino.hive.thrift.metastore.Partition partition, List<FieldSchema> schema) {
        StorageDescriptor storageDescriptor = partition.getSd();
        if (storageDescriptor == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Partition does not contain a storage descriptor: " + String.valueOf(partition));
        }
        Partition.Builder partitionBuilder = Partition.builder().setDatabaseName(partition.getDbName()).setTableName(partition.getTableName()).setValues(partition.getValues()).setColumns((List)schema.stream().map(ThriftMetastoreUtil::fromMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList())).setParameters(partition.getParameters());
        ThriftMetastoreUtil.fromMetastoreApiStorageDescriptor(storageDescriptor, partitionBuilder.getStorageBuilder(), String.format("%s.%s", partition.getTableName(), partition.getValues()));
        return partitionBuilder.build();
    }

    public static HiveColumnStatistics fromMetastoreApiColumnStatistics(ColumnStatisticsObj columnStatistics) {
        if (columnStatistics.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStatsData = columnStatistics.getStatsData().getLongStats();
            OptionalLong min = longStatsData.isSetLowValue() ? OptionalLong.of(longStatsData.getLowValue()) : OptionalLong.empty();
            OptionalLong max = longStatsData.isSetHighValue() ? OptionalLong.of(longStatsData.getHighValue()) : OptionalLong.empty();
            OptionalLong nullsCount = longStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(longStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesWithNullCount = longStatsData.isSetNumDVs() ? OptionalLong.of(longStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createIntegerColumnStatistics(min, max, nullsCount, distinctValuesWithNullCount);
        }
        if (columnStatistics.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStatsData = columnStatistics.getStatsData().getDoubleStats();
            OptionalDouble min = doubleStatsData.isSetLowValue() ? OptionalDouble.of(doubleStatsData.getLowValue()) : OptionalDouble.empty();
            OptionalDouble max = doubleStatsData.isSetHighValue() ? OptionalDouble.of(doubleStatsData.getHighValue()) : OptionalDouble.empty();
            OptionalLong nullsCount = doubleStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(doubleStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesWithNullCount = doubleStatsData.isSetNumDVs() ? OptionalLong.of(doubleStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createDoubleColumnStatistics(min, max, nullsCount, distinctValuesWithNullCount);
        }
        if (columnStatistics.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStatsData = columnStatistics.getStatsData().getDecimalStats();
            Optional<BigDecimal> min = decimalStatsData.isSetLowValue() ? ThriftMetastoreUtil.fromMetastoreDecimal(decimalStatsData.getLowValue()) : Optional.empty();
            Optional<BigDecimal> max = decimalStatsData.isSetHighValue() ? ThriftMetastoreUtil.fromMetastoreDecimal(decimalStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = decimalStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(decimalStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesWithNullCount = decimalStatsData.isSetNumDVs() ? OptionalLong.of(decimalStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createDecimalColumnStatistics(min, max, nullsCount, distinctValuesWithNullCount);
        }
        if (columnStatistics.getStatsData().isSetDateStats()) {
            DateColumnStatsData dateStatsData = columnStatistics.getStatsData().getDateStats();
            Optional<LocalDate> min = dateStatsData.isSetLowValue() ? ThriftMetastoreUtil.fromMetastoreDate(dateStatsData.getLowValue()) : Optional.empty();
            Optional<LocalDate> max = dateStatsData.isSetHighValue() ? ThriftMetastoreUtil.fromMetastoreDate(dateStatsData.getHighValue()) : Optional.empty();
            OptionalLong nullsCount = dateStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(dateStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesWithNullCount = dateStatsData.isSetNumDVs() ? OptionalLong.of(dateStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createDateColumnStatistics(min, max, nullsCount, distinctValuesWithNullCount);
        }
        if (columnStatistics.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData booleanStatsData = columnStatistics.getStatsData().getBooleanStats();
            OptionalLong trueCount = OptionalLong.empty();
            OptionalLong falseCount = OptionalLong.empty();
            if (booleanStatsData.isSetNumTrues() && booleanStatsData.isSetNumFalses() && booleanStatsData.getNumFalses() != -1L) {
                trueCount = OptionalLong.of(booleanStatsData.getNumTrues());
                falseCount = OptionalLong.of(booleanStatsData.getNumFalses());
            }
            return HiveColumnStatistics.createBooleanColumnStatistics(trueCount, falseCount, booleanStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(booleanStatsData.getNumNulls()) : OptionalLong.empty());
        }
        if (columnStatistics.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStatsData = columnStatistics.getStatsData().getStringStats();
            OptionalLong maxColumnLength = stringStatsData.isSetMaxColLen() ? OptionalLong.of(stringStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = stringStatsData.isSetAvgColLen() ? OptionalDouble.of(stringStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = stringStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(stringStatsData.getNumNulls()) : OptionalLong.empty();
            OptionalLong distinctValuesWithNullCount = stringStatsData.isSetNumDVs() ? OptionalLong.of(stringStatsData.getNumDVs()) : OptionalLong.empty();
            return HiveColumnStatistics.createStringColumnStatistics(maxColumnLength, averageColumnLength, nullsCount, distinctValuesWithNullCount);
        }
        if (columnStatistics.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStatsData = columnStatistics.getStatsData().getBinaryStats();
            OptionalLong maxColumnLength = binaryStatsData.isSetMaxColLen() ? OptionalLong.of(binaryStatsData.getMaxColLen()) : OptionalLong.empty();
            OptionalDouble averageColumnLength = binaryStatsData.isSetAvgColLen() ? OptionalDouble.of(binaryStatsData.getAvgColLen()) : OptionalDouble.empty();
            OptionalLong nullsCount = binaryStatsData.isSetNumNulls() ? ThriftMetastoreUtil.fromMetastoreNullsCount(binaryStatsData.getNumNulls()) : OptionalLong.empty();
            return HiveColumnStatistics.createBinaryColumnStatistics(maxColumnLength, averageColumnLength, nullsCount);
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Invalid column statistics data: " + String.valueOf(columnStatistics));
    }

    private static Optional<LocalDate> fromMetastoreDate(Date date) {
        if (date == null) {
            return Optional.empty();
        }
        return Optional.of(LocalDate.ofEpochDay(date.getDaysSinceEpoch()));
    }

    public static OptionalLong fromMetastoreNullsCount(long nullsCount) {
        if (nullsCount == -1L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(nullsCount);
    }

    private static Optional<BigDecimal> fromMetastoreDecimal(@Nullable Decimal decimal) {
        if (decimal == null) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(new BigInteger(decimal.getUnscaled()), decimal.getScale()));
    }

    public static Set<RoleGrant> fromRolePrincipalGrants(Collection<RolePrincipalGrant> grants) {
        return (Set)grants.stream().map(ThriftMetastoreUtil::fromRolePrincipalGrant).collect(ImmutableSet.toImmutableSet());
    }

    private static RoleGrant fromRolePrincipalGrant(RolePrincipalGrant grant) {
        return new RoleGrant(new TrinoPrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(grant.getPrincipalType()), grant.getPrincipalName()), grant.getRoleName(), grant.isGrantOption());
    }

    public static io.trino.hive.thrift.metastore.PrincipalType fromTrinoPrincipalType(PrincipalType principalType) {
        return switch (principalType) {
            default -> throw new MatchException(null, null);
            case PrincipalType.USER -> io.trino.hive.thrift.metastore.PrincipalType.USER;
            case PrincipalType.ROLE -> io.trino.hive.thrift.metastore.PrincipalType.ROLE;
        };
    }

    public static PrincipalType fromMetastoreApiPrincipalType(io.trino.hive.thrift.metastore.PrincipalType principalType) {
        Objects.requireNonNull(principalType, "principalType is null");
        switch (principalType) {
            case USER: {
                return PrincipalType.USER;
            }
            case ROLE: {
                return PrincipalType.ROLE;
            }
        }
        throw new IllegalArgumentException("Unsupported principal type: " + String.valueOf(principalType));
    }

    public static FieldSchema toMetastoreApiFieldSchema(Column column) {
        Preconditions.checkArgument((boolean)column.getProperties().isEmpty(), (String)"Persisting column properties is not supported: %s", (Object)column);
        return new FieldSchema(column.getName(), column.getType().getHiveTypeName().toString(), (String)column.getComment().orElse(null));
    }

    private static Column fromMetastoreApiFieldSchema(FieldSchema fieldSchema) {
        return new Column(fieldSchema.getName(), HiveType.valueOf(fieldSchema.getType().toLowerCase(Locale.ENGLISH)), Optional.ofNullable(fieldSchema.getComment()), (Map<String, String>)ImmutableMap.of());
    }

    private static void fromMetastoreApiStorageDescriptor(StorageDescriptor storageDescriptor, Storage.Builder builder, String tablePartitionName) {
        SerDeInfo serdeInfo = storageDescriptor.getSerdeInfo();
        if (serdeInfo == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table storage descriptor is missing SerDe info");
        }
        builder.setStorageFormat(StorageFormat.createNullable(serdeInfo.getSerializationLib(), storageDescriptor.getInputFormat(), storageDescriptor.getOutputFormat())).setLocation(Strings.nullToEmpty((String)storageDescriptor.getLocation())).setBucketProperty(HiveBucketProperty.fromStorageDescriptor(storageDescriptor, tablePartitionName)).setSkewed(storageDescriptor.isSetSkewedInfo() && storageDescriptor.getSkewedInfo().isSetSkewedColNames() && !storageDescriptor.getSkewedInfo().getSkewedColNames().isEmpty()).setSerdeParameters((Map<String, String>)(serdeInfo.getParameters() == null ? ImmutableMap.of() : serdeInfo.getParameters()));
    }

    private static StorageDescriptor makeStorageDescriptor(String tableName, List<Column> columns, Storage storage) {
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(tableName);
        serdeInfo.setSerializationLib(storage.getStorageFormat().getSerDeNullable());
        serdeInfo.setParameters(storage.getSerdeParameters());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(Strings.emptyToNull((String)storage.getOptionalLocation().orElse(null)));
        sd.setCols((List)columns.stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList()));
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(storage.getStorageFormat().getInputFormatNullable());
        sd.setOutputFormat(storage.getStorageFormat().getOutputFormatNullable());
        sd.setSkewedInfoIsSet(storage.isSkewed());
        sd.setParameters((Map)ImmutableMap.of());
        Optional<HiveBucketProperty> bucketProperty = storage.getBucketProperty();
        if (bucketProperty.isPresent()) {
            sd.setNumBuckets(bucketProperty.get().bucketCount());
            sd.setBucketCols(bucketProperty.get().bucketedBy());
            if (!bucketProperty.get().sortedBy().isEmpty()) {
                sd.setSortCols((List)bucketProperty.get().sortedBy().stream().map(column -> new Order(column.getColumnName(), column.getOrder().getHiveOrder())).collect(ImmutableList.toImmutableList()));
            }
        }
        return sd;
    }

    public static Set<HivePrivilegeInfo> parsePrivilege(PrivilegeGrantInfo userGrant, Optional<HivePrincipal> grantee) {
        boolean grantOption = userGrant.isGrantOption();
        String name = userGrant.getPrivilege().toUpperCase(Locale.ENGLISH);
        HivePrincipal grantor = new HivePrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(userGrant.getGrantorType()), userGrant.getGrantor());
        return switch (name) {
            case "ALL" -> (ImmutableSet)Arrays.stream(HivePrivilegeInfo.HivePrivilege.values()).map(hivePrivilege -> new HivePrivilegeInfo((HivePrivilegeInfo.HivePrivilege)((Object)hivePrivilege), grantOption, grantor, grantee.orElse(grantor))).collect(ImmutableSet.toImmutableSet());
            case "SELECT" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, grantOption, grantor, grantee.orElse(grantor)));
            case "INSERT" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, grantOption, grantor, grantee.orElse(grantor)));
            case "UPDATE" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, grantOption, grantor, grantee.orElse(grantor)));
            case "DELETE" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, grantOption, grantor, grantee.orElse(grantor)));
            case "OWNERSHIP" -> ImmutableSet.of((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, grantOption, grantor, grantee.orElse(grantor)));
            default -> throw new IllegalArgumentException("Unsupported privilege name: " + name);
        };
    }

    public static ColumnStatisticsObj createMetastoreColumnStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        TypeInfo typeInfo = columnType.getTypeInfo();
        Preconditions.checkArgument((typeInfo.getCategory() == Category.PRIMITIVE ? 1 : 0) != 0, (String)"unsupported type: %s", (Object)columnType);
        switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
            case BOOLEAN: {
                return ThriftMetastoreUtil.createBooleanStatistics(columnName, columnType, statistics);
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case TIMESTAMP: {
                return ThriftMetastoreUtil.createLongStatistics(columnName, columnType, statistics);
            }
            case FLOAT: 
            case DOUBLE: {
                return ThriftMetastoreUtil.createDoubleStatistics(columnName, columnType, statistics);
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return ThriftMetastoreUtil.createStringStatistics(columnName, columnType, statistics);
            }
            case DATE: {
                return ThriftMetastoreUtil.createDateStatistics(columnName, columnType, statistics);
            }
            case BINARY: {
                return ThriftMetastoreUtil.createBinaryStatistics(columnName, columnType, statistics);
            }
            case DECIMAL: {
                return ThriftMetastoreUtil.createDecimalStatistics(columnName, columnType, statistics);
            }
        }
        throw new IllegalArgumentException(String.format("unsupported type: %s", columnType));
    }

    private static ColumnStatisticsObj createBooleanStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        BooleanColumnStatsData data = new BooleanColumnStatsData();
        statistics.getNullsCount().ifPresent(arg_0 -> ((BooleanColumnStatsData)data).setNumNulls(arg_0));
        statistics.getBooleanStatistics().ifPresent(booleanStatistics -> {
            booleanStatistics.getFalseCount().ifPresent(arg_0 -> ((BooleanColumnStatsData)data).setNumFalses(arg_0));
            booleanStatistics.getTrueCount().ifPresent(arg_0 -> ((BooleanColumnStatsData)data).setNumTrues(arg_0));
        });
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.booleanStats((BooleanColumnStatsData)data));
    }

    private static ColumnStatisticsObj createLongStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        LongColumnStatsData data = new LongColumnStatsData();
        statistics.getIntegerStatistics().ifPresent(integerStatistics -> {
            integerStatistics.getMin().ifPresent(arg_0 -> ((LongColumnStatsData)data).setLowValue(arg_0));
            integerStatistics.getMax().ifPresent(arg_0 -> ((LongColumnStatsData)data).setHighValue(arg_0));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((LongColumnStatsData)data).setNumNulls(arg_0));
        statistics.getDistinctValuesWithNullCount().ifPresent(arg_0 -> ((LongColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.longStats((LongColumnStatsData)data));
    }

    private static ColumnStatisticsObj createDoubleStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        DoubleColumnStatsData data = new DoubleColumnStatsData();
        statistics.getDoubleStatistics().ifPresent(doubleStatistics -> {
            doubleStatistics.getMin().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setLowValue(arg_0));
            doubleStatistics.getMax().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setHighValue(arg_0));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setNumNulls(arg_0));
        statistics.getDistinctValuesWithNullCount().ifPresent(arg_0 -> ((DoubleColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.doubleStats((DoubleColumnStatsData)data));
    }

    private static ColumnStatisticsObj createStringStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        StringColumnStatsData data = new StringColumnStatsData();
        statistics.getNullsCount().ifPresent(arg_0 -> ((StringColumnStatsData)data).setNumNulls(arg_0));
        statistics.getDistinctValuesWithNullCount().ifPresent(arg_0 -> ((StringColumnStatsData)data).setNumDVs(arg_0));
        data.setMaxColLen(statistics.getMaxValueSizeInBytes().orElse(0L));
        data.setAvgColLen(statistics.getAverageColumnLength().orElse(0.0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.stringStats((StringColumnStatsData)data));
    }

    private static ColumnStatisticsObj createDateStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        DateColumnStatsData data = new DateColumnStatsData();
        statistics.getDateStatistics().ifPresent(dateStatistics -> {
            dateStatistics.getMin().ifPresent(value -> data.setLowValue(ThriftMetastoreUtil.toMetastoreDate(value)));
            dateStatistics.getMax().ifPresent(value -> data.setHighValue(ThriftMetastoreUtil.toMetastoreDate(value)));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((DateColumnStatsData)data).setNumNulls(arg_0));
        statistics.getDistinctValuesWithNullCount().ifPresent(arg_0 -> ((DateColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.dateStats((DateColumnStatsData)data));
    }

    private static ColumnStatisticsObj createBinaryStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        BinaryColumnStatsData data = new BinaryColumnStatsData();
        statistics.getNullsCount().ifPresent(arg_0 -> ((BinaryColumnStatsData)data).setNumNulls(arg_0));
        data.setMaxColLen(statistics.getMaxValueSizeInBytes().orElse(0L));
        data.setAvgColLen(statistics.getAverageColumnLength().orElse(0.0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.binaryStats((BinaryColumnStatsData)data));
    }

    private static ColumnStatisticsObj createDecimalStatistics(String columnName, HiveType columnType, HiveColumnStatistics statistics) {
        DecimalColumnStatsData data = new DecimalColumnStatsData();
        statistics.getDecimalStatistics().ifPresent(decimalStatistics -> {
            decimalStatistics.getMin().ifPresent(value -> data.setLowValue(ThriftMetastoreUtil.toMetastoreDecimal(value)));
            decimalStatistics.getMax().ifPresent(value -> data.setHighValue(ThriftMetastoreUtil.toMetastoreDecimal(value)));
        });
        statistics.getNullsCount().ifPresent(arg_0 -> ((DecimalColumnStatsData)data).setNumNulls(arg_0));
        statistics.getDistinctValuesWithNullCount().ifPresent(arg_0 -> ((DecimalColumnStatsData)data).setNumDVs(arg_0));
        return new ColumnStatisticsObj(columnName, columnType.toString(), ColumnStatisticsData.decimalStats((DecimalColumnStatsData)data));
    }

    private static Date toMetastoreDate(LocalDate date) {
        return new Date(date.toEpochDay());
    }

    public static Decimal toMetastoreDecimal(BigDecimal decimal) {
        return new Decimal(Shorts.checkedCast((long)decimal.scale()), ByteBuffer.wrap(decimal.unscaledValue().toByteArray()));
    }

    public static Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_TRUE_VALUES));
        }
        if (ThriftMetastoreUtil.isNumericType(type) || type.equals((Object)DateType.DATE)) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.MIN_VALUE), (Object)((Object)HiveColumnStatisticType.MAX_VALUE), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES));
        }
        if (type instanceof TimestampType || type instanceof TimestampWithTimeZoneType) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES));
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), (Object)((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES), (Object)((Object)HiveColumnStatisticType.TOTAL_SIZE_IN_BYTES), (Object)((Object)HiveColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES));
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return ImmutableSet.of((Object)((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), (Object)((Object)HiveColumnStatisticType.TOTAL_SIZE_IN_BYTES), (Object)((Object)HiveColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES));
        }
        if (type instanceof ArrayType || type instanceof RowType || type instanceof MapType) {
            return ImmutableSet.of();
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    private static boolean isNumericType(Type type) {
        return type.equals((Object)BigintType.BIGINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)TinyintType.TINYINT) || type.equals((Object)DoubleType.DOUBLE) || type.equals((Object)RealType.REAL) || type instanceof DecimalType;
    }

    public static LanguageFunction fromMetastoreApiFunction(Function function) {
        LanguageFunction result = ThriftMetastoreUtil.decodeFunction(function.getFunctionName(), function.getResourceUris());
        return new LanguageFunction(result.signatureToken(), result.sql(), result.path(), Optional.ofNullable(function.getOwnerName()));
    }

    public static Function toMetastoreApiFunction(String databaseName, String functionName, LanguageFunction function) {
        return new Function().setDbName(databaseName).setFunctionName(MetastoreUtil.metastoreFunctionName(functionName, function.signatureToken())).setClassName("TrinoFunction").setFunctionType(FunctionType.JAVA).setOwnerType(io.trino.hive.thrift.metastore.PrincipalType.USER).setOwnerName((String)function.owner().orElse(null)).setResourceUris(MetastoreUtil.toResourceUris(LANGUAGE_FUNCTION_CODEC.toJsonBytes((Object)function)));
    }

    public static byte[] fromResourceUris(List<ResourceUri> resourceUris) {
        ByteArrayDataOutput bytes = ByteStreams.newDataOutput();
        for (ResourceUri resourceUri : resourceUris) {
            bytes.write(BaseEncoding.base64Url().decode((CharSequence)resourceUri.getUri()));
        }
        byte[] compressed = bytes.toByteArray();
        long size = ZstdDecompressor.getDecompressedSize((byte[])compressed, (int)0, (int)compressed.length);
        byte[] output = new byte[Math.toIntExact(size)];
        new ZstdDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length);
        return output;
    }

    public static LanguageFunction decodeFunction(String name, List<ResourceUri> uris) {
        try {
            return (LanguageFunction)LANGUAGE_FUNCTION_CODEC.fromJson(ThriftMetastoreUtil.fromResourceUris(uris));
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Failed to decode function: " + name, (Throwable)e);
        }
    }
}

