/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.projection;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.projection.InvalidProjectionException;
import io.trino.plugin.hive.projection.PartitionProjectionProperties;
import io.trino.plugin.hive.projection.Projection;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class EnumProjection
implements Projection {
    private final String columnName;
    private final List<String> values;

    public EnumProjection(String columnName, Type columnType, Map<String, Object> columnProperties) {
        if (!(columnType instanceof VarcharType)) {
            throw new InvalidProjectionException(columnName, columnType);
        }
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.values = (List)PartitionProjectionProperties.getProjectionPropertyRequiredValue(columnName, columnProperties, "partition_projection_values", value -> (ImmutableList)((List)value).stream().map(String::valueOf).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public List<String> getProjectedValues(Optional<Domain> partitionValueFilter) {
        if (partitionValueFilter.isEmpty() || partitionValueFilter.get().isAll()) {
            return this.values;
        }
        return this.values.stream().filter(value -> this.isValueInDomain((Domain)partitionValueFilter.get(), (String)value)).collect(Collectors.toList());
    }

    private boolean isValueInDomain(Domain valueDomain, String value) {
        Type type = valueDomain.getType();
        if (type instanceof VarcharType) {
            return valueDomain.contains(Domain.singleValue((Type)type, (Object)Slices.utf8Slice((String)value)));
        }
        throw new InvalidProjectionException(this.columnName, type);
    }
}

