/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareModule;
import io.trino.plugin.base.security.ConnectorAccessControlModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.security.AccessControlMetadataFactory;
import io.trino.plugin.hive.security.AllowAllSecurityModule;
import io.trino.plugin.hive.security.SecurityConfig;
import io.trino.plugin.hive.security.SqlStandardSecurityModule;
import io.trino.plugin.hive.security.SystemSecurityModule;

public class HiveSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new ConnectorAccessControlModule());
        this.install((Module)(switch (((SecurityConfig)this.buildConfigObject(SecurityConfig.class)).getSecuritySystem().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new AllowAllSecurityModule();
            case 1 -> ConfigurationAwareModule.combine((Module[])new Module[]{new ReadOnlySecurityModule(), new StaticAccessControlMetadataModule()});
            case 2 -> ConfigurationAwareModule.combine((Module[])new Module[]{new FileBasedAccessControlModule(), new StaticAccessControlMetadataModule()});
            case 3 -> new SqlStandardSecurityModule();
            case 4 -> new SystemSecurityModule();
        }));
    }

    public static enum HiveSecurity {
        ALLOW_ALL,
        READ_ONLY,
        FILE,
        SQL_STANDARD,
        SYSTEM;

    }

    private static class StaticAccessControlMetadataModule
    implements Module {
        private StaticAccessControlMetadataModule() {
        }

        public void configure(Binder binder) {
            binder.bind(AccessControlMetadataFactory.class).toInstance(metastore -> new AccessControlMetadata(this){});
        }
    }
}

