/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.type;

import io.airlift.slice.SizeOf;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.TypeInfo;
import java.util.Objects;

public final class ListTypeInfo
extends TypeInfo {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ListTypeInfo.class);
    private final TypeInfo elementTypeInfo;

    ListTypeInfo(TypeInfo elementTypeInfo) {
        this.elementTypeInfo = Objects.requireNonNull(elementTypeInfo, "elementTypeInfo is null");
    }

    @Override
    public String getTypeName() {
        return "array<" + this.elementTypeInfo.getTypeName() + ">";
    }

    @Override
    public Category getCategory() {
        return Category.LIST;
    }

    public TypeInfo getListElementTypeInfo() {
        return this.elementTypeInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ListTypeInfo)) return false;
        ListTypeInfo o = (ListTypeInfo)other;
        if (!this.elementTypeInfo.equals(o.elementTypeInfo)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.elementTypeInfo.hashCode();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.elementTypeInfo.getRetainedSizeInBytes();
    }
}

