/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.array.IntBigArray;
import io.trino.orc.DictionaryCompressionOptimizer;
import io.trino.orc.checkpoint.BooleanStreamCheckpoint;
import io.trino.orc.checkpoint.LongStreamCheckpoint;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.CompressedMetadataWriter;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.RowGroupIndex;
import io.trino.orc.metadata.Stream;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.SliceColumnStatisticsBuilder;
import io.trino.orc.stream.ByteArrayOutputStream;
import io.trino.orc.stream.LongOutputStream;
import io.trino.orc.stream.LongOutputStreamV2;
import io.trino.orc.stream.PresentOutputStream;
import io.trino.orc.stream.StreamDataOutput;
import io.trino.orc.writer.ColumnWriter;
import io.trino.orc.writer.DictionaryBuilder;
import io.trino.orc.writer.SliceDirectColumnWriter;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SliceDictionaryColumnWriter
implements ColumnWriter,
DictionaryCompressionOptimizer.DictionaryColumn {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SliceDictionaryColumnWriter.class);
    private static final int DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES = Math.toIntExact(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
    private final OrcColumnId columnId;
    private final Type type;
    private final CompressionKind compression;
    private final int bufferSize;
    private final LongOutputStream dataStream;
    private final PresentOutputStream presentStream;
    private final ByteArrayOutputStream dictionaryDataStream;
    private final LongOutputStream dictionaryLengthStream;
    private final DictionaryBuilder dictionary = new DictionaryBuilder(10000);
    private final List<DictionaryRowGroup> rowGroups = new ArrayList<DictionaryRowGroup>();
    private final Supplier<SliceColumnStatisticsBuilder> statisticsBuilderSupplier;
    private IntBigArray values;
    private int rowGroupValueCount;
    private SliceColumnStatisticsBuilder statisticsBuilder;
    private long rawBytes;
    private long totalValueCount;
    private long totalNonNullValueCount;
    private boolean closed;
    private boolean inRowGroup;
    private ColumnEncoding columnEncoding;
    private boolean directEncoded;
    private SliceDirectColumnWriter directColumnWriter;

    public SliceDictionaryColumnWriter(OrcColumnId columnId, Type type, CompressionKind compression, int bufferSize, Supplier<SliceColumnStatisticsBuilder> statisticsBuilderSupplier) {
        this.columnId = Objects.requireNonNull(columnId, "columnId is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.compression = Objects.requireNonNull(compression, "compression is null");
        this.bufferSize = bufferSize;
        this.dataStream = new LongOutputStreamV2(compression, bufferSize, false, Stream.StreamKind.DATA);
        this.presentStream = new PresentOutputStream(compression, bufferSize);
        this.dictionaryDataStream = new ByteArrayOutputStream(compression, bufferSize, Stream.StreamKind.DICTIONARY_DATA);
        this.dictionaryLengthStream = LongOutputStream.createLengthOutputStream(compression, bufferSize);
        this.values = new IntBigArray();
        this.statisticsBuilderSupplier = Objects.requireNonNull(statisticsBuilderSupplier, "statisticsBuilderSupplier is null");
        this.statisticsBuilder = statisticsBuilderSupplier.get();
    }

    @Override
    public long getRawBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.rawBytes;
    }

    @Override
    public int getDictionaryBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return Math.toIntExact(this.dictionary.getSizeInBytes());
    }

    @Override
    public int getIndexBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return Math.toIntExact((long)DictionaryCompressionOptimizer.estimateIndexBytesPerValue(this.dictionary.getEntryCount()) * this.getNonNullValueCount());
    }

    @Override
    public long getValueCount() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.totalValueCount;
    }

    @Override
    public long getNonNullValueCount() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.totalNonNullValueCount;
    }

    @Override
    public int getDictionaryEntries() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.dictionary.getEntryCount();
    }

    @Override
    public OptionalInt tryConvertToDirect(int maxDirectBytes) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        if (this.directColumnWriter == null) {
            this.directColumnWriter = new SliceDirectColumnWriter(this.columnId, this.type, this.compression, this.bufferSize, this.statisticsBuilderSupplier);
        }
        Preconditions.checkState((this.directColumnWriter.getBufferedBytes() == 0L ? 1 : 0) != 0);
        VariableWidthBlock dictionaryValues = this.dictionary.getElementBlock();
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            this.directColumnWriter.beginRowGroup();
            boolean success = this.writeDictionaryRowGroup((Block)dictionaryValues, rowGroup.getValueCount(), rowGroup.getDictionaryIndexes(), maxDirectBytes);
            this.directColumnWriter.finishRowGroup();
            if (success) continue;
            this.directColumnWriter.close();
            this.directColumnWriter.reset();
            return OptionalInt.empty();
        }
        if (this.inRowGroup) {
            this.directColumnWriter.beginRowGroup();
            if (!this.writeDictionaryRowGroup((Block)dictionaryValues, this.rowGroupValueCount, this.values, maxDirectBytes)) {
                this.directColumnWriter.close();
                this.directColumnWriter.reset();
                return OptionalInt.empty();
            }
        } else {
            Preconditions.checkState((this.rowGroupValueCount == 0 ? 1 : 0) != 0);
        }
        this.rowGroups.clear();
        this.dictionary.clear();
        this.rawBytes = 0L;
        this.totalValueCount = 0L;
        this.totalNonNullValueCount = 0L;
        this.rowGroupValueCount = 0;
        this.statisticsBuilder = this.statisticsBuilderSupplier.get();
        this.directEncoded = true;
        return OptionalInt.of(Math.toIntExact(this.directColumnWriter.getBufferedBytes()));
    }

    private boolean writeDictionaryRowGroup(Block dictionary, int valueCount, IntBigArray dictionaryIndexes, int maxDirectBytes) {
        int positionCount;
        int[][] segments = dictionaryIndexes.getSegments();
        for (int i = 0; valueCount > 0 && i < segments.length; valueCount -= positionCount, ++i) {
            int[] segment = segments[i];
            positionCount = Math.min(valueCount, segment.length);
            Block block = DictionaryBlock.create((int)positionCount, (Block)dictionary, (int[])segment);
            while (block != null) {
                int chunkPositionCount = block.getPositionCount();
                Block chunk = block.getRegion(0, chunkPositionCount);
                while (chunkPositionCount > 1 && chunk.getLogicalSizeInBytes() > (long)DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES) {
                    chunk = chunk.getRegion(0, chunkPositionCount /= 2);
                }
                this.directColumnWriter.writeBlock(chunk);
                if (this.directColumnWriter.getBufferedBytes() > (long)maxDirectBytes) {
                    return false;
                }
                if (chunkPositionCount < block.getPositionCount()) {
                    block = block.getRegion(chunkPositionCount, block.getPositionCount() - chunkPositionCount);
                    continue;
                }
                block = null;
            }
        }
        Preconditions.checkState((valueCount == 0 ? 1 : 0) != 0);
        return true;
    }

    @Override
    public Map<OrcColumnId, ColumnEncoding> getColumnEncodings() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getColumnEncodings();
        }
        return ImmutableMap.of((Object)this.columnId, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.inRowGroup = true;
        if (this.directEncoded) {
            this.directColumnWriter.beginRowGroup();
        }
    }

    @Override
    public void writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        if (this.directEncoded) {
            this.directColumnWriter.writeBlock(block);
            return;
        }
        this.values.ensureCapacity((long)(this.rowGroupValueCount + block.getPositionCount()));
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int position = block.getUnderlyingValuePosition(i);
            int index = this.dictionary.putIfAbsent(valueBlock, position);
            this.values.set((long)this.rowGroupValueCount, index);
            ++this.rowGroupValueCount;
            ++this.totalValueCount;
            if (valueBlock.isNull(position)) continue;
            this.statisticsBuilder.addValue(this.type.getSlice((Block)valueBlock, position));
            this.rawBytes += (long)valueBlock.getSliceLength(position);
            ++this.totalNonNullValueCount;
        }
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.inRowGroup);
        this.inRowGroup = false;
        if (this.directEncoded) {
            return this.directColumnWriter.finishRowGroup();
        }
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.rowGroups.add(new DictionaryRowGroup(this.values, this.rowGroupValueCount, statistics));
        this.rowGroupValueCount = 0;
        this.statisticsBuilder = this.statisticsBuilderSupplier.get();
        this.values = new IntBigArray();
        return ImmutableMap.of((Object)this.columnId, (Object)statistics);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.closed = true;
        if (this.directEncoded) {
            this.directColumnWriter.close();
        } else {
            this.bufferOutputData();
        }
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getColumnStripeStatistics();
        }
        return ImmutableMap.of((Object)this.columnId, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroups.stream().map(DictionaryRowGroup::getColumnStatistics).collect(Collectors.toList())));
    }

    private void bufferOutputData() {
        int[] sortedDictionaryIndexes;
        Preconditions.checkState((boolean)this.closed);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        VariableWidthBlock dictionaryElements = this.dictionary.getElementBlock();
        for (int sortedDictionaryIndex : sortedDictionaryIndexes = SliceDictionaryColumnWriter.getSortedDictionaryNullsLast(dictionaryElements)) {
            if (dictionaryElements.isNull(sortedDictionaryIndex)) continue;
            Slice value = dictionaryElements.getSlice(sortedDictionaryIndex);
            this.dictionaryLengthStream.writeLong(value.length());
            this.dictionaryDataStream.writeSlice(value);
        }
        this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2, dictionaryElements.getPositionCount() - 1);
        int[] originalDictionaryToSortedIndex = new int[sortedDictionaryIndexes.length];
        int sortOrdinal = 0;
        while (sortOrdinal < sortedDictionaryIndexes.length) {
            int dictionaryIndex = sortedDictionaryIndexes[sortOrdinal];
            originalDictionaryToSortedIndex[dictionaryIndex] = sortOrdinal++;
        }
        if (!this.rowGroups.isEmpty()) {
            this.presentStream.recordCheckpoint();
            this.dataStream.recordCheckpoint();
        }
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            int position;
            IntBigArray dictionaryIndexes = rowGroup.getDictionaryIndexes();
            for (position = 0; position < rowGroup.getValueCount(); ++position) {
                this.presentStream.writeBoolean(dictionaryIndexes.get((long)position) != 0);
            }
            for (position = 0; position < rowGroup.getValueCount(); ++position) {
                int originalDictionaryIndex = dictionaryIndexes.get((long)position);
                if (originalDictionaryIndex == 0) continue;
                int sortedIndex = originalDictionaryToSortedIndex[originalDictionaryIndex];
                if (sortedIndex < 0) {
                    throw new IllegalArgumentException();
                }
                this.dataStream.writeLong(sortedIndex);
            }
            this.presentStream.recordCheckpoint();
            this.dataStream.recordCheckpoint();
        }
        this.dictionary.clear();
        this.dictionaryDataStream.close();
        this.dictionaryLengthStream.close();
        this.dataStream.close();
        this.presentStream.close();
    }

    private static int[] getSortedDictionaryNullsLast(VariableWidthBlock elementBlock) {
        int[] sortedPositions = new int[elementBlock.getPositionCount()];
        for (int i = 0; i < sortedPositions.length; ++i) {
            sortedPositions[i] = i;
        }
        Slice rawSlice = elementBlock.getRawSlice();
        IntArrays.quickSort((int[])sortedPositions, (int)0, (int)sortedPositions.length, (left, right) -> {
            boolean nullLeft = elementBlock.isNull(left);
            boolean nullRight = elementBlock.isNull(right);
            if (nullLeft && nullRight) {
                return 0;
            }
            if (nullLeft) {
                return 1;
            }
            if (nullRight) {
                return -1;
            }
            return rawSlice.compareTo(elementBlock.getRawSliceOffset(left), elementBlock.getSliceLength(left), rawSlice, elementBlock.getRawSliceOffset(right), elementBlock.getSliceLength(right));
        });
        return sortedPositions;
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(CompressedMetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getIndexStreams(metadataWriter);
        }
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List dataCheckpoints = this.dataStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        for (int i = 0; i < this.rowGroups.size(); ++i) {
            int groupId = i;
            ColumnStatistics columnStatistics = this.rowGroups.get(groupId).getColumnStatistics();
            LongStreamCheckpoint dataCheckpoint = (LongStreamCheckpoint)dataCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = SliceDictionaryColumnWriter.createSliceColumnPositionList(this.compression != CompressionKind.NONE, dataCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.columnId, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    private static List<Integer> createSliceColumnPositionList(boolean compressed, LongStreamCheckpoint dataCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getBloomFilters(CompressedMetadataWriter metadataWriter) throws IOException {
        if (this.directEncoded) {
            return this.directColumnWriter.getBloomFilters(metadataWriter);
        }
        List bloomFilters = (List)this.rowGroups.stream().map(rowGroup -> rowGroup.getColumnStatistics().getBloomFilter()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (!bloomFilters.isEmpty()) {
            Slice slice = metadataWriter.writeBloomFilters(bloomFilters);
            Stream stream = new Stream(this.columnId, Stream.StreamKind.BLOOM_FILTER_UTF8, slice.length(), false);
            return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
        }
        return ImmutableList.of();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getDataStreams();
        }
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.columnId).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.columnId));
        outputDataStreams.add((Object)this.dictionaryLengthStream.getStreamDataOutput(this.columnId));
        outputDataStreams.add((Object)this.dictionaryDataStream.getStreamDataOutput(this.columnId));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.directEncoded) {
            return this.directColumnWriter.getBufferedBytes();
        }
        return this.getIndexBytes() + this.getDictionaryBytes();
    }

    @Override
    public long getRetainedBytes() {
        long retainedBytes = (long)INSTANCE_SIZE + this.values.sizeOf() + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.dictionaryDataStream.getRetainedBytes() + this.dictionaryLengthStream.getRetainedBytes() + this.dictionary.getRetainedSizeInBytes() + (this.directColumnWriter == null ? 0L : this.directColumnWriter.getRetainedBytes());
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            retainedBytes += rowGroup.getColumnStatistics().getRetainedSizeInBytes();
        }
        return retainedBytes;
    }

    @Override
    public void reset() {
        Preconditions.checkState((boolean)this.closed);
        this.closed = false;
        this.dataStream.reset();
        this.presentStream.reset();
        this.dictionaryDataStream.reset();
        this.dictionaryLengthStream.reset();
        this.rowGroups.clear();
        this.rowGroupValueCount = 0;
        this.statisticsBuilder = this.statisticsBuilderSupplier.get();
        this.columnEncoding = null;
        this.dictionary.clear();
        this.rawBytes = 0L;
        this.totalValueCount = 0L;
        this.totalNonNullValueCount = 0L;
        if (this.directEncoded) {
            this.directEncoded = false;
            this.directColumnWriter.reset();
        }
    }

    private static class DictionaryRowGroup {
        private final IntBigArray dictionaryIndexes;
        private final int valueCount;
        private final ColumnStatistics columnStatistics;

        public DictionaryRowGroup(IntBigArray dictionaryIndexes, int valueCount, ColumnStatistics columnStatistics) {
            Objects.requireNonNull(dictionaryIndexes, "dictionaryIndexes is null");
            Preconditions.checkArgument((valueCount >= 0 ? 1 : 0) != 0, (Object)"valueCount is negative");
            Objects.requireNonNull(columnStatistics, "columnStatistics is null");
            this.dictionaryIndexes = dictionaryIndexes;
            this.valueCount = valueCount;
            this.columnStatistics = columnStatistics;
        }

        public IntBigArray getDictionaryIndexes() {
            return this.dictionaryIndexes;
        }

        public int getValueCount() {
            return this.valueCount;
        }

        public ColumnStatistics getColumnStatistics() {
            return this.columnStatistics;
        }
    }
}

