/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.exception.InvalidPathException;
import alluxio.uri.Authority;
import alluxio.uri.NoAuthority;
import alluxio.uri.URI;
import alluxio.util.URIUtils;
import alluxio.util.io.PathUtils;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

@ThreadSafe
public final class AlluxioURI
implements Comparable<AlluxioURI>,
Serializable {
    private static final long serialVersionUID = -1207227692436086387L;
    public static final String SEPARATOR = "/";
    public static final String CUR_DIR = ".";
    public static final String WILDCARD = "*";
    public static final AlluxioURI EMPTY_URI = new AlluxioURI("");
    private final URI mUri;
    private String mUriString = null;

    public AlluxioURI(String pathStr) {
        this.mUri = URI.Factory.create(pathStr);
    }

    public AlluxioURI(String scheme, Authority authority, String path) {
        this.mUri = URI.Factory.create(scheme, authority == null ? NoAuthority.INSTANCE : authority, path, null);
    }

    public AlluxioURI(String scheme, Authority authority, String path, Map<String, String> queryMap) {
        this.mUri = URI.Factory.create(scheme, authority, path, URIUtils.generateQueryString(queryMap));
    }

    public AlluxioURI(AlluxioURI parent, AlluxioURI child) {
        this.mUri = URI.Factory.create(parent.mUri, child.mUri);
    }

    public AlluxioURI(AlluxioURI baseURI, String newPath, boolean checkNormalization) {
        this.mUri = URI.Factory.create(baseURI.mUri, newPath, checkNormalization);
    }

    @Override
    public int compareTo(AlluxioURI other) {
        return this.mUri.compareTo(other.mUri);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlluxioURI)) {
            return false;
        }
        AlluxioURI that = (AlluxioURI)o;
        return this.mUri.equals(that.mUri);
    }

    public Authority getAuthority() {
        return this.mUri.getAuthority();
    }

    public int getDepth() {
        int slash;
        String path = this.mUri.getPath();
        if (path.isEmpty() || CUR_DIR.equals(path)) {
            return 0;
        }
        if (AlluxioURI.hasWindowsDrive(path, true)) {
            path = path.substring(3);
        }
        int depth = 0;
        int n = slash = path.length() == 1 && path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = path.indexOf(SEPARATOR, slash + 1);
        }
        return depth;
    }

    @Nullable
    public String getLeadingPath(int n) {
        String path = this.mUri.getPath();
        if (n == 0 && path.indexOf(SEPARATOR) == 0) {
            return SEPARATOR;
        }
        int depth = this.getDepth();
        if (depth < n) {
            return null;
        }
        if (depth == n) {
            return path;
        }
        String[] comp = path.split(SEPARATOR);
        return StringUtils.join(Arrays.asList(comp).subList(0, n + 1), (String)SEPARATOR);
    }

    public boolean containsWildcard() {
        return this.mUri.getPath().contains(WILDCARD);
    }

    public String getName() {
        String path = this.mUri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    @Nullable
    public AlluxioURI getParent() {
        String parent;
        int start;
        String path = this.mUri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int n = start = AlluxioURI.hasWindowsDrive(path, true) ? 3 : 0;
        if (path.length() == start || lastSlash == start && path.length() == start + 1) {
            return null;
        }
        if (lastSlash == -1) {
            parent = CUR_DIR;
        } else {
            int end = AlluxioURI.hasWindowsDrive(path, true) ? 3 : 0;
            parent = path.substring(0, lastSlash == end ? end + 1 : lastSlash);
        }
        return new AlluxioURI(this, parent, false);
    }

    public String getPath() {
        return this.mUri.getPath();
    }

    public Map<String, String> getQueryMap() {
        return URIUtils.parseQueryString(this.mUri.getQuery());
    }

    @Nullable
    public String getScheme() {
        return this.mUri.getScheme();
    }

    public String getRootPath() {
        String rootPath = this.toString();
        if (this.getPath() != null) {
            rootPath = rootPath.substring(0, rootPath.lastIndexOf(this.getPath()));
        }
        return PathUtils.normalizePath(rootPath, SEPARATOR);
    }

    public boolean hasAuthority() {
        return !(this.mUri.getAuthority() instanceof NoAuthority);
    }

    public int hashCode() {
        return this.mUri.hashCode();
    }

    public boolean hasScheme() {
        return this.mUri.getScheme() != null;
    }

    public static boolean hasWindowsDrive(String path, boolean slashed) {
        int start = slashed ? 1 : 0;
        return path.length() >= start + 2 && (!slashed || path.charAt(0) == '/') && path.charAt(start + 1) == ':' && (path.charAt(start) >= 'A' && path.charAt(start) <= 'Z' || path.charAt(start) >= 'a' && path.charAt(start) <= 'z');
    }

    public boolean isAbsolute() {
        return this.mUri.isAbsolute();
    }

    public boolean isPathAbsolute() {
        int start = AlluxioURI.hasWindowsDrive(this.mUri.getPath(), true) ? 3 : 0;
        return this.mUri.getPath().startsWith(SEPARATOR, start);
    }

    public boolean isRoot() {
        return this.mUri.getPath().equals(SEPARATOR) || this.mUri.getPath().isEmpty() && this.hasAuthority();
    }

    public AlluxioURI join(String suffix) {
        if (suffix.isEmpty()) {
            return new AlluxioURI(this.getScheme(), this.getAuthority(), this.getPath());
        }
        String path = this.getPath();
        StringBuilder sb = new StringBuilder(path.length() + 1 + suffix.length());
        return new AlluxioURI(this, sb.append(path).append(SEPARATOR).append(suffix).toString(), true);
    }

    public AlluxioURI join(AlluxioURI suffix) {
        return this.join(suffix.toString());
    }

    public AlluxioURI joinUnsafe(String suffix) {
        String path = this.getPath();
        StringBuilder sb = new StringBuilder(path.length() + 1 + suffix.length());
        return new AlluxioURI(this, sb.append(path).append(SEPARATOR).append(suffix).toString(), false);
    }

    public static String normalizePath(String path) {
        int minLength;
        while (path.contains("\\")) {
            path = path.replace("\\", SEPARATOR);
        }
        while (path.contains("//")) {
            path = path.replace("//", SEPARATOR);
        }
        int n = minLength = AlluxioURI.hasWindowsDrive(path, true) ? 4 : 1;
        while (path.length() > minLength && path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public boolean isAncestorOf(AlluxioURI alluxioURI) throws InvalidPathException {
        if (!Objects.equals(this.getAuthority(), alluxioURI.getAuthority())) {
            return false;
        }
        if (!Objects.equals(this.getScheme(), alluxioURI.getScheme())) {
            return false;
        }
        return PathUtils.hasPrefix(PathUtils.normalizePath(alluxioURI.getPath(), SEPARATOR), PathUtils.normalizePath(this.getPath(), SEPARATOR));
    }

    public String toString() {
        if (this.mUriString != null) {
            return this.mUriString;
        }
        StringBuilder sb = new StringBuilder();
        if (this.mUri.getScheme() != null) {
            sb.append(this.mUri.getScheme());
            sb.append("://");
        }
        if (this.hasAuthority()) {
            if (this.mUri.getScheme() == null) {
                sb.append("//");
            }
            sb.append(this.mUri.getAuthority().toString());
        }
        if (this.mUri.getPath() != null) {
            String path = this.mUri.getPath();
            if (path.indexOf(47) == 0 && AlluxioURI.hasWindowsDrive(path, true) && this.mUri.getScheme() == null && (this.mUri.getAuthority() == null || this.mUri.getAuthority() instanceof NoAuthority)) {
                path = path.substring(1);
            }
            sb.append(path);
        }
        if (this.mUri.getQuery() != null) {
            sb.append("?");
            sb.append(this.mUri.getQuery());
        }
        this.mUriString = sb.toString();
        return this.mUriString;
    }

    public String hash() {
        return AlluxioURI.hash(this.toString());
    }

    public static String hash(String uri) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(uri.getBytes());
            return Hex.encodeHexString((byte[])md.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException md) {
            try {
                MessageDigest md2 = MessageDigest.getInstance("MD5");
                md2.update(uri.getBytes());
                return Hex.encodeHexString((byte[])md2.digest()).toLowerCase();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return Hex.encodeHexString((byte[])String.valueOf(uri.hashCode()).getBytes()).toLowerCase();
            }
        }
    }
}

