/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.sink.Sink;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Slf4jSink
implements Sink {
    private static final int SLF4J_DEFAULT_PERIOD = 10;
    private static final String SLF4J_DEFAULT_UNIT = "SECONDS";
    private static final String SLF4J_KEY_PERIOD = "period";
    private static final String SLF4J_KEY_UNIT = "unit";
    private static final String SLF4J_KEY_FILTER_CLASS = "filter-class";
    private final Slf4jReporter mReporter;
    private final Properties mProperties;

    public Slf4jSink(Properties properties, MetricRegistry registry) throws Exception {
        this.mProperties = properties;
        MetricFilter filter = this.getMetricFilter();
        this.mReporter = Slf4jReporter.forRegistry((MetricRegistry)registry).filter(filter).build();
    }

    @Override
    public void start() {
        this.mReporter.start((long)this.getPollPeriod(), this.getPollUnit());
    }

    @Override
    public void stop() {
        this.mReporter.stop();
    }

    @Override
    public void report() {
        this.mReporter.report();
    }

    private int getPollPeriod() {
        String period = this.mProperties.getProperty(SLF4J_KEY_PERIOD);
        return period != null ? Integer.parseInt(period) : 10;
    }

    private TimeUnit getPollUnit() {
        String unit = this.mProperties.getProperty(SLF4J_KEY_UNIT);
        if (unit == null) {
            unit = SLF4J_DEFAULT_UNIT;
        }
        return TimeUnit.valueOf(unit.toUpperCase());
    }

    private MetricFilter getMetricFilter() throws Exception {
        String filterClass = this.mProperties.getProperty(SLF4J_KEY_FILTER_CLASS);
        if (filterClass == null) {
            return MetricFilter.ALL;
        }
        return (MetricFilter)Class.forName(filterClass).getConstructor(Properties.class).newInstance(this.mProperties);
    }
}

