/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.codec.binary.Hex;

@ThreadSafe
public class HashUtils {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32_fixed();

    private HashUtils() {
    }

    public static String hashAsStringMD5(String object) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(object.getBytes());
            return Hex.encodeHexString((byte[])md.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return HASH_FUNCTION.hashString((CharSequence)object, StandardCharsets.UTF_8).toString();
        }
    }

    public static long hashAsLong(String object) {
        return HASH_FUNCTION.hashString((CharSequence)object, StandardCharsets.UTF_8).padToLong();
    }
}

