/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.compression;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.io.IOUtils;

public final class TarUtils {
    public static long writeTarGz(Path dirPath, OutputStream output, int compressionLevel) throws IOException, InterruptedException {
        GzipParameters params = new GzipParameters();
        params.setCompressionLevel(compressionLevel);
        GzipCompressorOutputStream zipStream = new GzipCompressorOutputStream(output, params);
        TarArchiveOutputStream archiveStream = new TarArchiveOutputStream((OutputStream)zipStream);
        archiveStream.setLongFileMode(3);
        archiveStream.setBigNumberMode(2);
        long totalBytesCopied = 0L;
        try (Stream<Path> stream = Files.walk(dirPath, new FileVisitOption[0]);){
            for (Path subPath : stream.collect(Collectors.toList())) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                File file = subPath.toFile();
                TarArchiveEntry entry = new TarArchiveEntry(file, dirPath.relativize(subPath).toString());
                archiveStream.putArchiveEntry((ArchiveEntry)entry);
                if (file.isFile()) {
                    try (BufferedInputStream fileIn = new BufferedInputStream(Files.newInputStream(subPath, new OpenOption[0]));){
                        totalBytesCopied += IOUtils.copyLarge((InputStream)fileIn, (OutputStream)archiveStream);
                    }
                }
                archiveStream.closeArchiveEntry();
            }
        }
        archiveStream.finish();
        zipStream.finish();
        return totalBytesCopied;
    }

    public static long readTarGz(Path dirPath, InputStream input) throws IOException {
        TarArchiveEntry entry;
        GzipCompressorInputStream zipStream = new GzipCompressorInputStream(input);
        TarArchiveInputStream archiveStream = new TarArchiveInputStream((InputStream)zipStream);
        long totalBytesCopied = 0L;
        while ((entry = (TarArchiveEntry)archiveStream.getNextEntry()) != null) {
            File outputFile = new File(dirPath.toFile(), entry.getName());
            if (entry.isDirectory()) {
                outputFile.mkdirs();
                continue;
            }
            outputFile.getParentFile().mkdirs();
            BufferedOutputStream fileOut = new BufferedOutputStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));
            Throwable throwable = null;
            try {
                totalBytesCopied += IOUtils.copyLarge((InputStream)archiveStream, (OutputStream)fileOut);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileOut == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)fileOut).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((OutputStream)fileOut).close();
            }
        }
        return totalBytesCopied;
    }

    private TarUtils() {
    }
}

