/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.SerDeException;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@.InterfaceAudience.Public
@.InterfaceStability.Stable
public class LazySerDeParameters
implements LazyObjectInspectorParameters {
    public static final Logger LOG = LoggerFactory.getLogger((String)LazySerDeParameters.class.getName());
    public static final byte[] DefaultSeparators = new byte[]{1, 2, 3};
    public static final String SERIALIZATION_EXTEND_NESTING_LEVELS = "hive.serialization.extend.nesting.levels";
    public static final String SERIALIZATION_EXTEND_ADDITIONAL_NESTING_LEVELS = "hive.serialization.extend.additional.nesting.levels";
    private Properties tableProperties;
    private String serdeName;
    private byte[] separators;
    private Text nullSequence;
    private TypeInfo rowTypeInfo;
    private boolean lastColumnTakesRest;
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private boolean escaped;
    private byte escapeChar;
    private boolean[] needsEscape = new boolean[256];
    private boolean extendedBooleanLiteral;
    List<String> timestampFormats;

    public LazySerDeParameters(Configuration job, Properties tbl, String serdeName) throws SerDeException {
        this.tableProperties = tbl;
        this.serdeName = serdeName;
        String nullString = tbl.getProperty("serialization.null.format", "\\N");
        this.nullSequence = new Text(nullString);
        String lastColumnTakesRestString = tbl.getProperty("serialization.last.column.takes.rest");
        this.lastColumnTakesRest = lastColumnTakesRestString != null && lastColumnTakesRestString.equalsIgnoreCase("true");
        this.extractColumnInfo(job);
        this.rowTypeInfo = TypeInfoFactory.getStructTypeInfo(this.columnNames, this.columnTypes);
        this.collectSeparators(tbl);
        String escapeProperty = tbl.getProperty("escape.delim");
        boolean bl = this.escaped = escapeProperty != null;
        if (this.escaped) {
            this.escapeChar = LazyUtils.getByte(escapeProperty, (byte)92);
            this.needsEscape[this.escapeChar & 0xFF] = true;
            for (byte b : this.separators) {
                this.needsEscape[b & 0xFF] = true;
            }
            boolean isEscapeCRLF = Boolean.parseBoolean(tbl.getProperty("serialization.escape.crlf"));
            if (isEscapeCRLF) {
                this.needsEscape[13] = true;
                this.needsEscape[10] = true;
            }
        }
        this.extendedBooleanLiteral = job == null ? false : job.getBoolean(.HiveConf.ConfVars.HIVE_LAZYSIMPLE_EXTENDED_BOOLEAN_LITERAL.varname, false);
        String[] timestampFormatsArray = HiveStringUtils.splitAndUnEscape((String)tbl.getProperty("timestamp.formats"));
        if (timestampFormatsArray != null) {
            this.timestampFormats = Arrays.asList(timestampFormatsArray);
        }
        LOG.debug(serdeName + " initialized with: columnNames=" + this.columnNames + " columnTypes=" + this.columnTypes + " separator=" + Arrays.asList(new byte[][]{this.separators}) + " nullstring=" + nullString + " lastColumnTakesRest=" + this.lastColumnTakesRest + " timestampFormats=" + this.timestampFormats);
    }

    public void extractColumnInfo(Configuration conf) throws SerDeException {
        int i;
        String columnNameProperty = this.tableProperties.getProperty("columns");
        String columnTypeProperty = this.tableProperties.getProperty("columns.types");
        String columnNameDelimiter = this.tableProperties.containsKey("column.name.delimiter") ? this.tableProperties.getProperty("column.name.delimiter") : String.valueOf(',');
        this.columnNames = columnNameProperty != null && columnNameProperty.length() > 0 ? Arrays.asList(columnNameProperty.split(columnNameDelimiter)) : new ArrayList<String>();
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < this.columnNames.size(); ++i) {
                if (i > 0) {
                    sb.append(":");
                }
                sb.append("string");
            }
            columnTypeProperty = sb.toString();
        }
        this.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        if (conf != null) {
            TimestampLocalTZTypeInfo tsTZTypeInfo = new TimestampLocalTZTypeInfo(conf.get(.HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE.varname));
            for (i = 0; i < this.columnTypes.size(); ++i) {
                if (!(this.columnTypes.get(i) instanceof TimestampLocalTZTypeInfo)) continue;
                this.columnTypes.set(i, tsTZTypeInfo);
            }
        }
        if (this.columnNames.size() != this.columnTypes.size()) {
            throw new SerDeException(this.serdeName + ": columns has " + this.columnNames.size() + " elements while columns.types has " + this.columnTypes.size() + " elements!");
        }
    }

    public List<TypeInfo> getColumnTypes() {
        return this.columnTypes;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public byte[] getSeparators() {
        return this.separators;
    }

    @Override
    public Text getNullSequence() {
        return this.nullSequence;
    }

    public TypeInfo getRowTypeInfo() {
        return this.rowTypeInfo;
    }

    @Override
    public boolean isLastColumnTakesRest() {
        return this.lastColumnTakesRest;
    }

    @Override
    public boolean isEscaped() {
        return this.escaped;
    }

    @Override
    public byte getEscapeChar() {
        return this.escapeChar;
    }

    public boolean[] getNeedsEscape() {
        return this.needsEscape;
    }

    @Override
    public boolean isExtendedBooleanLiteral() {
        return this.extendedBooleanLiteral;
    }

    @Override
    public List<String> getTimestampFormats() {
        return this.timestampFormats;
    }

    public void setSeparator(int index, byte separator) throws SerDeException {
        if (index < 0 || index >= this.separators.length) {
            throw new SerDeException("Invalid separator array index value: " + index);
        }
        this.separators[index] = separator;
    }

    private void collectSeparators(Properties tableProperties) {
        byte b;
        ArrayList<Byte> separatorCandidates = new ArrayList<Byte>();
        String extendNestingValue = tableProperties.getProperty(SERIALIZATION_EXTEND_NESTING_LEVELS);
        String extendAdditionalNestingValue = tableProperties.getProperty(SERIALIZATION_EXTEND_ADDITIONAL_NESTING_LEVELS);
        boolean extendedNesting = extendNestingValue != null && extendNestingValue.equalsIgnoreCase("true");
        boolean extendedAdditionalNesting = extendAdditionalNestingValue != null && extendAdditionalNestingValue.equalsIgnoreCase("true");
        separatorCandidates.add(LazyUtils.getByte(tableProperties.getProperty("field.delim", tableProperties.getProperty("serialization.format")), DefaultSeparators[0]));
        separatorCandidates.add(LazyUtils.getByte(tableProperties.getProperty("collection.delim"), DefaultSeparators[1]));
        separatorCandidates.add(LazyUtils.getByte(tableProperties.getProperty("mapkey.delim"), DefaultSeparators[2]));
        for (b = 4; b <= 8; b = (byte)((byte)(b + 1))) {
            separatorCandidates.add(b);
        }
        separatorCandidates.add((byte)11);
        for (b = 14; b <= 26; b = (byte)(b + 1)) {
            separatorCandidates.add(b);
        }
        for (b = 28; b <= 31; b = (byte)(b + 1)) {
            separatorCandidates.add(b);
        }
        for (b = -128; b <= -1; b = (byte)(b + 1)) {
            separatorCandidates.add(b);
        }
        int numSeparators = 8;
        if (extendedAdditionalNesting) {
            numSeparators = separatorCandidates.size();
        } else if (extendedNesting) {
            numSeparators = 24;
        }
        this.separators = new byte[numSeparators];
        for (int i = 0; i < numSeparators; ++i) {
            this.separators[i] = (Byte)separatorCandidates.get(i);
        }
    }
}

