/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class StandardListObjectInspector
implements SettableListObjectInspector {
    private ObjectInspector listElementObjectInspector;

    protected StandardListObjectInspector() {
    }

    protected StandardListObjectInspector(ObjectInspector listElementObjectInspector) {
        this.listElementObjectInspector = listElementObjectInspector;
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.LIST;
    }

    @Override
    public ObjectInspector getListElementObjectInspector() {
        return this.listElementObjectInspector;
    }

    @Override
    public Object getListElement(Object data, int index) {
        if (data == null) {
            return null;
        }
        if (!(data instanceof List)) {
            if (!(data instanceof Set)) {
                Object[] list = (Object[])data;
                if (index < 0 || index >= list.length) {
                    return null;
                }
                return list[index];
            }
            data = new ArrayList((Set)((Object)data));
        }
        List list = data;
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    @Override
    public int getListLength(Object data) {
        if (data == null) {
            return -1;
        }
        if (!(data instanceof List)) {
            if (!(data instanceof Set)) {
                Object[] list = (Object[])data;
                return list.length;
            }
            Set set = (Set)data;
            return set.size();
        }
        List list = (List)data;
        return list.size();
    }

    @Override
    public List<?> getList(Object data) {
        if (data == null) {
            return null;
        }
        if (!(data instanceof List)) {
            data = !(data instanceof Set) ? Arrays.asList((Object[])data) : new ArrayList<Object>((Set)((Object)data));
        }
        List list = data;
        return list;
    }

    @Override
    public String getTypeName() {
        return "array<" + this.listElementObjectInspector.getTypeName() + ">";
    }

    @Override
    public Object create(int size) {
        ArrayList<Object> a = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            a.add(null);
        }
        return a;
    }

    @Override
    public Object resize(Object list, int newSize) {
        List a = (List)list;
        while (a.size() < newSize) {
            a.add(null);
        }
        while (a.size() > newSize) {
            a.remove(a.size() - 1);
        }
        return a;
    }

    @Override
    public Object set(Object list, int index, Object element) {
        List a = (List)list;
        a.set(index, element);
        return a;
    }
}

